/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTexturePattern;
import java.awt.Color;

public class ChartShading {
    public static final float xLightS = 1.0f;
    public static final float yLightS = 1.0f;
    public static final float zLightS = 1.0f;
    public static final int percentH = -60;
    public static final float alpha = 0.0f;

    public static ChartFillPattern HighLightPattern(ChartFillPattern chartFillPattern) {
        if (chartFillPattern == null) {
            return null;
        }
        if (chartFillPattern instanceof ChartColorPattern) {
            ChartColorPattern chartColorPattern = (ChartColorPattern)chartFillPattern;
            ChartColorPattern chartColorPattern2 = new ChartColorPattern(ChartShading.highlight(chartColorPattern.getColor(), -60));
            chartColorPattern2.setAlpha(chartColorPattern.getAlpha());
            return chartColorPattern2;
        }
        if (chartFillPattern instanceof ChartTexturePattern) {
            ChartTexturePattern chartTexturePattern = (ChartTexturePattern)chartFillPattern;
            ChartTexturePattern chartTexturePattern2 = new ChartTexturePattern(chartTexturePattern.getPattern(), new ChartColorPattern(ChartShading.highlight(chartTexturePattern.getForeground().getColor(), -60)), new ChartColorPattern(ChartShading.highlight(chartTexturePattern.getBackground().getColor(), -60)));
            chartTexturePattern2.setAlpha(chartTexturePattern.getAlpha());
            return chartTexturePattern2;
        }
        if (chartFillPattern instanceof ChartGradientPattern) {
            ChartGradientPattern chartGradientPattern = (ChartGradientPattern)chartFillPattern;
            ChartGradientPattern chartGradientPattern2 = new ChartGradientPattern(chartGradientPattern.getPattern());
            chartGradientPattern2.setStartColor(new ChartColorPattern(ChartShading.highlight(chartGradientPattern.getStartColor().getColor(), -60)));
            chartGradientPattern2.setEndColor(new ChartColorPattern(ChartShading.highlight(chartGradientPattern.getEndColor().getColor(), -60)));
            chartGradientPattern2.setStartPoint(chartGradientPattern.getStartPoint());
            chartGradientPattern2.setEndPoint(chartGradientPattern.getEndPoint());
            chartGradientPattern2.setAlpha(chartGradientPattern.getAlpha());
            return chartGradientPattern2;
        }
        return null;
    }

    public static ChartFillPattern HighLightPattern(ChartFillPattern chartFillPattern, float f) {
        if (chartFillPattern == null) {
            return null;
        }
        if (chartFillPattern instanceof ChartColorPattern) {
            ChartColorPattern chartColorPattern = (ChartColorPattern)chartFillPattern;
            ChartColorPattern chartColorPattern2 = new ChartColorPattern(ChartShading.highlight(chartColorPattern.getColor(), (int)(-60.0f * f)));
            chartColorPattern2.setAlpha(chartColorPattern.getAlpha());
            return chartColorPattern2;
        }
        if (chartFillPattern instanceof ChartTexturePattern) {
            ChartTexturePattern chartTexturePattern = (ChartTexturePattern)chartFillPattern;
            ChartTexturePattern chartTexturePattern2 = new ChartTexturePattern(chartTexturePattern.getPattern(), new ChartColorPattern(ChartShading.highlight(chartTexturePattern.getForeground().getColor(), (int)(-60.0f * f))), new ChartColorPattern(ChartShading.highlight(chartTexturePattern.getBackground().getColor(), (int)(-60.0f * f))));
            chartTexturePattern2.setAlpha(chartTexturePattern.getAlpha());
            return chartTexturePattern2;
        }
        if (chartFillPattern instanceof ChartGradientPattern) {
            ChartGradientPattern chartGradientPattern = (ChartGradientPattern)chartFillPattern;
            ChartGradientPattern chartGradientPattern2 = new ChartGradientPattern(chartGradientPattern.getPattern());
            chartGradientPattern2.setStartColor(new ChartColorPattern(ChartShading.highlight(chartGradientPattern.getStartColor().getColor(), (int)(-60.0f * f))));
            chartGradientPattern2.setEndColor(new ChartColorPattern(ChartShading.highlight(chartGradientPattern.getEndColor().getColor(), (int)(-60.0f * f))));
            chartGradientPattern2.setStartPoint(chartGradientPattern.getStartPoint());
            chartGradientPattern2.setEndPoint(chartGradientPattern.getEndPoint());
            chartGradientPattern2.setAlpha(chartGradientPattern.getAlpha());
            return chartGradientPattern2;
        }
        return null;
    }

    public static ChartFillPattern HighLightPattern(ChartFillPattern chartFillPattern, int n) {
        if (chartFillPattern == null) {
            return null;
        }
        if (chartFillPattern instanceof ChartColorPattern) {
            ChartColorPattern chartColorPattern = (ChartColorPattern)chartFillPattern;
            ChartColorPattern chartColorPattern2 = new ChartColorPattern(ChartShading.highlight(chartColorPattern.getColor(), n));
            chartColorPattern2.setAlpha(chartColorPattern.getAlpha());
            return chartColorPattern2;
        }
        if (chartFillPattern instanceof ChartTexturePattern) {
            ChartTexturePattern chartTexturePattern = (ChartTexturePattern)chartFillPattern;
            ChartTexturePattern chartTexturePattern2 = new ChartTexturePattern(chartTexturePattern.getPattern(), new ChartColorPattern(ChartShading.highlight(chartTexturePattern.getForeground().getColor(), n)), new ChartColorPattern(ChartShading.highlight(chartTexturePattern.getBackground().getColor(), n)));
            chartTexturePattern2.setAlpha(chartTexturePattern.getAlpha());
            return chartTexturePattern2;
        }
        if (chartFillPattern instanceof ChartGradientPattern) {
            ChartGradientPattern chartGradientPattern = (ChartGradientPattern)chartFillPattern;
            ChartGradientPattern chartGradientPattern2 = new ChartGradientPattern(chartGradientPattern.getPattern());
            chartGradientPattern2.setStartColor(new ChartColorPattern(ChartShading.highlight(chartGradientPattern.getStartColor().getColor(), n)));
            chartGradientPattern2.setEndColor(new ChartColorPattern(ChartShading.highlight(chartGradientPattern.getEndColor().getColor(), n)));
            chartGradientPattern2.setStartPoint(chartGradientPattern.getStartPoint());
            chartGradientPattern2.setEndPoint(chartGradientPattern.getEndPoint());
            chartGradientPattern2.setAlpha(chartGradientPattern.getAlpha());
            return chartGradientPattern2;
        }
        return null;
    }

    public static Color highlight(Color color, int n) {
        if (color != null) {
            int n2 = color.getRGB();
            int n3 = color.getAlpha();
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = n >= 0 ? 1 : 0;
            n = Math.abs(n);
            n4 = (n4 * (100 - n) + n7 * 255 * n) / 100;
            n5 = (n5 * (100 - n) + n7 * 255 * n) / 100;
            n6 = (n6 * (100 - n) + n7 * 255 * n) / 100;
            return new Color(n4, n5, n6, n3);
        }
        return null;
    }

    public static Color shadingColor(float f, Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        n = (int)((float)n * f);
        n2 = (int)((float)n2 * f);
        n3 = (int)((float)n3 * f);
        return new Color(n, n2, n3);
    }

    public static ChartFillPattern shadingPattern(float f, ChartFillPattern chartFillPattern) {
        if (chartFillPattern == null) {
            return null;
        }
        if (chartFillPattern instanceof ChartColorPattern) {
            ChartColorPattern chartColorPattern = (ChartColorPattern)chartFillPattern;
            ChartColorPattern chartColorPattern2 = new ChartColorPattern(ChartShading.shadingColor(f, chartColorPattern.getColor()));
            chartColorPattern2.setAlpha(chartColorPattern.getAlpha());
            return chartColorPattern2;
        }
        if (chartFillPattern instanceof ChartTexturePattern) {
            ChartTexturePattern chartTexturePattern = (ChartTexturePattern)chartFillPattern;
            ChartTexturePattern chartTexturePattern2 = new ChartTexturePattern(chartTexturePattern.getPattern(), new ChartColorPattern(ChartShading.shadingColor(f, chartTexturePattern.getForeground().getColor())), new ChartColorPattern(ChartShading.shadingColor(f, chartTexturePattern.getBackground().getColor())));
            chartTexturePattern2.setAlpha(chartTexturePattern.getAlpha());
            return chartTexturePattern2;
        }
        if (chartFillPattern instanceof ChartGradientPattern) {
            ChartGradientPattern chartGradientPattern = (ChartGradientPattern)chartFillPattern;
            ChartGradientPattern chartGradientPattern2 = new ChartGradientPattern(chartGradientPattern.getPattern());
            chartGradientPattern2.setStartColor(new ChartColorPattern(ChartShading.shadingColor(f, chartGradientPattern.getStartColor().getColor())));
            chartGradientPattern2.setEndColor(new ChartColorPattern(ChartShading.shadingColor(f, chartGradientPattern.getEndColor().getColor())));
            chartGradientPattern2.setStartPoint(chartGradientPattern.getStartPoint());
            chartGradientPattern2.setEndPoint(chartGradientPattern.getEndPoint());
            chartGradientPattern2.setAlpha(chartGradientPattern.getAlpha());
            return chartGradientPattern2;
        }
        return null;
    }

    public static float calculateAngle(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = (f + f4) / 2.0f;
        float f8 = (f2 + f5) / 2.0f;
        float f9 = (f3 + f6) / 2.0f;
        float f10 = f7 * 1.0f + f8 * 1.0f + f9 * 1.0f;
        float f11 = (float)Math.sqrt(f7 * f7 + f8 * f8 + f9 * f9) * (float)Math.sqrt(3.0);
        float f12 = f10 / f11;
        return f12;
    }
}

