/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.schema.relational.datasource.relational;

import com.jinfonet.dataservice.api.schema.DataSchemaObjectType;
import com.jinfonet.dataservice.api.schema.relational.JRelationModel;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbConnection;
import com.jinfonet.dataservice.relational.datasource.ADSConnection;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbDataField;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbRelationModel;
import com.jinfonet.dataservice.schema.relational.datasource.relational.rdbResource.DBSpecificInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jet.dataengine.api.DSException;
import jet.dataengine.util.StringTools;
import jet.dataengine8.util.StringToolKit;
import toolkit.db.DbTools;

public class RdbConnection
extends ADSConnection
implements JRdbConnection {
    private Connection RDBCONNECTION = null;
    private Connection add;
    private String addContentElement;
    private String close;
    private String debug;
    private int dump = 3;
    private String equals = "";
    private String getCatalogs;
    private String getColumns;
    private String getConnection = "";
    private String getDatabaseName;
    private String getDriver;
    private String getExtraKeyWords;
    private String getExtraNameChar = "";
    private String getInt;

    public String getCurrentCatalog() {
        return this.getInt;
    }

    public void setCurrentCatalog(String string) {
        this.getInt = string;
    }

    public RdbConnection(String string) throws DSException {
        super(string, DataSchemaObjectType.RDBCONNECTION);
    }

    public boolean closeConnection() {
        if (this.RDBCONNECTION == null) {
            return true;
        }
        try {
            this.RDBCONNECTION.close();
            this.RDBCONNECTION = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void dump() {
        super.dump();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connection Information : ");
            this.log.debug(" Driver :" + this.getDriver());
            this.log.debug(" URL :" + this.getUrl());
            this.log.debug(" User :" + this.getUser());
            this.log.debug(" Password :" + this.getPassword());
            this.log.debug(" Database name :" + this.getDatabaseName());
            this.log.debug(" QuoteChar :" + this.getQuoteChar());
            this.log.debug(" Extra key words :" + this.getExtraKeyWords());
            this.log.debug(" Extra Name Char :" + this.getExtraNameChar());
            this.log.debug(" DBQualifyNameType : " + (this.is1PartName() ? " 1 Part" : (this.is2PartName() ? " 2 Part" : (this.is3PartName() ? " 3 Part" : " Unknow! "))));
        }
    }

    public String[] getCatalogNames() throws DSException {
        try {
            String[] stringArray;
            this.initConnection();
            DatabaseMetaData databaseMetaData = this.RDBCONNECTION.getMetaData();
            ResultSet resultSet = databaseMetaData.getCatalogs();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (resultSet.next()) {
                stringArray = resultSet.getString(1);
                arrayList.add(stringArray);
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        catch (SQLException sQLException) {
            throw new DSException(2098, (Throwable)sQLException);
        }
    }

    public Connection getConnection() throws DSException {
        this.initConnection();
        if (this.add != null) {
            return this.add;
        }
        return this.RDBCONNECTION;
    }

    public String getDatabaseName() {
        return this.addContentElement;
    }

    public String getDatabaseVersion() {
        return this.close;
    }

    public String getDateFormatString() {
        return this.debug;
    }

    public String getDriver() {
        return StringTools.isEmptyString(this.equals) ? "sun.jdbc.odbc.JdbcOdbcDriver" : this.equals;
    }

    public String getExtraKeyWords() {
        return this.getCatalogs;
    }

    public String getExtraNameChar() {
        return this.getColumns;
    }

    public String getPassword() {
        return this.getConnection;
    }

    public String getQuoteChar() {
        return this.getDatabaseName;
    }

    public JRelationModel getRecordModel(String string) throws DSException {
        String[] stringArray = StringToolKit.splitString(string, ".");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        if (stringArray.length > 3) {
            throw new RuntimeException();
        }
        if (stringArray.length == 3) {
            string2 = stringArray[0];
            ++n;
        }
        if (stringArray.length > 2) {
            string3 = stringArray[n];
            ++n;
        }
        string4 = stringArray[n];
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = this.getConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            throw new DSException(2097, (Throwable)sQLException);
        }
        String string5 = "";
        if (string2 != null) {
            string5 = string2 + "_";
        }
        if (string3 != null) {
            string5 = string5 + string3 + "_";
        }
        string5 = string5 + string4;
        RdbRelationModel rdbRelationModel = new RdbRelationModel(string4);
        rdbRelationModel.setNameInDs(string4);
        try {
            ResultSet resultSet = databaseMetaData.getColumns(string2, string3, string4, "%");
            while (resultSet.next()) {
                RdbDataField rdbDataField;
                block13: {
                    String string6 = resultSet.getString("COLUMN_NAME");
                    rdbDataField = new RdbDataField(string6);
                    rdbDataField.setNameInDs(string6);
                    int n2 = resultSet.getInt("DATA_TYPE");
                    rdbDataField.setDataType(n2);
                    int n3 = resultSet.getInt("COLUMN_SIZE");
                    rdbDataField.setLength(n3);
                    try {
                        ResultSet resultSet2 = databaseMetaData.getPrimaryKeys(string2, string3, string4);
                        while (resultSet2.next()) {
                            String string7 = resultSet2.getString("COLUMN_NAME");
                            if (!string7.equals(string4)) continue;
                            rdbDataField.setPrimaryKey(true);
                        }
                        resultSet2.close();
                    }
                    catch (SQLException sQLException) {
                        if (!this.log.isDebugEnabled()) break block13;
                        this.log.debug("Get Table error!");
                    }
                }
                rdbDataField.setPrecision(0);
                rdbDataField.setScale(0);
                rdbRelationModel.addContentElement(rdbDataField);
            }
        }
        catch (SQLException sQLException) {
            throw new DSException(2099, (Throwable)sQLException);
        }
        return rdbRelationModel;
    }

    public String[] getSchemaNames() throws DSException {
        try {
            String[] stringArray;
            ArrayList<String> arrayList;
            block5: {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                arrayList = new ArrayList<String>();
                try {
                    stringArray = databaseMetaData.getSchemas();
                    while (stringArray.next()) {
                        String string = stringArray.getString(1);
                        arrayList.add(string);
                    }
                    stringArray.close();
                }
                catch (SQLException sQLException) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug("Get schema error!");
                }
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        catch (SQLException sQLException) {
            throw new DSException(2100, (Throwable)sQLException);
        }
    }

    public String[] getTableNames(String string, String string2) throws DSException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        DatabaseMetaData databaseMetaData = null;
        String string3 = null;
        String[] stringArray2 = new String[]{"TABLE", "VIEW"};
        if (string2 != null) {
            string3 = string;
        }
        try {
            this.initConnection();
            databaseMetaData = this.RDBCONNECTION.getMetaData();
            stringArray = databaseMetaData.getTables(string3, string2, "%", stringArray2);
            while (stringArray.next()) {
                arrayList.add(stringArray.getString(3));
            }
            stringArray.close();
        }
        catch (SQLException sQLException) {
            throw new DSException(2101, (Throwable)sQLException);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String getTimeFormatString() {
        return this.getDriver;
    }

    public String getTimeStampFormatString() {
        return this.getExtraKeyWords;
    }

    public String getUser() {
        return this.getExtraNameChar;
    }

    public void initConnection() throws DSException {
    }

    public boolean is1PartName() {
        return this.dump == 1;
    }

    public boolean is2PartName() {
        return this.dump == 2;
    }

    public boolean is3PartName() {
        return this.dump == 3;
    }

    public String quotedWhenNeed(String string) {
        return DbTools.quotedWhenNeed(string, this.getColumns, this.getDatabaseName, this.getCatalogs);
    }

    public DBSpecificInfo getDBSpecificInfo() {
        return null;
    }

    public void setDatabaseName(String string) {
        this.addContentElement = string;
    }

    public void setDatabaseVersion(String string) {
        this.close = string;
    }

    public void setDateFormatString(String string) {
        this.debug = string;
    }

    public void setDBQualifyNameType(int n) {
        this.dump = n;
    }

    public void setDriver(String string) {
        this.equals = string;
    }

    public void setExtraKeyWords(String string) {
        this.getCatalogs = string;
    }

    public void setExtraNameChar(String string) {
        this.getColumns = string;
    }

    public void setPassword(String string) {
        this.getConnection = string;
    }

    public void setQuoteChar(String string) {
        this.getDatabaseName = string;
    }

    public void setTimeFormatString(String string) {
        this.getDriver = string;
    }

    public void setTimeStampFormatString(String string) {
        this.getExtraKeyWords = string;
    }

    public void setUser(String string) {
        this.getExtraNameChar = string;
    }

    public boolean testConnection() throws DSException {
        this.initConnection();
        return true;
    }

    public int getType() {
        return 2;
    }

    public void setUserConnection(Connection connection) {
        this.add = connection;
    }
}

