/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.image.encoder;

import com.jinfonet.image.encoder.ImageFrame;
import com.jinfonet.image.encoder.ImageFrameGrabber;
import com.jinfonet.image.encoder.gif.GIFEncoder;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import jet.util.JpegEncoder;

public class ImageEncoder {
    public static final int ENCODE_ERR = -1;
    public static final int ENCODE_GIF = 1;
    public static final int ENCODE_JPEG = 2;
    public static final int ENCODE_LOSTFRAMES = 4;

    public int encode(Image image, DataOutputStream dataOutputStream) {
        Vector vector = new Vector();
        boolean bl = new ImageFrameGrabber().startGrab(image, vector);
        if (vector.size() > 0) {
            int n = this.Compress(dataOutputStream, vector, image);
            if (n != -1 && !bl) {
                n |= 4;
            }
            return n;
        }
        return -1;
    }

    private int Compress(DataOutputStream dataOutputStream, Vector vector, Image image) {
        Object object;
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (ImageFrame)vector.elementAt(n2);
            n = Math.max(((ImageFrame)object).model.getPixelSize(), n);
            ++n2;
        }
        try {
            if (n > 8 && vector.size() == 1) {
                object = new JpegEncoder(image, 100, dataOutputStream);
                ((JpegEncoder)object).Compress();
                dataOutputStream.close();
                return 2;
            }
            GIFEncoder.encode(dataOutputStream, vector);
            return 1;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public int encode(Image image, DataOutputStream dataOutputStream, int n) {
        Vector vector = new Vector();
        boolean bl = new ImageFrameGrabber().startGrab(image, vector);
        if (vector.size() > 0) {
            int n2 = -1;
            n2 = n == 1 || n == 2 ? this.QOIV(dataOutputStream, vector, n, image) : this.Compress(dataOutputStream, vector, image);
            if (n2 != -1 && !bl) {
                n2 |= 4;
            }
            return n2;
        }
        return -1;
    }

    private int QOIV(DataOutputStream dataOutputStream, Vector vector, int n, Image image) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            object = (ImageFrame)vector.elementAt(n3);
            n2 = Math.max(((ImageFrame)object).model.getPixelSize(), n2);
            ++n3;
        }
        try {
            if (n == 2) {
                object = new JpegEncoder(image, 100, dataOutputStream);
                ((JpegEncoder)object).Compress();
                dataOutputStream.close();
                return 2;
            }
            if (n == 1) {
                GIFEncoder.encode(dataOutputStream, vector);
                return 1;
            }
            return -1;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            Image image = Toolkit.getDefaultToolkit().getImage(stringArray[0]);
            MediaTracker mediaTracker = new MediaTracker(new Component(){});
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
                mediaTracker.removeImage(image);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImageEncoder imageEncoder = new ImageEncoder();
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(new File(stringArray[1])));
                int n = imageEncoder.encode(image, dataOutputStream);
                dataOutputStream.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            System.exit(0);
        } else {
            System.err.println("Usage: java com.jinfonet.image.encoder.ImageEncoder <Source File> <Destination File>");
            System.exit(1);
        }
    }
}

