/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.model;

import com.jinfonet.jdbc.model.AbstractAccessingPath;
import com.jinfonet.jdbc.model.ModelObject;
import com.jinfonet.jdbc.model.Table;
import com.jinfonet.jdbc.model.wizard.TestTable;
import com.jinfonet.jdbc.util.TypeTools;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class Column
implements ModelObject {
    protected String colName;
    protected int sqlType;
    protected AbstractAccessingPath valuePath;
    protected int precision;
    protected int scale;
    protected int nullable;
    protected boolean currency;
    protected Table parent;

    public void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.colName);
        objectOutput.writeInt(this.sqlType);
        objectOutput.writeInt(this.precision);
        objectOutput.writeInt(this.scale);
        objectOutput.writeInt(this.nullable);
        objectOutput.writeBoolean(this.currency);
        this.valuePath.write(objectOutput);
    }

    public void read(ObjectInput objectInput, int n) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.colName = objectInput.readUTF();
        this.sqlType = objectInput.readInt();
        this.precision = objectInput.readInt();
        this.scale = objectInput.readInt();
        this.nullable = objectInput.readInt();
        this.currency = objectInput.readBoolean();
        this.valuePath = new AbstractAccessingPath();
        this.valuePath.read(objectInput, n);
    }

    public void setParent(Table table) {
        this.parent = table;
    }

    public Table getParent() {
        return this.parent;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String string) {
        this.colName = string;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(int n) {
        this.sqlType = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public int isNullable() {
        return this.nullable;
    }

    public void setNullable(int n) {
        this.nullable = n;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public void setCurrency(boolean bl) {
        this.currency = bl;
    }

    public void setAccessingPath(AbstractAccessingPath abstractAccessingPath) {
        this.valuePath = abstractAccessingPath;
    }

    public AbstractAccessingPath getAccessingPath() {
        return this.valuePath;
    }

    public String toString() {
        return this.getColName();
    }

    public Element getXMLNode(Document document) {
        Element element = document.createElement("Column");
        element.setAttribute("ColumnName", this.colName);
        element.setAttribute("SQLType", TypeTools.mapTypeToString(this.sqlType));
        element.setAttribute("Precision", this.precision + "");
        element.setAttribute("Scale", this.scale + "");
        element.setAttribute("Nullable", TestTable.NULLABLE[this.nullable]);
        element.setAttribute("Currency", this.currency + "");
        element.appendChild(this.valuePath.getXMLNode(document));
        return element;
    }

    public void setXMLNode(Element element) {
        Element element2 = Table.I(element, "Column");
        if (element2 != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            this.colName = Table.I(namedNodeMap, "ColumnName");
            this.sqlType = TypeTools.mapTypeToInt(Table.I(namedNodeMap, "SQLType"));
            this.precision = Integer.parseInt(Table.I(namedNodeMap, "Precision"));
            this.scale = Integer.parseInt(Table.I(namedNodeMap, "Scale"));
            this.nullable = TestTable.getNullable(Table.I(namedNodeMap, "Nullable"));
            this.currency = new Boolean(Table.I(namedNodeMap, "Currency"));
            this.valuePath = Table.I(element);
        }
    }

    public Column() {
    }

    public Column(String string, int n, int n2, int n3, int n4, boolean bl) {
        this.colName = string;
        this.sqlType = n;
        this.precision = n2;
        this.scale = n3;
        this.nullable = n4;
        this.currency = bl;
    }
}

