/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.util;

import com.jinfonet.jdbc.util.DupIntHashNode;
import com.jinfonet.jdbc.util.IntCircle;
import java.util.Vector;
import jet.util.IntVector;

public class DupIntHashtable {
    private transient DupIntHashNode[] QOIV;
    private transient int addElement;
    private int append;
    private float clone;

    public DupIntHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.clone = f;
        this.QOIV = new DupIntHashNode[n];
        this.append = (int)((float)n * f);
    }

    public DupIntHashtable(int n) {
        this(n, 0.618f);
    }

    public DupIntHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.addElement;
    }

    public boolean isEmpty() {
        return this.addElement == 0;
    }

    public synchronized boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.QOIV.length) {
            DupIntHashNode dupIntHashNode = this.QOIV[n2];
            while (dupIntHashNode != null) {
                if (dupIntHashNode.Z.contains(n)) {
                    return true;
                }
                dupIntHashNode = dupIntHashNode.C;
            }
            ++n2;
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        DupIntHashNode dupIntHashNode = this.QOIV[n2];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.I == n) {
                return true;
            }
            dupIntHashNode = dupIntHashNode.C;
        }
        return false;
    }

    public synchronized int get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        DupIntHashNode dupIntHashNode = this.QOIV[n2];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.I == n) {
                return dupIntHashNode.Z.next();
            }
            dupIntHashNode = dupIntHashNode.C;
        }
        return -1;
    }

    public synchronized int getFirst(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        DupIntHashNode dupIntHashNode = this.QOIV[n2];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.I == n) {
                return dupIntHashNode.Z.first();
            }
            dupIntHashNode = dupIntHashNode.C;
        }
        return -1;
    }

    public synchronized IntCircle getAll(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        DupIntHashNode dupIntHashNode = this.QOIV[n2];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.I == n) {
                return dupIntHashNode.Z;
            }
            dupIntHashNode = dupIntHashNode.C;
        }
        return null;
    }

    protected void rehash() {
        int n = this.QOIV.length;
        DupIntHashNode[] dupIntHashNodeArray = this.QOIV;
        int n2 = n * 2 + 1;
        DupIntHashNode[] dupIntHashNodeArray2 = new DupIntHashNode[n2];
        this.append = (int)((float)n2 * this.clone);
        this.QOIV = dupIntHashNodeArray2;
        int n3 = 0;
        while (n3 < n) {
            DupIntHashNode dupIntHashNode = dupIntHashNodeArray[n3];
            while (dupIntHashNode != null) {
                DupIntHashNode dupIntHashNode2 = dupIntHashNode;
                dupIntHashNode = dupIntHashNode.C;
                int n4 = (dupIntHashNode2.I & Integer.MAX_VALUE) % n2;
                dupIntHashNode2.C = dupIntHashNodeArray2[n4];
                dupIntHashNodeArray2[n4] = dupIntHashNode2;
            }
            ++n3;
        }
    }

    public synchronized IntCircle put(int n, int n2) {
        int n3 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        DupIntHashNode dupIntHashNode = this.QOIV[n3];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.I == n) {
                IntCircle intCircle = dupIntHashNode.Z;
                if (!intCircle.contains(n2)) {
                    intCircle.addElement(n2);
                }
                return intCircle;
            }
            dupIntHashNode = dupIntHashNode.C;
        }
        if (this.addElement >= this.append) {
            this.rehash();
            return this.put(n, n2);
        }
        DupIntHashNode dupIntHashNode2 = new DupIntHashNode();
        dupIntHashNode2.I = n;
        IntCircle intCircle = new IntCircle();
        intCircle.addElement(n2);
        dupIntHashNode2.Z = intCircle;
        dupIntHashNode2.C = this.QOIV[n3];
        this.QOIV[n3] = dupIntHashNode2;
        ++this.addElement;
        return null;
    }

    public synchronized IntCircle remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.QOIV.length;
        DupIntHashNode dupIntHashNode = this.QOIV[n2];
        DupIntHashNode dupIntHashNode2 = null;
        while (dupIntHashNode != null) {
            if (dupIntHashNode.I == n) {
                if (dupIntHashNode2 != null) {
                    dupIntHashNode2.C = dupIntHashNode.C;
                } else {
                    this.QOIV[n2] = dupIntHashNode.C;
                }
                --this.addElement;
                return dupIntHashNode.Z;
            }
            dupIntHashNode2 = dupIntHashNode;
            dupIntHashNode = dupIntHashNode.C;
        }
        return null;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.QOIV.length) {
            this.QOIV[n] = null;
            ++n;
        }
        this.addElement = 0;
    }

    public synchronized Object clone() {
        DupIntHashtable dupIntHashtable = new DupIntHashtable(this.QOIV.length, this.clone);
        int n = 0;
        while (n < this.QOIV.length) {
            dupIntHashtable.QOIV[n] = this.QOIV[n] != null ? (DupIntHashNode)this.QOIV[n].clone() : null;
            ++n;
        }
        return dupIntHashtable;
    }

    public synchronized IntVector keys() {
        IntVector intVector = null;
        if (this.addElement != 0) {
            intVector = new IntVector();
            int n = 0;
            while (n < this.QOIV.length) {
                DupIntHashNode dupIntHashNode = this.QOIV[n];
                if (dupIntHashNode != null) {
                    do {
                        intVector.addElement(dupIntHashNode.I);
                    } while ((dupIntHashNode = dupIntHashNode.C) != null);
                }
                ++n;
            }
        }
        return intVector;
    }

    public synchronized Vector elements() {
        Vector<IntCircle> vector = null;
        if (this.addElement != 0) {
            vector = new Vector<IntCircle>();
            int n = 0;
            while (n < this.QOIV.length) {
                DupIntHashNode dupIntHashNode = this.QOIV[n];
                if (dupIntHashNode != null) {
                    do {
                        vector.addElement(dupIntHashNode.Z);
                    } while ((dupIntHashNode = dupIntHashNode.C) != null);
                }
                ++n;
            }
        }
        return vector;
    }

    public synchronized IntCircle getKeys(int n) {
        IntCircle intCircle = new IntCircle();
        int n2 = 0;
        while (n2 < this.QOIV.length) {
            DupIntHashNode dupIntHashNode = this.QOIV[n2];
            while (dupIntHashNode != null) {
                if (dupIntHashNode.Z.contains(n)) {
                    intCircle.addElement(dupIntHashNode.I);
                }
                dupIntHashNode = dupIntHashNode.C;
            }
            ++n2;
        }
        int n3 = intCircle.size();
        if (n3 > 0) {
            return intCircle;
        }
        return null;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.addElement != 0) {
            stringBuffer.append("[");
            int n = 0;
            while (n < this.QOIV.length) {
                DupIntHashNode dupIntHashNode = this.QOIV[n];
                if (dupIntHashNode != null) {
                    do {
                        stringBuffer.append("[").append(dupIntHashNode.I).append(",").append(dupIntHashNode.Z).append("],");
                    } while ((dupIntHashNode = dupIntHashNode.C) != null);
                }
                ++n;
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void reStartValue() {
        int n = 0;
        while (n < this.QOIV.length) {
            DupIntHashNode dupIntHashNode = this.QOIV[n];
            while (dupIntHashNode != null) {
                dupIntHashNode.Z.reStart();
                dupIntHashNode = dupIntHashNode.C;
            }
            ++n;
        }
    }
}

