/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import java.util.EmptyStackException;

public class IntStack
implements Cloneable {
    int[] QOIV = new int[8];
    int append = -1;

    public final int push(int n) {
        this.QOIV(false);
        this.QOIV[++this.append] = n;
        return n;
    }

    public final synchronized int pop() {
        if (this.append == -1) {
            throw new EmptyStackException();
        }
        this.QOIV(true);
        return this.append > -1 ? this.QOIV[this.append--] : this.QOIV[0];
    }

    public final synchronized void pop(int n) {
        if (n > this.append + 1) {
            throw new EmptyStackException();
        }
        this.append -= n;
        this.QOIV(true);
    }

    public final synchronized int peek() {
        if (this.append == -1) {
            throw new EmptyStackException();
        }
        return this.QOIV[this.append];
    }

    public final void clear() {
        this.append = -1;
    }

    public final boolean empty() {
        return this.append == -1;
    }

    public final int getSize() {
        return this.append + 1;
    }

    public final synchronized int elementAt(int n) {
        if (n > this.append) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.append);
        }
        try {
            return this.QOIV[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized void setElementAt(int n, int n2) {
        if (n2 > this.append) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.append);
        }
        this.QOIV[n2] = n;
    }

    public final synchronized void removeElementAt(int n) {
        if (n > this.append) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.append);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.append - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.QOIV, n + 1, this.QOIV, n, n2);
        }
        --this.append;
        this.QOIV[this.append] = 0;
        this.QOIV(true);
    }

    public final synchronized void insertElementAt(int n, int n2) {
        if (n2 > this.append + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.append);
        }
        this.QOIV(false);
        System.arraycopy(this.QOIV, n2, this.QOIV, n2 + 1, this.append - n2);
        this.QOIV[n2] = n;
        ++this.append;
    }

    public synchronized Object clone() {
        try {
            IntStack intStack = (IntStack)super.clone();
            intStack.QOIV = new int[this.QOIV.length];
            if (this.append >= 0) {
                System.arraycopy(this.QOIV, 0, intStack.QOIV, 0, this.append + 1);
            }
            return intStack;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof IntStack) {
            if (this.append != -1 || ((IntStack)object).append != -1) {
                boolean bl3 = bl = this.append == ((IntStack)object).append;
                if (bl) {
                    int n = this.append;
                    while (n >= 0) {
                        if (this.QOIV[n] != ((IntStack)object).QOIV[n]) {
                            bl = false;
                            break;
                        }
                        --n;
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private void QOIV(boolean bl) {
        if (bl) {
            if (this.append < this.QOIV.length / 2 - 1 && this.QOIV.length > 8) {
                int[] nArray = new int[this.QOIV.length / 2];
                System.arraycopy(this.QOIV, 0, nArray, 0, this.QOIV.length / 2);
            }
        } else if (this.append == this.QOIV.length - 1) {
            int[] nArray = new int[this.QOIV.length * 2];
            System.arraycopy(this.QOIV, 0, nArray, 0, this.QOIV.length);
            this.QOIV = nArray;
        }
    }

    public String toString() {
        String string = "size = " + (this.append + 1) + ", {";
        int n = 0;
        while (n <= this.append) {
            string = string + this.QOIV[n] + (n == this.append ? "}" : ",");
            ++n;
        }
        string = string + '\n';
        return string;
    }
}

