/*
 * Decompiled with CFR 0.152.
 */
package jet.bean;

import com.jinfonet.util.JRLog;
import guitools.DefaultButton;
import guitools.toolkit.Unit;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import jet.Env;
import jet.JRStopEngineException;
import jet.ReportEnv;
import jet.bean.ExcelParameter;
import jet.bean.HtmlParameter;
import jet.bean.PDFParameter;
import jet.bean.PSParameter;
import jet.bean.RtfParameter;
import jet.bean.TextParameter;
import jet.bean.XmlParameter;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DataStream;
import jet.export.ExpException;
import jet.export.ExportEngineForViewer;
import jet.export.print.JReportPrintListener;
import jet.export.print.JReportSwingPrintViewer_JDK12;
import jet.export.print.JReportSwingPrintViewer_JDK14;
import jet.export.print.JReportSwingPrinter;
import jet.export.print.NoSuchPrintAttributeException;
import jet.export.xml.ExportToXML;
import jet.ie.RSTLoadControler;
import jet.ie.VersionException;
import jet.log.JRLogger;
import jet.log.JRLoggingUtil;
import jet.thinviewer.ClickActionListener;
import jet.thinviewer.JReportRunnerViewerHolder;
import jet.thinviewer.JReportViewer;
import jet.util.AwtTreeIterater;
import jet.util.FontSets;
import jet.util.RandomInputable;

public class JRResultViewer
extends JPanel
implements AdjustmentListener,
JReportPrintListener,
Externalizable,
ActionListener {
    private JPanel C = null;
    public static final int vOff = 0;
    public static final int vDebug = 1;
    public static final int vError = 4;
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int IE = 0;
    public static final int NETSCAPE = 1;
    private String QOIV = "";
    private String add = "no";
    private boolean addActionListener = false;
    private boolean addAdjustmentListener = false;
    private String addClickActionListener = "No report load";
    private boolean addElement = false;
    private String addViewer = "No print job";
    private Thread append = null;
    private int clearAwtTree = 0;
    private JScrollBar clearMem = new JScrollBar(0);
    private JScrollBar close = new JScrollBar(1);
    private DefaultButton compareTo;
    private DefaultButton configLog;
    private DefaultButton convertUnitToPixel;
    private DefaultButton currentTimeMillis;
    private JReportRunnerViewerHolder delXMLExt = null;
    private Communicator dispose = null;
    private Communicator elementAt = null;
    private static JFrame endsWith = null;
    private Vector equals;
    private Vector equalsIgnoreCase;
    private Vector error;
    private Vector exists;
    private Vector exit = null;
    private RandomInputable export = null;
    private int exportToDhtml = -1;
    private InputStream exportToExcelFile;
    private boolean exportToHtml = false;
    private boolean exportToHtmlFile = true;

    public JRResultViewer() {
        this.setSize(100, 150);
        this.setLayout(new BorderLayout());
        this.add((Component)this.clearMem, "South");
        this.add((Component)this.close, "East");
        this.clearMem.setMaximum(0);
        this.close.setMaximum(0);
        this.enableEvents(1L);
    }

    public JRResultViewer(boolean bl) {
        this();
        if (bl) {
            this.C = this.C();
            this.add((Component)this.C, "North");
        }
    }

    JRResultViewer(boolean bl, Communicator communicator) {
        this(bl);
        this.dispose = communicator;
    }

    private JPanel C() {
        this.C = new ButtonJPanel(this);
        this.C.setSize(200, 40);
        this.C.setLayout(null);
        this.compareTo = new DefaultButton("|<");
        this.compareTo.setBounds(10, 5, 30, 20);
        this.compareTo.setActionCommand("first page");
        this.compareTo.setLabelAlignment(1);
        this.compareTo.addActionListener(this);
        this.compareTo.setEnabled(false);
        this.C.add(this.compareTo);
        this.configLog = new DefaultButton("<<");
        this.configLog.setBounds(45, 5, 30, 20);
        this.configLog.setActionCommand("prev page");
        this.configLog.addActionListener(this);
        this.configLog.setEnabled(false);
        this.configLog.setLabelAlignment(4);
        this.C.add(this.configLog);
        this.convertUnitToPixel = new DefaultButton(">>");
        this.convertUnitToPixel.setBounds(80, 5, 30, 20);
        this.convertUnitToPixel.setActionCommand("next page");
        this.convertUnitToPixel.addActionListener(this);
        this.convertUnitToPixel.setEnabled(false);
        this.convertUnitToPixel.setLabelAlignment(4);
        this.C.add(this.convertUnitToPixel);
        this.currentTimeMillis = new DefaultButton(">|");
        this.currentTimeMillis.setBounds(115, 5, 30, 20);
        this.currentTimeMillis.setActionCommand("last page");
        this.currentTimeMillis.addActionListener(this);
        this.currentTimeMillis.setEnabled(false);
        this.currentTimeMillis.setLabelAlignment(4);
        this.C.add(this.currentTimeMillis);
        return this.C;
    }

    public void setRandomInput(RandomInputable randomInputable) {
        this.export = randomInputable;
    }

    public void setInputStream(InputStream inputStream, boolean bl) {
        this.exportToExcelFile = inputStream;
        this.exportToHtml = bl;
    }

    public void addClickActionListener(ClickActionListener clickActionListener) {
        if (this.exit == null) {
            this.exit = new Vector(3);
        }
        this.exit.addElement(clickActionListener);
    }

    public void setTempPath(String string) {
        ReportEnv.temporaryPath = string;
        if (!ReportEnv.temporaryPath.endsWith(File.separator)) {
            ReportEnv.temporaryPath = ReportEnv.temporaryPath + File.separator;
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5402901, ReportEnv.temporaryPath);
        }
    }

    public String getTempPath() {
        return ReportEnv.temporaryPath;
    }

    public String getReportName() {
        return this.QOIV;
    }

    public void setReportName(String string) {
        this.QOIV = string;
    }

    public int getPageOrientation() {
        block3: {
            if (this.dispose != null) {
                try {
                    DataStream dataStream = (DataStream)this.dispose.getDataStream(0);
                    Rectangle rectangle = this.QOIV(dataStream);
                    this.exportToDhtml = rectangle.width > rectangle.height ? 0 : 1;
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, 2402901);
                }
            }
        }
        return this.exportToDhtml;
    }

    private Rectangle QOIV(DataStream dataStream) throws Exception {
        Rectangle rectangle = null;
        DSPage dSPage = dataStream.getPage(1);
        rectangle = dSPage.getPageArea();
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setCommunicator(Communicator communicator) {
        this.elementAt = communicator;
    }

    public boolean isShowButton() {
        return this.addActionListener;
    }

    public void setShowButton(boolean bl) {
        this.addActionListener = bl;
        if (bl) {
            if (this.C == null) {
                this.C = this.C();
                this.add((Component)this.C, "North");
            }
        } else {
            this.remove(this.C);
            this.C = null;
        }
        this.doLayout();
    }

    public String getLoadReport() {
        return this.add;
    }

    public void setLoadReport(String string) {
        if (string.equalsIgnoreCase("no")) {
            this.add = string;
        } else {
            this.runReport();
            if (this.addClickActionListener != null && this.addClickActionListener.equals("OK")) {
                this.add = string;
            }
        }
    }

    public void printStart() {
        this.setEnabled(false);
        this.addViewer = "Busy";
    }

    public void printEnd() {
        this.setEnabled(true);
        this.addViewer = "Ok";
    }

    public void printReport() {
        this.printReport(null, null, true, false, false);
    }

    public void printReport(Object object, Object object2, boolean bl, boolean bl2, boolean bl3) {
        this.printReport(object, object2, bl, bl2, bl3, false);
    }

    public void printReport(Object object, Object object2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.printReport(object, object2, bl, bl2, bl3, bl4, null);
    }

    public void printReport(Object object, Object object2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        this.printReport(object, object2, bl, bl2, bl3, bl4, string, null);
    }

    public void printReport(Object object, Object object2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, String string2) {
        if (this.dispose != null) {
            if (endsWith == null) {
                endsWith = new JFrame();
            }
            this.addElement = false;
            try {
                JReportSwingPrinter.printInSameProcess(endsWith, this.dispose, object, bl, object2, bl2, this, bl3, false, bl4, string, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (endsWith == null) {
                endsWith.dispose();
                endsWith = null;
            }
        }
    }

    public void printReport(Object object, boolean bl, Object object2, boolean bl2, JReportPrintListener jReportPrintListener, int n, String string, Vector vector, String string2) throws NoSuchPrintAttributeException {
        if (this.dispose != null) {
            if (endsWith == null) {
                endsWith = new JFrame();
            }
            this.addElement = false;
            if (bl2) {
                this.setPrintStatus();
            }
            try {
                JReportSwingPrinter.printInSameProcess(endsWith, this.dispose, object, bl, object2, bl2, jReportPrintListener, n, false, true, string, vector, string2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                JReportSwingPrintViewer_JDK12.print(endsWith, this.dispose, null, true, null, bl2, null, false, true, string);
            }
            catch (JRStopEngineException jRStopEngineException) {
                // empty catch block
            }
        }
    }

    public void printReportJDK14(boolean bl, boolean bl2, JReportPrintListener jReportPrintListener, String string, Vector vector, Vector vector2, String string2) throws NoSuchPrintAttributeException {
        if (this.dispose != null) {
            if (endsWith == null) {
                endsWith = new JFrame();
            }
            this.addElement = false;
            if (bl2) {
                this.setPrintStatus();
            }
            try {
                JReportSwingPrinter.printJDK14(endsWith, this.dispose, bl, bl2, jReportPrintListener, false, string, vector, vector2, string2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                JReportSwingPrintViewer_JDK12.print(endsWith, this.dispose, null, true, null, bl2, null, false, true, string);
            }
        }
    }

    public static Vector getAllPrinters() {
        Vector<String> vector = new Vector<String>();
        if (JRResultViewer.add()) {
            String[] stringArray = JReportSwingPrintViewer_JDK14.getAvailablePrinter();
            int n = 0;
            while (n < stringArray.length) {
                vector.add(stringArray[n]);
                ++n;
            }
        }
        return vector;
    }

    private static boolean add() {
        String string = System.getProperty("java.version");
        int n = string.indexOf("version");
        if (n != -1) {
            string = string.substring(n);
        }
        return string.compareTo("1.4.0") >= 0;
    }

    public String getPrintStatus() {
        if (this.addElement) {
            this.addViewer = "No report load";
            this.addElement = false;
        }
        if (!this.addViewer.equals("Busy")) {
            this.addElement = true;
        }
        return this.addViewer;
    }

    public void setPrintStatus() {
        this.addViewer = "printing";
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.delXMLExt.scrolls(-this.clearMem.getValue(), -this.close.getValue());
    }

    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        if (aWTEvent.getID() == 101 && this.delXMLExt != null) {
            Dimension dimension = this.getSize();
            this.clearMem.setVisibleAmount(dimension.width);
            this.clearMem.setValue(this.clearMem.getValue());
            this.close.setVisibleAmount(dimension.height);
            this.close.setValue(this.close.getValue());
            this.clearMem.setUnitIncrement(dimension.width / 10);
            this.close.setUnitIncrement(dimension.height / 10);
            this.delXMLExt.scrolls(-this.clearMem.getValue(), -this.close.getValue());
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.getSize().width);
        objectOutput.writeInt(this.getSize().height);
        objectOutput.writeObject(this.QOIV);
        objectOutput.writeObject(this.add);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        this.setSize(n, n2);
        this.QOIV = (String)objectInput.readObject();
        this.setLoadReport((String)objectInput.readObject());
    }

    public void runReport() {
        block26: {
            if (JRLog.isTrace(4)) {
                long l = System.currentTimeMillis();
                JRLog.trace(4, 4402901, new Timestamp(l));
            }
            this.addAdjustmentListener = false;
            this.addClickActionListener = "Busy";
            if (this.elementAt != null && this.elementAt != this.dispose) {
                this.exit();
                this.dispose = this.elementAt;
                try {
                    this.addElement(this.dispose);
                    this.addClickActionListener = "OK";
                    this.repaint();
                }
                catch (Exception exception) {
                    this.addClickActionListener = exception.getMessage();
                    if (JRLog.isError(2)) {
                        JRLog.error(2, exception);
                    }
                    break block26;
                }
            }
            if (this.exportToExcelFile != null) {
                try {
                    this.addClickActionListener(this.exportToExcelFile);
                    this.addClickActionListener = "OK";
                }
                catch (Exception exception) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, exception);
                    }
                    this.addClickActionListener = exception.getMessage();
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, 5402902);
                    }
                    break block26;
                }
            }
            if (this.export != null) {
                try {
                    this.addActionListener(this.export);
                    this.addClickActionListener = "OK";
                }
                catch (Exception exception) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, exception);
                    }
                    this.addClickActionListener = exception.getMessage();
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, 5402903);
                    }
                    break block26;
                }
            }
            if (this.QOIV != null && this.QOIV.length() != 0) {
                File file = new File(this.QOIV);
                if (file.exists()) {
                    block27: {
                        try {
                            this.exit();
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, 5402904);
                            }
                            RSTLoadControler rSTLoadControler = new RSTLoadControler(this.QOIV);
                            this.dispose = this.addAdjustmentListener(rSTLoadControler);
                            this.addElement(this.dispose);
                            this.addClickActionListener = "OK";
                        }
                        catch (Exception exception) {
                            this.addClickActionListener = exception.getMessage();
                            if (!JRLog.isError(2)) break block27;
                            JRLog.error(2, exception);
                        }
                    }
                    this.repaint();
                } else {
                    this.addClickActionListener = "Cannot open the report result file \"" + this.QOIV + "\"!";
                }
            } else if (this.dispose != null) {
                block28: {
                    try {
                        this.addElement(this.dispose);
                        this.addClickActionListener = "OK";
                    }
                    catch (Exception exception) {
                        this.addClickActionListener = exception.getMessage();
                        if (!JRLog.isError(2)) break block28;
                        JRLog.error(2, exception);
                    }
                }
                this.repaint();
            } else {
                this.addClickActionListener = "Communicator is null";
            }
        }
    }

    private boolean addActionListener(RandomInputable randomInputable) throws Exception {
        this.addClickActionListener = "Busy";
        boolean bl = false;
        this.addAdjustmentListener = false;
        RSTLoadControler rSTLoadControler = new RSTLoadControler(randomInputable);
        this.dispose = this.addAdjustmentListener(rSTLoadControler);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5402905);
        }
        this.addElement(this.dispose);
        return bl;
    }

    private Communicator addAdjustmentListener(RSTLoadControler rSTLoadControler) {
        try {
            rSTLoadControler.openFile();
            Map map = rSTLoadControler.getReportInfos();
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            String string = null;
            String string2 = null;
            if (iterator.hasNext()) {
                string = (String)iterator.next();
                if (string.equals("noReportSet")) {
                    string2 = null;
                } else {
                    Vector vector = (Vector)map.get(string);
                    if (vector != null && vector.size() > 0) {
                        string2 = ((String[])vector.get(0))[0];
                    }
                }
            }
            return rSTLoadControler.getCommunicator(string, string2);
        }
        catch (VersionException versionException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2402902, (Throwable)versionException);
            }
            return null;
        }
    }

    private boolean addClickActionListener(InputStream inputStream) throws Exception {
        this.addClickActionListener = "Busy";
        boolean bl = false;
        this.addAdjustmentListener = false;
        RSTLoadControler rSTLoadControler = new RSTLoadControler(inputStream, this.exportToHtml);
        this.dispose = this.addAdjustmentListener(rSTLoadControler);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5402905);
        }
        this.addElement(this.dispose);
        return bl;
    }

    private void addElement(Communicator communicator) throws Exception {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5402906);
        }
        DataStream dataStream = (DataStream)communicator.getDataStream(0);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5402907);
        }
        JReportViewer jReportViewer = new JReportViewer(dataStream);
        if (this.exit != null) {
            int n = 0;
            while (n < this.exit.size()) {
                jReportViewer.addClickActionListener((ClickActionListener)this.exit.elementAt(n));
                ++n;
            }
        }
        Rectangle rectangle = this.QOIV(dataStream);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle2.width = Unit.convertUnitToPixel(rectangle2.width);
        rectangle2.height = Unit.convertUnitToPixel(rectangle2.height);
        if (this.delXMLExt != null) {
            this.remove(this.delXMLExt);
        }
        this.delXMLExt = new JReportRunnerViewerHolder();
        this.delXMLExt.setBounds(0, 0, rectangle2.width, rectangle2.height);
        this.delXMLExt.addViewer(jReportViewer);
        jReportViewer.setUsingThread(false);
        this.add((Component)this.delXMLExt, "Center");
        this.doLayout();
        Dimension dimension = this.getSize();
        this.clearMem.setBlockIncrement(dimension.width);
        this.close.setBlockIncrement(dimension.height);
        this.clearMem.setValues(0, dimension.width, 0, rectangle2.width);
        this.close.setValues(0, dimension.height, 0, rectangle2.height);
        this.clearMem.setUnitIncrement(dimension.width / 10);
        this.close.setUnitIncrement(dimension.height / 10);
        this.clearMem.addAdjustmentListener(this);
        this.close.addAdjustmentListener(this);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5402908);
        }
        jReportViewer.firstViewReport(0, 0, rectangle2.width, rectangle2.height);
        this.elementAt(this.getCurrentPageNumber(), this.getTotalPageNumber());
        this.addClickActionListener = "OK";
    }

    private String addViewer() {
        int n;
        String string = new File(this.QOIV).getName();
        if (!string.equals("") && this.QOIV.endsWith(string) && (n = string.lastIndexOf(".")) != -1) {
            string = Env.delXMLExt(string);
            string = string.substring(0, n);
        }
        return string;
    }

    public boolean exportToHtml(String string) {
        return this.exportToHtml(string, false, true, false, true, true, true, 0);
    }

    public boolean exportToHtml(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        return this.exportToHtml(string, bl, bl2, bl3, bl4, bl5, bl6, n, false);
    }

    public boolean exportToHtml(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7) {
        if (this.dispose != null) {
            if (string.equals("")) {
                string = this.addViewer() + ".html";
            }
            return this.clearAwtTree(this.dispose, string, bl, bl2, bl3, bl4, bl5, bl6, n, bl7, false, -1);
        }
        this.addClickActionListener = "communicator is null";
        return false;
    }

    public boolean exportToHtml(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8) {
        return this.exportToHtml(string, string2, bl, bl2, bl3, bl4, bl5, bl6, n, bl7, bl8, -1);
    }

    public boolean exportToHtml(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8, int n2) {
        try {
            RSTLoadControler rSTLoadControler = new RSTLoadControler(string);
            Communicator communicator = this.addAdjustmentListener(rSTLoadControler);
            boolean bl9 = this.clearAwtTree(communicator, string2, bl, bl2, bl3, bl4, bl5, bl6, n, bl7, bl8, n2);
            communicator.clearMem();
            this.addClickActionListener = "Export OK";
            return bl9;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, iOException);
            }
            this.addClickActionListener = "can not get communicator from rst file";
            return false;
        }
    }

    public void setHtmlImageType(int n) {
        this.clearAwtTree = n;
    }

    public boolean exportToHtml(String string, HtmlParameter htmlParameter) {
        if (this.dispose != null) {
            return this.append(this.dispose, string, htmlParameter);
        }
        this.addClickActionListener = "communicator is null";
        return false;
    }

    private boolean append(Communicator communicator, String string, HtmlParameter htmlParameter) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (string.equals("")) {
                    string = this.addViewer() + ".html";
                }
                String string2 = new File(string).getName();
                String string3 = this.close(string);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, 5402910, new Object[]{string3, string2});
                }
                List list = ExportEngineForViewer.exportToHtmlFile(communicator, string, htmlParameter, null);
                this.equals = new Vector(list);
                this.addClickActionListener = "Export ok!";
                this.addAdjustmentListener = false;
                bl = true;
            }
            catch (Exception exception) {
                this.addClickActionListener = "error";
                if (!JRLog.isError(2)) break block4;
                JRLog.error(2, exception);
            }
        }
        return bl;
    }

    private boolean clearAwtTree(Communicator communicator, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8, int n2) {
        HtmlParameter htmlParameter = new HtmlParameter();
        htmlParameter.setIsExportAppletChart(bl);
        htmlParameter.setIsExportToMultiFiles(bl2);
        htmlParameter.setIsIncludeDrillDownFile(bl7);
        htmlParameter.setIsNoMargin(bl8);
        htmlParameter.setExportImageType(this.clearAwtTree);
        htmlParameter.setHasHyperlink(bl4);
        htmlParameter.setHasPageNumber(bl5);
        htmlParameter.setIsAbsoluteFontSize(bl6);
        htmlParameter.setBrowserType(n);
        htmlParameter.setResolution(n2);
        return this.append(communicator, string, htmlParameter);
    }

    public Vector getAllHtmlFile() {
        return this.equals;
    }

    public boolean exportToDhtml(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8) {
        try {
            RSTLoadControler rSTLoadControler = new RSTLoadControler(string);
            Communicator communicator = this.addAdjustmentListener(rSTLoadControler);
            boolean bl9 = this.clearMem(communicator, string2, bl, bl2, bl3, bl4, bl5, bl6, n, bl7, bl8, -1);
            communicator.clearMem();
            return bl9;
        }
        catch (IOException iOException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, iOException);
            }
            return false;
        }
    }

    public boolean exportToDhtml(String string) {
        return this.exportToDhtml(string, false, true, false, true, true, true, 0);
    }

    public boolean exportToDhtml(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        return this.exportToDhtml(string, bl, bl2, bl3, bl4, bl5, bl6, n, false);
    }

    public boolean exportToDhtml(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7) {
        return this.exportToDhtml(string, bl, bl2, bl3, bl4, bl5, bl6, n, bl7, false);
    }

    public boolean exportToDhtml(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8) {
        return this.exportToDhtml(string, bl, bl2, bl3, bl4, bl5, bl6, n, bl7, bl8, -1);
    }

    public boolean exportToDhtml(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8, int n2) {
        boolean bl9 = false;
        if (this.dispose != null) {
            bl9 = this.clearMem(this.dispose, string, bl, bl2, bl3, bl4, bl5, bl6, n, bl7, bl8, n2);
        }
        this.addClickActionListener = "communicator is null";
        return bl9;
    }

    private boolean clearMem(Communicator communicator, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8, int n2) {
        boolean bl9;
        block8: {
            bl9 = false;
            try {
                if (string.equals("")) {
                    string = this.addViewer();
                }
                this.addAdjustmentListener = false;
                String string2 = new File(string).getName();
                String string3 = this.close(string);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, 5402910, new Object[]{string3, string2});
                }
                HtmlParameter htmlParameter = new HtmlParameter();
                htmlParameter.setIsExportAppletChart(bl);
                htmlParameter.setIsExportToMultiFiles(bl2);
                htmlParameter.setIsIncludeDrillDownFile(bl7);
                htmlParameter.setIsNoMargin(bl8);
                htmlParameter.setExportImageType(this.clearAwtTree);
                htmlParameter.setHasHyperlink(bl4);
                htmlParameter.setHasPageNumber(bl5);
                htmlParameter.setIsAbsoluteFontSize(bl6);
                htmlParameter.setBrowserType(n);
                htmlParameter.setResolution(n2);
                String string4 = new File(this.QOIV).getName();
                if (string4.lastIndexOf(".cls") != -1) {
                    string4 = string4.substring(0, string4.lastIndexOf(".cls"));
                } else if (string4.lastIndexOf(".rpt") != -1) {
                    string4 = string4.substring(0, string4.lastIndexOf(".rpt"));
                }
                if (string4.lastIndexOf(File.separatorChar) != -1) {
                    string4 = string4.substring(string4.lastIndexOf(File.separatorChar) + 1, string4.length());
                }
                htmlParameter.setTitle(string4);
                List list = ExportEngineForViewer.exportToHtmlFile(communicator, string, htmlParameter, null);
                this.equals = new Vector(list);
                this.addClickActionListener = "OK";
                bl9 = true;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block8;
                JRLog.error(2, exception);
            }
        }
        return bl9;
    }

    private String close(String string) {
        File file = new File(string);
        String string2 = string.endsWith(file.getName()) ? file.getParent() : file.getParent() + File.separator + file.getName();
        if (string2 != null) {
            return string2;
        }
        return System.getProperty("user.dir");
    }

    public boolean exportToPdf(String string) {
        return this.exportToPdf(string, false);
    }

    public boolean exportToPdf(String string, boolean bl) {
        return this.exportToPdf(string, bl, false);
    }

    public boolean exportToPdf(String string, boolean bl, boolean bl2) {
        return this.exportToPdf(string, bl, bl2, true);
    }

    public boolean exportToPdf(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.exportToPdf(string, bl, bl2, bl3 ? 20 : -1, false);
    }

    public boolean exportToPdf(String string, boolean bl, boolean bl2, int n, boolean bl3) {
        return this.exportToPdf(string, bl, bl2, n, bl3, false, false);
    }

    public boolean exportToPdf(String string, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5) {
        return this.exportToPdf(string, bl, bl2, n, bl3, bl4, bl5, null);
    }

    public boolean exportToPdf(String string, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5, String string2) {
        PDFParameter pDFParameter = new PDFParameter();
        pDFParameter.setNoMargin(bl);
        pDFParameter.setIsSimPrintMode(bl2);
        pDFParameter.setImageCompressRatio(n);
        pDFParameter.setToc(bl4);
        pDFParameter.setDrill(bl5);
        if (string2 != null) {
            pDFParameter.setPassword(string2);
        }
        return this.exportToPdf(string, pDFParameter);
    }

    public boolean exportToPdf(String string, PDFParameter pDFParameter) {
        if (this.dispose != null) {
            return this.compareTo(this.dispose, string, pDFParameter);
        }
        this.addClickActionListener = "communicator is null";
        return false;
    }

    private boolean compareTo(Communicator communicator, String string, PDFParameter pDFParameter) {
        boolean bl;
        block5: {
            bl = false;
            try {
                if (string.equals("")) {
                    string = this.addViewer() + ".pdf";
                }
                ExportEngineForViewer.exportToPDFFile(communicator, string, pDFParameter, null);
                this.addClickActionListener = "Export ok!";
                this.addAdjustmentListener = false;
                bl = true;
            }
            catch (ExpException expException) {
                this.addClickActionListener = "error";
                if (JRLog.isError(2)) {
                    JRLog.error(2, expException);
                }
            }
            catch (Exception exception) {
                this.addClickActionListener = "error";
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, exception);
            }
        }
        return bl;
    }

    public boolean exportToText(String string, boolean bl) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, int n, int n2) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setUDCHWidth(n);
        textParameter.setUDCHHeight(n2);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, int n, int n2, boolean bl2, int n3) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setUDCHWidth(n);
        textParameter.setUDCHHeight(n2);
        textParameter.setCompress(bl2);
        textParameter.setResolution(n3);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, boolean bl2, char c) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setRepeat(bl2);
        textParameter.setDelimiter(c);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, boolean bl2, char c, boolean bl3) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setRepeat(bl2);
        textParameter.setDelimiter(c);
        textParameter.setCompress(bl3);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, boolean bl2, char c, boolean bl3, boolean bl4) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setRepeat(bl2);
        textParameter.setDelimiter(c);
        textParameter.setCompress(bl3);
        textParameter.setUseQuoteMark(bl4);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, int n, int n2, boolean bl2, int n3, boolean bl3) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setUDCHWidth(n);
        textParameter.setUDCHHeight(n2);
        textParameter.setCompress(bl2);
        textParameter.setResolution(n3);
        textParameter.setUseQuoteMark(bl3);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, boolean bl2, char c, int n, int n2, boolean bl3, int n3, boolean bl4, boolean bl5) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setRepeat(bl2);
        textParameter.setDelimiter(c);
        textParameter.setUDCHWidth(n);
        textParameter.setUDCHHeight(n2);
        textParameter.setCompress(bl3);
        textParameter.setResolution(n3);
        textParameter.setUseQuoteMark(bl4);
        textParameter.setHasHeadFoot(bl5);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, boolean bl2, char c, int n, int n2, boolean bl3, int n3, boolean bl4, boolean bl5, boolean bl6) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setRepeat(bl2);
        textParameter.setDelimiter(c);
        textParameter.setUDCHWidth(n);
        textParameter.setUDCHHeight(n2);
        textParameter.setCompress(bl3);
        textParameter.setResolution(n3);
        textParameter.setUseQuoteMark(bl4);
        textParameter.setHasHeadFoot(bl5);
        textParameter.setForWinExport(bl6);
        return this.exportToText(string, textParameter);
    }

    public boolean exportToText(String string, boolean bl, boolean bl2, char c, int n, int n2, boolean bl3, int n3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        TextParameter textParameter = new TextParameter();
        textParameter.setNormalTextFile(bl);
        textParameter.setRepeat(bl2);
        if (!bl7) {
            textParameter.setDelimiter(c);
        }
        textParameter.setUDCHWidth(n);
        textParameter.setUDCHHeight(n2);
        textParameter.setCompress(bl3);
        textParameter.setResolution(n3);
        textParameter.setUseQuoteMark(bl4);
        textParameter.setHasHeadFoot(bl5);
        textParameter.setForWinExport(bl6);
        return this.exportToText(string, textParameter);
    }

    private boolean configLog(Communicator communicator, String string, TextParameter textParameter) {
        boolean bl;
        block5: {
            bl = false;
            try {
                if (string.length() == 0) {
                    string = this.addViewer();
                }
                ExportEngineForViewer.exportToTextFile(communicator, string, textParameter, null);
                this.addClickActionListener = "Export ok!";
                this.addAdjustmentListener = false;
            }
            catch (ExpException expException) {
                this.addClickActionListener = "error";
                if (JRLog.isError(2)) {
                    JRLog.error(2, expException);
                }
            }
            catch (Exception exception) {
                this.addClickActionListener = "error";
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, exception);
            }
        }
        return bl;
    }

    public boolean exportToText(String string, TextParameter textParameter) {
        if (this.dispose != null) {
            return this.configLog(this.dispose, string, textParameter);
        }
        this.addClickActionListener = "communicator is null";
        return false;
    }

    public boolean exportToPS(String string) {
        return this.exportToPS(string, false);
    }

    public boolean exportToPS(String string, boolean bl) {
        PSParameter pSParameter = new PSParameter();
        pSParameter.setNoMargin(bl);
        return this.exportToPS(string, pSParameter);
    }

    public boolean exportToPS(String string, PSParameter pSParameter) {
        if (this.dispose != null) {
            return this.convertUnitToPixel(this.dispose, string, pSParameter);
        }
        this.addClickActionListener = "communicator is null";
        return false;
    }

    private boolean convertUnitToPixel(Communicator communicator, String string, PSParameter pSParameter) {
        boolean bl;
        block5: {
            bl = false;
            try {
                if (string == null) {
                    string = this.addViewer();
                }
                this.addAdjustmentListener = false;
                ExportEngineForViewer.exportToPsFile(communicator, string, pSParameter, null);
                bl = true;
                this.addClickActionListener = "OK";
            }
            catch (ExpException expException) {
                this.addClickActionListener = "error";
                if (JRLog.isError(2)) {
                    JRLog.error(2, expException);
                }
            }
            catch (Exception exception) {
                this.addClickActionListener = "error";
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, exception);
            }
        }
        return bl;
    }

    public boolean exportToRtf(String string) {
        return this.exportToRtf(string, false);
    }

    public boolean exportToRtf(String string, boolean bl) {
        RtfParameter rtfParameter = new RtfParameter();
        rtfParameter.setNoMargin(bl);
        return this.currentTimeMillis(this.dispose, string, rtfParameter);
    }

    public boolean exportToRtf(String string, RtfParameter rtfParameter) {
        if (this.dispose != null) {
            return this.currentTimeMillis(this.dispose, string, rtfParameter);
        }
        this.addClickActionListener = "communicator is null";
        return false;
    }

    private boolean currentTimeMillis(Communicator communicator, String string, RtfParameter rtfParameter) {
        boolean bl;
        block6: {
            bl = false;
            try {
                this.addAdjustmentListener = false;
                if (string == null) {
                    string = this.addViewer();
                }
                String string2 = new File(string).getName();
                String string3 = this.close(string);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, 5402909, new Object[]{string3, string2});
                }
                List list = ExportEngineForViewer.exportToRtfFile(communicator, string, rtfParameter, null);
                this.error = new Vector(list);
                this.addClickActionListener = "OK";
                bl = true;
            }
            catch (ExpException expException) {
                this.addClickActionListener = "Error!";
                if (JRLog.isError(2)) {
                    JRLog.error(2, expException);
                }
            }
            catch (Exception exception) {
                this.addClickActionListener = "Error!";
                if (!JRLog.isError(2)) break block6;
                JRLog.error(2, exception);
            }
        }
        return bl;
    }

    public Vector getAllRtfFile() {
        return this.error;
    }

    public boolean exportToXls(String string) {
        return this.exportToXls(string, 0);
    }

    public boolean exportToXls(String string, int n) {
        return this.exportToXls(string, n, false);
    }

    public boolean exportToXls(String string, int n, boolean bl) {
        return this.exportToXls(string, n, bl, 0);
    }

    public boolean exportToXls(String string, int n, boolean bl, int n2) {
        ExcelParameter excelParameter = new ExcelParameter();
        excelParameter.setBiff8(bl);
        excelParameter.setParam(n2);
        excelParameter.setWordWrapType(n);
        return this.exportToXls(string, excelParameter);
    }

    public boolean exportToXls(String string, ExcelParameter excelParameter) {
        if (this.dispose != null) {
            return this.delXMLExt(this.dispose, string, excelParameter);
        }
        this.addClickActionListener = "communicator is null";
        return false;
    }

    private boolean delXMLExt(Communicator communicator, String string, ExcelParameter excelParameter) {
        boolean bl;
        block6: {
            bl = false;
            try {
                if (string.length() == 0) {
                    string = this.addViewer() + ".xls";
                }
                this.addAdjustmentListener = false;
                String string2 = new File(string).getName();
                String string3 = this.close(string);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, 5402911, new Object[]{string3, string2});
                }
                List list = ExportEngineForViewer.exportToExcelFile(communicator, string, excelParameter, null);
                this.equalsIgnoreCase = new Vector(list);
                this.addClickActionListener = "OK";
                bl = true;
            }
            catch (ExpException expException) {
                this.addClickActionListener = "Error!";
                if (JRLog.isError(2)) {
                    JRLog.error(2, expException);
                }
            }
            catch (Exception exception) {
                this.addClickActionListener = "Error!";
                if (!JRLog.isError(2)) break block6;
                JRLog.error(2, exception);
            }
        }
        return bl;
    }

    public Vector getAllXlsFile() {
        return this.equalsIgnoreCase;
    }

    public boolean exportToXML(String string, boolean bl, String string2) {
        if (this.dispose != null) {
            if (string.equals("")) {
                string = this.addViewer() + ".xml";
            }
            return this.dispose(this.dispose, string, bl, string2);
        }
        return false;
    }

    public boolean exportToXML(String string, boolean bl) {
        return this.exportToXML(string, bl, null);
    }

    public boolean exportToXML(String string, boolean bl, boolean bl2) {
        return this.exportToXML(string, bl2);
    }

    private boolean dispose(Communicator communicator, String string, boolean bl, String string2) {
        boolean bl2;
        block3: {
            bl2 = false;
            try {
                this.addAdjustmentListener = false;
                XmlParameter xmlParameter = new XmlParameter();
                xmlParameter.setOnlyData(bl);
                xmlParameter.setSchemaFile(string2);
                xmlParameter.setXmlFileName(string);
                this.exists = ExportToXML.export(communicator, xmlParameter);
                if (JRLog.isTrace(4)) {
                    JRLog.trace(2, 5402912, this.exists);
                }
                bl2 = this.exists.size() > 0;
                this.addClickActionListener = "OK";
                bl2 = true;
            }
            catch (Exception exception) {
                this.addClickActionListener = "Error!";
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, exception);
            }
        }
        return bl2;
    }

    public Vector getAllXMLFile() {
        return this.exists;
    }

    public void exit() {
        block6: {
            try {
                block7: {
                    if (this.dispose == null) break block6;
                    if (this.append != null) {
                        try {
                            this.append.join();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!JRLog.isError(2)) break block7;
                            JRLog.error(2, interruptedException);
                        }
                    }
                }
                FontSets.unloadAllFonts();
                this.dispose.clearMem();
                this.dispose = null;
                AwtTreeIterater.clearAwtTree(this.delXMLExt);
                this.remove(this.delXMLExt);
                if (this.delXMLExt != null) {
                    this.delXMLExt.clearMem();
                }
                this.delXMLExt = null;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block6;
                JRLog.error(2, exception);
            }
        }
    }

    public String getStatus() {
        if (this.addAdjustmentListener) {
            this.addClickActionListener = "No report load";
            this.addAdjustmentListener = false;
        }
        if (this.addClickActionListener == null) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5402913);
            }
            this.addClickActionListener = "";
            this.addAdjustmentListener = true;
        } else if (!this.addClickActionListener.equals("No Report Load")) {
            this.addAdjustmentListener = true;
        }
        return this.addClickActionListener;
    }

    public int getCurrentPageNumber() {
        if (this.delXMLExt != null) {
            return this.delXMLExt.getCurrentPageNumber();
        }
        return -1;
    }

    public int getTotalPageNumber() {
        if (this.delXMLExt != null) {
            return this.delXMLExt.getTotalPageNumber();
        }
        return -1;
    }

    public int gotoPage(int n) {
        if (this.delXMLExt != null) {
            try {
                int n2 = this.delXMLExt.toPage(n);
                this.elementAt(this.getCurrentPageNumber(), this.getTotalPageNumber());
                return n2;
            }
            catch (JRStopEngineException jRStopEngineException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String firstPage() {
        if (this.delXMLExt != null) {
            try {
                String string = this.delXMLExt.firstPage();
                this.elementAt(this.getCurrentPageNumber(), this.getTotalPageNumber());
                return string;
            }
            catch (JRStopEngineException jRStopEngineException) {
                return "Be stoped!";
            }
        }
        return "No report load";
    }

    public String prevPage() {
        if (this.delXMLExt != null) {
            try {
                String string = this.delXMLExt.prevPage();
                this.elementAt(this.getCurrentPageNumber(), this.getTotalPageNumber());
                return string;
            }
            catch (JRStopEngineException jRStopEngineException) {
                return "Be stoped!";
            }
        }
        return "No report load";
    }

    public String nextPage() {
        if (this.delXMLExt != null) {
            try {
                String string = this.delXMLExt.nextPage();
                this.elementAt(this.getCurrentPageNumber(), this.getTotalPageNumber());
                return string;
            }
            catch (JRStopEngineException jRStopEngineException) {
                return "Be stoped!";
            }
        }
        return "No report load";
    }

    public String lastPage() {
        if (this.delXMLExt != null) {
            try {
                String string = this.delXMLExt.lastPage();
                this.elementAt(this.getCurrentPageNumber(), this.getTotalPageNumber());
                return string;
            }
            catch (JRStopEngineException jRStopEngineException) {
                return "Be stoped!";
            }
        }
        return "No report load";
    }

    public void setShowInfoLevel(int n) {
        JRLogger.setDebugLevel(n);
    }

    public boolean setLogFile(String string) {
        return JRLoggingUtil.configLog(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("first page")) {
            this.firstPage();
        } else if (string.equals("last page")) {
            this.lastPage();
        } else if (string.equals("next page")) {
            this.nextPage();
        } else if (string.equals("prev page")) {
            this.prevPage();
        }
    }

    public String saveAs() {
        String string;
        block7: {
            string = "No report load";
            Container container = this.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            if (container != null) {
                FileDialog fileDialog = new FileDialog((Frame)container, "Save As...", 1);
                fileDialog.setFile("*.rst");
                fileDialog.setVisible(true);
                String string2 = fileDialog.getFile();
                String string3 = fileDialog.getDirectory();
                try {
                    int n;
                    FileReader fileReader = new FileReader(this.QOIV);
                    FileWriter fileWriter = new FileWriter(string3 + string2);
                    while ((n = fileReader.read()) != -1) {
                        fileWriter.write(n);
                    }
                    fileReader.close();
                    fileWriter.close();
                    string = "OK";
                }
                catch (FileNotFoundException fileNotFoundException) {
                    string = "Error: can not open file " + this.QOIV;
                    if (JRLog.isError(2)) {
                        JRLog.error(2, fileNotFoundException);
                    }
                }
                catch (IOException iOException) {
                    string = "Error: can not save file " + string3 + string2;
                    if (!JRLog.isError(2)) break block7;
                    JRLog.error(2, iOException);
                }
            }
        }
        return string;
    }

    private void elementAt(int n, int n2) {
        if (this.compareTo == null) {
            return;
        }
        if (n2 == 1) {
            this.compareTo.setEnabled(false);
            this.configLog.setEnabled(false);
            this.convertUnitToPixel.setEnabled(false);
            this.currentTimeMillis.setEnabled(false);
            return;
        }
        if (n == 1) {
            this.compareTo.setEnabled(false);
            this.configLog.setEnabled(false);
            this.convertUnitToPixel.setEnabled(true);
            this.currentTimeMillis.setEnabled(true);
        } else if (n == n2) {
            this.compareTo.setEnabled(true);
            this.configLog.setEnabled(true);
            this.convertUnitToPixel.setEnabled(false);
            this.currentTimeMillis.setEnabled(false);
        } else {
            this.compareTo.setEnabled(true);
            this.configLog.setEnabled(true);
            this.convertUnitToPixel.setEnabled(true);
            this.currentTimeMillis.setEnabled(true);
        }
    }

    public void zoom(int n) {
        if (this.dispose != null) {
            int n2 = (int)((double)Unit.getResolution() * ((double)n / 100.0));
            this.dispose.setResolution(n2);
            JReportViewer jReportViewer = this.delXMLExt.getViewer();
            jReportViewer.setUsingThread(false);
            jReportViewer.setDataStream(null);
            jReportViewer.reload();
            try {
                DataStream dataStream = (DataStream)this.dispose.getDataStream(0);
                Rectangle rectangle = null;
                try {
                    rectangle = this.QOIV(dataStream);
                }
                catch (Exception exception) {
                    rectangle = new Rectangle(0, 0, 597, 842);
                }
                rectangle.width = Unit.convertUnitToPixel(rectangle.width, n2);
                rectangle.height = Unit.convertUnitToPixel(rectangle.height, n2);
                jReportViewer.setSize(rectangle.width, rectangle.height);
                this.clearMem.setMaximum(rectangle.width);
                this.clearMem.setValue(this.clearMem.getValue() * n2);
                this.close.setMaximum(rectangle.height);
                this.close.setValue(this.close.getValue() * n2);
            }
            catch (JRStopEngineException jRStopEngineException) {
                // empty catch block
            }
        }
    }

    public boolean isZipStream(InputStream inputStream) {
        try {
            return inputStream != null && inputStream.read() == 80 && inputStream.read() == 75;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setScrollbars(boolean bl) {
        this.exportToHtmlFile = bl;
        if (bl) {
            if (this.clearMem.getParent() == null) {
                this.add((Component)this.clearMem, "South");
                this.add((Component)this.close, "East");
            }
        } else if (this.clearMem.getParent() != null) {
            this.remove(this.clearMem);
            this.remove(this.close);
        }
    }

    public boolean hasScrollbars() {
        return this.exportToHtmlFile;
    }

    public boolean getScrollbars() {
        return this.exportToHtmlFile;
    }

    public void closeLog() {
    }

    public void setHomePath(String string) {
        ReportEnv.homePath = string;
    }

    class ButtonJPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JRResultViewer this$0;

        ButtonJPanel(JRResultViewer jRResultViewer) {
            this.this$0 = jRResultViewer;
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 30);
        }
    }
}

