/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine.util.externalsort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.util.externalsort.CellComparator;
import jet.dataengine.util.externalsort.RecordComparator;
import jet.dataengine8.dbbuffer.DbBufferDataImpl;
import jet.dataengine8.dbbuffer.RecordImpl;
import jet.dataengine8.dbbuffer.RecordModel;
import jet.dataengine8.dbbuffer.RecordTool;

public class MergerSort {
    public static final int MINMEMORYSIZE = 4;
    public static final int ASC = 1;
    public static final int DESC = -1;
    private final RecordModelInfo QOIV;
    private final int[] active;
    private final int add;
    private final int addRecord;
    private final JRecord clone;
    private final DbValue[][] close;
    private final RecordComparator compare;
    private final CellComparator countColumns;
    private final int createCursor = 2048;
    private final int createRecord = 2;
    private int currentTimeMillis = 0;
    private List finish = new ArrayList(20);
    private final int get;
    private final int getCell;
    private final int getColDescs;
    private DbBufferDataImpl getPosition;
    private boolean getRecordLen = true;

    public MergerSort(RecordModelInfo recordModelInfo, int n, int[] nArray) {
        this.QOIV = recordModelInfo;
        this.active = nArray;
        this.add = Math.max(n, 4);
        this.compare = new RecordComparator(nArray);
        this.countColumns = new CellComparator(nArray);
        long l = System.currentTimeMillis();
        this.get = RecordTool.getRecordLen(this.QOIV.getColDescs());
        this.getCell = Math.max(2048 / this.get, 1);
        this.addRecord = (int)(0x100000L * (long)this.add / (long)this.get);
        this.getColDescs = 512 * this.add / 2;
        RecordModel recordModel = new RecordModel(this.QOIV);
        this.clone = new RecordImpl(recordModel);
        this.close = new DbValue[this.addRecord][];
        int n2 = 0;
        int n3 = recordModel.countColumns();
        while (n2 < this.addRecord) {
            this.close[n2] = new DbValue[n3];
            ++n2;
        }
    }

    public void appendRecord(JRecord jRecord) throws DSException {
        DbValue[] dbValueArray = this.close[this.currentTimeMillis];
        if (this.getRecordLen) {
            int n = 0;
            int n2 = dbValueArray.length;
            while (n < n2) {
                dbValueArray[n] = (DbValue)jRecord.getCell(n).clone();
                ++n;
            }
        } else {
            int n = 0;
            int n3 = dbValueArray.length;
            while (n < n3) {
                dbValueArray[n].set(jRecord.getCell(n));
                ++n;
            }
        }
        ++this.currentTimeMillis;
        if (this.currentTimeMillis == this.addRecord) {
            Arrays.sort(this.close, this.countColumns);
            this.QOIV(this.close, 0, this.currentTimeMillis);
            this.currentTimeMillis = 0;
        }
    }

    private void QOIV(DbValue[][] dbValueArray, int n, int n2) throws DSException {
        DbBufferDataImpl dbBufferDataImpl = new DbBufferDataImpl(this.QOIV, this.getCell, 2L);
        int n3 = 0;
        while (n3 < n2) {
            DbValue[] dbValueArray2 = dbValueArray[n3];
            int n4 = 0;
            int n5 = dbValueArray2.length;
            while (n4 < n5) {
                this.clone.getCell(n4).set(dbValueArray2[n4]);
                ++n4;
            }
            dbBufferDataImpl.addRecord(this.clone);
            ++n3;
        }
        dbBufferDataImpl.finish();
        dbBufferDataImpl.hibernate();
        this.finish.add(dbBufferDataImpl);
    }

    public JDbBufferCursor finish() throws DSException {
        int n;
        if (this.currentTimeMillis > 0) {
            Arrays.sort(this.close, 0, this.currentTimeMillis, this.countColumns);
            this.QOIV(this.close, 0, this.currentTimeMillis);
        }
        if ((n = this.finish.size()) == 1) {
            this.getPosition = (DbBufferDataImpl)this.finish.get(0);
            this.getPosition.active();
            this.finish = null;
            return this.getPosition.createCursor();
        }
        if (n == 0) {
            this.getPosition = new DbBufferDataImpl(this.QOIV, this.getCell, 2L);
            this.finish = null;
            return this.getPosition.createCursor();
        }
        int n2 = n / this.getColDescs + (n % this.getColDescs == 0 ? 0 : 1);
        DbBufferDataImpl[] dbBufferDataImplArray = new DbBufferDataImpl[n];
        this.finish.toArray(dbBufferDataImplArray);
        this.finish = null;
        DbBufferDataImpl[] dbBufferDataImplArray2 = new DbBufferDataImpl[n2];
        while (true) {
            int n3 = 1;
            while (n3 <= n2) {
                int n4 = this.getColDescs;
                if (n3 * this.getColDescs > dbBufferDataImplArray.length) {
                    n4 = dbBufferDataImplArray.length - (n3 - 1) * this.getColDescs;
                }
                DbBufferDataImpl[] dbBufferDataImplArray3 = new DbBufferDataImpl[n4];
                int n5 = 0;
                int n6 = (n3 - 1) * this.getColDescs;
                while (n5 < n4) {
                    dbBufferDataImplArray3[n5] = dbBufferDataImplArray[n6 + n5];
                    ++n5;
                }
                dbBufferDataImplArray2[n3 - 1] = this.active(dbBufferDataImplArray3);
                ++n3;
            }
            if (n2 == 1) break;
            n2 = n2 / this.getColDescs + (n2 % this.getColDescs == 0 ? 0 : 1);
            dbBufferDataImplArray = dbBufferDataImplArray2;
            dbBufferDataImplArray2 = new DbBufferDataImpl[n2];
        }
        this.getPosition = dbBufferDataImplArray2[0];
        this.getPosition.active();
        return this.getPosition.createCursor();
    }

    private DbBufferDataImpl active(DbBufferDataImpl[] dbBufferDataImplArray) throws DSException {
        int n;
        DbBufferDataImpl dbBufferDataImpl;
        int n2 = dbBufferDataImplArray.length;
        Object[] objectArray = new Entry[n2];
        JDbBufferCursor[] jDbBufferCursorArray = new JDbBufferCursor[n2];
        int n3 = 0;
        while (n3 < n2) {
            dbBufferDataImpl = dbBufferDataImplArray[n3];
            dbBufferDataImpl.active();
            jDbBufferCursorArray[n3] = dbBufferDataImpl.createCursor();
            objectArray[n3] = new Entry(n3, this.compare);
            ((Entry)objectArray[n3]).v = jDbBufferCursorArray[n3].createRecord();
            jDbBufferCursorArray[n3].next();
            ((Entry)objectArray[n3]).v.setPosition(jDbBufferCursorArray[n3].getPosition());
            ((Entry)objectArray[n3]).v.refresh();
            ++n3;
        }
        dbBufferDataImpl = new DbBufferDataImpl(this.QOIV, this.getCell, 2L);
        Arrays.sort(objectArray);
        while (n2 > 1) {
            int n4 = ((Entry)objectArray[0]).I;
            dbBufferDataImpl.addRecord(((Entry)objectArray[0]).v);
            if (jDbBufferCursorArray[n4].next()) {
                Object object = objectArray[0];
                ((Entry)object).v.setPosition(jDbBufferCursorArray[n4].getPosition());
                ((Entry)object).v.refresh();
                n = 0;
                n = 1;
                while (n < n2) {
                    if (this.compare.compare(((Entry)object).v, ((Entry)objectArray[n]).v) <= 0) break;
                    objectArray[n - 1] = objectArray[n];
                    ++n;
                }
                objectArray[n - 1] = object;
                continue;
            }
            --n2;
            int n5 = 0;
            while (n5 < n2) {
                objectArray[n5] = objectArray[n5 + 1];
                ++n5;
            }
            objectArray[n2] = null;
        }
        dbBufferDataImpl.addRecord(((Entry)objectArray[0]).v);
        while (jDbBufferCursorArray[((Entry)objectArray[0]).I].next()) {
            ((Entry)objectArray[0]).v.setPosition(jDbBufferCursorArray[((Entry)objectArray[0]).I].getPosition());
            ((Entry)objectArray[0]).v.refresh();
            dbBufferDataImpl.addRecord(((Entry)objectArray[0]).v);
        }
        dbBufferDataImpl.finish();
        dbBufferDataImpl.hibernate();
        int n6 = 0;
        n = dbBufferDataImplArray.length;
        while (n6 < n) {
            jDbBufferCursorArray[n6].close();
            dbBufferDataImplArray[n6].close();
            ++n6;
        }
        return dbBufferDataImpl;
    }

    public void close() throws DSException {
        this.getPosition.close();
    }

    private static class Entry
    implements Comparable {
        final int I;
        JRecord v;
        private final Comparator QOIV;

        Entry(int n, Comparator comparator) {
            this.I = n;
            this.QOIV = comparator;
        }

        public int compareTo(Object object) {
            return this.QOIV.compare(this.v, ((Entry)object).v);
        }
    }
}

