/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.olap.core;

import jet.dataengine.api.DSException;
import jet.dataengine.api.schema.olap.JCube;
import jet.dataengine.api.schema.olap.metadata.JDimension;
import jet.dataengine8.olap.core.CoordinateCalculator;
import jet.dataengine8.olap.core.CubeInstance;
import jet.dataengine8.olap.core.DimensionInstance;
import jet.dataengine8.olap.core.node.AAggregatorNode;
import jet.dataengine8.olap.core.node.ANode;
import jet.dataengine8.olap.core.node.Node;
import jet.dataengine8.olap.core.node.NodeHashMap;
import jet.dataengine8.util.LongArrayList;
import jet.dataengine8.util.OneDimensionIntArrayList;

public class LeafLayer {
    private CubeInstance QOIV;
    private NodeHashMap addLayer;
    private DimensionInstance[] aggregate;
    private final long[] arraycopy;
    private JCube convertFromDecimal;

    public LeafLayer(CubeInstance cubeInstance, NodeHashMap nodeHashMap, DimensionInstance[] dimensionInstanceArray, long[] lArray) {
        this.QOIV = cubeInstance;
        this.addLayer = nodeHashMap;
        this.aggregate = dimensionInstanceArray;
        this.arraycopy = lArray;
    }

    public long[] getRadixCopy() {
        long[] lArray = new long[this.arraycopy.length];
        System.arraycopy(this.arraycopy, 0, lArray, 0, this.arraycopy.length);
        return lArray;
    }

    public long[] getRadixRef() {
        return this.arraycopy;
    }

    public DimensionInstance[] getDimensionInstances() {
        return this.aggregate;
    }

    public NodeHashMap getAllLeafNodes() {
        return this.addLayer;
    }

    public ANode getNode(long l) {
        return this.addLayer.get(l);
    }

    public void setCube(JCube jCube) {
        this.convertFromDecimal = jCube;
    }

    public JCube getCube() {
        return this.convertFromDecimal;
    }

    public int getDimensionInstanceIndex(JDimension jDimension) throws DSException {
        String string = jDimension.getName();
        int n = 0;
        int n2 = this.aggregate.length;
        while (n < n2) {
            String string2 = this.aggregate[n].getDimension().getName();
            if (string.equals(string2)) {
                return n;
            }
            ++n;
        }
        throw new DSException(3017, new String[]{string});
    }

    public LeafLayer createLayer(JCube jCube, boolean bl) throws DSException {
        JDimension[] jDimensionArray = jCube.getDimensions();
        int[] nArray = new int[jDimensionArray.length];
        int n = 0;
        int n2 = jDimensionArray.length;
        while (n < n2) {
            nArray[n] = this.getDimensionInstanceIndex(jDimensionArray[n]);
            ++n;
        }
        DimensionInstance[] dimensionInstanceArray = new DimensionInstance[nArray.length];
        long[] lArray = new long[Math.max(nArray.length - 1, 0)];
        int n3 = 0;
        int n4 = nArray.length;
        while (n3 < n4) {
            dimensionInstanceArray[n3] = this.aggregate[nArray[n3]];
            ++n3;
        }
        if (nArray.length > 1) {
            lArray[lArray.length - 1] = dimensionInstanceArray[nArray.length - 1].getMemberCount() + 1;
            int n5 = lArray.length - 1;
            while (n5 > 0) {
                int n6 = dimensionInstanceArray[n5].getMemberCount() + 1;
                lArray[n5 - 1] = lArray[n5] * (long)n6;
                --n5;
            }
        }
        NodeHashMap nodeHashMap = new NodeHashMap();
        int[] nArray2 = new int[this.aggregate.length];
        int[] nArray3 = new int[nArray.length];
        LongArrayList longArrayList = this.addLayer.keys();
        AAggregatorNode[] aAggregatorNodeArray = this.QOIV.getAggregatorNodes();
        int n7 = 0;
        int n8 = longArrayList.size();
        while (n7 < n8) {
            ANode aNode;
            long l = longArrayList.get(n7);
            ANode aNode2 = this.addLayer.get(l);
            CoordinateCalculator.convertFromDecimal(nArray2, this.arraycopy, l);
            int n9 = 0;
            int n10 = nArray.length;
            while (n9 < n10) {
                nArray3[n9] = nArray2[nArray[n9]];
                ++n9;
            }
            long l2 = 0L;
            if (nArray.length != 0) {
                l2 = CoordinateCalculator.convertToDecimal(lArray, nArray3);
            }
            if ((aNode = nodeHashMap.get(l2)) == null) {
                aNode = new Node(l2, this.QOIV.getNodeMetaData(), false);
                aNode.setRowID(new OneDimensionIntArrayList());
                nodeHashMap.put(l2, aNode);
            }
            int n11 = 0;
            int n12 = aAggregatorNodeArray.length;
            while (n11 < n12) {
                aAggregatorNodeArray[n11].aggregate(aNode, aNode2, n11 == 0);
                ++n11;
            }
            ++n7;
        }
        LeafLayer leafLayer = new LeafLayer(this.QOIV, nodeHashMap, dimensionInstanceArray, lArray);
        leafLayer.setCube(jCube);
        if (bl) {
            this.QOIV.addLayer(leafLayer);
        }
        return leafLayer;
    }

    public LeafLayer createGrandTotalLayer() throws DSException {
        Node node = new Node(0L, this.QOIV.getNodeMetaData(), false);
        node.setRowID(new OneDimensionIntArrayList());
        LongArrayList longArrayList = this.addLayer.keys();
        AAggregatorNode[] aAggregatorNodeArray = this.QOIV.getAggregatorNodes();
        int n = 0;
        int n2 = longArrayList.size();
        while (n < n2) {
            long l = longArrayList.get(n);
            ANode aNode = this.addLayer.get(l);
            int n3 = 0;
            int n4 = aAggregatorNodeArray.length;
            while (n3 < n4) {
                aAggregatorNodeArray[n3].aggregate(node, aNode, n3 == 0);
                ++n3;
            }
            ++n;
        }
        NodeHashMap nodeHashMap = new NodeHashMap();
        if (longArrayList.size() > 0) {
            nodeHashMap.put(node.getKey(), node);
        }
        return new LeafLayer(this.QOIV, nodeHashMap, new DimensionInstance[0], new long[0]);
    }
}

