/*
 * Decompiled with CFR 0.152.
 */
package jet.dataengine8.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class IntVector
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public IntVector(int n, int n2) {
        this.elementData = new int[n];
        this.capacityIncrement = n2;
    }

    public IntVector(int n) {
        this(n, 0);
    }

    public IntVector() {
        this(10);
    }

    public final synchronized void copyInto(int[] nArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            nArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            int[] nArray = this.elementData;
            this.elementData = new int[this.elementCount];
            System.arraycopy(nArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            int[] nArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new int[n3];
            System.arraycopy(nArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public final int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public final synchronized int indexOf(int n, int n2) {
        int n3 = n2;
        while (n3 < this.elementCount) {
            if (n == this.elementData[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(int n, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (n == this.elementData[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public final synchronized int elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized int firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized int lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(int n, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        this.elementData[n2] = n;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        --this.elementCount;
        int[] nArray = new int[this.elementCount];
        int n2 = this.elementCount - n;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        System.arraycopy(this.elementData, 0, nArray, 0, this.elementCount);
        this.elementData = nArray;
    }

    public final synchronized void insertElementAt(int n, int n2) {
        if (n2 >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = n;
        ++this.elementCount;
    }

    public final synchronized void addElement(int n) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = n;
    }

    public final synchronized boolean removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        this.elementCount = 0;
    }

    public int[] getAllElements() {
        return this.elementData;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(this.elementAt(n2));
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final synchronized int[] toArray() {
        this.trimToSize();
        return this.elementData;
    }

    public synchronized Object clone() {
        IntVector intVector = new IntVector(this.elementCount, this.capacityIncrement);
        System.arraycopy(this.elementData, 0, intVector.elementData, 0, this.elementCount);
        intVector.elementCount = this.elementCount;
        return intVector;
    }

    public synchronized void addElements(IntVector intVector, boolean bl) {
        int[] nArray = intVector.elementData;
        int n = 0;
        while (n < intVector.elementCount) {
            int n2 = intVector.elementAt(n);
            if (bl && !this.contains(n2)) {
                this.addElement(n2);
            } else if (!bl) {
                this.addElement(n2);
            }
            ++n;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        int n = 0;
        while (n < this.size()) {
            objectOutputStream.writeInt(this.elementData[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = new int[n];
        int n2 = 0;
        while (n2 < this.size()) {
            this.elementData[n2] = objectInputStream.readInt();
            ++n2;
        }
    }
}

