/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.oracle;

import com.jinfonet.common.api.JdbcDriversConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.oracle.AbstractUds;
import jet.datasource.oracle.MyStringTokenizer;
import oracle.jdbc.driver.OracleCallableStatement;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.ProcParaInfo;

public class OracleSeamlessUDS
extends AbstractUds {
    Hashtable QOIV = new Hashtable();
    Vector add = new Vector();

    OracleSeamlessUDS(Connection connection, Connection connection2, JdbcDriversConfig jdbcDriversConfig) {
        this.Z = connection;
        this.M = connection2;
        this.I = jdbcDriversConfig;
        this.QOIV.put("BIT", new Integer(-7));
        this.QOIV.put("TINYINT", new Integer(-6));
        this.QOIV.put("SMALLINT", new Integer(5));
        this.QOIV.put("INTEGER", new Integer(4));
        this.QOIV.put("BIGINT", new Integer(-5));
        this.QOIV.put("FLOAT", new Integer(6));
        this.QOIV.put("REAL", new Integer(7));
        this.QOIV.put("DOUBLE", new Integer(8));
        this.QOIV.put("NUMERIC", new Integer(2));
        this.QOIV.put("DECIMAL", new Integer(3));
        this.QOIV.put("CHAR", new Integer(1));
        this.QOIV.put("VARCHAR", new Integer(12));
        this.QOIV.put("LONGVARCHAR", new Integer(-1));
        this.QOIV.put("DATE", new Integer(91));
        this.QOIV.put("TIME", new Integer(92));
        this.QOIV.put("TIMESTAMP", new Integer(93));
        this.QOIV.put("BINARY", new Integer(-2));
        this.QOIV.put("VARBINARY", new Integer(-3));
        this.QOIV.put("LONGVARBINARY", new Integer(-4));
        this.QOIV.put("NULL", new Integer(0));
        this.QOIV.put("OTHER", new Integer(1111));
        this.QOIV.put("OBJECT", new Integer(2000));
        this.QOIV.put("DISTINCT", new Integer(2001));
        this.QOIV.put("STRUCT", new Integer(2002));
        this.QOIV.put("ARRAY", new Integer(2003));
        this.QOIV.put("BLOB", new Integer(2004));
        this.QOIV.put("CLOB", new Integer(2005));
        this.QOIV.put("REF", new Integer(2006));
        this.QOIV.put("DATALINK", new Integer(70));
        this.QOIV.put("BOOLEAN", new Integer(16));
    }

    public ResultSet getResultSet(Properties properties) throws JRUserDataSourceException {
        try {
            this.F = properties.getProperty("OWNER");
            this.J = properties.getProperty("PROCNAME");
            this.S = properties.getProperty("SQL");
            this.A = properties.getProperty("REFCURSORINDEX");
            this.N = Integer.parseInt(this.A);
            this.add.add(new ProcParaInfo(this.N, "", -10, 0, "OracleTypes.CURSOR", 0, 0, 0, 0, 0, false, ""));
            this.L = properties.getProperty("OUTPARAM");
            if (this.L != null) {
                try {
                    this.L = new String(this.L.getBytes("8859_1"), "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new JRUserDataSourceException(unsupportedEncodingException.getMessage());
                }
            }
            this.I(this.L, 4);
            this.E = properties.getProperty("INPARAMVALUE");
            if (this.E != null) {
                try {
                    this.E = new String(this.E.getBytes("8859_1"), "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new JRUserDataSourceException(unsupportedEncodingException.getMessage());
                }
            }
            this.I(this.E, 1);
            this.run();
        }
        catch (SQLException sQLException) {
            throw new JRUserDataSourceException(sQLException.getMessage());
        }
        catch (ParameterFormatInvalid parameterFormatInvalid) {
            throw new JRUserDataSourceException(parameterFormatInvalid.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new JRUserDataSourceException(numberFormatException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JRUserDataSourceException(illegalArgumentException.getMessage());
        }
        catch (ParseException parseException) {
            throw new JRUserDataSourceException(parseException.getMessage());
        }
        catch (IOException iOException) {
            throw new JRUserDataSourceException(iOException.getMessage());
        }
        return this.C;
    }

    public void run() throws SQLException, ParameterFormatInvalid, NumberFormatException, IllegalArgumentException, ParseException, IOException {
        int n = this.getFetchSize(this.Z, this.I);
        if (n == 0) {
            this.B = this.Z.prepareCall(this.S);
        } else {
            this.B = this.Z.prepareCall(this.S, 1003, 1007);
            this.B.setFetchSize(n);
        }
        this.prepareParameter();
        this.B.execute();
        this.C = ((OracleCallableStatement)this.B).getCursor(this.N);
    }

    private void I(String string, int n) {
        if (string == null || string.trim().length() < 0) {
            return;
        }
        if (string != null) {
            string = this.I(string, AbstractUds.strParaValueTranferSymbolV9, AbstractUds.strParaValueReplaceSymbolV9);
            MyStringTokenizer myStringTokenizer = new MyStringTokenizer(string, AbstractUds.strParaTypeSeparatorV9);
            while (myStringTokenizer.hasMoreTokens()) {
                Vector<String> vector;
                if (n == 4 || n == 2) {
                    vector = new Vector<String>();
                    vector.add("");
                } else {
                    vector = new Vector();
                }
                String string2 = myStringTokenizer.nextToken();
                string2 = this.I(string2, AbstractUds.strParaValueReplaceSymbolV9, AbstractUds.strParaTypeSeparatorV9);
                string2 = this.I(string2, AbstractUds.strParaValueTranferSymbol, AbstractUds.strParaValueReplaceSymbol);
                MyStringTokenizer myStringTokenizer2 = new MyStringTokenizer(string2, AbstractUds.strParaValueSeparator);
                while (myStringTokenizer2.hasMoreTokens()) {
                    string2 = myStringTokenizer2.nextToken();
                    if (string2 != null) {
                        string2.trim();
                        string2 = this.I(string2, AbstractUds.strParaValueReplaceSymbol, AbstractUds.strParaValueSeparator);
                    }
                    vector.add(string2);
                }
                String string3 = (String)vector.get(0);
                String string4 = (String)vector.get(1);
                Integer n2 = (Integer)this.QOIV.get(string4.toUpperCase());
                int n3 = n2 == null ? Integer.MIN_VALUE : n2;
                int n4 = Integer.parseInt((String)vector.get(2));
                this.add.add(new ProcParaInfo(n4, "", n, n3, string4, 0, 0, 0, 0, 0, false, string3));
            }
        }
    }

    protected void prepareParameter() throws SQLException, ParameterFormatInvalid, NumberFormatException, IllegalArgumentException, ParseException, IOException {
        int n = this.add.size();
        ProcParaInfo procParaInfo = null;
        int n2 = 0;
        while (n2 < n) {
            procParaInfo = (ProcParaInfo)this.add.get(n2);
            if (procParaInfo.getType() == -10) {
                this.B.registerOutParameter(procParaInfo.getIndex(), -10);
            } else if (procParaInfo.getType() == 4) {
                this.B.registerOutParameter(procParaInfo.getIndex(), procParaInfo.getSQLType());
            } else if (procParaInfo.getType() == 1) {
                switch (procParaInfo.getSQLType()) {
                    case -7: {
                        Object object = procParaInfo.getValue().toUpperCase().equals("TRUE") ? "1" : "0";
                        this.B.setBoolean(procParaInfo.getIndex(), ((String)object).equals("1"));
                        break;
                    }
                    case -6: {
                        this.B.setByte(procParaInfo.getIndex(), Byte.parseByte(procParaInfo.getValue()));
                        break;
                    }
                    case 5: {
                        this.B.setShort(procParaInfo.getIndex(), Short.parseShort(procParaInfo.getValue()));
                        break;
                    }
                    case 4: {
                        this.B.setInt(procParaInfo.getIndex(), Integer.parseInt(procParaInfo.getValue()));
                        break;
                    }
                    case -5: {
                        this.B.setLong(procParaInfo.getIndex(), Long.parseLong(procParaInfo.getValue()));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.B.setString(procParaInfo.getIndex(), procParaInfo.getValue());
                        break;
                    }
                    case 7: {
                        this.B.setFloat(procParaInfo.getIndex(), new Float(procParaInfo.getValue()).floatValue());
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.B.setDouble(procParaInfo.getIndex(), (double)new Double(procParaInfo.getValue()));
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (procParaInfo.getValue() == null || "NULL".equals(procParaInfo.getValue())) {
                            this.B.setBigDecimal(procParaInfo.getIndex(), null);
                            break;
                        }
                        this.B.setBigDecimal(procParaInfo.getIndex(), new BigDecimal(procParaInfo.getValue()));
                        break;
                    }
                    case 91: {
                        Object object = new SimpleDateFormat(AbstractUds.dateFormat);
                        Object object2 = ((DateFormat)object).parse(procParaInfo.getValue());
                        this.B.setDate(procParaInfo.getIndex(), new Date(((java.util.Date)object2).getTime()));
                        break;
                    }
                    case 92: {
                        Object object = new SimpleDateFormat(AbstractUds.timeFormat);
                        Object object2 = ((DateFormat)object).parse(procParaInfo.getValue());
                        this.B.setTime(procParaInfo.getIndex(), new Time(((java.util.Date)object2).getTime()));
                        break;
                    }
                    case 93: {
                        Object object = new SimpleDateFormat(AbstractUds.timestampFormat);
                        Object object2 = ((DateFormat)object).parse(procParaInfo.getValue());
                        this.B.setTimestamp(procParaInfo.getIndex(), new Timestamp(((java.util.Date)object2).getTime()));
                        break;
                    }
                    case 2005: {
                        Object object = procParaInfo.getValue();
                        Object object2 = this.I((String)object);
                        this.B.setClob(procParaInfo.getIndex(), (Clob)object2);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        this.B.setBytes(procParaInfo.getIndex(), procParaInfo.getValue().getBytes());
                        break;
                    }
                    case 1111: {
                        Object object2;
                        Object object = procParaInfo.getValue();
                        if (procParaInfo.getSQLTypeName().equals("CLOB")) {
                            object2 = this.I((String)object);
                            this.B.setClob(procParaInfo.getIndex(), (Clob)object2);
                            break;
                        }
                        this.B.setObject(procParaInfo.getIndex(), (Object)procParaInfo.getValue());
                        break;
                    }
                    case -2147483648: {
                        throw new JRUserDataSourceException(procParaInfo.getSQLTypeName() + "unkonw data types");
                    }
                }
            }
            ++n2;
        }
    }
}

