/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.controls.JetBoolean;
import jet.datastream.DSCTField;
import jet.datastream.DSCrossTab;
import jet.datastream.DSDataStreamable;
import jet.util.VersionControlable;

public class CTGridInfo {
    public static final int TYPE_COL_HEADER = 1;
    public static final int TYPE_ROW_HEADER = 2;
    public static final int TYPE_CELL = 3;
    public int type;
    public int xCoord;
    public int yCoord;
    public Color fillColor;
    public Rectangle bgRect;
    private Vector QOIV = new Vector();
    private int add = 1;
    private int addElement = 1;
    private boolean clear = true;
    private int get = -1;
    private boolean getBlue;
    private boolean getGreen = false;
    private DSCrossTab getPropertyByName;

    public CTGridInfo duplicate() {
        CTGridInfo cTGridInfo = new CTGridInfo();
        cTGridInfo.fillColor = this.fillColor;
        cTGridInfo.type = this.type;
        cTGridInfo.xCoord = this.xCoord;
        cTGridInfo.yCoord = this.yCoord;
        cTGridInfo.add = this.add;
        cTGridInfo.addElement = this.addElement;
        cTGridInfo.getGreen = this.getGreen;
        Vector vector = new Vector();
        Vector vector2 = this.QOIV;
        cTGridInfo.setChildList(vector);
        int n = 0;
        int n2 = vector2.size();
        while (n < n2) {
            cTGridInfo.setChild(n, (DSCTField)vector2.get(n));
            ++n;
        }
        return cTGridInfo;
    }

    protected void read(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n = ((VersionControlable)((Object)dataInput)).getVersion();
        int n2 = 0;
        if (n >= 262176 || n == 0) {
            this.add = dataInput.readShort();
            this.addElement = dataInput.readShort();
            n2 = dataInput.readShort();
        } else if (n >= 262145 || n == 0) {
            this.add = dataInput.readInt();
            this.addElement = dataInput.readInt();
            n2 = dataInput.readInt();
        }
        if (n >= 262145 || n == 0) {
            if (n2 > 0) {
                this.QOIV = new Vector(n2);
                int n3 = 0;
                while (n3 < n2) {
                    DSCTField dSCTField = new DSCTField();
                    if (n >= 131097 || n == 0) {
                        dataInput.readInt();
                    } else {
                        dataInput.readShort();
                    }
                    dSCTField.read(dataInput, dSDataStreamable);
                    dSCTField.setParentGridInfo(this);
                    if (!this.getBlue) {
                        this.getPropertyByName.add(dSCTField);
                    }
                    this.QOIV.addElement(dSCTField);
                    ++n3;
                }
            } else {
                this.QOIV = new Vector();
            }
        }
        if (n >= 262176 || n == 0) {
            this.type = dataInput.readShort();
        } else if (n >= 9 || n == 0) {
            this.type = dataInput.readInt();
        }
        if (n >= 9 || n == 0) {
            this.xCoord = dataInput.readInt();
            this.yCoord = dataInput.readInt();
        }
        this.bgRect = n >= 131087 || n == 0 ? new Rectangle(dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt()) : new Rectangle((int)Math.round((double)dataInput.readInt() * 5760.0 / 65535.0), (int)Math.round((double)dataInput.readInt() * 5760.0 / 65535.0), (int)Math.round((double)dataInput.readInt() * 5760.0 / 65535.0), (int)Math.round((double)dataInput.readInt() * 5760.0 / 65535.0));
        if (dataInput.readBoolean()) {
            this.fillColor = new Color(dataInput.readInt());
        }
    }

    protected void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.add);
        dataOutput.writeShort(this.addElement);
        int n = this.QOIV.size();
        if (n > 0 && this.QOIV.get(0) == null) {
            n = 0;
        }
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            DSCTField dSCTField = (DSCTField)this.QOIV.get(n2);
            if (dSCTField != null) {
                dSCTField.write(dataOutput);
            }
            ++n2;
        }
        dataOutput.writeShort(this.type);
        dataOutput.writeInt(this.xCoord);
        dataOutput.writeInt(this.yCoord);
        dataOutput.writeInt(this.bgRect.x);
        dataOutput.writeInt(this.bgRect.y);
        dataOutput.writeInt(this.bgRect.width);
        dataOutput.writeInt(this.bgRect.height);
        if (this.fillColor != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(0xFF000000 | this.fillColor.getRed() << 16 | this.fillColor.getGreen() << 8 | this.fillColor.getBlue());
        } else {
            dataOutput.writeBoolean(false);
        }
    }

    int length() {
        int n = 25;
        n += 8;
        if (this.fillColor != null) {
            n += 4;
        }
        int n2 = 0;
        int n3 = this.QOIV.size();
        while (n2 < n3) {
            if (this.QOIV.get(n2) != null) {
                n += ((DSCTField)this.QOIV.get(n2)).length();
            }
            ++n2;
        }
        return n;
    }

    public Vector getChildren() {
        return this.QOIV;
    }

    public int getColSpan() {
        return this.add;
    }

    public void setColSpan(int n) {
        this.add = n;
    }

    public int getRowSpan() {
        return this.addElement;
    }

    public void setRowSpan(int n) {
        this.addElement = n;
    }

    public boolean isExpanded() {
        JetBoolean jetBoolean;
        DSCTField dSCTField;
        if ((this.type == 1 || this.type == 2) && this.QOIV.size() != 0 && (dSCTField = (DSCTField)this.QOIV.get(0)).isDBField() && (jetBoolean = (JetBoolean)dSCTField.getTemplate().getPropertyByName("isExpandData")) != null) {
            return jetBoolean.get();
        }
        return this.clear;
    }

    public void setChildList(Vector vector) {
        this.QOIV = vector;
    }

    public boolean isDbHeader() {
        DSCTField dSCTField;
        return (this.type == 1 || this.type == 2) && this.QOIV.size() != 0 && (dSCTField = (DSCTField)this.QOIV.get(0)).isDBField();
    }

    public void add(DSCTField dSCTField) {
        this.QOIV.addElement(dSCTField);
        dSCTField.setParentGridInfo(this);
    }

    public void setChild(int n, DSCTField dSCTField) {
        int n2 = this.QOIV.size();
        if (n2 == 0 || n2 < n + 1) {
            this.QOIV.add(dSCTField);
        } else {
            this.QOIV.set(n, dSCTField);
        }
        dSCTField.setParentGridInfo(this);
    }

    public void resetChild(DSCTField dSCTField) {
        int n = this.QOIV.size();
        if (this.get == -1) {
            this.QOIV.clear();
            this.QOIV.addElement(dSCTField);
        } else if (n < this.get) {
            this.QOIV.addElement(dSCTField);
        }
        if (n != 0 && n >= this.get) {
            this.get = n;
        }
        if (n == this.get - 1) {
            this.get = -1;
        }
        dSCTField.setParentGridInfo(this);
    }

    public DSCrossTab getParentCrosstab() {
        return this.getPropertyByName;
    }

    public void setParentCrosstab(DSCrossTab dSCrossTab) {
        this.getPropertyByName = dSCrossTab;
    }

    public void setForDhtml(boolean bl) {
        this.getBlue = bl;
    }

    public boolean isEmptyAggGrid() {
        return this.getGreen;
    }

    public void setEmptyAggGrid(boolean bl) {
        this.getGreen = bl;
    }
}

