/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTableRow;
import jet.util.VersionControlable;

public class DSTableCell
extends DSContainer {
    public static final String TOC_ANCHOR_PREFIX = "TabelAnchor";
    int QOIV;
    int append;
    int dup;
    int getParent;
    String getRecord;

    public JRecord getRecord() {
        return ((DSTableRow)this.getParent()).getRecord();
    }

    public int getColSpan() {
        return this.dup;
    }

    public void setColSpan(int n) {
        this.dup = n;
    }

    public int getRowSpan() {
        return this.getParent;
    }

    public void setRowSpan(int n) {
        this.getParent = n;
    }

    public int getGridX() {
        return this.QOIV;
    }

    public void setGridX(int n) {
        this.QOIV = n;
    }

    public int getGridY() {
        return this.append;
    }

    public void setGridY(int n) {
        this.append = n;
    }

    public String getTocAnchor() {
        return this.getRecord;
    }

    public void setTocAnchor(String string) {
        this.getRecord = string;
    }

    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        if (dataInput instanceof VersionControlable) {
            int n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n >= 262176 || n == 0) {
                this.QOIV = dataInput.readShort();
                this.append = dataInput.readShort();
                boolean bl = dataInput.readBoolean();
                this.dup = bl ? 1 : (int)dataInput.readShort();
            } else {
                int n2;
                this.QOIV = dataInput.readInt();
                this.append = dataInput.readInt();
                if (n >= 262160 || n == 0) {
                    this.dup = dataInput.readInt();
                }
                if ((n2 = dataInput.readInt()) >= 0) {
                    this.getRecord = DSTableCell.getTocAnchor(n2);
                }
            }
            if (n >= 262400 || n == 0) {
                this.getParent = dataInput.readShort();
            }
        }
    }

    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeShort(this.QOIV);
        dataOutput.writeShort(this.append);
        if (this.dup == 1) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            dataOutput.writeShort(this.dup);
        }
        dataOutput.writeShort(this.getParent);
    }

    protected int propLength() {
        int n = super.propLength();
        n += 6;
        if (this.dup == 1) {
            ++n;
        } else {
            ++n;
            n += 2;
        }
        return n;
    }

    public static final int getTocIndex(String string) {
        return Integer.parseInt(string.substring(TOC_ANCHOR_PREFIX.length()));
    }

    public static final String getTocAnchor(int n) {
        return TOC_ANCHOR_PREFIX + n;
    }

    public Object clone() {
        return this.dup(new DSTableCell());
    }

    public DSTableCell dup(DSTableCell dSTableCell) {
        super.dup(dSTableCell);
        dSTableCell.setGridX(this.QOIV);
        dSTableCell.setGridY(this.append);
        dSTableCell.setColSpan(this.dup);
        dSTableCell.setRowSpan(this.getParent);
        dSTableCell.getRecord = this.getRecord == null ? null : new String(this.getRecord);
        return dSTableCell;
    }
}

