/*
 * Decompiled with CFR 0.152.
 */
package jet.export;

import com.jinfonet.util.JRLog;
import java.io.OutputStream;
import java.util.List;
import jet.JRStopEngineException;
import jet.bean.ExcelParameter;
import jet.datastream.Communicator;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportEngineForViewer;
import jet.export.excel.type1.ExportToXlsType1;
import jet.export.excel.v7x.ExportToXls;
import jet.export.excel.v7x.ExportToXlsBiff8;
import jet.export.util.ExportUtil;
import jet.util.EngineErrorListener;

public class ExportEngine
extends ExportEngineForViewer {
    public static List exportToExcelFile(Communicator communicator, String string, ExcelParameter excelParameter, EngineErrorListener[] engineErrorListenerArray) throws ExpException, JRStopEngineException {
        List list;
        String string2 = "Export Engine: Export to Excel Files.";
        ExportUtil.checkStop(communicator);
        JRLog.indent(string2);
        long l = ExportEngineForViewer.logExportTime("Excel File", true);
        try {
            AbstractExporter abstractExporter = excelParameter.isBiff8() ? new ExportToXlsBiff8(communicator, excelParameter) : (excelParameter.isNewExcelLayout() ? new ExportToXlsType1(communicator, excelParameter) : new ExportToXls(communicator, excelParameter));
            abstractExporter.setListeners(engineErrorListenerArray);
            list = abstractExporter.exportToFile(string);
        }
        catch (ExpException expException) {
            ExportUtil.checkStop(communicator);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportUtil.checkStop(communicator);
            throw new ExpException(exception);
        }
        long l2 = ExportEngineForViewer.logExportTime("Excel File", false);
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4406001, new Object[]{"Excel File", Long.toString(l2 - l)});
        }
        JRLog.deIndent(string2);
        return list;
    }

    public static void exportToExcelStream(Communicator communicator, OutputStream outputStream, ExcelParameter excelParameter, EngineErrorListener[] engineErrorListenerArray) throws ExpException, JRStopEngineException {
        ExportUtil.checkStop(communicator);
        String string = "Export Engine: Export to Excel Files.";
        JRLog.indent(string);
        long l = ExportEngineForViewer.logExportTime("Excel Stream", true);
        try {
            AbstractExporter abstractExporter = excelParameter.isBiff8() ? new ExportToXlsBiff8(communicator, excelParameter) : (excelParameter.isNewExcelLayout() ? new ExportToXlsType1(communicator, excelParameter) : new ExportToXls(communicator, excelParameter));
            abstractExporter.setListeners(engineErrorListenerArray);
            abstractExporter.exportToStream(outputStream);
        }
        catch (ExpException expException) {
            ExportUtil.checkStop(communicator);
            throw expException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw jRStopEngineException;
        }
        catch (Exception exception) {
            ExportUtil.checkStop(communicator);
            throw new ExpException(exception);
        }
        long l2 = ExportEngineForViewer.logExportTime("Excel Stream", false);
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4406001, new Object[]{"Excel Stream", Long.toString(l2 - l)});
        }
        JRLog.deIndent(string);
    }
}

