/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.api;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jet.export.util.ImageEncoder;

public final class ImageInfo {
    private Image QOIV;
    private int[] available;
    private int[] close;
    private File getHeight;
    private int getWidth;
    private int read;
    private boolean renderImageToPNG = false;
    private static byte[] I = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public ImageInfo(Image image) {
        this.QOIV = image;
        this.getWidth = image.getWidth(null);
        this.read = image.getHeight(null);
        this.renderImageToPNG = true;
    }

    public ImageInfo(File file, int n, int n2) {
        this.getHeight = file;
        this.getWidth = n;
        this.read = n2;
    }

    public byte[] getBytes() throws IOException {
        byte[] byArray;
        if (this.renderImageToPNG) {
            ImageEncoder imageEncoder = new ImageEncoder();
            byte[] byArray2 = imageEncoder.renderImageToPNG(this.QOIV);
            int n = byArray2.length * 2;
            byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < byArray2.length) {
                byArray[n2] = I[byArray2[n3] >> 4 & 0xF];
                byArray[++n2] = I[byArray2[n3] & 0xF];
                ++n2;
                ++n3;
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(this.getHeight);
            int n = fileInputStream.available();
            byArray = new byte[n];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        return byArray;
    }

    public File getImageFile() {
        return this.getHeight;
    }

    public void setShowArea(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.available = new int[]{n, n2};
        }
    }

    public int[] getShowWH() {
        if (this.available == null) {
            this.available = new int[2];
            this.available[0] = this.getWidth;
            this.available[0] = this.read;
        }
        return this.available;
    }

    public int getImageWidth() {
        return this.getWidth;
    }

    public int getImageHeight() {
        return this.read;
    }

    public void setClipSize(int n, int n2, int n3, int n4) {
        this.close = new int[4];
        this.close[0] = n >= 0 ? n : 0;
        this.close[1] = n2 >= 0 ? n2 : 0;
        this.close[2] = n3 >= 0 ? n3 : 0;
        this.close[3] = n4 >= 0 ? n4 : 0;
    }

    public int[] getClipSize() {
        return this.close;
    }
}

