/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.imp;

import jet.export.rtf.api.BorderInfo;
import jet.export.rtf.api.GlobalDoc;
import jet.export.rtf.api.TableCell;
import jet.export.rtf.api.writer.TableCellWriter;
import jet.export.rtf.api.writer.TableRowWriter;

public class RtfTableRow
implements TableRowWriter {
    private StringBuffer QOIV;
    private GlobalDoc append;
    private boolean clear = true;
    private boolean getColor;

    public RtfTableRow(int n, int n2, GlobalDoc globalDoc) {
        this.append = globalDoc;
        this.QOIV = new StringBuffer("\\trowd \\irow");
        this.QOIV.append(n);
        this.QOIV.append("\\irowband").append(n);
        this.QOIV.append("\\trgaph0");
        this.QOIV.append("\\trleft").append(n2);
    }

    public String getContents() {
        if (this.clear) {
            this.QOIV.append("\\row\n");
            this.clear = false;
        }
        return this.QOIV.toString();
    }

    public void setLeftMargin(int n) {
        this.QOIV.append("\\trpaddfl3\\trpaddl").append(n);
    }

    public void setTopMargin(int n) {
        this.QOIV.append("\\trpaddft3\\trpaddt").append(n);
    }

    public void setRightMargin(int n) {
        this.QOIV.append("\\trpaddfr3\\trpaddr").append(n);
    }

    public void setBottomMargin(int n) {
        this.QOIV.append("\\trpaddfb3\\trpaddb").append(n);
    }

    public void addCell(TableCell tableCell) {
        this.QOIV.append(((TableCellWriter)tableCell).getContents());
        tableCell.clear();
    }

    public void setIsLastRow(boolean bl) {
        if (bl) {
            this.QOIV.append("\\lastrow");
        }
    }

    public void setIsFirstRow(boolean bl) {
        this.getColor = bl;
    }

    public void setHeight(int n) {
        this.QOIV.append("\\trrh-").append(n).append("\\trftsWidth1\\trftsWidthB3\\trautofit1\n");
    }

    public void setBorder(BorderInfo borderInfo, BorderInfo borderInfo2, BorderInfo borderInfo3, BorderInfo borderInfo4) {
        if (borderInfo != null) {
            if (borderInfo.getStyle() == 0) {
                this.QOIV.append("\\trbrdrl\\brdrs\\brdrw").append(borderInfo.getWidth());
                this.QOIV.append("\\brdrcf").append(this.append.getColorIndex(borderInfo.getColor())).append(" ");
            }
        } else {
            this.QOIV.append("\\trbrdrl\\brdrnone ");
        }
        if (borderInfo2 != null) {
            if (borderInfo2.getStyle() == 0) {
                this.QOIV.append("\\trbrdrt\\brdrs\\brdrw").append(borderInfo2.getWidth());
                this.QOIV.append("\\brdrcf").append(this.append.getColorIndex(borderInfo2.getColor())).append(" ");
            }
        } else {
            this.QOIV.append("\\trbrdrt\\brdrnone ");
        }
        if (borderInfo3 != null) {
            if (borderInfo3.getStyle() == 0) {
                this.QOIV.append("\\trbrdrr\\brdrs\\brdrw").append(borderInfo3.getWidth());
                this.QOIV.append("\\brdrcf").append(this.append.getColorIndex(borderInfo3.getColor())).append(" ");
            }
        } else {
            this.QOIV.append("\\trbrdrr\\brdrnone ");
        }
        if (borderInfo4 != null) {
            if (borderInfo4.getStyle() == 0) {
                this.QOIV.append("\\trbrdrb\\brdrs\\brdrw").append(borderInfo4.getWidth());
                this.QOIV.append("\\brdrcf").append(this.append.getColorIndex(borderInfo4.getColor())).append(" ");
            }
        } else {
            this.QOIV.append("\\trbrdrb\\brdrnone ");
        }
    }

    public void setTopGap(int n) {
        if (n > 0) {
            this.QOIV.append("\\trspdt").append(n).append("\\trspdft3");
        }
    }

    public void setBottomGap(int n) {
        if (n > 0) {
            this.QOIV.append("\\trspdb").append(n).append("\\trspdfb3");
        }
    }

    public void setLeftRightGap(int n, int n2) {
        if (n > 0) {
            this.QOIV.append("\\trspdl").append(n).append("\\trspdfl3");
        }
        if (n2 > 0) {
            this.QOIV.append("\\trspdr").append(n2).append("\\trspdfr3");
        }
    }
}

