/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbReal;
import jet.connect.DbSecurityContext;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.formula.DataTypeDef;
import jet.formula.DateTimeParser;
import jet.formula.IAllValue;
import jet.formula.JavaFormula;
import jet.formula.MyCalendar;
import jet.formula.SpecFormulaDateTime;
import jet.formula.SpecFormulaNum;
import jet.formula.SpecFormulaString;
import jet.formula.SpecFormulaValueChange;
import jet.formula.fArray;
import jet.formula.fBinaryArray;
import jet.formula.fBoolArray;
import jet.formula.fCurArray;
import jet.formula.fCurrency;
import jet.formula.fDateArray;
import jet.formula.fDateRange;
import jet.formula.fDateTimeArray;
import jet.formula.fImage;
import jet.formula.fImageArray;
import jet.formula.fIntArray;
import jet.formula.fNumArray;
import jet.formula.fStrArray;
import jet.formula.fText;
import jet.formula.fTextArray;
import jet.formula.fTimeArray;
import jet.log.JRLogger;

public class Functions {
    public static final long MILLION = 1000000L;
    public static final long BILLION = 1000000000L;
    public static final long TRILLION = 1000000000000L;
    public static final long QUADRILLION = 1000000000000000L;
    public static final int EACH = 1;
    public MyCalendar gc = new MyCalendar();
    public MyCalendar bgc = new MyCalendar();
    public Date sqldate = new Date(0L);
    public Time sqltime = new Time(0L);
    public Timestamp sqltimestamp = new Timestamp(0L);
    public SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateInstance();
    public SimpleDateFormat stf = (SimpleDateFormat)DateFormat.getTimeInstance();
    public SimpleDateFormat sdtf = (SimpleDateFormat)DateFormat.getDateTimeInstance();
    public DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
    public DecimalFormat cf = (DecimalFormat)NumberFormat.getCurrencyInstance();
    public DecimalFormatSymbols dfs;
    public static final String[] ones;
    public static final String[] teens;
    public static final String[] tens;
    public static final String[] units;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    private static final int[] Average;
    public static final String[] ROUND_MODEL_KEY;
    DbValue[] Count = new DbValue[32];
    Record CurrentDate;
    JavaFormula I;
    private static JRLogger CurrentDateTime;
    public static final int NOSPECFUNC = -1;
    public static final int FOREACHSECOND = 0;
    public static final int FOREACHMINUTE = 1;
    public static final int FOREACHHOUR = 2;
    public static final int FOREACHDAY = 10;
    public static final int FOREACHWEEK = 11;
    public static final int FOREACHHALFMONTH = 12;
    public static final int FOREACHMONTH = 13;
    public static final int FOREACHQUARTER = 14;
    public static final int FOREACHHALFYEAR = 15;
    public static final int FOREACHYEAR = 16;
    public static final int FOREACHBIWEEK = 17;
    private static Hashtable CurrentTime;
    private static Hashtable D;
    public static Hashtable weekdayToName;
    public static Hashtable weekdayToAbbr;
    public static Hashtable firstdayOfWeek;
    public static String[] dateFormats;
    public static String[] timeFormats;
    public static String[] datetimeFormats;
    private Random DDB = new Random();
    private DbDouble DateAdd = new DbDouble(0.0);
    static Class class$jet$formula$Functions;
    static final boolean $assertionsDisabled;

    public Functions() {
        this.gc.setTimeZone(TimeZone.getDefault());
        this.sdf.setCalendar(this.gc);
        this.stf.setCalendar(this.gc);
        this.sdtf.setCalendar(this.gc);
        this.cf.setNegativePrefix("-$");
        this.cf.setNegativeSuffix("");
        int n = 1;
        while (n < 32) {
            this.Count[n] = DataTypeDef.makeData(n);
            ++n;
        }
        this.Count[0] = (DbDate)this.Count[6].clone();
    }

    public void setEnvironment(Record record) {
        this.CurrentDate = record;
    }

    public static int getRoundModelValue(String string) {
        int n = 0;
        int n2 = ROUND_MODEL_KEY.length;
        while (n < n2) {
            if (string.equals(ROUND_MODEL_KEY[n])) {
                return Average[n];
            }
            ++n;
        }
        throw new RuntimeException("The round model key is invalid. key = " + string);
    }

    public DbBigInt Abs(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = Math.abs(dbBigInt.value);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbDouble Abs(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.abs(dbDouble.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public fCurrency Abs(fCurrency fCurrency2) {
        if (fCurrency2.bNull) {
            this.Count[3].bNull = true;
        } else {
            ((fCurrency)this.Count[3]).value = fCurrency2.value.abs();
            this.Count[3].bNull = false;
        }
        return (fCurrency)this.Count[3];
    }

    public DbBigInt Asc(DbChar dbChar) {
        if (dbChar.bNull || dbChar.value.length() < 1) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = dbChar.value.charAt(0);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbChar Chr(DbBigInt dbBigInt) {
        if (dbBigInt.bNull || dbBigInt.value < 0L || dbBigInt.value >= 255L) {
            this.Count[5].bNull = true;
        } else {
            ((DbChar)this.Count[5]).value = "" + (char)dbBigInt.value;
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbBigInt InStr(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = dbChar2.value.indexOf(dbChar.value);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt InStr(DbBigInt dbBigInt, DbChar dbChar, DbChar dbChar2) {
        if (dbBigInt.bNull || dbChar.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
            return (DbBigInt)this.Count[1];
        }
        int n = (int)dbBigInt.value;
        ((DbBigInt)this.Count[1]).value = n < 0 || n >= dbChar.value.length() ? -1L : (long)dbChar.value.indexOf(dbChar2.value, n);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt LastIndexOf(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = dbChar.value.lastIndexOf(dbChar2.value);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt LastIndexOf(DbBigInt dbBigInt, DbChar dbChar, DbChar dbChar2) {
        if (dbBigInt.bNull || dbChar.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
            return (DbBigInt)this.Count[1];
        }
        int n = (int)dbBigInt.value;
        ((DbBigInt)this.Count[1]).value = n < 0 || n >= dbChar.value.length() ? -1L : (long)dbChar.value.lastIndexOf(dbChar2.value, n);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbChar ReplaceString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3) {
        if (dbChar.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.Count[5].bNull = true;
            return (DbChar)this.Count[5];
        }
        String string = dbChar.value;
        String string2 = dbChar2.value;
        String string3 = dbChar3.value;
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        if (n3 == 0) {
            ((DbChar)this.Count[5]).value = string;
            return (DbChar)this.Count[5];
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer = stringBuffer.append(string.substring(n2, n)).append(string3);
            n2 = n + n3;
        }
        stringBuffer = stringBuffer.append(string.substring(n2, string.length()));
        this.Count[5].bNull = false;
        ((DbChar)this.Count[5]).value = stringBuffer.toString();
        return (DbChar)this.Count[5];
    }

    public DbChar Left(DbChar dbChar, DbBigInt dbBigInt) {
        int n = (int)dbBigInt.value;
        if (dbChar.bNull || dbBigInt.bNull || n < 0) {
            this.Count[5].bNull = true;
            return (DbChar)this.Count[5];
        }
        if (n > dbChar.value.length()) {
            n = dbChar.value.length();
        }
        ((DbChar)this.Count[5]).value = n == 0 ? "" : dbChar.value.substring(0, n);
        this.Count[5].bNull = false;
        return (DbChar)this.Count[5];
    }

    public DbBigInt Length(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.Count[1].bNull = false;
            ((DbBigInt)this.Count[1]).value = dbChar.value.length();
        }
        return (DbBigInt)this.Count[1];
    }

    public DbChar LowerCase(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = dbChar.value.toLowerCase();
        }
        return (DbChar)this.Count[5];
    }

    public DbChar Mid(DbChar dbChar, DbBigInt dbBigInt) {
        int n = (int)dbBigInt.value;
        if (dbChar.bNull || dbBigInt.bNull || n < 0 || n >= dbChar.value.length()) {
            this.Count[5].bNull = true;
        } else {
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = dbChar.value.substring(n);
        }
        return (DbChar)this.Count[5];
    }

    public DbChar Mid(DbChar dbChar, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        int n = (int)dbBigInt.value;
        int n2 = (int)dbBigInt2.value;
        if (dbChar.bNull || dbBigInt.bNull || dbBigInt2.bNull || n < 0 || n >= dbChar.value.length() || n2 <= 0 || n + n2 > dbChar.value.length()) {
            this.Count[5].bNull = true;
        } else {
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = dbChar.value.substring(n, n + n2);
        }
        return (DbChar)this.Count[5];
    }

    public DbBit NumericText(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[4].bNull = true;
        } else {
            try {
                Double.valueOf(dbChar.value);
                ((DbBit)this.Count[4]).value = true;
            }
            catch (Exception exception) {
                ((DbBit)this.Count[4]).value = false;
            }
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    public DbChar ReplicateString(DbChar dbChar, DbBigInt dbBigInt) {
        if (dbChar.bNull || dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            int n = (int)dbBigInt.value;
            if (n < 0) {
                this.Count[5].bNull = true;
            } else {
                String string = "";
                int n2 = 254 / dbChar.value.length();
                if (n > n2) {
                    n = n2;
                }
                int n3 = 0;
                while (n3 < n) {
                    string = string + dbChar.value;
                    ++n3;
                }
                ((DbChar)this.Count[5]).value = string;
                this.Count[5].bNull = false;
            }
        }
        return (DbChar)this.Count[5];
    }

    public DbChar Right(DbChar dbChar, DbBigInt dbBigInt) {
        if (dbChar.bNull || dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            int n = (int)dbBigInt.value;
            if (n < 0) {
                this.Count[5].bNull = true;
            } else {
                int n2 = dbChar.value.length();
                if (n > n2) {
                    n = n2;
                }
                ((DbChar)this.Count[5]).value = dbChar.value.substring(n2 - n, n2);
                this.Count[5].bNull = false;
            }
        }
        return (DbChar)this.Count[5];
    }

    public DbChar Space(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            int n = (int)dbBigInt.value;
            if (n < 0) {
                this.Count[5].bNull = true;
            } else {
                String string = "";
                if (n > 254) {
                    n = 254;
                }
                int n2 = 0;
                while (n2 < n) {
                    string = string + ' ';
                    ++n2;
                }
                ((DbChar)this.Count[5]).value = string;
                this.Count[5].bNull = false;
            }
        }
        return (DbChar)this.Count[5];
    }

    public DbBigInt StrCmp(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = dbChar.value.compareTo(dbChar2.value);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbChar Trim(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = dbChar.value;
            ((DbChar)this.Count[5]).value = string != null && string.length() > 0 ? dbChar.value.trim() : "";
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar TrimLeft(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            int n = 0;
            byte[] byArray = dbChar.value.getBytes();
            int n2 = byArray.length;
            while (n < n2 && byArray[n] <= 32) {
                ++n;
            }
            ((DbChar)this.Count[5]).value = dbChar.value.substring(n);
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar TrimRight(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            int n = dbChar.value.length();
            char[] cArray = new char[n];
            dbChar.value.getChars(0, n, cArray, 0);
            while (0 < n && cArray[n - 1] <= ' ') {
                --n;
            }
            ((DbChar)this.Count[5]).value = dbChar.value.substring(0, n);
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar UpperCase(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            ((DbChar)this.Count[5]).value = dbChar.value.toUpperCase();
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbDouble Val(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[2].bNull = true;
        } else {
            try {
                int n = dbChar.value.length();
                char[] cArray = new char[n];
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    char c = dbChar.value.charAt(n3);
                    if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                        cArray[n2++] = c;
                    }
                    ++n3;
                }
                String string = new String(cArray);
                ((DbDouble)this.Count[2]).value = this.df.parse(string).doubleValue();
                this.Count[2].bNull = false;
            }
            catch (Exception exception) {
                this.Count[2].bNull = true;
            }
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble ToNumber(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[2].bNull = true;
        } else {
            try {
                ((DbDouble)this.Count[2]).value = this.df.parse(dbChar.value).doubleValue();
                this.Count[2].bNull = false;
            }
            catch (Exception exception) {
                this.Count[2].bNull = true;
            }
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble ToNumber(fCurrency fCurrency2) {
        if (fCurrency2.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = fCurrency2.value.doubleValue();
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbChar ToText(DbBit dbBit) {
        if (dbBit.bNull) {
            this.Count[5].bNull = true;
        } else {
            ((DbChar)this.Count[5]).value = "" + dbBit.value;
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ToText(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = dbChar.value;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ToText(fCurrency fCurrency2) {
        return this.ToText(fCurrency2, (DbBigInt)null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbBigInt dbBigInt) {
        return this.ToText(fCurrency2, null, dbBigInt, null, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbBigInt dbBigInt, DbChar dbChar) {
        return this.ToText(fCurrency2, null, dbBigInt, dbChar, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbBigInt dbBigInt, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(fCurrency2, null, dbBigInt, dbChar, dbChar2);
    }

    public DbChar ToText(fCurrency fCurrency2, DbChar dbChar) {
        return this.ToText(fCurrency2, dbChar, null, null, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbChar dbChar, DbBigInt dbBigInt) {
        return this.ToText(fCurrency2, dbChar, dbBigInt, null, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2) {
        return this.ToText(fCurrency2, dbChar, dbBigInt, dbChar2, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2, DbChar dbChar3) {
        this.dfs = this.cf.getDecimalFormatSymbols();
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)this.dfs.clone();
        if (fCurrency2.bNull) {
            this.Count[5].bNull = true;
            return (DbChar)this.Count[5];
        }
        try {
            if (dbChar2 != null && !dbChar2.bNull) {
                if (dbChar2.value.length() > 0) {
                    decimalFormatSymbols.setGroupingSeparator(dbChar2.value.charAt(0));
                }
            } else {
                decimalFormatSymbols.setGroupingSeparator(',');
            }
            if (dbChar3 != null && !dbChar3.bNull) {
                if (dbChar3.value.length() > 0) {
                    decimalFormatSymbols.setDecimalSeparator(dbChar3.value.charAt(0));
                }
            } else {
                decimalFormatSymbols.setDecimalSeparator('.');
            }
            this.cf.setDecimalFormatSymbols(decimalFormatSymbols);
            if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                this.cf.applyPattern(dbChar.value);
            } else {
                this.cf.applyPattern("$#,##0.00");
            }
            if (dbBigInt != null && !dbBigInt.bNull) {
                int n = (int)dbBigInt.value;
                this.cf.setMaximumFractionDigits(n);
                this.cf.setMinimumFractionDigits(n);
            }
            ((DbChar)this.Count[5]).value = this.cf.format(fCurrency2.value.doubleValue());
            this.Count[5].bNull = false;
        }
        catch (Exception exception) {
            this.Count[5].bNull = true;
        }
        this.cf.setDecimalFormatSymbols(this.dfs);
        return (DbChar)this.Count[5];
    }

    public DbChar ToText(DbBigInt dbBigInt) {
        return this.ToText(dbBigInt, (DbBigInt)null);
    }

    public DbChar ToText(DbDouble dbDouble) {
        return this.ToText(dbDouble, (DbBigInt)null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        return this.ToText(dbBigInt, null, dbBigInt2, null, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbBigInt dbBigInt) {
        return this.ToText(dbDouble, null, dbBigInt, null, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbChar dbChar) {
        return this.ToText(dbBigInt, null, dbBigInt2, dbChar, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbBigInt dbBigInt, DbChar dbChar) {
        return this.ToText(dbDouble, null, dbBigInt, dbChar, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(dbBigInt, null, dbBigInt2, dbChar, dbChar2);
    }

    public DbChar ToText(DbDouble dbDouble, DbBigInt dbBigInt, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(dbDouble, null, dbBigInt, dbChar, dbChar2);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbChar dbChar) {
        return this.ToText(dbBigInt, dbChar, null, null, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbChar dbChar) {
        return this.ToText(dbDouble, dbChar, null, null, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbChar dbChar, DbBigInt dbBigInt2) {
        return this.ToText(dbBigInt, dbChar, dbBigInt2, null, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbChar dbChar, DbBigInt dbBigInt) {
        return this.ToText(dbDouble, dbChar, dbBigInt, null, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbChar dbChar, DbBigInt dbBigInt2, DbChar dbChar2) {
        return this.ToText(dbBigInt, dbChar, dbBigInt2, dbChar2, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2) {
        return this.ToText(dbDouble, dbChar, dbBigInt, dbChar2, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbChar dbChar, DbBigInt dbBigInt2, DbChar dbChar2, DbChar dbChar3) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            this.$assertionsDisabled(dbBigInt.value, dbChar, dbBigInt2, dbChar2, dbChar3);
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ToText(DbDouble dbDouble, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2, DbChar dbChar3) {
        if (dbDouble.bNull) {
            this.Count[5].bNull = true;
        } else {
            this.$assertionsDisabled(dbDouble.value, dbChar, dbBigInt, dbChar2, dbChar3);
        }
        return (DbChar)this.Count[5];
    }

    private void $assertionsDisabled(double d, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2, DbChar dbChar3) {
        String string = this.df.toPattern();
        this.dfs = this.df.getDecimalFormatSymbols();
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)this.dfs.clone();
        try {
            if (dbChar2 != null && !dbChar2.bNull) {
                if (dbChar2.value.length() > 0) {
                    decimalFormatSymbols.setGroupingSeparator(dbChar2.value.charAt(0));
                }
            } else {
                decimalFormatSymbols.setGroupingSeparator(',');
            }
            if (dbChar3 != null && !dbChar3.bNull) {
                if (dbChar3.value.length() > 0) {
                    decimalFormatSymbols.setDecimalSeparator(dbChar3.value.charAt(0));
                }
            } else {
                decimalFormatSymbols.setDecimalSeparator('.');
            }
            this.df.setDecimalFormatSymbols(decimalFormatSymbols);
            if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                this.df.applyPattern(dbChar.value);
            } else {
                this.df.applyPattern("#,##0.###");
            }
            if (dbBigInt != null && !dbBigInt.bNull) {
                int n = (int)dbBigInt.value;
                this.df.setMinimumFractionDigits(n);
                this.df.setMaximumFractionDigits(n);
            }
            ((DbChar)this.Count[5]).value = this.df.format(d);
            this.Count[5].bNull = false;
        }
        catch (Exception exception) {
            if (CurrentDateTime.isErrorEnabled()) {
                CurrentDateTime.error("", exception);
            }
            this.Count[5].bNull = true;
        }
        this.df.applyPattern(string);
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    public DbChar ToHex(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = Long.toHexString(dbBigInt.value);
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ToOctal(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = Long.toOctalString(dbBigInt.value);
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ToBinary(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = Long.toBinaryString(dbBigInt.value);
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ToText(DbDate dbDate) {
        return this.ToText(dbDate, null);
    }

    public DbChar ToText(DbDate dbDate, DbChar dbChar) {
        if (dbDate.bNull) {
            this.Count[5].bNull = true;
        } else {
            try {
                this.sqldate.setTime(dbDate.value);
                if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                    this.sdf.applyPattern(dbChar.value);
                } else {
                    this.sdf.applyPattern("dd-MMM-yy");
                }
                ((DbChar)this.Count[5]).value = this.sdf.format(this.sqldate);
                this.Count[5].bNull = false;
            }
            catch (Exception exception) {
                this.Count[5].bNull = true;
            }
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ToText(DbTime dbTime) {
        return this.ToText(dbTime, null, null, null);
    }

    public DbChar ToText(DbTime dbTime, DbChar dbChar) {
        return this.ToText(dbTime, dbChar, null, null);
    }

    public DbChar ToText(DbTime dbTime, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(dbTime, dbChar, dbChar2, null);
    }

    public DbChar ToText(DbTime dbTime, DbChar dbChar, DbChar dbChar2, DbChar dbChar3) {
        if (dbTime.bNull) {
            this.Count[5].bNull = true;
        } else {
            try {
                if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                    this.stf.applyPattern(dbChar.value);
                } else {
                    this.stf.applyPattern("h:mm:ss a");
                }
                DateFormatSymbols dateFormatSymbols = this.stf.getDateFormatSymbols();
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                if (dbChar2 != null && !dbChar2.bNull && dbChar2.value.length() > 0) {
                    stringArray[0] = dbChar2.value;
                }
                if (dbChar3 != null && !dbChar3.bNull && dbChar3.value.length() > 0) {
                    stringArray[1] = dbChar3.value;
                }
                dateFormatSymbols.setAmPmStrings(stringArray);
                this.stf.setDateFormatSymbols(dateFormatSymbols);
                this.sqltime.setTime(dbTime.value);
                ((DbChar)this.Count[5]).value = this.stf.format(this.sqltime);
                this.Count[5].bNull = false;
            }
            catch (Exception exception) {
                if (CurrentDateTime.isErrorEnabled()) {
                    CurrentDateTime.error("", exception);
                }
                this.Count[5].bNull = true;
            }
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ToText(DbTimestamp dbTimestamp) {
        return this.ToText(dbTimestamp, null, null, null);
    }

    public DbChar ToText(DbTimestamp dbTimestamp, DbChar dbChar) {
        return this.ToText(dbTimestamp, dbChar, null, null);
    }

    public DbChar ToText(DbTimestamp dbTimestamp, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(dbTimestamp, dbChar, dbChar2, null);
    }

    public DbChar ToText(DbTimestamp dbTimestamp, DbChar dbChar, DbChar dbChar2, DbChar dbChar3) {
        if (dbTimestamp.bNull) {
            this.Count[5].bNull = true;
        } else {
            try {
                if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                    this.sdtf.applyPattern(dbChar.value);
                } else {
                    this.sdtf.applyPattern("dd-MMM-yy h:mm:ss a");
                }
                DateFormatSymbols dateFormatSymbols = this.sdtf.getDateFormatSymbols();
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                if (dbChar2 != null && !dbChar2.bNull) {
                    stringArray[0] = dbChar2.toString();
                }
                if (dbChar3 != null && !dbChar3.bNull) {
                    stringArray[1] = dbChar3.toString();
                }
                dateFormatSymbols.setAmPmStrings(stringArray);
                this.sdtf.setDateFormatSymbols(dateFormatSymbols);
                ((DbChar)this.Count[5]).value = this.sdtf.format(dbTimestamp.toUtilDate());
                this.Count[5].bNull = false;
            }
            catch (Exception exception) {
                if (CurrentDateTime.isErrorEnabled()) {
                    CurrentDateTime.error("", exception);
                }
                this.Count[5].bNull = true;
            }
        }
        return (DbChar)this.Count[5];
    }

    public DbChar toString(fText fText2) {
        ((DbChar)this.Count[5]).value = fText2.value;
        ((DbChar)this.Count[5]).bNull = fText2.bNull;
        return (DbChar)this.Count[5];
    }

    public fText toLongString(DbChar dbChar) {
        ((fText)this.Count[10]).value = dbChar.value;
        ((fText)this.Count[10]).bNull = dbChar.bNull;
        return (fText)this.Count[10];
    }

    public DbChar ToWords(DbBigInt dbBigInt) {
        return this.ToWords(dbBigInt, null);
    }

    public DbChar ToWords(DbDouble dbDouble) {
        return this.ToWords(dbDouble, null);
    }

    public DbChar ToWords(fCurrency fCurrency2) {
        return this.ToWords(fCurrency2, null);
    }

    public DbChar ToWords(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
            return (DbChar)this.Count[5];
        }
        ((DbDouble)this.Count[2]).value = dbBigInt.value;
        this.Count[2].bNull = false;
        return this.ToWords((DbDouble)this.Count[2], dbBigInt2);
    }

    public DbChar ToWords(fCurrency fCurrency2, DbBigInt dbBigInt) {
        if (fCurrency2.bNull) {
            this.Count[5].bNull = true;
            return (DbChar)this.Count[5];
        }
        ((DbDouble)this.Count[2]).value = fCurrency2.value.doubleValue();
        this.Count[2].bNull = false;
        return this.ToWords((DbDouble)this.Count[2], dbBigInt);
    }

    public DbChar ToWords(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull) {
            this.Count[5].bNull = true;
        } else {
            double d = dbDouble.value;
            int n = 2;
            String string = "";
            if (dbBigInt != null && !dbBigInt.bNull) {
                n = (int)dbBigInt.value;
            }
            double d2 = Math.pow(10.0, n);
            if (d >= 1.0E15 || d <= -1.0E15 || n > 10 || n < 0) {
                this.Count[5].bNull = true;
                return (DbChar)this.Count[5];
            }
            if (d < 0.0) {
                string = "negative ";
            }
            d = Math.abs(d);
            d = (double)Math.round(d * d2) / d2;
            if (n == 0) {
                string = string + this.Average((long)d);
            } else {
                String string2 = "/10";
                String string3 = "X";
                int n2 = 1;
                while (n2 < n) {
                    string2 = string2 + '0';
                    string3 = string3 + 'X';
                    ++n2;
                }
                string = string + this.Average((long)d) + "and ";
                if (d - (double)((long)d) == 0.0) {
                    string = string + string3 + string2;
                } else {
                    d = (double)Math.round((d - (double)((long)d)) * d2) / d2;
                    string = string + String.valueOf(d).substring(2) + string2;
                }
            }
            ((DbChar)this.Count[5]).value = string;
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    String Average(long l) {
        String string;
        long l2;
        String string2 = "";
        if (l == 0L) {
            return "zero ";
        }
        if (l >= 1000000000000L) {
            l2 = l / 1000000000000L;
            string = this.Count(l2);
            string2 = string2 + string + " trillion ";
            l -= l2 * 1000000000000L;
        }
        if (l >= 1000000000L) {
            l2 = l / 1000000000L;
            string = this.Count(l2);
            string2 = string2 + string + " billion ";
            l -= l2 * 1000000000L;
        }
        if (l >= 1000000L) {
            l2 = l / 1000000L;
            string = this.Count(l2);
            string2 = string2 + string + " million ";
            l -= l2 * 1000000L;
        }
        if (l >= 1000L) {
            l2 = l / 1000L;
            string = this.Count(l2);
            string2 = string2 + string + " thousand ";
            l -= l2 * 1000L;
        }
        if (l > 0L) {
            String string3 = this.Count(l);
            string2 = string2 + string3;
            string2 = string2 + ' ';
        }
        return string2;
    }

    String Count(long l) {
        String string = "";
        if (l >= 100L) {
            long l2 = l / 100L;
            String string2 = ones[(int)l2];
            string = string2 + " hundred ";
            l -= l2 * 100L;
        }
        if (l > 0L) {
            String string3 = this.CurrentDate(l);
            string = string + string3;
        }
        return string;
    }

    String CurrentDate(long l) {
        String string = "";
        if (l > 19L) {
            long l2 = l / 10L;
            string = string + tens[(int)l2];
            if ((l -= l2 * 10L) > 0L) {
                string = string + '-';
                string = string + ones[(int)l];
            }
        } else {
            string = l >= 10L ? string + teens[(int)l - 10] : string + ones[(int)l];
        }
        return string;
    }

    public DbDouble Truncate(DbDouble dbDouble) {
        ((DbBigInt)this.Count[1]).value = 0L;
        this.Count[1].bNull = false;
        return this.Truncate(dbDouble, (DbBigInt)this.Count[1]);
    }

    public DbDouble Truncate(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            try {
                double d = Math.pow(10.0, dbBigInt.value);
                ((DbDouble)this.Count[2]).value = (double)((long)(dbDouble.value * d)) / d;
                this.Count[2].bNull = false;
            }
            catch (Exception exception) {
                this.Count[2].bNull = true;
            }
        }
        return (DbDouble)this.Count[2];
    }

    public DbBigInt Count(fArray fArray2) {
        if (fArray2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = fArray2.value.length;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Sum(fIntArray fIntArray2) {
        if (fIntArray2.bNull) {
            this.Count[1].bNull = true;
        } else {
            int n = fIntArray2.value.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (!fIntArray2.value[n3].bNull) {
                    n2 = (int)((long)n2 + ((DbBigInt)fIntArray2.value[n3]).value);
                }
                ++n3;
            }
            ((DbBigInt)this.Count[1]).value = n2;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbDouble Sum(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.Count[2].bNull = true;
        } else {
            int n = fNumArray2.value.length;
            double d = 0.0;
            int n2 = 0;
            while (n2 < n) {
                if (!fNumArray2.value[n2].bNull) {
                    d += ((DbDouble)fNumArray2.value[n2]).value;
                }
                ++n2;
            }
            ((DbDouble)this.Count[2]).value = d;
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public fCurrency Sum(fCurArray fCurArray2) {
        if (fCurArray2.bNull) {
            this.Count[3].bNull = true;
        } else {
            int n = fCurArray2.value.length;
            BigDecimal bigDecimal = new BigDecimal(0.0);
            int n2 = 0;
            while (n2 < n) {
                if (!fCurArray2.value[n2].bNull) {
                    bigDecimal = bigDecimal.add(((fCurrency)fCurArray2.value[n2]).value);
                }
                ++n2;
            }
            ((fCurrency)this.Count[3]).value = bigDecimal;
            this.Count[3].bNull = false;
        }
        return (fCurrency)this.Count[3];
    }

    public DbDouble Average(fIntArray fIntArray2) {
        if (fIntArray2.bNull) {
            this.Count[2].bNull = true;
        } else {
            int n = fIntArray2.value.length;
            if (n > 0) {
                DbBigInt dbBigInt = this.Sum(fIntArray2);
                ((DbDouble)this.Count[2]).value = (double)dbBigInt.value / (double)n;
                this.Count[2].bNull = false;
            } else {
                this.Count[2].bNull = true;
            }
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble Average(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.Count[2].bNull = true;
        } else {
            int n = fNumArray2.value.length;
            if (n > 0) {
                DbDouble dbDouble = this.Sum(fNumArray2);
                ((DbDouble)this.Count[2]).value = dbDouble.value / (double)n;
                this.Count[2].bNull = false;
            } else {
                this.Count[2].bNull = true;
            }
        }
        return (DbDouble)this.Count[2];
    }

    public fCurrency Average(fCurArray fCurArray2) {
        if (fCurArray2.bNull) {
            this.Count[3].bNull = true;
        } else {
            int n = fCurArray2.value.length;
            if (n > 0) {
                fCurrency fCurrency2 = this.Sum(fCurArray2);
                ((fCurrency)this.Count[3]).value = fCurrency2.value.divide(new BigDecimal((double)n), 2, 5);
                this.Count[3].bNull = false;
            } else {
                this.Count[3].bNull = true;
            }
        }
        return (fCurrency)this.Count[3];
    }

    private DbDouble CurrentDateTime(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.Count[2].bNull = true;
        } else {
            int n = fNumArray2.value.length;
            double d = 0.0;
            int n2 = 0;
            while (n2 < n) {
                if (!fNumArray2.value[n2].bNull) {
                    d += Math.pow(((DbDouble)fNumArray2.value[n2]).value, 2.0);
                }
                ++n2;
            }
            ((DbDouble)this.Count[2]).value = d;
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    private DbDouble CurrentTime(fNumArray fNumArray2) {
        double d = this.Average((fNumArray)fNumArray2).value;
        double d2 = this.Sum((fNumArray)fNumArray2).value;
        double d3 = this.CurrentDateTime((fNumArray)fNumArray2).value;
        ((DbDouble)this.Count[2]).value = d3 - d2 * d;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble PopulationStdDev(fNumArray fNumArray2) {
        DbDouble dbDouble = this.PopulationVariance(fNumArray2);
        if (!dbDouble.bNull) {
            dbDouble.value = Math.sqrt(dbDouble.value);
        }
        return dbDouble;
    }

    public DbDouble PopulationVariance(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double d = this.CurrentTime((fNumArray)fNumArray2).value;
        double d2 = this.Count((fArray)fNumArray2).value;
        ((DbDouble)this.Count[2]).value = d / d2;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble StdDev(fNumArray fNumArray2) {
        DbDouble dbDouble = this.Variance(fNumArray2);
        if (!dbDouble.bNull) {
            dbDouble.value = Math.sqrt(dbDouble.value);
        }
        return dbDouble;
    }

    public DbDouble Variance(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.Count[2].bNull = true;
        } else {
            int n = fNumArray2.value.length;
            if (n <= 1) {
                ((DbDouble)this.Count[2]).value = 0.0;
            } else {
                double d = this.CurrentTime((fNumArray)fNumArray2).value;
                ((DbDouble)this.Count[2]).value = d / (double)(n - 1);
            }
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbBigInt DistinctCount(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.Count[1].bNull = true;
        } else {
            int n = 0;
            int n2 = fNumArray2.value.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n3) {
                    if (((DbDouble)fNumArray2.value[n4]).value == ((DbDouble)fNumArray2.value[n3]).value) break;
                    ++n4;
                }
                if (n4 == n3) {
                    ++n;
                }
                ++n3;
            }
            ((DbBigInt)this.Count[1]).value = n;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbDouble Maximum(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        int n = fNumArray2.value.length;
        if (n > 0) {
            DbDouble dbDouble = (DbDouble)fNumArray2.value[0];
            int n2 = 1;
            while (n2 < n) {
                if (dbDouble.value < ((DbDouble)fNumArray2.value[n2]).value) {
                    dbDouble = (DbDouble)fNumArray2.value[n2];
                }
                ++n2;
            }
            return dbDouble;
        }
        this.Count[2].bNull = true;
        return (DbDouble)this.Count[2];
    }

    public DbDouble Minimum(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        int n = fNumArray2.value.length;
        if (n > 0) {
            DbDouble dbDouble = (DbDouble)fNumArray2.value[0];
            int n2 = 1;
            while (n2 < n) {
                if (dbDouble.value >= ((DbDouble)fNumArray2.value[n2]).value) {
                    dbDouble = (DbDouble)fNumArray2.value[n2];
                }
                ++n2;
            }
            return dbDouble;
        }
        this.Count[2].bNull = true;
        return (DbDouble)this.Count[2];
    }

    public DbBigInt Remainder(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbBigInt.bNull || dbBigInt2.bNull) {
            this.Count[1].bNull = true;
        } else {
            int n = (int)dbBigInt.value;
            int n2 = (int)dbBigInt2.value;
            if (n2 == 0) {
                this.Count[1].bNull = true;
            } else {
                ((DbBigInt)this.Count[1]).value = n % n2;
                this.Count[1].bNull = false;
            }
        }
        return (DbBigInt)this.Count[1];
    }

    public DbDouble Round(DbDouble dbDouble) {
        ((DbBigInt)this.Count[1]).value = 0L;
        this.Count[1].bNull = false;
        return this.Round(dbDouble, (DbBigInt)this.Count[1]);
    }

    public DbDouble Round(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            try {
                int n = dbDouble.value < 0.0 ? -1 : 1;
                double d = Math.pow(10.0, (int)dbBigInt.value);
                ((DbDouble)this.Count[2]).value = (double)n * (double)Math.round(dbDouble.value * d * (double)n) / d;
                this.Count[2].bNull = false;
            }
            catch (Exception exception) {
                this.Count[2].bNull = true;
            }
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble Round(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbDouble.bNull || dbBigInt.bNull || dbBigInt2.bNull || dbBigInt.value < 0L || !Functions.D(dbBigInt2)) {
            this.Count[2].bNull = true;
        } else {
            try {
                BigDecimal bigDecimal = new BigDecimal(Double.toString(dbDouble.value));
                bigDecimal = bigDecimal.setScale((int)dbBigInt.value, (int)dbBigInt2.value);
                ((DbDouble)this.Count[2]).set(bigDecimal.doubleValue());
            }
            catch (Exception exception) {
                this.Count[2].bNull = true;
            }
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble Round(DbDouble dbDouble, DbBigInt dbBigInt, DbChar dbChar) {
        if (dbDouble.bNull || dbBigInt.bNull || dbChar.bNull) {
            this.Count[2].bNull = true;
        } else {
            int n = 0;
            while (n < ROUND_MODEL_KEY.length) {
                if (ROUND_MODEL_KEY[n].equalsIgnoreCase(dbChar.value)) {
                    return this.Round(dbDouble, dbBigInt, new DbBigInt(Average[n]));
                }
                ++n;
            }
            this.Count[2].bNull = true;
        }
        return (DbDouble)this.Count[2];
    }

    private static boolean D(DbBigInt dbBigInt) {
        switch ((int)dbBigInt.value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        if (CurrentDateTime.isDebugEnabled()) {
            CurrentDateTime.debug("Illegal RoundMode: " + dbBigInt.value);
        }
        return false;
    }

    public fCurrency MRound(fCurrency fCurrency2, DbDouble dbDouble) {
        return this.MRound(fCurrency2, new fCurrency(new BigDecimal(dbDouble.doubleValue())));
    }

    public fCurrency MRound(fCurrency fCurrency2, fCurrency fCurrency3) {
        if (fCurrency2.bNull || fCurrency3.bNull) {
            this.Count[3].bNull = true;
        } else {
            BigDecimal[] bigDecimalArray;
            BigDecimal bigDecimal = fCurrency3.value.abs();
            BigDecimal bigDecimal2 = fCurrency2.value.abs();
            bigDecimalArray = new BigDecimal[]{bigDecimal2.divide(bigDecimal, 1).setScale(0, 1), bigDecimal2.subtract(bigDecimalArray[0].multiply(bigDecimal))};
            ((fCurrency)this.Count[3]).value = (fCurrency2.value.signum() == -1 ? bigDecimal.negate() : bigDecimal).multiply(bigDecimalArray[0].add(bigDecimalArray[1].compareTo(bigDecimal.divide(new BigDecimal(2.0), 4)) >= 0 ? new BigDecimal(1.0) : new BigDecimal(0.0)));
            this.Count[3].bNull = false;
        }
        return (fCurrency)this.Count[3];
    }

    public DbDouble MRound(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull) {
            this.Count[2].bNull = true;
        } else {
            double d = Math.abs(dbDouble2.doubleValue());
            double d2 = Math.abs(dbDouble.doubleValue());
            double d3 = d2 / d;
            BigDecimal bigDecimal = new BigDecimal(d3).setScale(0, 1);
            ((DbDouble)this.Count[2]).value = (dbDouble.doubleValue() < 0.0 ? -d : d) * (bigDecimal.doubleValue() + (double)((d3 - bigDecimal.doubleValue()) * d >= d / 2.0 ? 1 : 0));
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDate CurrentDate() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.Count[6]).value = myCalendar.I();
        this.Count[6].bNull = false;
        return (DbDate)this.Count[6];
    }

    public DbDate Today() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.Count[6]).value = myCalendar.I();
        this.Count[6].bNull = false;
        return (DbDate)this.Count[6];
    }

    public DbTime CurrentTime() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbTime)this.Count[7]).value = myCalendar.I();
        this.Count[7].bNull = false;
        return (DbTime)this.Count[7];
    }

    public DbBigInt Quarter() {
        DbDate dbDate = this.CurrentDate();
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = this.Quarter(dbDate, new DbBigInt(1L)).intValue();
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Quarter(DbDate dbDate, DbBigInt dbBigInt) {
        if (dbDate.bNull || dbBigInt.bNull || dbBigInt.intValue() < 1 || dbBigInt.intValue() > 12) {
            this.Count[1].bNull = true;
        } else {
            DbBigInt dbBigInt2 = this.Month(dbDate);
            ((DbBigInt)this.Count[1]).value = this.DDB(dbBigInt2.intValue(), dbBigInt.intValue()).intValue();
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Quarter(DbTimestamp dbTimestamp, DbBigInt dbBigInt) {
        if (dbTimestamp.bNull || dbBigInt.bNull || dbBigInt.intValue() < 1 || dbBigInt.intValue() > 12) {
            this.Count[1].bNull = true;
        } else {
            DbBigInt dbBigInt2 = this.Month(dbTimestamp);
            ((DbBigInt)this.Count[1]).value = this.DDB(dbBigInt2.intValue(), dbBigInt.intValue()).intValue();
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    private DbBigInt DDB(int n, int n2) {
        int n3 = n - n2 >= 0 ? n - n2 + 1 : 12 - n2 + n + 1;
        if (n3 % 3 == 0) {
            return new DbBigInt(n3 / 3);
        }
        return new DbBigInt(n3 / 3 + 1);
    }

    public DbTimestamp CurrentDateTime() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbTimestamp)this.Count[8]).value = myCalendar.I();
        ((DbTimestamp)this.Count[8]).nanos = 0;
        this.Count[8].bNull = false;
        return (DbTimestamp)this.Count[8];
    }

    public DbDate ToDate(DbDate dbDate) {
        return dbDate;
    }

    public DbDate ToDate(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[6].bNull = true;
        } else {
            Timestamp timestamp = dbTimestamp.getTimestamp();
            ((DbDate)this.Count[6]).value = new Date(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate()).getTime();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate ToDate(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.clear();
            this.gc.set((int)dbBigInt.value, (int)dbBigInt2.value - 1, (int)dbBigInt3.value, 0, 0, 0);
            this.gc.set(14, 0);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbTimestamp ToDateTime(DbDate dbDate, DbTime dbTime) {
        if (dbDate.bNull || dbTime.bNull) {
            this.Count[8].bNull = true;
        } else {
            this.gc.I(dbTime.value);
            this.gc.computeTime();
            int n = this.gc.get(11);
            int n2 = this.gc.get(12);
            int n3 = this.gc.get(13);
            this.gc.I(dbDate.value);
            this.gc.computeTime();
            this.gc.setHMS(n, n2, n3);
            ((DbTimestamp)this.Count[8]).value = this.gc.I();
            ((DbTimestamp)this.Count[8]).nanos = 0;
            this.Count[8].bNull = false;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbTimestamp ToDateTime(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull) {
            this.Count[8].bNull = true;
            return (DbTimestamp)this.Count[8];
        }
        this.gc.set((int)dbBigInt.value, (int)dbBigInt2.value - 1, (int)dbBigInt3.value, 0, 0, 0);
        ((DbTimestamp)this.Count[8]).value = this.gc.I();
        ((DbTimestamp)this.Count[8]).nanos = 0;
        this.Count[8].bNull = false;
        return (DbTimestamp)this.Count[8];
    }

    public DbTimestamp ToDateTime(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3, DbBigInt dbBigInt4, DbBigInt dbBigInt5, DbBigInt dbBigInt6) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull || dbBigInt4.bNull || dbBigInt5.bNull || dbBigInt6.bNull) {
            this.Count[8].bNull = true;
        } else {
            this.gc.clear();
            this.gc.set((int)dbBigInt.value, (int)dbBigInt2.value - 1, (int)dbBigInt3.value, (int)dbBigInt4.value, (int)dbBigInt5.value, (int)dbBigInt6.value);
            ((DbTimestamp)this.Count[8]).value = this.gc.I();
            ((DbTimestamp)this.Count[8]).nanos = 0;
            this.Count[8].bNull = false;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbDate DateTimeToDate(DbTimestamp dbTimestamp) {
        return this.ToDate(dbTimestamp);
    }

    public DbBigInt DateTimeToSeconds(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            int n = this.gc.get(11);
            int n2 = this.gc.get(12);
            int n3 = this.gc.get(13);
            int n4 = (n * 60 + n2) * 60 + n3;
            ((DbBigInt)this.Count[1]).value = n4;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbTime DateTimeToTime(DbTimestamp dbTimestamp) {
        return this.ToTime(dbTimestamp);
    }

    public DbBigInt Day(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbDate.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(5);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Day(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(5);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DayOfWeek(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbDate.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(7);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DayOfWeek(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(7);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Month(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbDate.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(2) + 1;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Month(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(2) + 1;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Year(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbDate.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(1);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Year(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(1);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Hour(DbTime dbTime) {
        if (dbTime.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTime.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(11);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Hour(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(11);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Minute(DbTime dbTime) {
        if (dbTime.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTime.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(12);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Minute(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(12);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Second(DbTime dbTime) {
        if (dbTime.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTime.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(13);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Second(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(13);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekOfYear(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbDate.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(3);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekOfYear(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(3);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekOfMonth(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbDate.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(4);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekOfMonth(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            ((DbBigInt)this.Count[1]).value = this.gc.get(4);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekFrom1970(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            long l = dbTimestamp.value / 86400000L;
            ((DbBigInt)this.Count[1]).value = (int)((l + 5L) / 7L);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekFrom1970(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            long l = dbDate.value / 86400000L;
            ((DbBigInt)this.Count[1]).value = (int)((l + 5L) / 7L);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbTime ToTime(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.Count[7].bNull = true;
        } else {
            this.gc.I(dbTimestamp.value);
            this.gc.computeFields();
            this.gc.set(1, 0);
            this.gc.set(2, 0);
            this.gc.set(5, 0);
            ((DbTime)this.Count[7]).value = this.gc.I();
            this.Count[7].bNull = false;
        }
        return (DbTime)this.Count[7];
    }

    public DbTime ToTime(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull) {
            this.Count[7].bNull = true;
        } else {
            this.gc.I(0L);
            this.gc.set(11, (int)dbBigInt.value);
            this.gc.set(12, (int)dbBigInt2.value);
            this.gc.set(13, (int)dbBigInt3.value);
            ((DbTime)this.Count[7]).value = this.gc.I();
            this.Count[7].bNull = false;
        }
        return (DbTime)this.Count[7];
    }

    public fDateRange Aged0To30Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(5, -30);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        ((DbDate)this.Count[0]).value = l;
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Aged31To60Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(5, -31);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.add(5, -29);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Aged61To90Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(5, -61);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.add(5, -29);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange AllDatesFromToday() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.Count[6]).value = myCalendar.I();
        this.Count[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], null};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange AllDatesFromTomorrow() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(5, 1);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], null};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange AllDatesToToday() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.Count[6]).value = myCalendar.I();
        this.Count[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{null, (DbDate)this.Count[6]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange AllDatesToYesterday() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.I(myCalendar.I());
        this.gc.add(5, -1);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{null, (DbDate)this.Count[6]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Calendar1stHalf() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 0, 1, 0, 0, 0);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(myCalendar.get(1), 5, 30, 0, 0, 0);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Calendar2ndHalf() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 6, 1, 0, 0, 0);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(myCalendar.get(1), 11, 31, 0, 0, 0);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Calendar1stQtr() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 0, 1, 0, 0, 0);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(myCalendar.get(1), 2, 31, 0, 0, 0);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Calendar2ndQtr() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 3, 1, 0, 0, 0);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(myCalendar.get(1), 5, 30, 0, 0, 0);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Calendar3rdQtr() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 6, 1, 0, 0, 0);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(myCalendar.get(1), 8, 30, 0, 0, 0);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Calendar4thQtr() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 9, 1, 0, 0, 0);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(myCalendar.get(1), 11, 31, 0, 0, 0);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Last4WeeksToSun() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.I(myCalendar.I());
        this.gc.setFirstDayOfWeek(1);
        int n = -1 * (this.gc.get(7) - 1);
        this.gc.add(5, n);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.add(5, -27);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Last7Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(5, -6);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        ((DbDate)this.Count[0]).value = l;
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange LastFullMonth() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.I(myCalendar.I());
        this.gc.add(2, -1);
        this.gc.set(5, 1);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(5, this.gc.getMaximum(5));
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange LastFullWeek() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.I(myCalendar.I());
        this.gc.setFirstDayOfWeek(1);
        int n = -1 * this.gc.get(7);
        this.gc.add(5, n);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.add(5, -6);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange LastYearMTD() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.I(myCalendar.I());
        this.gc.add(1, -1);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(5, 1);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange LastYearYTD() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.I(myCalendar.I());
        this.gc.add(1, -1);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.set(5, 1);
        this.gc.set(2, 0);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange MonthToDate() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.I(myCalendar.I());
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.add(2, 0);
        this.gc.set(5, 1);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Next30Days() {
        long l;
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.Count[6]).value = l = myCalendar.I();
        this.Count[6].bNull = false;
        this.gc.I(l);
        this.gc.add(5, 30);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Next31To60Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(5, 31);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.add(5, 29);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Next61To90Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(5, 61);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.add(5, 29);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Next91To365Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(5, 91);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        this.gc.add(5, 264);
        ((DbDate)this.Count[0]).value = this.gc.I();
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange Over90Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.I(myCalendar.I());
        this.gc.add(5, -91);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], null};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange WeekToDateFromSun() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.setFirstDayOfWeek(1);
        int n = -1 * (this.gc.get(7) - 1);
        this.gc.add(5, n);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        ((DbDate)this.Count[0]).value = l;
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public fDateRange YearToDate() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.I();
        this.gc.I(l);
        this.gc.add(2, 0);
        this.gc.set(2, 0);
        this.gc.set(5, 1);
        ((DbDate)this.Count[6]).value = this.gc.I();
        this.Count[6].bNull = false;
        ((DbDate)this.Count[0]).value = l;
        this.Count[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.Count[6], (DbDate)this.Count[0]};
        ((fDateRange)this.Count[28]).value = dbDateArray;
        this.Count[28].bNull = false;
        return (fDateRange)this.Count[28];
    }

    public DbBit LooksLike(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.Count[4].bNull = true;
            return (DbBit)this.Count[4];
        }
        String string = dbChar.value;
        String string2 = dbChar2.value;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*?", true);
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals("*")) {
                if (!bl) continue;
                vector.addElement(string3);
                bl = false;
                continue;
            }
            vector.addElement(string3);
            bl = true;
        }
        int n = 0;
        int n2 = vector.size();
        int n3 = string.length();
        boolean bl2 = true;
        boolean bl3 = true;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            string3 = (String)vector.elementAt(n5);
            if (string3.charAt(0) == '?') {
                if (++n > n3) {
                    bl2 = false;
                    break;
                }
            } else if (string3.charAt(0) == '*') {
                bl3 = false;
            } else {
                n4 = string.indexOf(string3, n);
                if (bl3) {
                    int n6 = n4 = n == n4 ? n4 : -1;
                }
                if (n4 == -1) {
                    bl2 = false;
                    break;
                }
                n = n4 + string3.length();
                bl3 = true;
            }
            ++n5;
        }
        this.Count[4].bNull = false;
        ((DbBit)this.Count[4]).value = bl2;
        return (DbBit)this.Count[4];
    }

    public DbChar Now() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbTime)this.Count[7]).value = myCalendar.I();
        this.Count[7].bNull = false;
        return this.ToText((DbTime)this.Count[7]);
    }

    public DbChar Picture(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = dbChar.value;
            String string2 = dbChar2.value;
            int n = string2.length();
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                char c = string2.charAt(n4);
                if (c == 'x' || c == 'X') {
                    if (n3 < n2) {
                        stringBuffer.setCharAt(n4, string.charAt(n3++));
                    } else {
                        int n5 = n4;
                        while (n5 < n) {
                            c = string2.charAt(n5);
                            if (c != 'x' && c != 'X') {
                                stringBuffer.setCharAt(n4++, c);
                            }
                            ++n5;
                        }
                        stringBuffer.setLength(n4);
                        break;
                    }
                }
                ++n4;
            }
            if (n3 < n2) {
                stringBuffer.append(string.substring(n3));
            }
            ((DbChar)this.Count[5]).value = stringBuffer.toString();
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ExtractString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3) {
        if (dbChar.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = dbChar.value;
            String string2 = dbChar2.value;
            String string3 = dbChar3.value;
            String string4 = "";
            int n = 0;
            int n2 = 0;
            if (string != null && (n = string.indexOf(string2)) != -1) {
                n2 = string.indexOf(string3, n);
                string4 = n2 != -1 ? string.substring(n, n2) : string.substring(n);
            }
            ((DbChar)this.Count[5]).value = string4;
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbDouble FRCurrentRatio(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRQuickRatio(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble3.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = (dbDouble.value - dbDouble2.value) / dbDouble3.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRDebtEquityRatio(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FREquityVsTotalAssets(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRNetProfitMargin(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRGrossProfitMargin(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FROperatingProfitMargin(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRInterestCoverage(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRCashFlowVsTotalDebt(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRReturnOnEquity(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRReturnOnNetFixedAssets(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRReturnOntotalAssets(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRReturnOnInvestedCapital(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        double d = dbDouble2.value + dbDouble3.value;
        if (dbDouble2.bNull || dbDouble3.bNull || dbDouble.bNull || d == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / d;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRReturnOnCommonEquity(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble2.bNull || dbDouble3.bNull || dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else if (dbDouble3.value == 0.0 || dbDouble.value < dbDouble2.value) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = (dbDouble.value - dbDouble2.value) / dbDouble3.value;
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FREarningsPerCommonShare(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble2.bNull || dbDouble3.bNull || dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else if (dbDouble3.value == 0.0 || dbDouble.value < dbDouble2.value) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = (dbDouble.value - dbDouble2.value) / (double)((int)dbDouble3.value);
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRAccRecTurnover(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value * (double)((int)dbDouble3.value);
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRInventoryTurnover(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value * (double)((int)dbDouble3.value);
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRPriceEarningsRatio(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble FRDividendYield(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.Count[2];
    }

    public DbBit IsNull(DbValue dbValue) {
        ((DbBit)this.Count[4]).value = dbValue.bNull;
        this.Count[4].bNull = false;
        return (DbBit)this.Count[4];
    }

    public static boolean isSupportSpecFunc(int n, int n2) {
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (n2 != 4 && n2 != 3) break;
                return true;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                if (n2 != 4) break;
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                if (n2 != 2) break;
                return true;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (n2 != 1) break;
                return true;
            }
            case -7: 
            case -4: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw new Error("unknow sql type : " + n);
            }
        }
        return false;
    }

    public static int[] getSpecFuncForType(int n) {
        int[] nArray = null;
        switch (n) {
            case 92: {
                break;
            }
            case 91: {
                nArray = new int[]{10, 11, 17, 12, 13, 14, 15, 16};
                break;
            }
            case 93: {
                nArray = new int[]{10, 11, 17, 12, 13, 14, 15, 16};
            }
        }
        return nArray;
    }

    public static String getSpecFuncName(String string, int n) {
        String string2 = null;
        if (string.equals(Integer.toString(1))) {
            switch (n) {
                case 1: {
                    string2 = "for each year";
                    break;
                }
                case 2: {
                    string2 = "for each month";
                    break;
                }
                case 5: {
                    string2 = "for each day";
                    break;
                }
                case 10: {
                    string2 = "for each hour";
                    break;
                }
                case 12: {
                    string2 = "for each minute";
                    break;
                }
                case 13: {
                    string2 = "for each second";
                    break;
                }
                case 21: {
                    string2 = "for each half month";
                    break;
                }
                case 20: {
                    string2 = "for each half year";
                    break;
                }
                case 22: {
                    string2 = "for each quarter";
                    break;
                }
                case 24: {
                    string2 = "for each week";
                    break;
                }
                case 23: {
                    string2 = "for each bi-week";
                }
            }
        }
        return string2;
    }

    public static String getSpecFuncName(int n) {
        String string = null;
        switch (n) {
            case -1: {
                string = "None";
                break;
            }
            case 0: {
                string = "for each second";
                break;
            }
            case 1: {
                string = "for each minute";
                break;
            }
            case 2: {
                string = "for each hour";
                break;
            }
            case 10: {
                string = "for each day";
                break;
            }
            case 11: {
                string = "for each week";
                break;
            }
            case 12: {
                string = "for each half month";
                break;
            }
            case 13: {
                string = "for each month";
                break;
            }
            case 14: {
                string = "for each quarter";
                break;
            }
            case 15: {
                string = "for each half year";
                break;
            }
            case 16: {
                string = "for each year";
                break;
            }
            case 17: {
                string = "for each bi-week";
            }
        }
        return string;
    }

    public static int getSpecFuncByName(String string) {
        int n = -1;
        if (string.equals("for each second")) {
            n = 0;
        } else if (string.equals("for each minute")) {
            n = 1;
        } else if (string.equals("for each hour")) {
            n = 2;
        } else if (string.equals("for each day")) {
            n = 10;
        } else if (string.equals("for each week")) {
            n = 11;
        } else if (string.equals("for each bi-week")) {
            n = 17;
        } else if (string.equals("for each half month")) {
            n = 12;
        } else if (string.equals("for each month")) {
            n = 13;
        } else if (string.equals("for each quarter")) {
            n = 14;
        } else if (string.equals("for each half year")) {
            n = 15;
        } else if (string.equals("for each year")) {
            n = 16;
        }
        return n;
    }

    public static String[] getSpecialFunctionNames() {
        String[] stringArray = new String[]{"None", "for each second", "for each minute", "for each hour", "for each day", "for each week", "for each bi-week", "for each half month", "for each month", "for each quarter", "for each half year", "for each year"};
        return stringArray;
    }

    public DbDate ForEachDay(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate ForEachWeek(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.add(7, -1 * this.gc.get(7) + 1);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate ForEachBiWeek(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            int n = this.gc.get(3);
            if (n % 2 == 0) {
                --n;
            }
            this.gc.set(3, n);
            this.gc.add(7, -1 * this.gc.get(7) + 1);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate ForEachHalfMonth(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            if (this.gc.get(5) > 15) {
                this.gc.set(5, 16);
            } else {
                this.gc.set(5, 1);
            }
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate ForEachMonth(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.set(5, 1);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate ForEachQuarter(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            int n = this.gc.get(2);
            if (n < 3) {
                this.gc.set(2, 0);
            } else if (n >= 3 && n < 6) {
                this.gc.set(2, 3);
            } else if (n >= 6 && n < 9) {
                this.gc.set(2, 6);
            } else if (n >= 9 && n <= 11) {
                this.gc.set(2, 9);
            }
            this.gc.set(5, 1);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate ForEachHalfYear(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            int n = this.gc.get(2);
            if (n < 6) {
                this.gc.set(2, 0);
            } else {
                this.gc.set(2, 6);
            }
            this.gc.set(5, 1);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate ForEachYear(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.set(2, 0);
            this.gc.set(5, 1);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbBigInt Age(DbDate dbDate, DbDate dbDate2) {
        if (dbDate.bNull || dbDate2.bNull) {
            this.Count[1].bNull = true;
        } else {
            this.gc.I(dbDate.value);
            this.gc.computeFields();
            int n = this.gc.get(1);
            this.gc.I(dbDate2.value);
            this.gc.computeFields();
            int n2 = this.gc.get(1);
            ((DbBigInt)this.Count[1]).value = n - n2;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Age(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            MyCalendar myCalendar = new MyCalendar();
            myCalendar.set(11, 0);
            myCalendar.set(12, 0);
            myCalendar.set(13, 0);
            myCalendar.set(14, 0);
            this.gc.I(dbDate.value);
            this.gc.computeFields();
            int n = this.gc.get(1);
            int n2 = myCalendar.get(1);
            ((DbBigInt)this.Count[1]).value = n - n2;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Day() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(5);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DayOfWeek() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(7);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DayOfYear() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(6);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Hour() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(11);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Second() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(13);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Minute() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(12);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt currentMonth() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(2) + 1;
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Month() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(2);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt Year() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(1);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekOfYear() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(3);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekOfMonth() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.Count[1]).value = myCalendar.get(4);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt WeekFrom1970() {
        MyCalendar myCalendar = new MyCalendar();
        long l = myCalendar.I() / 86400000L;
        ((DbBigInt)this.Count[1]).value = (int)((l + 5L) / 7L);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbValue Next(DbValue dbValue) {
        ((DbBigInt)this.Count[1]).value = 1L;
        this.Count[1].bNull = false;
        return this.Next(dbValue, (DbBigInt)this.Count[1]);
    }

    public DbValue Next(DbValue dbValue, DbBigInt dbBigInt) {
        return this.DateAdd(dbValue, dbBigInt);
    }

    public DbValue Prev(DbValue dbValue) {
        ((DbBigInt)this.Count[1]).value = -1L;
        this.Count[1].bNull = false;
        return this.Prev(dbValue, (DbBigInt)this.Count[1]);
    }

    public DbValue Prev(DbValue dbValue, DbBigInt dbBigInt) {
        return this.DateAdd(dbValue, dbBigInt);
    }

    private DbValue DateAdd(DbValue dbValue, DbBigInt dbBigInt) {
        int n = DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
        if (dbBigInt.bNull) {
            this.Count[n].bNull = true;
        } else {
            int n2 = this.CurrentDate.getRecordIndex();
            int n3 = n2 + (int)dbBigInt.value;
            int n4 = ((JRecord)this.CurrentDate).getDependCursor().getCurrentEnd();
            if (n3 < 1 || n3 > n4) {
                this.Count[n].bNull = true;
            } else {
                this.CurrentDate.setRecordIndex(n3);
                this.CurrentDate.refresh(false);
                if (this.Count[n] instanceof DbNumber) {
                    ((DbNumber)this.Count[n]).setValue((DbNumber)this.CurrentDate.getCell(dbValue.getColDesc().getColIndex()));
                } else {
                    this.Count[n].set(this.CurrentDate.getCell(dbValue.getColDesc().getColIndex()));
                }
            }
            this.CurrentDate.setRecordIndex(n2);
            this.CurrentDate.refresh(false);
        }
        return this.Count[n];
    }

    public fText openTxtFile(DbChar dbChar) {
        fText fText2;
        block5: {
            fText2 = (fText)this.Count[10];
            fText2.setNull();
            if (!dbChar.isNull()) {
                FileInputStream fileInputStream = null;
                String string = dbChar.get();
                try {
                    if (string != null) {
                        fileInputStream = new FileInputStream(string);
                        byte[] byArray = this.DateDiff(fileInputStream);
                        ((InputStream)fileInputStream).close();
                        if (byArray != null) {
                            fText2.setRaw(byArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!CurrentDateTime.isDebugEnabled()) break block5;
                    CurrentDateTime.debug(exception.getMessage(), exception);
                }
            }
        }
        return fText2;
    }

    public fText openTxtURL(DbChar dbChar) {
        fText fText2;
        block5: {
            fText2 = (fText)this.Count[10];
            fText2.setNull();
            if (!dbChar.isNull()) {
                InputStream inputStream = null;
                String string = dbChar.get();
                try {
                    if (string != null) {
                        URL uRL = new URL(string);
                        inputStream = uRL.openStream();
                        byte[] byArray = this.DateDiff(inputStream);
                        inputStream.close();
                        if (byArray != null) {
                            fText2.setRaw(byArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!CurrentDateTime.isDebugEnabled()) break block5;
                    CurrentDateTime.debug(exception.getMessage(), exception);
                }
            }
        }
        return fText2;
    }

    public fImage openBinFile(DbChar dbChar) {
        fImage fImage2;
        block5: {
            fImage2 = (fImage)this.Count[11];
            fImage2.setNull();
            if (!dbChar.isNull()) {
                FileInputStream fileInputStream = null;
                String string = dbChar.get();
                try {
                    if (string != null) {
                        fileInputStream = new FileInputStream(string);
                        byte[] byArray = this.DateDiff(fileInputStream);
                        ((InputStream)fileInputStream).close();
                        if (byArray != null) {
                            fImage2.set(byArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!CurrentDateTime.isDebugEnabled()) break block5;
                    CurrentDateTime.debug(exception.getMessage(), exception);
                }
            }
        }
        return fImage2;
    }

    public fImage openBinURL(DbChar dbChar) {
        fImage fImage2;
        block5: {
            fImage2 = (fImage)this.Count[11];
            fImage2.setNull();
            if (!dbChar.isNull()) {
                InputStream inputStream = null;
                String string = dbChar.get();
                try {
                    if (string != null) {
                        URL uRL = new URL(string);
                        inputStream = uRL.openStream();
                        byte[] byArray = this.DateDiff(inputStream);
                        inputStream.close();
                        if (byArray != null) {
                            fImage2.set(byArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!CurrentDateTime.isDebugEnabled()) break block5;
                    CurrentDateTime.debug(exception.getMessage(), exception);
                }
            }
        }
        return fImage2;
    }

    private byte[] DateDiff(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        if (inputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            int n = 0;
            while (n >= 0) {
                n = inputStream.read(byArray2);
                if (n <= 0) continue;
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length == 0) {
                byArray = null;
            }
        }
        return byArray;
    }

    public DbChar reportName() {
        ((DbChar)this.Count[5]).value = this.I.REPORT_NAME();
        this.Count[5].bNull = false;
        return (DbChar)this.Count[5];
    }

    public DbBit isRunBursting() {
        ((DbBit)this.Count[4]).value = this.I.isRunningBursting();
        this.Count[4].bNull = false;
        return (DbBit)this.Count[4];
    }

    public DbChar currentBurstingSchema() {
        ((DbChar)this.Count[5]).value = this.I.getCurrentBurstingSchema();
        this.Count[5].bNull = false;
        return (DbChar)this.Count[5];
    }

    public DbChar getLanguage() {
        ((DbChar)this.Count[5]).value = this.I.LOCAL_LANGUAGE();
        this.Count[5].bNull = false;
        return (DbChar)this.Count[5];
    }

    public DbBit IsNoRecord() {
        DbBit dbBit = (DbBit)this.Count[4];
        dbBit.set(this.I.isNoRecord());
        return dbBit;
    }

    public DbDate ToDate(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[6].bNull = true;
        } else {
            ((DbDate)this.Count[6]).value = dbBigInt.value;
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbTimestamp ToDateTime(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[8].bNull = true;
        } else {
            ((DbTimestamp)this.Count[8]).value = dbBigInt.value;
            this.Count[8].bNull = false;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbTime ToTime(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[7].bNull = true;
        } else {
            ((DbTime)this.Count[7]).value = dbBigInt.value;
            this.Count[7].bNull = false;
        }
        return (DbTime)this.Count[7];
    }

    public DbBigInt ToInt(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = dbDouble.longValue();
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt ToInt(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[1].bNull = true;
        } else {
            try {
                ((DbBigInt)this.Count[1]).value = this.df.parse(dbChar.value).longValue();
                this.Count[1].bNull = false;
            }
            catch (ParseException parseException) {
                this.Count[1].bNull = true;
            }
        }
        return (DbBigInt)this.Count[1];
    }

    public DbDate DateTo2000(DbDate dbDate, DbBigInt dbBigInt) {
        if (dbDate.bNull || dbBigInt.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.clear();
            this.gc.setTime(dbDate.getDate());
            int n = this.gc.get(1);
            int n2 = this.gc.get(2);
            int n3 = this.gc.get(5);
            if (n < 2000 & n >= 1900) {
                int n4 = dbDate.getDate().getYear();
                if ((long)n4 < dbBigInt.value) {
                    this.gc.clear();
                    this.gc.set(n4 + 2000, n2, n3);
                    ((DbDate)this.Count[6]).value = this.gc.I();
                } else {
                    ((DbDate)this.Count[6]).value = dbDate.value;
                }
            } else if (n < 100 & n >= 0) {
                if ((long)n < dbBigInt.value) {
                    this.gc.clear();
                    this.gc.set(n + 2000, n2, n3);
                    ((DbDate)this.Count[6]).value = this.gc.I();
                } else {
                    this.gc.clear();
                    this.gc.set(n + 1900, n2, n3);
                    ((DbDate)this.Count[6]).value = this.gc.I();
                }
            } else {
                ((DbDate)this.Count[6]).value = dbDate.value;
            }
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbTimestamp DateTimeTo2000(DbTimestamp dbTimestamp, DbBigInt dbBigInt) {
        if (dbTimestamp.bNull || dbBigInt.bNull) {
            this.Count[8].bNull = true;
        } else {
            this.gc.clear();
            this.gc.setTime(dbTimestamp.getTimestamp());
            int n = this.gc.get(1);
            int n2 = this.gc.get(2);
            int n3 = this.gc.get(5);
            int n4 = this.gc.get(10);
            int n5 = this.gc.get(12);
            int n6 = this.gc.get(13);
            if (n < 2000 & n >= 1900) {
                int n7 = dbTimestamp.getTimestamp().getYear();
                if ((long)n7 < dbBigInt.value) {
                    this.gc.clear();
                    this.gc.set(n7 + 2000, n2, n3, n4, n5, n6);
                    ((DbTimestamp)this.Count[8]).value = this.gc.I();
                } else {
                    ((DbTimestamp)this.Count[8]).value = dbTimestamp.value;
                }
            } else if (n < 100 & n >= 0) {
                if ((long)n < dbBigInt.value) {
                    this.gc.clear();
                    this.gc.set(n + 2000, n2, n3, n4, n5, n6);
                    ((DbTimestamp)this.Count[8]).value = this.gc.I();
                } else {
                    this.gc.clear();
                    this.gc.set(n + 1900, n2, n3, n4, n5, n6);
                    ((DbTimestamp)this.Count[8]).value = this.gc.I();
                }
            } else {
                ((DbTimestamp)this.Count[8]).value = dbTimestamp.value;
            }
            this.Count[8].bNull = false;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbChar DTSTo2000(DbChar dbChar, DbBigInt dbBigInt) {
        if (dbChar.bNull || dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            Integer n;
            Integer n2;
            int n3;
            Integer n4;
            Integer n5;
            int n6;
            int n7 = dbChar.value.length();
            String string = "";
            int n8 = 0;
            while (n8 < n7) {
                if (!(dbChar.value.charAt(n8) >= '0' & dbChar.value.charAt(n8) <= '9')) break;
                string = string + dbChar.value.charAt(n8);
                ++n8;
            }
            ((DbChar)this.Count[5]).value = string.length() == 0 ? dbChar.value : (string.length() <= 4 & string.length() > 0 ? ((n6 = (n5 = new Integer(string)).intValue()) < 2000 & n6 >= 1900 ? ((long)(n4 = new Integer(string.substring(2, 4))).intValue() < dbBigInt.value ? "20" + dbChar.value.substring(2, dbChar.value.length()) : dbChar.value) : (n6 < 100 & n6 >= 10 ? ((long)n6 < dbBigInt.value ? "20" + dbChar.value : "19" + dbChar.value) : (n6 < 10 && n6 > 0 ? ((long)n6 < dbBigInt.value ? "200" + dbChar.value : "190" + dbChar.value) : dbChar.value))) : ((n3 = (n2 = new Integer(string.substring(0, 4))).intValue()) < 2000 & n3 >= 1900 ? ((long)(n = new Integer(string.substring(2, 4))).intValue() < dbBigInt.value ? "20" + dbChar.value.substring(2, dbChar.value.length()) : dbChar.value) : (n3 < 100 & n3 >= 0 ? ((long)n3 < dbBigInt.value ? "20" + dbChar.value : "19" + dbChar.value) : dbChar.value)));
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ByteToText(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            if (dbBigInt.value < 1024L) {
                ((DbChar)this.Count[5]).set(dbBigInt.toString() + " bytes");
            } else if (dbBigInt.value >= 1024L & dbBigInt.value < 0x100000L) {
                int n = (int)(dbBigInt.value / 1024L);
                DbBigInt dbBigInt2 = new DbBigInt();
                dbBigInt2.set(n);
                ((DbChar)this.Count[5]).set(dbBigInt2.toString() + " KB");
            } else if (dbBigInt.value >= 0x100000L) {
                int n = (int)(dbBigInt.value / 0x100000L);
                DbBigInt dbBigInt3 = new DbBigInt();
                dbBigInt3.set(n);
                ((DbChar)this.Count[5]).set(dbBigInt3.toString() + " MB");
            }
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    private String DatePart(String string) {
        String string2 = (string = string.toUpperCase()).substring(0, 1);
        if (!Character.isLetter(string2.charAt(0))) {
            return "0000";
        }
        int n = 1;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case 'A': 
                case 'E': 
                case 'H': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'W': 
                case 'Y': {
                    break;
                }
                case 'B': 
                case 'F': 
                case 'P': 
                case 'V': {
                    string2 = string2 + "1";
                    break;
                }
                case 'C': 
                case 'G': 
                case 'J': 
                case 'K': 
                case 'Q': 
                case 'S': 
                case 'X': 
                case 'Z': {
                    string2 = string2 + "2";
                    break;
                }
                case 'D': 
                case 'T': {
                    string2 = string2 + "3";
                    break;
                }
                case 'L': {
                    string2 = string2 + 4;
                    break;
                }
                case 'M': 
                case 'N': {
                    string2 = string2 + "5";
                    break;
                }
                case 'R': {
                    string2 = string2 + "6";
                    break;
                }
                default: {
                    string2 = string2 + "0";
                }
            }
            ++n;
        }
        string2 = string2 + "0000";
        return string2.substring(0, 4);
    }

    public DbChar Soundex(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = this.DatePart(dbChar.value);
            ((DbChar)this.Count[5]).set(string);
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ExchGetId(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = "";
            String string2 = "";
            if (dbChar.value.toUpperCase().indexOf("/CN=") != -1) {
                int n = 0;
                while (n < dbChar.value.length()) {
                    if (dbChar.value.charAt(n) == '/' && (string = dbChar.value.substring(n, n + 4)).toUpperCase().equals("/CN=") && (string2 = dbChar.value.substring(n + 4, dbChar.value.length())).toUpperCase().indexOf("/CN=") == -1) break;
                    ++n;
                }
                ((DbChar)this.Count[5]).value = string2;
            } else if (dbChar.value.toUpperCase().indexOf("DDA:SMTP=") != -1) {
                int n = 3;
                while (n < dbChar.value.length()) {
                    if (dbChar.value.charAt(n) == ':' && (string = dbChar.value.substring(n - 3, n + 6)).toUpperCase().equals("DDA:SMTP=")) {
                        string2 = dbChar.value.substring(n + 6, dbChar.value.length());
                        break;
                    }
                    ++n;
                }
                ((DbChar)this.Count[5]).value = string2;
            } else if (dbChar.value.toUpperCase().indexOf("DDA:MS=") != -1) {
                int n = 3;
                while (n < dbChar.value.length()) {
                    if (dbChar.value.charAt(n) == ':' && (string = dbChar.value.substring(n - 3, n + 4)).toUpperCase().equals("DDA:MS=")) {
                        string2 = dbChar.value.substring(n + 4, dbChar.value.length());
                        break;
                    }
                    ++n;
                }
                ((DbChar)this.Count[5]).value = string2;
            } else {
                ((DbChar)this.Count[5]).value = "";
            }
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ExchGetOrganization(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = "";
            String string2 = "";
            String string3 = "";
            if (dbChar.value.toUpperCase().indexOf("/O=") != -1) {
                int n = 0;
                while (n < dbChar.value.length()) {
                    if (dbChar.value.charAt(n) == '/' && (string = dbChar.value.substring(n, n + 3)).toUpperCase().equals("/O=")) {
                        string3 = dbChar.value.substring(n + 3, dbChar.value.length());
                        break;
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < string3.length()) {
                    if (string3.charAt(n2) == '/') break;
                    string2 = string2 + string3.charAt(n2);
                    ++n2;
                }
                ((DbChar)this.Count[5]).value = string2;
            } else if (dbChar.value.toUpperCase().indexOf(";P=") != -1) {
                int n = 0;
                while (n < dbChar.value.length()) {
                    if (dbChar.value.charAt(n) == ';' && (string = dbChar.value.substring(n, n + 3)).toUpperCase().equals(";P=")) {
                        string3 = dbChar.value.substring(n + 3, dbChar.value.length());
                        break;
                    }
                    ++n;
                }
                int n3 = 0;
                while (n3 < string3.length()) {
                    if (string3.charAt(n3) == ';') break;
                    string2 = string2 + string3.charAt(n3);
                    ++n3;
                }
                ((DbChar)this.Count[5]).value = string2;
            }
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ExchGetSite(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = "";
            String string2 = "";
            String string3 = "";
            if (dbChar.value.toUpperCase().indexOf("/OU=") != -1) {
                int n = 0;
                while (n < dbChar.value.length()) {
                    if (dbChar.value.charAt(n) == '/' && (string = dbChar.value.substring(n, n + 4)).toUpperCase().equals("/OU=")) {
                        string3 = dbChar.value.substring(n + 4, dbChar.value.length());
                        break;
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < string3.length()) {
                    if (string3.charAt(n2) == '/') break;
                    string2 = string2 + string3.charAt(n2);
                    ++n2;
                }
                ((DbChar)this.Count[5]).value = string2;
            } else if (dbChar.value.toUpperCase().indexOf(";O=") != -1) {
                int n = 0;
                while (n < dbChar.value.length()) {
                    if (dbChar.value.charAt(n) == ';' && (string = dbChar.value.substring(n, n + 3)).toUpperCase().equals(";O=")) {
                        string3 = dbChar.value.substring(n + 3, dbChar.value.length());
                        break;
                    }
                    ++n;
                }
                int n3 = 0;
                while (n3 < string3.length()) {
                    if (string3.charAt(n3) == ';') break;
                    string2 = string2 + string3.charAt(n3);
                    ++n3;
                }
                ((DbChar)this.Count[5]).value = string2;
            }
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar ExchGetPath(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = "";
            int n = 0;
            int n2 = 0;
            if (dbChar.value.toUpperCase().indexOf("CN=") != -1) {
                int n3 = 2;
                while (n3 < dbChar.value.length()) {
                    String string2;
                    if (dbChar.value.toUpperCase().charAt(n3) == '=' && (string = dbChar.value.substring(n3 - 2, n3 + 1)).toUpperCase().equals("CN=") && (string2 = dbChar.value.substring(n3 + 1, dbChar.value.length())).toUpperCase().indexOf("CN=") == -1) {
                        n = n3 - 3;
                    }
                    ++n3;
                }
                int n4 = 2;
                while (n4 < dbChar.value.length()) {
                    if (dbChar.value.toUpperCase().charAt(n4) == '=' && (string = dbChar.value.substring(n4 - 2, n4 + 1)).toUpperCase().equals("CN=")) {
                        String string3 = dbChar.value.substring(n4 + 1, dbChar.value.length());
                        if (string3.toUpperCase().indexOf("CN=") != -1) {
                            ((DbChar)this.Count[5]).value = dbChar.value.substring(n4 - 2, n);
                            break;
                        }
                        ((DbChar)this.Count[5]).value = "";
                    }
                    ++n4;
                }
            } else if (dbChar.value.toUpperCase().indexOf("P=") != -1 & dbChar.value.toUpperCase().indexOf("O=") != -1) {
                int n5 = 1;
                while (n5 < dbChar.value.length()) {
                    if (dbChar.value.charAt(n5) == '=') {
                        string = dbChar.value.substring(n5 - 1, n5 + 1);
                        if (string.toUpperCase().equals("P=")) {
                            String string4 = dbChar.value.substring(n5 + 1, dbChar.value.length());
                            int n6 = 0;
                            while (n6 < string4.length()) {
                                if (string4.charAt(n6) == ';') {
                                    n = n5 + 1 + n6 + 1;
                                    break;
                                }
                                ++n6;
                            }
                        } else if (string.toUpperCase().equals("O=")) {
                            n2 = n5 - 1;
                        }
                    }
                    ++n5;
                }
                if (n != 0 & n < n2) {
                    ((DbChar)this.Count[5]).value = dbChar.value.substring(n, n2);
                }
            } else if (dbChar.value.toUpperCase().indexOf("DDA:") != -1) {
                int n7 = 3;
                while (n7 < dbChar.value.length()) {
                    if (dbChar.value.charAt(n7) == ':' && (string = dbChar.value.substring(n7 - 3, n7 + 1)).toUpperCase().equals("DDA:")) {
                        ((DbChar)this.Count[5]).value = dbChar.value.substring(n7 + 1, dbChar.value.length());
                        break;
                    }
                    ++n7;
                }
            } else {
                ((DbChar)this.Count[5]).value = "UNKNOWN ADDRESS TYPE";
            }
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbBit IsDate(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[4].bNull = true;
        } else {
            this.gc.clear();
            this.gc.set(1900, 0, (int)dbDouble.value, 0, 0, 0);
            int n = this.gc.get(1);
            ((DbBit)this.Count[4]).value = n >= 100 && n <= 9999;
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    public DbDate ToDate(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[6].bNull = true;
        } else if (this.IsDate((DbDouble)dbDouble).value) {
            this.gc.clear();
            this.gc.set(1900, 0, (int)dbDouble.value, 0, 0, 0);
            ((DbDate)this.Count[6]).value = this.gc.I();
            this.Count[6].bNull = false;
        } else {
            this.Count[6].bNull = true;
        }
        return (DbDate)this.Count[6];
    }

    public DbBit IsTime(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[7].bNull = true;
        } else if (this.IsDate((DbDouble)dbDouble).value) {
            float f;
            int n;
            float f2;
            int n2;
            int n3;
            float f3 = (float)(dbDouble.value - (double)((int)dbDouble.value));
            if (f3 < 0.0f) {
                f3 = 1.0f + f3;
            }
            if ((n3 = (int)(f3 * 24.0f)) < 24 & n3 >= 0 & (n2 = (int)((f2 = f3 * 24.0f - (float)n3) * 60.0f)) <= 59 & n2 >= 0 & (n = (int)((f = f2 * 60.0f - (float)n2) * 60.0f)) <= 59 & n2 >= 0) {
                ((DbBit)this.Count[4]).value = true;
                this.Count[7].bNull = false;
            } else {
                ((DbBit)this.Count[4]).value = false;
            }
        } else {
            ((DbBit)this.Count[4]).value = false;
        }
        return (DbBit)this.Count[4];
    }

    public DbTime ToTime(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[6].bNull = true;
        } else if (this.IsTime((DbDouble)dbDouble).value) {
            float f = (float)(dbDouble.value - (double)((int)dbDouble.value));
            if (f < 0.0f) {
                f = 1.0f + f;
            }
            int n = (int)(f * 24.0f);
            float f2 = f * 24.0f - (float)n;
            int n2 = (int)(f2 * 60.0f);
            float f3 = f2 * 60.0f - (float)n2;
            int n3 = (int)(f3 * 60.0f);
            this.gc.clear();
            this.gc.set(11, n);
            this.gc.set(12, n2);
            this.gc.set(13, n3);
            ((DbTime)this.Count[7]).value = this.gc.I();
            this.Count[7].bNull = false;
        } else {
            this.Count[7].bNull = true;
        }
        return (DbTime)this.Count[7];
    }

    public DbBit IsDateTime(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[4].bNull = true;
        } else {
            ((DbBit)this.Count[4]).value = this.IsTime((DbDouble)dbDouble).value;
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    public DbTimestamp ToDateTime(DbDate dbDate) {
        if (dbDate.bNull) {
            this.Count[8].bNull = true;
        } else {
            ((DbTimestamp)this.Count[8]).value = dbDate.value;
            this.Count[8].bNull = false;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbTimestamp DateAdd(DbChar dbChar, DbBigInt dbBigInt, DbTimestamp dbTimestamp) {
        if (dbChar.bNull || dbBigInt.bNull || dbTimestamp.bNull) {
            this.Count[8].bNull = true;
        } else {
            String string = dbChar.value;
            if (string.equalsIgnoreCase("yyyy")) {
                int n = (int)((long)(1900 + dbTimestamp.getTimestamp().getYear()) + dbBigInt.value);
                this.gc.clear();
                this.gc.set(n, dbTimestamp.getTimestamp().getMonth(), dbTimestamp.getTimestamp().getDate(), dbTimestamp.getTimestamp().getHours(), dbTimestamp.getTimestamp().getMinutes(), dbTimestamp.getTimestamp().getSeconds());
                ((DbTimestamp)this.Count[8]).value = this.gc.I();
            } else if (string.equalsIgnoreCase("q")) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dbTimestamp.getTimestamp());
                calendar.add(2, (int)dbBigInt.value * 3);
                ((DbTimestamp)this.Count[8]).value = calendar.getTimeInMillis();
            } else if (string.equalsIgnoreCase("m")) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dbTimestamp.getTimestamp());
                calendar.add(2, (int)dbBigInt.value);
                ((DbTimestamp)this.Count[8]).value = calendar.getTimeInMillis();
            } else if (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("d") || string.equalsIgnoreCase("w")) {
                int n = (int)((long)dbTimestamp.getTimestamp().getDate() + dbBigInt.value);
                this.gc.clear();
                this.gc.set(1900 + dbTimestamp.getTimestamp().getYear(), dbTimestamp.getTimestamp().getMonth(), n, dbTimestamp.getTimestamp().getHours(), dbTimestamp.getTimestamp().getMinutes(), dbTimestamp.getTimestamp().getSeconds());
                ((DbTimestamp)this.Count[8]).value = this.gc.I();
            } else if (string.equalsIgnoreCase("ww")) {
                int n = (int)((long)dbTimestamp.getTimestamp().getDate() + dbBigInt.value * 7L);
                this.gc.clear();
                this.gc.set(1900 + dbTimestamp.getTimestamp().getYear(), dbTimestamp.getTimestamp().getMonth(), n, dbTimestamp.getTimestamp().getHours(), dbTimestamp.getTimestamp().getMinutes(), dbTimestamp.getTimestamp().getSeconds());
                ((DbTimestamp)this.Count[8]).value = this.gc.I();
            } else if (string.equalsIgnoreCase("h")) {
                int n = (int)((long)dbTimestamp.getTimestamp().getHours() + dbBigInt.value);
                this.gc.clear();
                this.gc.set(1900 + dbTimestamp.getTimestamp().getYear(), dbTimestamp.getTimestamp().getMonth(), dbTimestamp.getTimestamp().getDate(), n, dbTimestamp.getTimestamp().getMinutes(), dbTimestamp.getTimestamp().getSeconds());
                ((DbTimestamp)this.Count[8]).value = this.gc.I();
            } else if (string.equalsIgnoreCase("n")) {
                int n = (int)((long)dbTimestamp.getTimestamp().getMinutes() + dbBigInt.value);
                this.gc.clear();
                this.gc.set(1900 + dbTimestamp.getTimestamp().getYear(), dbTimestamp.getTimestamp().getMonth(), dbTimestamp.getTimestamp().getDate(), dbTimestamp.getTimestamp().getHours(), n, dbTimestamp.getTimestamp().getSeconds());
                ((DbTimestamp)this.Count[8]).value = this.gc.I();
            } else if (string.equalsIgnoreCase("s")) {
                int n = (int)((long)dbTimestamp.getTimestamp().getSeconds() + dbBigInt.value);
                this.gc.clear();
                this.gc.set(1900 + dbTimestamp.getTimestamp().getYear(), dbTimestamp.getTimestamp().getMonth(), dbTimestamp.getTimestamp().getDate(), dbTimestamp.getTimestamp().getHours(), dbTimestamp.getTimestamp().getMinutes(), n);
                ((DbTimestamp)this.Count[8]).value = this.gc.I();
            }
            this.Count[8].bNull = false;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        if (dbChar.bNull || dbTimestamp.bNull || dbTimestamp2.bNull) {
            this.Count[1].bNull = true;
        } else {
            String string = dbChar.value;
            if (string.equalsIgnoreCase("yyyy")) {
                int n = dbTimestamp.getTimestamp().getYear();
                int n2 = dbTimestamp2.getTimestamp().getYear();
                ((DbBigInt)this.Count[1]).value = n2 - n;
            } else if (string.equalsIgnoreCase("q")) {
                int n = dbTimestamp.getTimestamp().getYear();
                int n3 = dbTimestamp2.getTimestamp().getYear();
                int n4 = dbTimestamp.getTimestamp().getMonth();
                int n5 = dbTimestamp2.getTimestamp().getMonth();
                int n6 = 0;
                int n7 = 0;
                switch (n4) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n6 = 1;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n6 = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        n6 = 3;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        n6 = 4;
                    }
                }
                switch (n5) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n7 = 1;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n7 = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        n7 = 3;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        n7 = 4;
                    }
                }
                ((DbBigInt)this.Count[1]).value = (n3 - n) * 4 + (n7 - n6);
            } else if (string.equalsIgnoreCase("m")) {
                int n = dbTimestamp.getTimestamp().getYear();
                int n8 = dbTimestamp2.getTimestamp().getYear();
                int n9 = dbTimestamp.getTimestamp().getMonth();
                int n10 = dbTimestamp2.getTimestamp().getMonth();
                ((DbBigInt)this.Count[1]).value = (n8 - n) * 12 + (n10 - n9);
            } else if (string.equalsIgnoreCase("d") || string.equalsIgnoreCase("y")) {
                this.ForEachMonth(dbTimestamp, dbTimestamp2);
            } else if (string.equalsIgnoreCase("w")) {
                int n = (int)this.ForEachMonth((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
                ((DbBigInt)this.Count[1]).value = n / 7;
            } else if (string.equalsIgnoreCase("ww")) {
                int n = (int)this.ForEachMonth((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
                DbChar dbChar2 = new DbChar();
                dbChar2.setValue("jrSunday");
                DbBigInt dbBigInt = this.DateDiff(dbChar, dbTimestamp, dbTimestamp2, dbChar2);
                ((DbBigInt)this.Count[1]).value = dbBigInt.longValue();
            } else if (string.equalsIgnoreCase("h")) {
                this.FV(dbTimestamp, dbTimestamp2);
            } else if (string.equalsIgnoreCase("n")) {
                this.DayOfWeek(dbTimestamp, dbTimestamp2);
            } else if (string.equalsIgnoreCase("s")) {
                this.Day(dbTimestamp, dbTimestamp2);
            }
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2, DbChar dbChar2) {
        DbBigInt dbBigInt = new DbBigInt();
        if (dbChar.bNull || dbTimestamp.bNull || dbTimestamp2.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            String string = dbChar.toString();
            if (string.equalsIgnoreCase("yyyy") || string.equalsIgnoreCase("q") || string.equalsIgnoreCase("m") || string.equalsIgnoreCase("d") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("w") || string.equalsIgnoreCase("h") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("s")) {
                dbBigInt = this.DateDiff(dbChar, dbTimestamp, dbTimestamp2);
            } else if (string.equalsIgnoreCase("ww")) {
                int n = (int)this.ForEachMonth((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
                int n2 = (int)this.DayOfWeek((DbTimestamp)dbTimestamp).value;
                int n3 = (int)this.DayOfWeek((DbTimestamp)dbTimestamp2).value;
                int n4 = (n - (7 - n2) - n3) / 7;
                String string2 = (String)firstdayOfWeek.get(dbChar2.toString().toUpperCase());
                Integer n5 = new Integer(string2);
                int n6 = n5;
                int n7 = 0;
                if (n6 == 0) {
                    DbDate dbDate = this.CurrentDate();
                    n7 = dbDate.getDate().getDay() + 1;
                } else {
                    n7 = n6;
                }
                int n8 = 0;
                if (n2 < n7 & n3 >= n7) {
                    n8 = n4 + 2;
                } else if (n2 >= n7 & n3 >= n7 || n2 < n7 & n3 < n7) {
                    n8 = n4 + 1;
                } else if (n2 >= n7 & n3 < n7) {
                    n8 = n4;
                }
                dbBigInt.set(n8);
            }
        }
        return dbBigInt;
    }

    private DbBigInt Day(DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        int n = (int)this.DayOfWeek((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
        this.gc.clear();
        this.gc.setTime(dbTimestamp.getTimestamp());
        int n2 = this.gc.get(13);
        this.gc.clear();
        this.gc.setTime(dbTimestamp2.getTimestamp());
        int n3 = this.gc.get(13);
        ((DbBigInt)this.Count[1]).value = n * 60 + (n3 - n2);
        return (DbBigInt)this.Count[1];
    }

    private DbBigInt DayOfWeek(DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        int n = (int)this.FV((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
        this.gc.clear();
        this.gc.setTime(dbTimestamp.getTimestamp());
        int n2 = this.gc.get(12);
        this.gc.clear();
        this.gc.setTime(dbTimestamp2.getTimestamp());
        int n3 = this.gc.get(12);
        ((DbBigInt)this.Count[1]).value = n * 60 + (n3 - n2);
        return (DbBigInt)this.Count[1];
    }

    private DbBigInt FV(DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        int n = (int)this.ForEachMonth((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
        this.gc.clear();
        this.gc.setTime(dbTimestamp.getTimestamp());
        int n2 = this.gc.get(11);
        this.gc.clear();
        this.gc.setTime(dbTimestamp2.getTimestamp());
        int n3 = this.gc.get(11);
        ((DbBigInt)this.Count[1]).value = n * 24 + (n3 - n2);
        return (DbBigInt)this.Count[1];
    }

    private DbBigInt ForEachMonth(DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        this.gc.clear();
        this.gc.setTime(dbTimestamp.getTimestamp());
        int n = this.gc.get(1);
        int n2 = this.gc.get(6);
        this.gc.clear();
        this.gc.setTime(dbTimestamp2.getTimestamp());
        int n3 = this.gc.get(1);
        int n4 = this.gc.get(6);
        if (n == n3) {
            ((DbBigInt)this.Count[1]).value = n4 - n2;
        } else if (n3 > n) {
            int n5 = 0;
            n5 = this.gc.isLeapYear(n) ? 366 - n2 : 365 - n2;
            int n6 = 0;
            int n7 = n + 1;
            while (n7 < n3) {
                int n8 = 0;
                n8 = this.gc.isLeapYear(n7) ? 366 : 365;
                n6 += n8;
                ++n7;
            }
            ((DbBigInt)this.Count[1]).value = n6 + n5 + n4;
        } else {
            int n9 = 0;
            n9 = this.gc.isLeapYear(n3) ? 366 - n4 : 365 - n4;
            int n10 = 0;
            int n11 = n3 + 1;
            while (n11 < n) {
                int n12 = 0;
                n12 = this.gc.isLeapYear(n11) ? 366 : 365;
                n10 += n12;
                ++n11;
            }
            ((DbBigInt)this.Count[1]).value = -(n10 + n9 + n2);
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbTimestamp dbTimestamp) {
        DbBigInt dbBigInt = new DbBigInt();
        if (dbChar.bNull || dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            String string = dbChar.toString();
            if (string.equalsIgnoreCase("yyyy")) {
                dbBigInt = this.Year(dbTimestamp);
            } else if (string.equalsIgnoreCase("q")) {
                int n = dbTimestamp.getTimestamp().getMonth();
                int n2 = 0;
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n2 = 1;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        n2 = 3;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        n2 = 4;
                    }
                }
                ((DbBigInt)this.Count[1]).value = n2;
                this.Count[1].bNull = false;
                dbBigInt = (DbBigInt)this.Count[1];
            } else if (string.equalsIgnoreCase("m")) {
                dbBigInt = this.Month(dbTimestamp);
            } else if (string.equalsIgnoreCase("y")) {
                this.gc.setTime(dbTimestamp.getTimestamp());
                ((DbBigInt)this.Count[1]).value = this.gc.get(6);
                this.Count[1].bNull = false;
                dbBigInt = (DbBigInt)this.Count[1];
            } else if (string.equalsIgnoreCase("d")) {
                dbBigInt = this.Day(dbTimestamp);
            } else if (string.equalsIgnoreCase("w")) {
                dbBigInt = this.DayOfWeek(dbTimestamp);
            } else if (string.equalsIgnoreCase("ww")) {
                dbBigInt = this.WeekOfYear(dbTimestamp);
            } else if (string.equalsIgnoreCase("h")) {
                dbBigInt = this.Hour(dbTimestamp);
            } else if (string.equalsIgnoreCase("n")) {
                dbBigInt = this.Minute(dbTimestamp);
            } else if (string.equalsIgnoreCase("s")) {
                dbBigInt = this.Second(dbTimestamp);
            }
        }
        return dbBigInt;
    }

    public DbBigInt DatePart(DbChar dbChar, DbTimestamp dbTimestamp, DbChar dbChar2) {
        DbBigInt dbBigInt = new DbBigInt();
        if (dbChar.bNull || dbTimestamp.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            String string = dbChar.toString();
            if (string.equalsIgnoreCase("yyyy") || string.equalsIgnoreCase("q") || string.equalsIgnoreCase("m") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("d") || string.equalsIgnoreCase("h") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("s")) {
                dbBigInt = this.DatePart(dbChar, dbTimestamp);
            } else if (string.equalsIgnoreCase("w")) {
                int n = (int)this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp).value;
                String string2 = (String)firstdayOfWeek.get(dbChar2.toString().toUpperCase());
                Integer n2 = new Integer(string2);
                int n3 = n2;
                int n4 = 0;
                if (n3 == 0) {
                    DbDate dbDate = this.CurrentDate();
                    int n5 = dbDate.getDate().getDay();
                    n4 = (n - n5 + 7) % 7;
                } else {
                    n4 = (n - (n3 - 1) + 7) % 7;
                }
                if (n4 == 0) {
                    n4 += 7;
                }
                dbBigInt.set(n4);
            } else if (string.equalsIgnoreCase("ww")) {
                int n;
                int n6 = (int)this.DayOfWeek((DbTimestamp)dbTimestamp).value;
                int n7 = (int)this.WeekOfYear((DbTimestamp)dbTimestamp).value;
                String string3 = (String)firstdayOfWeek.get(dbChar2.toString().toUpperCase());
                Integer n8 = new Integer(string3);
                int n9 = n8;
                if (n9 == 0) {
                    DbDate dbDate = this.CurrentDate();
                    n = dbDate.getDate().getDay() + 1;
                } else {
                    n = n9;
                }
                int n10 = 0;
                if (n6 - (n - 1) > 0) {
                    n10 = n7;
                } else if (n6 - (n - 1) <= 0) {
                    n10 = n7 - 1;
                }
                this.gc.clear();
                this.gc.setTime(dbTimestamp.getTimestamp());
                int n11 = this.gc.get(1);
                this.gc.clear();
                this.gc.setTime(this.ToDate(new DbBigInt(n11), new DbBigInt(1L), new DbBigInt(1L)).getDate());
                int n12 = this.gc.get(7);
                int n13 = n12 >= n ? n10 : n10 + 1;
                dbBigInt.set(n13);
            }
            this.Count[1].bNull = false;
        }
        return dbBigInt;
    }

    public DbBigInt DatePart(DbChar dbChar, DbTimestamp dbTimestamp, DbChar dbChar2, DbChar dbChar3) {
        DbBigInt dbBigInt = new DbBigInt();
        if (dbChar.bNull || dbTimestamp.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.Count[1].bNull = true;
        } else {
            String string = dbChar.toString();
            if (string.equalsIgnoreCase("yyyy") || string.equalsIgnoreCase("q") || string.equalsIgnoreCase("m") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("d") || string.equalsIgnoreCase("w") || string.equalsIgnoreCase("h") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("s")) {
                dbBigInt = this.DatePart(dbChar, dbTimestamp, dbChar2);
            } else if (string.equalsIgnoreCase("ww")) {
                String string2 = dbChar3.toString();
                if (string2.equalsIgnoreCase("jrFirstJan1")) {
                    dbBigInt = this.DatePart(dbChar, dbTimestamp, dbChar2);
                } else if (string2.equalsIgnoreCase("jrFirstFourDays")) {
                    this.gc.clear();
                    this.gc.setTime(dbTimestamp.getTimestamp());
                    int n = this.gc.get(1);
                    DbTimestamp dbTimestamp2 = this.ToDateTime(new DbBigInt(n), new DbBigInt(1L), new DbBigInt(1L));
                    int n2 = (int)this.DatePart((DbChar)new DbChar((String)"w"), (DbTimestamp)dbTimestamp2, (DbChar)dbChar2).value;
                    if (7 - n2 + 1 < 4) {
                        dbBigInt.set(this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value - 1L);
                    } else {
                        dbBigInt = this.DatePart(dbChar, dbTimestamp, dbChar2);
                    }
                } else if (string2.equalsIgnoreCase("jrFirstFullWeek")) {
                    this.gc.clear();
                    this.gc.setTime(dbTimestamp.getTimestamp());
                    int n = this.gc.get(1);
                    DbTimestamp dbTimestamp3 = this.ToDateTime(new DbBigInt(n), new DbBigInt(1L), new DbBigInt(1L));
                    int n3 = (int)this.DatePart((DbChar)new DbChar((String)"w"), (DbTimestamp)dbTimestamp3, (DbChar)dbChar2).value;
                    if (n3 == 1) {
                        dbBigInt = this.DatePart(dbChar, dbTimestamp, dbChar2);
                    } else {
                        dbBigInt.set(this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value - 1L);
                    }
                } else if (string2.equalsIgnoreCase("JRUSESYSTEM")) {
                    DbTimestamp dbTimestamp4 = this.CurrentDateTime();
                    this.gc.clear();
                    this.gc.setTime(dbTimestamp4.getTimestamp());
                    int n = (int)this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp4, (DbChar)dbChar2).value;
                    int n4 = (int)this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value;
                    DbTimestamp dbTimestamp5 = this.ToDateTime(new DbBigInt(this.gc.get(1)), new DbBigInt(1L), new DbBigInt(1L));
                    int n5 = (int)this.DatePart((DbChar)new DbChar((String)"w"), (DbTimestamp)dbTimestamp5, (DbChar)dbChar2).value;
                    int n6 = (int)this.DatePart((DbChar)dbChar, (DbTimestamp)this.ToDateTime((DbBigInt)new DbBigInt((long)((long)this.gc.get((int)1))), (DbBigInt)new DbBigInt((long)1L), (DbBigInt)new DbBigInt((long)((long)(1 - n5)))), (DbChar)dbChar2).value;
                    if (n4 >= n) {
                        dbBigInt.set(n4 - n + 1);
                    } else {
                        dbBigInt.set(n6 - (n - n4));
                    }
                }
            }
            this.Count[1].bNull = false;
        }
        return dbBigInt;
    }

    public DbChar MonthName(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = dbBigInt.toString();
            ((DbChar)this.Count[5]).value = (String)CurrentTime.get(string);
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar MonthName(DbBigInt dbBigInt, DbBit dbBit) {
        if (dbBigInt.bNull || dbBit.bNull) {
            this.Count[5].bNull = true;
        } else {
            if (dbBit.value) {
                String string = dbBigInt.toString();
                ((DbChar)this.Count[5]).value = (String)D.get(string);
            } else {
                String string = dbBigInt.toString();
                ((DbChar)this.Count[5]).value = (String)CurrentTime.get(string);
            }
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbBigInt Timer() {
        DbTime dbTime = this.CurrentTime();
        MyCalendar myCalendar = new MyCalendar();
        int n = dbTime.getTime().getHours();
        int n2 = dbTime.getTime().getMinutes();
        int n3 = dbTime.getTime().getSeconds();
        int n4 = n * 3600 + n2 * 60 + n3;
        ((DbBigInt)this.Count[1]).set(n4);
        this.Count[1].bNull = false;
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt UBound(fArray fArray2) {
        if (fArray2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = fArray2.value.length;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbChar WeekdayName(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[5].bNull = true;
        } else {
            String string = dbBigInt.toString();
            ((DbChar)this.Count[5]).value = (String)weekdayToName.get(string);
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar WeekdayName(DbBigInt dbBigInt, DbBit dbBit) {
        if (dbBigInt.bNull || dbBit.bNull) {
            this.Count[5].bNull = true;
        } else {
            if (dbBit.value) {
                String string = dbBigInt.toString();
                ((DbChar)this.Count[5]).value = (String)weekdayToAbbr.get(string);
            } else {
                String string = dbBigInt.toString();
                ((DbChar)this.Count[5]).value = (String)weekdayToName.get(string);
            }
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbChar WeekdayName(DbBigInt dbBigInt, DbBit dbBit, DbChar dbChar) {
        if (dbBigInt.bNull || dbBit.bNull || dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            int n;
            String string = dbChar.value;
            String string2 = (String)firstdayOfWeek.get(string.toUpperCase());
            Integer n2 = new Integer(string2);
            int n3 = n2;
            boolean bl = false;
            if (n3 == 0) {
                Calendar calendar = Calendar.getInstance();
                n3 = calendar.get(7);
            }
            if ((n = (int)(((long)n3 + dbBigInt.value - 1L) % 7L)) == 0) {
                n = 7;
            }
            DbBigInt dbBigInt2 = new DbBigInt();
            dbBigInt2.set(n);
            String string3 = dbBigInt2.toString();
            ((DbChar)this.Count[5]).value = dbBit.value ? (String)weekdayToAbbr.get(string3) : (String)weekdayToName.get(string3);
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public DbTimestamp ToDateTime(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[8].bNull = true;
        } else if (this.IsDateTime((DbDouble)dbDouble).value) {
            DbDate dbDate = this.ToDate(dbDouble);
            DbTime dbTime = this.ToTime(dbDouble);
            this.gc.setTime(dbTime.getTime());
            this.gc.computeTime();
            int n = this.gc.get(11);
            int n2 = this.gc.get(12);
            int n3 = this.gc.get(13);
            this.gc.setTime(dbDate.getDate());
            this.gc.computeTime();
            this.gc.setHMS(n, n2, n3);
            ((DbTimestamp)this.Count[8]).value = this.gc.I();
            ((DbTimestamp)this.Count[8]).nanos = 0;
            this.Count[8].bNull = false;
        } else {
            this.Count[8].bNull = true;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbBit IsDate(DbChar dbChar) {
        return this.IsDateTime(dbChar);
    }

    public DbDate ToDate(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[6].bNull = true;
        } else if (this.ForEachWeek((DbChar)dbChar).value) {
            ((DbDate)this.Count[6]).value = this.ToDate((DbTimestamp)this.Hour((DbChar)dbChar)).value;
            this.Count[6].bNull = false;
        } else if (this.ForEachQuarter((DbChar)dbChar).value) {
            ((DbDate)this.Count[6]).value = this.IPmt((DbChar)dbChar).value;
            this.Count[6].bNull = false;
        } else {
            this.Count[6].bNull = true;
        }
        return (DbDate)this.Count[6];
    }

    public DbBit IsTime(DbChar dbChar) {
        return this.ForEachYear(dbChar);
    }

    public DbTime ToTime(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[7].bNull = true;
        } else if (this.ForEachWeek((DbChar)dbChar).value) {
            ((DbTime)this.Count[7]).value = this.ToTime((DbTimestamp)this.Hour((DbChar)dbChar)).value;
            this.Count[7].bNull = false;
        } else if (this.ForEachYear((DbChar)dbChar).value) {
            ((DbTime)this.Count[7]).value = this.IRR((DbChar)dbChar).value;
            this.Count[7].bNull = false;
        } else if (this.ForEachQuarter((DbChar)dbChar).value) {
            this.gc.clear();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            ((DbTime)this.Count[7]).value = this.gc.I();
            this.Count[7].bNull = false;
        } else {
            this.Count[7].bNull = true;
        }
        return (DbTime)this.Count[7];
    }

    public DbBit IsDateTime(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[4].bNull = true;
        } else {
            ((DbBit)this.Count[4]).value = this.ForEachYear((DbChar)dbChar).value ? true : (this.ForEachQuarter((DbChar)dbChar).value ? true : this.ForEachWeek((DbChar)dbChar).value);
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    public DbTimestamp ToDateTime(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[8].bNull = true;
        } else if (this.ForEachWeek((DbChar)dbChar).value) {
            ((DbTimestamp)this.Count[8]).value = this.Hour((DbChar)dbChar).value;
            this.Count[8].bNull = false;
        } else if (this.ForEachQuarter((DbChar)dbChar).value) {
            ((DbTimestamp)this.Count[8]).value = this.ToDateTime((DbDate)this.IPmt((DbChar)dbChar)).value;
            this.Count[8].bNull = false;
        } else if (this.ForEachYear((DbChar)dbChar).value) {
            ((DbTimestamp)this.Count[8]).value = this.ToDateTime((DbDate)this.CurrentDate(), (DbTime)this.IRR((DbChar)dbChar)).value;
            this.Count[8].bNull = false;
        } else {
            this.Count[8].bNull = true;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbBigInt DTSToSeconds(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[1].bNull = true;
        } else {
            if (this.IsDateTime((DbChar)dbChar).value) {
                DbTimestamp dbTimestamp = new DbTimestamp();
                dbTimestamp.set(this.ToDateTime(dbChar));
                int n = dbTimestamp.getTimestamp().getHours();
                int n2 = dbTimestamp.getTimestamp().getMinutes();
                int n3 = dbTimestamp.getTimestamp().getSeconds();
                ((DbBigInt)this.Count[1]).value = n * 3600 + n2 * 60 + n3;
            } else {
                ((DbBigInt)this.Count[1]).value = 0L;
            }
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbTimestamp DateAdd(DbChar dbChar, DbBigInt dbBigInt, DbDate dbDate) {
        if (dbChar.bNull || dbBigInt.bNull || dbDate.bNull) {
            this.Count[8].bNull = true;
        } else {
            DbTimestamp dbTimestamp = new DbTimestamp();
            dbTimestamp.set(this.ToDateTime(dbDate));
            ((DbTimestamp)this.Count[8]).value = this.DateAdd((DbChar)dbChar, (DbBigInt)dbBigInt, (DbTimestamp)dbTimestamp).value;
            this.Count[8].bNull = false;
        }
        return (DbTimestamp)this.Count[8];
    }

    public DbTime DateAdd(DbChar dbChar, DbBigInt dbBigInt, DbTime dbTime) {
        if (dbChar.bNull || dbBigInt.bNull || dbTime.bNull) {
            this.Count[7].bNull = true;
        } else {
            if (dbChar.value.equalsIgnoreCase("yyyy") || dbChar.value.equalsIgnoreCase("q") || dbChar.value.equalsIgnoreCase("m") || dbChar.value.equalsIgnoreCase("y") || dbChar.value.equalsIgnoreCase("d") || dbChar.value.equalsIgnoreCase("w") || dbChar.value.equalsIgnoreCase("ww")) {
                ((DbTime)this.Count[7]).value = dbTime.value;
            } else if (dbChar.value.equalsIgnoreCase("h")) {
                int n = (int)((long)dbTime.getTime().getHours() + dbBigInt.value);
                this.gc.clear();
                this.gc.set(11, n);
                this.gc.set(12, dbTime.getTime().getMinutes());
                this.gc.set(13, dbTime.getTime().getSeconds());
                ((DbTime)this.Count[7]).value = this.gc.I();
            } else if (dbChar.value.equalsIgnoreCase("n")) {
                int n = (int)((long)dbTime.getTime().getMinutes() + dbBigInt.value);
                this.gc.clear();
                this.gc.set(11, dbTime.getTime().getHours());
                this.gc.set(12, n);
                this.gc.set(13, dbTime.getTime().getSeconds());
                ((DbTime)this.Count[7]).value = this.gc.I();
            } else if (dbChar.value.equalsIgnoreCase("s")) {
                int n = (int)((long)dbTime.getTime().getSeconds() + dbBigInt.value);
                this.gc.clear();
                this.gc.set(11, dbTime.getTime().getHours());
                this.gc.set(12, dbTime.getTime().getMinutes());
                this.gc.set(13, n);
                ((DbTime)this.Count[7]).value = this.gc.I();
            }
            this.Count[7].bNull = false;
        }
        return (DbTime)this.Count[7];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbDate dbDate2) {
        if (dbChar.bNull || dbDate.bNull || dbDate2.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = new DbTimestamp();
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp.set(this.ToDateTime(dbDate));
            dbTimestamp2.set(this.ToDateTime(dbDate2));
            ((DbBigInt)this.Count[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbDate dbDate) {
        if (dbChar.bNull || dbTimestamp.bNull || dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.Count[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbTimestamp dbTimestamp) {
        if (dbChar.bNull || dbDate.bNull || dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.Count[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp2, (DbTimestamp)dbTimestamp).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbTime dbTime) {
        if (dbChar.bNull || dbTimestamp.bNull || dbTime.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = 0L;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbTime dbTime) {
        if (dbChar.bNull || dbDate.bNull || dbTime.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = 0L;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbTimestamp dbTimestamp) {
        if (dbChar.bNull || dbTime.bNull || dbTimestamp.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = 0L;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbDate dbDate) {
        if (dbChar.bNull || dbTime.bNull || dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = 0L;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbTime dbTime2) {
        if (dbChar.bNull || dbTime.bNull || dbTime2.bNull) {
            this.Count[1].bNull = true;
        } else {
            if (dbChar.value.equalsIgnoreCase("yyyy") || dbChar.value.equalsIgnoreCase("q") || dbChar.value.equalsIgnoreCase("m") || dbChar.value.equalsIgnoreCase("y") || dbChar.value.equalsIgnoreCase("d") || dbChar.value.equalsIgnoreCase("w") || dbChar.value.equalsIgnoreCase("ww")) {
                ((DbBigInt)this.Count[1]).value = 0L;
            } else if (dbChar.value.equalsIgnoreCase("h")) {
                int n = dbTime.getTime().getHours();
                int n2 = dbTime2.getTime().getHours();
                ((DbBigInt)this.Count[1]).value = n2 - n;
            } else if (dbChar.value.equalsIgnoreCase("n")) {
                int n = dbTime.getTime().getHours();
                int n3 = dbTime2.getTime().getHours();
                int n4 = dbTime.getTime().getMinutes();
                int n5 = dbTime2.getTime().getMinutes();
                ((DbBigInt)this.Count[1]).value = (n3 - n) * 60 + (n5 - n4);
            } else if (dbChar.value.equalsIgnoreCase("s")) {
                int n = dbTime.getTime().getHours();
                int n6 = dbTime2.getTime().getHours();
                int n7 = dbTime.getTime().getMinutes();
                int n8 = dbTime2.getTime().getMinutes();
                int n9 = dbTime.getTime().getSeconds();
                int n10 = dbTime2.getTime().getSeconds();
                ((DbBigInt)this.Count[1]).value = (n6 - n) * 3600 + (n8 - n7) * 60 + (n10 - n9);
            }
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbDate dbDate2, DbChar dbChar2) {
        if (dbChar.bNull || dbDate.bNull || dbDate2.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = new DbTimestamp();
            dbTimestamp.set(this.ToDateTime(dbDate));
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate2));
            ((DbBigInt)this.Count[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2, (DbChar)dbChar2).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbTimestamp dbTimestamp, DbChar dbChar2) {
        if (dbChar.bNull || dbDate.bNull || dbTimestamp.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.Count[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp2, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbDate dbDate, DbChar dbChar2) {
        if (dbChar.bNull || dbTimestamp.bNull || dbDate.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.Count[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2, (DbChar)dbChar2).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbTimestamp dbTimestamp, DbChar dbChar2) {
        if (dbChar.bNull || dbTime.bNull || dbTimestamp.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = 0L;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbTime dbTime, DbChar dbChar2) {
        if (dbChar.bNull || dbTimestamp.bNull || dbTime.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = 0L;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbTime dbTime, DbChar dbChar2) {
        if (dbChar.bNull || dbDate.bNull || dbTime.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = 0L;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbDate dbDate, DbChar dbChar2) {
        if (dbChar.bNull || dbTime.bNull || dbDate.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = 0L;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbTime dbTime2, DbChar dbChar2) {
        if (dbChar.bNull || dbTime.bNull || dbTime2.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = this.DateDiff((DbChar)dbChar, (DbTime)dbTime, (DbTime)dbTime2).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbDate dbDate) {
        if (dbChar.bNull || dbDate.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = new DbTimestamp();
            dbTimestamp.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.Count[1]).value = this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbTime dbTime) {
        if (dbChar.bNull || dbTime.bNull) {
            this.Count[1].bNull = true;
        } else {
            if (dbChar.value.equalsIgnoreCase("yyyy") || dbChar.value.equalsIgnoreCase("q") || dbChar.value.equalsIgnoreCase("m") || dbChar.value.equalsIgnoreCase("y") || dbChar.value.equalsIgnoreCase("d") || dbChar.value.equalsIgnoreCase("w") || dbChar.value.equalsIgnoreCase("ww")) {
                ((DbBigInt)this.Count[1]).value = 0L;
            } else if (dbChar.value.equalsIgnoreCase("h")) {
                ((DbBigInt)this.Count[1]).value = this.Hour((DbTime)dbTime).value;
            } else if (dbChar.value.equalsIgnoreCase("n")) {
                ((DbBigInt)this.Count[1]).value = this.Minute((DbTime)dbTime).value;
            } else if (dbChar.value.equalsIgnoreCase("s")) {
                ((DbBigInt)this.Count[1]).value = this.Second((DbTime)dbTime).value;
            }
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbDate dbDate, DbChar dbChar2) {
        if (dbChar.bNull || dbDate.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = this.ToDateTime(dbDate);
            ((DbBigInt)this.Count[1]).value = this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbTime dbTime, DbChar dbChar2) {
        if (dbChar.bNull || dbTime.bNull || dbChar2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = this.DatePart((DbChar)dbChar, (DbTime)dbTime).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbDate dbDate, DbChar dbChar2, DbChar dbChar3) {
        if (dbChar.bNull || dbDate.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.Count[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = this.ToDateTime(dbDate);
            ((DbBigInt)this.Count[1]).value = this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2, (DbChar)dbChar3).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbTime dbTime, DbChar dbChar2, DbChar dbChar3) {
        if (dbChar.bNull || dbTime.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = this.DatePart((DbChar)dbChar, (DbTime)dbTime).value;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    private DbBit ForEachQuarter(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[4].bNull = true;
        } else {
            DateTimeParser dateTimeParser = new DateTimeParser();
            String string = dbChar.value.trim();
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            int n = -1;
            int n2 = 0;
            while (n2 < dateFormats.length) {
                dateTimeParser.applyPattern(dateFormats[n2]);
                try {
                    java.util.Date date = dateTimeParser.parse(string);
                    if (date != null) {
                        int n3 = dateTimeParser.getYear();
                        int n4 = dateTimeParser.getMonth();
                        int n5 = dateTimeParser.getDate();
                        this.gc.clear();
                        this.gc.setTime(date);
                        if (dateTimeParser.hasYearField() && dateTimeParser.hasMonthField() && dateTimeParser.hasDateField()) {
                            n = 0;
                            if (this.gc.get(1) == n3 && this.gc.get(2) == n4 - 1 && this.gc.get(5) == n5) {
                                bl = true;
                                break;
                            }
                            bl2 = false;
                            bl3 = false;
                        } else if (bl3 && dateTimeParser.hasMonthField() && dateTimeParser.hasDateField()) {
                            if (this.gc.get(2) == n4 - 1) {
                                bl = true;
                                break;
                            }
                        } else if (bl2 && dateTimeParser.hasYearField() && dateTimeParser.hasMonthField()) {
                            if (this.gc.get(1) == n3 && this.gc.get(2) == n4 - 1 && this.gc.get(5) == 1) {
                                bl = true;
                                break;
                            }
                        } else {
                            bl = false;
                        }
                    }
                }
                catch (ParseException parseException) {
                    bl = false;
                }
                ++n2;
            }
            ((DbBit)this.Count[4]).value = bl;
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DbBit ForEachWeek(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[4].bNull = true;
            return (DbBit)this.Count[4];
        }
        DateTimeParser dateTimeParser = new DateTimeParser();
        String string = dbChar.value.trim();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        String string3 = "";
        int n = 1;
        int n2 = 0;
        block2: while (n2 < datetimeFormats.length) {
            dateTimeParser.applyPattern(datetimeFormats[n2]);
            try {
                java.util.Date date = dateTimeParser.parse(string);
                if (date != null) {
                    while (true) {
                        if (bl2 || bl3 || n > string.length()) {
                            if (!bl2 || !bl3) break;
                            bl = true;
                            break block2;
                        }
                        string2 = string.substring(0, n).trim();
                        string3 = string.substring(n, string.length()).trim();
                        if (this.ForEachQuarter((DbChar)new DbChar((String)string2)).value && this.ForEachYear((DbChar)new DbChar((String)string3)).value) {
                            bl2 = true;
                            bl3 = true;
                        }
                        ++n;
                    }
                    bl = false;
                }
            }
            catch (ParseException parseException) {
                bl = false;
            }
            ++n2;
        }
        ((DbBit)this.Count[4]).value = bl;
        this.Count[4].bNull = false;
        return (DbBit)this.Count[4];
    }

    private DbBit ForEachYear(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[4].bNull = true;
        } else {
            DateTimeParser dateTimeParser = new DateTimeParser();
            String string = dbChar.value.trim();
            boolean bl = false;
            int n = 0;
            while (n < timeFormats.length) {
                dateTimeParser.applyPattern(timeFormats[n]);
                try {
                    java.util.Date date = dateTimeParser.parse(string);
                    if (date != null) {
                        int n2 = dateTimeParser.getHour();
                        int n3 = dateTimeParser.getMinute();
                        int n4 = dateTimeParser.getSecond();
                        this.gc.clear();
                        this.gc.setTime(date);
                        if (n2 >= 0 && n2 < 24 && n3 >= 0 && n3 <= 59 && n4 >= 0 && n4 <= 59) {
                            bl = true;
                            break;
                        }
                        bl = false;
                    }
                }
                catch (ParseException parseException) {
                    bl = false;
                }
                ++n;
            }
            ((DbBit)this.Count[4]).value = bl;
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DbTimestamp Hour(DbChar dbChar) {
        Object object;
        if (dbChar.bNull) {
            this.Count[8].bNull = true;
            return (DbTimestamp)this.Count[8];
        }
        DateTimeParser dateTimeParser = new DateTimeParser();
        String string = dbChar.value.trim();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        String string3 = "";
        int n = 1;
        int n2 = 0;
        block2: while (n2 < datetimeFormats.length) {
            dateTimeParser.applyPattern(datetimeFormats[n2]);
            try {
                object = dateTimeParser.parse(string);
                if (object != null) {
                    while (true) {
                        if (bl2 || bl3 || n > string.length()) {
                            if (!bl2 || !bl3) break;
                            bl = true;
                            break block2;
                        }
                        string2 = string.substring(0, n).trim();
                        string3 = string.substring(n, string.length()).trim();
                        if (this.ForEachQuarter((DbChar)new DbChar((String)string2)).value && this.ForEachYear((DbChar)new DbChar((String)string3)).value) {
                            bl2 = true;
                            bl3 = true;
                        }
                        ++n;
                    }
                    bl = false;
                }
            }
            catch (ParseException parseException) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            object = this.IPmt(new DbChar(string2));
            DbTime dbTime = this.IRR(new DbChar(string3));
            ((DbTimestamp)this.Count[8]).value = this.ToDateTime((DbDate)object, (DbTime)dbTime).value;
            this.Count[8].bNull = false;
            return (DbTimestamp)this.Count[8];
        }
        this.Count[8].bNull = true;
        return (DbTimestamp)this.Count[8];
    }

    private DbDate IPmt(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[6].bNull = true;
        } else if (this.ForEachQuarter((DbChar)dbChar).value) {
            DateTimeParser dateTimeParser = new DateTimeParser();
            String string = dbChar.value.trim();
            int n = 0;
            while (n < dateFormats.length) {
                dateTimeParser.applyPattern(dateFormats[n]);
                try {
                    java.util.Date date = dateTimeParser.parse(string);
                    if (date != null) {
                        this.gc.clear();
                        this.gc.setTime(date);
                        if (this.ForEachQuarter((DbChar)dbChar).value) {
                            ((DbDate)this.Count[6]).value = this.gc.I();
                            this.Count[6].bNull = false;
                            break;
                        }
                    }
                }
                catch (ParseException parseException) {
                    this.Count[6].bNull = true;
                }
                ++n;
            }
        }
        return (DbDate)this.Count[6];
    }

    private DbTime IRR(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[7].bNull = true;
        } else if (this.ForEachYear((DbChar)dbChar).value) {
            DateTimeParser dateTimeParser = new DateTimeParser();
            String string = dbChar.value.trim();
            int n = 0;
            while (n < timeFormats.length) {
                dateTimeParser.applyPattern(timeFormats[n]);
                try {
                    java.util.Date date = dateTimeParser.parse(string);
                    if (date != null) {
                        if (dateTimeParser.getAMPM() == 1 && dateTimeParser.getHour() >= 12) {
                            int n2 = dateTimeParser.getHour();
                            int n3 = dateTimeParser.getMinute();
                            int n4 = dateTimeParser.getSecond();
                            this.gc.clear();
                            this.gc.set(11, n2);
                            this.gc.set(12, n3);
                            this.gc.set(13, n4);
                            ((DbTime)this.Count[7]).value = this.gc.I();
                            this.Count[7].bNull = false;
                            break;
                        }
                        this.gc.clear();
                        this.gc.setTime(date);
                        ((DbTime)this.Count[7]).value = this.gc.I();
                        this.Count[7].bNull = false;
                        break;
                    }
                }
                catch (ParseException parseException) {
                    this.Count[7].bNull = true;
                }
                ++n;
            }
        }
        return (DbTime)this.Count[7];
    }

    public DbDouble e() {
        DbDouble dbDouble = new DbDouble(Math.E);
        dbDouble.bNull = false;
        this.Count[2].bNull = false;
        ((DbDouble)this.Count[2]).value = Math.E;
        return dbDouble;
    }

    public DbDouble pi() {
        DbDouble dbDouble = new DbDouble(Math.PI);
        dbDouble.bNull = false;
        this.Count[2].bNull = false;
        ((DbDouble)this.Count[2]).value = Math.PI;
        return dbDouble;
    }

    public DbDouble random() {
        return this.random(new DbBigInt(123L));
    }

    public DbDouble random(DbBigInt dbBigInt) {
        return this.IsDate(dbBigInt.value);
    }

    public DbDouble random(DbDouble dbDouble) {
        return this.IsDate((long)dbDouble.value);
    }

    public DbDouble random(fCurrency fCurrency2) {
        return this.IsDate(fCurrency2.value.intValue());
    }

    private DbDouble IsDate(long l) {
        if (l == 0L) {
            return this.DateAdd;
        }
        if (l > 0L) {
            ((DbDouble)this.Count[2]).value = this.DDB.nextDouble();
            this.Count[2].bNull = false;
            this.DateAdd = (DbDouble)this.Count[2];
            return (DbDouble)this.Count[2];
        }
        this.DDB.setSeed(l);
        ((DbDouble)this.Count[2]).value = this.DDB.nextDouble();
        this.Count[2].bNull = false;
        this.DateAdd = (DbDouble)this.Count[2];
        return (DbDouble)this.Count[2];
    }

    public DbDouble pow(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbBigInt.bNull || dbBigInt2.bNull) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = Math.pow(dbBigInt.value, dbBigInt2.value);
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble pow(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = Math.pow(dbDouble.value, dbBigInt.value);
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble pow(DbBigInt dbBigInt, DbDouble dbDouble) {
        if (dbBigInt.bNull || dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = Math.pow(dbBigInt.value, dbDouble.value);
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble pow(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull) {
            this.Count[2].bNull = true;
        } else {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = Math.pow(dbDouble.value, dbDouble2.value);
        }
        return (DbDouble)this.Count[2];
    }

    public DbBigInt sgn(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[1].bNull = true;
        } else {
            int n = 0;
            if (dbBigInt.value > 0L) {
                n = 1;
            } else if (dbBigInt.value < 0L) {
                n = -1;
            }
            ((DbBigInt)this.Count[1]).value = n;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt sgn(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[1].bNull = true;
        } else {
            int n = 0;
            if (dbDouble.value > 0.0) {
                n = 1;
            } else if (dbDouble.value < 0.0) {
                n = -1;
            }
            ((DbBigInt)this.Count[1]).value = n;
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbDouble sin(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.sin(dbBigInt.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble sin(DbNumber dbNumber) {
        if (dbNumber.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.sin(dbNumber.doubleValue());
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble sin(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.sin(dbDouble.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble cos(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.cos(dbBigInt.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble cos(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.cos(dbDouble.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble tan(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.tan(dbBigInt.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble tan(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.tan(dbDouble.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble atan(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.atan(dbBigInt.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble atan(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.atan(dbDouble.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble sqr(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[2].bNull = true;
            return new DbDouble();
        }
        DbDouble dbDouble = new DbDouble();
        ((DbDouble)this.Count[2]).value = dbDouble.value = Math.sqrt(dbBigInt.value);
        dbDouble.bNull = false;
        return dbDouble;
    }

    public DbDouble sqr(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
            return new DbDouble();
        }
        DbDouble dbDouble2 = new DbDouble();
        ((DbDouble)this.Count[2]).value = dbDouble2.value = Math.sqrt(dbDouble.value);
        dbDouble2.bNull = false;
        return dbDouble2;
    }

    public DbDouble exp(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.exp(dbBigInt.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble exp(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.exp(dbDouble.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble log(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.log(dbBigInt.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble log(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
        } else {
            ((DbDouble)this.Count[2]).value = Math.log(dbDouble.value);
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbBigInt integDiv(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbBigInt.bNull || dbBigInt2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = (int)(dbBigInt.value / dbBigInt2.value);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt integDiv(DbBigInt dbBigInt, DbDouble dbDouble) {
        if (dbBigInt.bNull || dbDouble.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = (int)((double)dbBigInt.value / dbDouble.value);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt integDiv(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbBigInt.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = (int)(dbDouble.value / (double)dbBigInt.value);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbBigInt integDiv(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull) {
            this.Count[1].bNull = true;
        } else {
            ((DbBigInt)this.Count[1]).value = (int)(dbDouble.value / dbDouble2.value);
            this.Count[1].bNull = false;
        }
        return (DbBigInt)this.Count[1];
    }

    public DbChar strReverse(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            if (dbChar.value.length() < 2) {
                return dbChar;
            }
            String string = dbChar.value;
            char[] cArray = new char[string.length()];
            int n = string.length() - 1;
            while (n >= 0) {
                cArray[string.length() - n - 1] = string.charAt(n);
                --n;
            }
            String string2 = String.valueOf(cArray[0]);
            int n2 = 1;
            while (n2 < string.length()) {
                string2 = string2 + String.valueOf(cArray[n2]);
                ++n2;
            }
            ((DbChar)this.Count[5]).value = string2;
            this.Count[5].bNull = false;
        }
        return (DbChar)this.Count[5];
    }

    public fStrArray filter(fStrArray fStrArray2, DbChar dbChar) {
        DbChar[] dbCharArray = new DbChar[fStrArray2.value.length];
        int n = 0;
        while (n < fStrArray2.value.length) {
            dbCharArray[n] = new DbChar();
            dbCharArray[n] = (DbChar)fStrArray2.value[n];
            ++n;
        }
        if (dbChar == null || dbChar.bNull || dbChar.value == null || dbChar.value.length() == 0) {
            fStrArray fStrArray3 = new fStrArray(1);
            fStrArray3.value = new DbChar[0];
            fStrArray3.bNull = true;
            return fStrArray3;
        }
        return this.filter(fStrArray2, dbChar, new DbBit(true));
    }

    public fStrArray filter(fStrArray fStrArray2, DbChar dbChar, DbBit dbBit) {
        return this.filter(fStrArray2, dbChar, dbBit, new DbBigInt(0L));
    }

    public fStrArray filter(fStrArray fStrArray2, DbChar dbChar, DbBit dbBit, DbBigInt dbBigInt) {
        Object object;
        Object object2;
        int n = 0;
        int n2 = 0;
        DbChar[] dbCharArray = new DbChar[fStrArray2.value.length];
        int n3 = 0;
        while (n3 < fStrArray2.value.length) {
            dbCharArray[n3] = new DbChar();
            dbCharArray[n3] = (DbChar)fStrArray2.value[n3];
            ++n3;
        }
        if (dbChar.bNull || dbChar.value.length() == 0) {
            fStrArray fStrArray3 = new fStrArray(1);
            fStrArray3.bNull = true;
            return fStrArray3;
        }
        int n4 = 0;
        while (n4 < dbCharArray.length) {
            if (dbCharArray[n4] != null && !dbCharArray[n4].bNull) break;
            ++n4;
        }
        if (n4 >= dbCharArray.length) {
            fStrArray fStrArray4 = new fStrArray(1);
            fStrArray4.bNull = true;
            return fStrArray4;
        }
        ArrayList<DbChar> arrayList = new ArrayList<DbChar>();
        if (dbBigInt.value == 0L) {
            if (dbBit.value) {
                n = 0;
                while (n < dbCharArray.length) {
                    if (dbCharArray[n].value.length() >= dbChar.value.length()) {
                        n2 = 0;
                        while (n2 <= dbCharArray[n].value.length() - dbChar.value.length()) {
                            object2 = dbCharArray[n].value.substring(n2, n2 + dbChar.value.length());
                            if (dbChar.value.equals(object2)) {
                                arrayList.add(dbCharArray[n]);
                                break;
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < dbCharArray.length) {
                    if (dbChar.value.equals(dbCharArray[n].value)) {
                        arrayList.add(dbCharArray[n]);
                    }
                    ++n;
                }
            }
        } else if (dbBigInt.value == 1L) {
            object2 = dbCharArray[0].value;
            object = dbChar.value;
            if (dbBit.value) {
                n = 0;
                while (n < dbCharArray.length) {
                    object2 = dbCharArray[n].value;
                    n2 = 0;
                    while (n2 <= ((String)object2).length() - ((String)object).length()) {
                        if (((String)object).equalsIgnoreCase(((String)object2).substring(n2, n2 + ((String)object).length()))) {
                            arrayList.add(dbCharArray[n]);
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < dbCharArray.length) {
                    object2 = dbCharArray[n].value;
                    if (((String)object).equalsIgnoreCase((String)object2)) {
                        arrayList.add(dbCharArray[n]);
                    }
                    ++n;
                }
            }
        }
        object2 = new DbChar[arrayList.size()];
        n2 = 0;
        while (n2 < arrayList.size()) {
            object2[n2] = (DbChar)arrayList.get(n2);
            ++n2;
        }
        object = new fStrArray(((DbChar[])object2).length);
        ((fStrArray)object).value = object2;
        return object;
    }

    public DbChar replaceString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3, DbBigInt dbBigInt) {
        return this.replaceString(dbChar, dbChar2, dbChar3, dbBigInt, new DbBigInt(-1L), new DbBigInt(0L));
    }

    public DbChar replaceString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        return this.replaceString(dbChar, dbChar2, dbChar3, dbBigInt, dbBigInt2, new DbBigInt(0L));
    }

    public DbChar replaceString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbChar.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.Count[5].bNull = true;
            return (DbChar)this.Count[5];
        }
        int n = (int)dbBigInt.value;
        if (n > dbChar.value.length()) {
            n = dbChar.value.length();
        }
        if (n - 1 >= 0) {
            --n;
        }
        if (dbBigInt3.value == 0L) {
            String string = dbChar.value.substring(0, n);
            String string2 = dbChar.value.substring(n);
            String string3 = dbChar2.value;
            String string4 = dbChar3.value;
            int n2 = 0;
            int n3 = 0;
            int n4 = string3.length();
            int n5 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = string2.indexOf(string3, n3)) != -1 && ((long)n5 < dbBigInt2.value || dbBigInt2.value == -1L)) {
                stringBuffer = stringBuffer.append(string2.substring(n3, n2)).append(string4);
                n3 = n2 + n4;
                ++n5;
            }
            stringBuffer = stringBuffer.append(string2.substring(n3, string2.length()));
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = string + stringBuffer.toString();
            return (DbChar)this.Count[5];
        }
        if (dbBigInt3.value == 1L) {
            String string = dbChar.value.substring(0, n);
            String string5 = dbChar.value.substring(n);
            String string6 = dbChar3.value;
            String string7 = dbChar2.value.toLowerCase();
            String string8 = string5.toLowerCase();
            int n6 = 0;
            int n7 = 0;
            int n8 = string7.length();
            int n9 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n6 = string8.indexOf(string7, n7)) != -1 && ((long)n9 < dbBigInt2.value || dbBigInt2.value == -1L)) {
                stringBuffer = stringBuffer.append(string5.substring(n7, n6)).append(string6);
                n7 = n6 + n8;
                ++n9;
            }
            stringBuffer = stringBuffer.append(string5.substring(n7, string8.length()));
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = string + stringBuffer.toString();
            return (DbChar)this.Count[5];
        }
        return (DbChar)this.Count[5];
    }

    public DbChar join(fStrArray fStrArray2) {
        return this.join(fStrArray2, new DbChar(" "));
    }

    public DbChar join(fStrArray fStrArray2, DbChar dbChar) {
        DbChar[] dbCharArray = new DbChar[fStrArray2.value.length];
        int n = 0;
        while (n < fStrArray2.value.length) {
            dbCharArray[n] = (DbChar)fStrArray2.value[n];
            ++n;
        }
        if (fStrArray2 != null && dbCharArray.length > 0) {
            String string = dbCharArray[0].value;
            if (dbChar != null && dbChar.value != null && dbChar.value.length() > 0) {
                int n2 = 1;
                while (n2 < dbCharArray.length) {
                    string = string + dbChar.value + dbCharArray[n2].value;
                    ++n2;
                }
            } else {
                int n3 = 1;
                while (n3 < dbCharArray.length) {
                    string = string + dbCharArray[n3].value;
                    ++n3;
                }
            }
            ((DbChar)this.Count[5]).value = string;
            this.Count[5].bNull = false;
            return (DbChar)this.Count[5];
        }
        this.Count[5].bNull = true;
        return (DbChar)this.Count[5];
    }

    public fStrArray stringSplit(DbChar dbChar) {
        if (dbChar.bNull) {
            fStrArray fStrArray2 = new fStrArray(0);
            fStrArray2.bNull = true;
            return fStrArray2;
        }
        ArrayList<DbChar> arrayList = new ArrayList<DbChar>();
        String string = dbChar.value;
        while (string != null && string.length() > 0) {
            if (string.charAt(0) == ' ') {
                string = string.substring(1);
                continue;
            }
            DbChar dbChar2 = new DbChar();
            try {
                dbChar2.value = string.substring(0, string.indexOf(32));
                dbChar2.bNull = false;
                arrayList.add(dbChar2);
                string = string.substring(string.indexOf(32));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                dbChar2.value = string.substring(0, string.length());
                dbChar2.bNull = false;
                arrayList.add(dbChar2);
                break;
            }
        }
        DbChar[] dbCharArray = new DbChar[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            dbCharArray[n] = (DbChar)arrayList.get(n);
            ++n;
        }
        fStrArray fStrArray3 = new fStrArray(dbCharArray.length);
        fStrArray3.value = dbCharArray;
        return fStrArray3;
    }

    public fStrArray stringSplit(DbChar dbChar, DbChar dbChar2) {
        return this.stringSplit(dbChar, dbChar2, new DbBigInt(-1L));
    }

    public fStrArray stringSplit(DbChar dbChar, DbChar dbChar2, DbBigInt dbBigInt) {
        return this.stringSplit(dbChar, dbChar2, dbBigInt, new DbBigInt(0L));
    }

    public fStrArray stringSplit(DbChar dbChar, DbChar dbChar2, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbChar.bNull || dbBigInt.bNull || dbBigInt2.bNull) {
            this.Count[5].bNull = true;
            DbChar[] dbCharArray = new DbChar[]{dbChar};
            fStrArray fStrArray2 = new fStrArray(1);
            fStrArray2.bNull = true;
            fStrArray2.value = dbCharArray;
            return fStrArray2;
        }
        if (dbChar2.bNull || dbChar2.value == null || dbChar2.value.length() == 0) {
            DbChar[] dbCharArray = new DbChar[1];
            this.Count[5].bNull = false;
            dbCharArray[0] = dbChar;
            fStrArray fStrArray3 = new fStrArray(1);
            fStrArray3.bNull = false;
            fStrArray3.value = dbCharArray;
            return fStrArray3;
        }
        ArrayList<DbChar> arrayList = new ArrayList<DbChar>();
        String string = dbChar.value;
        String string2 = dbChar2.value;
        int n = 1;
        if (dbBigInt2.value != 1L) {
            while (string != null && string.length() > 0) {
                if (string.indexOf(string2) == 0) {
                    string = string.substring(string2.length());
                    continue;
                }
                DbChar dbChar3 = new DbChar();
                try {
                    if (dbBigInt.value == -1L || dbBigInt.value > (long)n) {
                        dbChar3.value = string.substring(0, string.indexOf(string2));
                        dbChar3.bNull = false;
                        arrayList.add(dbChar3);
                        string = string.substring(string.indexOf(string2));
                        ++n;
                        continue;
                    }
                    dbChar3.value = string.substring(0, string.length());
                    dbChar3.bNull = false;
                    arrayList.add(dbChar3);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    dbChar3.value = string.substring(0, string.length());
                    dbChar3.bNull = false;
                    arrayList.add(dbChar3);
                }
                break;
            }
            DbChar[] dbCharArray = new DbChar[arrayList.size()];
            int n2 = 0;
            while (n2 < arrayList.size()) {
                dbCharArray[n2] = (DbChar)arrayList.get(n2);
                ++n2;
            }
            fStrArray fStrArray4 = new fStrArray(dbCharArray.length);
            fStrArray4.value = dbCharArray;
            return fStrArray4;
        }
        if (dbBigInt2.value == 1L) {
            String string3 = string.toLowerCase();
            string2 = string2.toLowerCase();
            while (string != null && string.length() > 0) {
                if (string3.indexOf(string2) == 0) {
                    string = string.substring(string2.length());
                    string3 = string3.substring(string2.length());
                    continue;
                }
                DbChar dbChar4 = new DbChar();
                try {
                    if (dbBigInt.value == -1L || dbBigInt.value > (long)n) {
                        dbChar4.value = string.substring(0, string3.indexOf(string2));
                        dbChar4.bNull = false;
                        arrayList.add(dbChar4);
                        string = string.substring(string3.indexOf(string2));
                        string3 = string3.substring(string3.indexOf(string2));
                        ++n;
                        continue;
                    }
                    dbChar4.value = string.substring(0, string3.length());
                    dbChar4.bNull = false;
                    arrayList.add(dbChar4);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    dbChar4.value = string.substring(0, string3.length());
                    dbChar4.bNull = false;
                    arrayList.add(dbChar4);
                }
                break;
            }
            DbChar[] dbCharArray = new DbChar[arrayList.size()];
            int n3 = 0;
            while (n3 < arrayList.size()) {
                dbCharArray[n3] = (DbChar)arrayList.get(n3);
                ++n3;
            }
            fStrArray fStrArray5 = new fStrArray(dbCharArray.length);
            fStrArray5.value = dbCharArray;
            return fStrArray5;
        }
        fStrArray fStrArray6 = new fStrArray();
        fStrArray6.bNull = true;
        return fStrArray6;
    }

    public DbBit toBool(DbBigInt dbBigInt) {
        boolean bl;
        if (dbBigInt == null || dbBigInt.bNull) {
            this.Count[4].bNull = true;
            return (DbBit)this.Count[4];
        }
        ((DbBit)this.Count[4]).value = bl = (int)dbBigInt.value != 0;
        this.Count[4].bNull = false;
        return (DbBit)this.Count[4];
    }

    public DbBit toBool(DbDouble dbDouble) {
        boolean bl;
        if (dbDouble == null || dbDouble.bNull) {
            this.Count[4].bNull = true;
            return (DbBit)this.Count[4];
        }
        ((DbBit)this.Count[4]).value = bl = (int)dbDouble.value != 0;
        this.Count[4].bNull = false;
        return (DbBit)this.Count[4];
    }

    public DbBit toBool(fCurrency fCurrency2) {
        boolean bl;
        if (fCurrency2.bNull) {
            this.Count[4].bNull = true;
            return (DbBit)this.Count[4];
        }
        ((DbBit)this.Count[4]).value = bl = fCurrency2.value.intValue() != 0;
        this.Count[4].bNull = false;
        return (DbBit)this.Count[4];
    }

    public DbDouble toNumber(DbBit dbBit) {
        DbDouble dbDouble = new DbDouble();
        if (dbBit.bNull) {
            dbDouble.bNull = true;
            this.Count[2].bNull = true;
        } else {
            double d;
            ((DbDouble)this.Count[2]).value = d = dbBit.value ? 1.0 : 0.0;
            this.Count[2].bNull = false;
            dbDouble.value = d;
            dbDouble.bNull = false;
        }
        return dbDouble;
    }

    /*
     * Unable to fully structure code
     */
    public DbBit isNumeric(DbChar var1_1) {
        var2_2 = new DbBit();
        if (var1_1.bNull) {
            var2_2.bNull = true;
            this.Count[4].bNull = true;
        } else {
            var3_3 = var1_1.value.trim();
            var4_4 = true;
            if (var3_3 == null || var3_3.length() == 0) {
                var2_2.bNull = true;
                this.Count[4].bNull = true;
                return var2_2;
            }
            var3_3.trim();
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = -1;
            var8_8 = -1;
            try {
                Double.parseDouble(var1_1.value);
                var2_2.value = true;
                var2_2.bNull = false;
                ((DbBit)this.Count[4]).value = true;
                this.Count[4].bNull = false;
                return var2_2;
            }
            catch (Exception var9_9) {
                var2_2.value = false;
                var2_2.bNull = false;
                ((DbBit)this.Count[4]).value = true;
                this.Count[4].bNull = false;
                ** while (var5_5 < var3_3.length())
            }
lbl-1000:
            // 1 sources

            {
                if ((var3_3.charAt(var5_5) < '0' || var3_3.charAt(var5_5) > '9') && var3_3.charAt(var5_5) != ',' && var3_3.charAt(var5_5) != '.') break;
                if (var3_3.charAt(var5_5) == '.') {
                    var8_8 = var5_5;
                    ++var6_6;
                }
                if (var3_3.charAt(var5_5) == ',') {
                    if (var7_7 != -1 && var7_7 + 4 != var5_5) {
                        var4_4 = false;
                        break;
                    }
                    var7_7 = var5_5;
                }
                ++var5_5;
                continue;
            }
lbl43:
            // 3 sources

            if (var6_6 >= 2 || var8_8 != -1 && var7_7 != -1 && var8_8 != var7_7 + 4) {
                var4_4 = false;
            }
            if (var5_5 == var3_3.length() && var4_4) {
                var2_2.value = true;
                var2_2.bNull = false;
                ((DbBit)this.Count[4]).value = true;
                this.Count[4].bNull = false;
            } else {
                var2_2.value = false;
                var2_2.bNull = false;
                ((DbBit)this.Count[4]).value = false;
                this.Count[4].bNull = false;
            }
        }
        return var2_2;
    }

    public DbDouble FV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.FV(dbDouble, dbDouble2, dbDouble3, new DbDouble(0.0));
    }

    public DbDouble FV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2) {
        return this.FV(dbDouble, dbBigInt, dbDouble2, new DbDouble(0.0));
    }

    public DbDouble FV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.FV(dbDouble, dbBigInt, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble FV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.FV(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble FV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.FV(dbDouble, dbDouble4, dbDouble2, dbDouble3, dbBigInt2);
    }

    public DbDouble FV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        DbDouble dbDouble5 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull) {
            ((DbDouble)this.Count[2]).bNull = true;
            dbDouble5.bNull = true;
        } else {
            double d = dbBigInt.value != 1L ? (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) / dbDouble.value : (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) * (1.0 + dbDouble.value) / dbDouble.value;
            d *= -dbDouble3.value;
            long l = (long)(((d += Math.pow(1.0 + dbDouble.value, dbDouble2.value) * -dbDouble4.value) + 0.005) * 100.0);
            ((DbDouble)this.Count[2]).value = (double)l / 100.0;
            ((DbDouble)this.Count[2]).bNull = true;
            dbDouble5.value = (double)l / 100.0;
            dbDouble5.bNull = false;
        }
        return dbDouble5;
    }

    public DbDouble IPmt(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbDouble dbDouble3) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.IPmt(dbDouble, dbDouble2, dbDouble4, dbDouble3);
    }

    public DbDouble IPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.IPmt(dbDouble, dbDouble4, dbDouble2, dbDouble3);
    }

    public DbDouble IPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2) {
        DbDouble dbDouble3 = new DbDouble();
        dbDouble3.bNull = dbBigInt.bNull;
        dbDouble3.value = dbBigInt.value;
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt2.bNull;
        dbDouble4.value = dbBigInt2.value;
        return this.IPmt(dbDouble, dbDouble3, dbDouble4, dbDouble2);
    }

    public DbDouble IPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        DbDouble dbDouble5 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull) {
            ((DbDouble)this.Count[2]).bNull = true;
            dbDouble5.bNull = true;
        } else {
            double d = dbDouble4.value;
            double d2 = dbDouble4.value * dbDouble.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            int n = 1;
            while ((double)n < dbDouble2.value) {
                d = d * (1.0 + dbDouble.value) - d2;
                ++n;
            }
            long l = (long)((d * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.Count[2]).value = (double)(-l) / 100.0;
            ((DbDouble)this.Count[2]).bNull = false;
            dbDouble5.value = (double)(-l) / 100.0;
            dbDouble5.bNull = false;
        }
        return dbDouble5;
    }

    public DbDouble IPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.IPmt(dbDouble, dbBigInt, dbBigInt2, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble IPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5) {
        return this.IPmt(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbDouble5, new DbBigInt(0L));
    }

    public DbDouble IPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt3) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        DbDouble dbDouble5 = new DbDouble();
        dbDouble5.bNull = dbBigInt2.bNull;
        dbDouble5.value = dbBigInt2.value;
        return this.IPmt(dbDouble, dbDouble4, dbDouble5, dbDouble2, dbDouble3, dbBigInt3);
    }

    public DbDouble IPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5, DbBigInt dbBigInt) {
        DbDouble dbDouble6 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbDouble5.bNull || dbBigInt.bNull) {
            this.Count[2].bNull = true;
            dbDouble6.bNull = true;
        } else if (dbBigInt.value != 1L) {
            double d = (dbDouble4.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) + dbDouble5.value) * dbDouble.value / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            double d2 = dbDouble4.value;
            int n = 1;
            while ((double)n < dbDouble2.value) {
                d2 = d2 * (1.0 + dbDouble.value) - d;
                ++n;
            }
            long l = (long)((d2 * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.Count[2]).value = (double)(-l) / 100.0;
            this.Count[2].bNull = false;
            dbDouble6.value = (double)(-l) / 100.0;
            dbDouble6.bNull = false;
        } else {
            double d = (dbDouble4.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) + dbDouble5.value) * dbDouble.value / (1.0 + dbDouble.value) / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            double d3 = dbDouble4.value;
            int n = 0;
            while ((double)n < dbDouble2.value - 2.0) {
                d3 = (d3 - d) * (1.0 + dbDouble.value);
                ++n;
            }
            long l = (long)(((d3 -= d) * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.Count[2]).value = (double)(-l) / 100.0;
            this.Count[2].bNull = false;
            dbDouble6.value = (double)(-l) / 100.0;
            dbDouble6.bNull = false;
        }
        return dbDouble6;
    }

    public DbDouble Pmt(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2) {
        DbDouble dbDouble3 = new DbDouble();
        dbDouble3.bNull = dbBigInt.bNull;
        dbDouble3.value = dbBigInt.value;
        return this.Pmt(dbDouble, dbDouble3, dbDouble2);
    }

    public DbDouble Pmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        DbDouble dbDouble4 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull) {
            dbDouble4.bNull = true;
            this.Count[2].bNull = true;
        } else {
            double d = dbDouble3.value * dbDouble.value * Math.pow(1.0 + dbDouble.value, dbDouble2.value) / (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0);
            long l = (long)((d + 0.005) * 100.0);
            ((DbDouble)this.Count[2]).value = (double)(-l) / 100.0;
            ((DbDouble)this.Count[2]).bNull = false;
            dbDouble4.value = (double)(-l) / 100.0;
            dbDouble4.bNull = false;
        }
        return dbDouble4;
    }

    public DbDouble Pmt(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.Pmt(dbDouble, dbBigInt, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble Pmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.Pmt(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble Pmt(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.Pmt(dbDouble, dbDouble4, dbDouble2, dbDouble3, dbBigInt2);
    }

    public DbDouble Pmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        DbDouble dbDouble5 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull) {
            dbDouble5.bNull = true;
            this.Count[2].bNull = true;
        } else {
            double d = dbBigInt.value != 1L ? (dbDouble3.value * Math.pow(1.0 + dbDouble.value, dbDouble2.value) + dbDouble4.value) * dbDouble.value / (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) : (dbDouble3.value * Math.pow(1.0 + dbDouble.value, dbDouble2.value) + dbDouble4.value) * dbDouble.value / (1.0 + dbDouble.value) / (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0);
            long l = (long)((d + 0.005) * 100.0);
            ((DbDouble)this.Count[2]).value = (double)(-l) / 100.0;
            this.Count[2].bNull = false;
            dbDouble5.value = (double)(-l) / 100.0;
            dbDouble5.bNull = false;
        }
        return dbDouble5;
    }

    public DbDouble PPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.PPmt(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbDouble(0.0));
    }

    public DbDouble PPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2) {
        return this.PPmt(dbDouble, dbBigInt, dbBigInt2, dbDouble2, new DbDouble(0.0));
    }

    public DbDouble PPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5) {
        return this.PPmt(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbDouble5, new DbBigInt(0L));
    }

    public DbDouble PPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.PPmt(dbDouble, dbBigInt, dbBigInt2, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble PPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt3) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        DbDouble dbDouble5 = new DbDouble();
        dbDouble5.bNull = dbBigInt2.bNull;
        dbDouble5.value = dbBigInt2.value;
        return this.PPmt(dbDouble, dbDouble4, dbDouble5, dbDouble2, dbDouble3, dbBigInt3);
    }

    public DbDouble PPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbDouble3.bNull || dbDouble3.bNull || dbDouble4.bNull || dbDouble5.bNull || dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else if (dbBigInt.value != 1L) {
            double d = (dbDouble4.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) + dbDouble5.value) * dbDouble.value / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            double d2 = dbDouble4.value;
            int n = 1;
            while ((double)n < dbDouble2.value) {
                d2 = d2 * (1.0 + dbDouble.value) - d;
                ++n;
            }
            long l = (long)((d - d2 * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.Count[2]).value = (double)(-l) / 100.0;
            this.Count[2].bNull = false;
        } else {
            double d = (dbDouble4.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) + dbDouble5.value) * dbDouble.value / (1.0 + dbDouble.value) / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            double d3 = dbDouble4.value;
            int n = 0;
            while ((double)n < dbDouble2.value - 2.0) {
                d3 = (d3 - d) * (1.0 + dbDouble.value);
                ++n;
            }
            long l = (long)((d - (d3 -= d) * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.Count[2]).value = (double)(-l) / 100.0;
            this.Count[2].bNull = false;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble PV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2) {
        return this.PV(dbDouble, dbBigInt, dbDouble2, new DbDouble(0.0));
    }

    public DbDouble PV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.PV(dbDouble, dbDouble2, dbDouble3, new DbDouble(0.0));
    }

    public DbDouble PV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.PV(dbDouble, dbBigInt, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble PV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.PV(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble PV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.PV(dbDouble, dbDouble4, dbDouble2, dbDouble3, dbBigInt2);
    }

    public DbDouble PV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull) {
            this.Count[2].bNull = true;
        } else {
            double d = dbBigInt.value != 1L ? -(((Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) * dbDouble3.value / dbDouble.value + dbDouble4.value) / Math.pow(1.0 + dbDouble.value, dbDouble2.value)) : -(((Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) * dbDouble3.value / dbDouble.value + dbDouble4.value / (1.0 + dbDouble.value)) / Math.pow(1.0 + dbDouble.value, dbDouble2.value - 1.0));
            long l = (long)((d + 0.005) * 100.0);
            d = (double)l / 100.0;
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = d;
        }
        return (DbDouble)this.Count[2];
    }

    public DbDouble NPV(DbDouble dbDouble, fNumArray fNumArray2) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double[] dArray = new double[fNumArray2.value.length];
        int n = 0;
        while (n < fNumArray2.value.length) {
            if (((DbDouble)fNumArray2.value[n]).bNull) {
                this.Count[2].bNull = true;
                return (DbDouble)this.Count[2];
            }
            dArray[n] = ((DbDouble)fNumArray2.value[n]).value;
            ++n;
        }
        return this.IsDateTime(dbDouble, dArray);
    }

    public DbDouble NPV(DbDouble dbDouble, fIntArray fIntArray2) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double[] dArray = new double[fIntArray2.value.length];
        int n = 0;
        while (n < fIntArray2.value.length) {
            if (((DbBigInt)fIntArray2.value[n]).bNull) {
                this.Count[2].bNull = true;
                return (DbDouble)this.Count[2];
            }
            dArray[n] = ((DbBigInt)fIntArray2.value[n]).value;
            ++n;
        }
        return this.IsDateTime(dbDouble, dArray);
    }

    private DbDouble IsDateTime(DbDouble dbDouble, double[] dArray) {
        if (dbDouble.bNull || dArray.length == 0) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n] * Math.pow(1.0 + dbDouble.value, dArray.length - n - 1);
            ++n;
        }
        long l = (long)(((d /= Math.pow(1.0 + dbDouble.value, dArray.length)) + 0.005) * 100.0);
        ((DbDouble)this.Count[2]).value = d = (double)l / 100.0;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble NPer(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        return this.NPer(dbDouble, dbBigInt, dbBigInt2, new DbBigInt(0L));
    }

    public DbDouble NPer(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        return this.NPer(dbDouble, dbBigInt, dbBigInt2, dbBigInt3, new DbBigInt(0L));
    }

    public DbDouble NPer(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3, DbBigInt dbBigInt4) {
        DbDouble dbDouble2 = new DbDouble();
        dbDouble2.bNull = dbBigInt.bNull;
        dbDouble2.value = dbBigInt.value;
        DbDouble dbDouble3 = new DbDouble();
        dbDouble3.bNull = dbBigInt2.bNull;
        dbDouble3.value = dbBigInt2.value;
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt3.bNull;
        dbDouble4.value = dbBigInt3.value;
        return this.NPer(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbBigInt4);
    }

    public DbDouble NPer(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.NPer(dbDouble, dbDouble2, dbDouble3, new DbDouble(0.0), new DbBigInt(0L));
    }

    public DbDouble NPer(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.NPer(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble NPer(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        if (dbDouble2.value == 0.0 && dbDouble3.value == 0.0 && dbDouble4.value == 0.0) {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = 0.0;
            return (DbDouble)this.Count[2];
        }
        if (dbDouble2.value == 0.0 && dbDouble3.value * dbDouble4.value != 0.0) {
            if (dbDouble3.value * dbDouble4.value > 0.0) {
                this.Count[2].bNull = true;
            } else {
                this.Count[2].bNull = false;
                ((DbDouble)this.Count[2]).value = this.IsTime(dbDouble.value, dbDouble3.value, dbDouble4.value);
            }
            return (DbDouble)this.Count[2];
        }
        if (dbDouble2.value * (dbDouble3.value + dbDouble4.value) > 0.0) {
            this.Count[2].bNull = false;
            ((DbDouble)this.Count[2]).value = -this.LOCAL_LANGUAGE(dbDouble.value, dbDouble2.value, dbDouble3.value, dbDouble4.value, dbBigInt.value);
            return (DbDouble)this.Count[2];
        }
        double d = 0.0;
        double d2 = 300.0;
        double d3 = 0.0;
        double d4 = 150.0;
        double d5 = Math.pow(1.0 + dbDouble.value, d4);
        int n = 0;
        if (dbBigInt.value != 1L) {
            d = (1.0 - dbDouble4.value * dbDouble.value / dbDouble2.value) / (1.0 + dbDouble3.value * dbDouble.value / dbDouble2.value);
            if (d > 0.0) {
                while (Math.pow(1.0 + dbDouble.value, d2) < d) {
                    d4 = ((d2 *= 2.0) + d3) / 2.0;
                    d5 = Math.pow(1.0 + dbDouble.value, d4);
                }
                while (Math.pow(1.0 + dbDouble.value, d4) - d > 1.0E-5 * d || Math.pow(1.0 + dbDouble.value, d4) - d < -1.0E-5 * d) {
                    d5 = Math.pow(1.0 + dbDouble.value, d4);
                    if (d5 > d) {
                        d2 = d4;
                        d4 = (d2 + d3) / 2.0;
                        continue;
                    }
                    if (d5 < d) {
                        d3 = d4;
                        d4 = (d2 + d3) / 2.0;
                        continue;
                    }
                    if (n++ > 1000 || d3 > d2) break;
                }
                ((DbDouble)this.Count[2]).value = d4;
                this.Count[2].bNull = false;
            } else {
                ((DbDouble)this.Count[2]).value = 1.0E308;
                this.Count[2].bNull = false;
            }
        } else {
            d = (1.0 + dbDouble.value - dbDouble4.value * dbDouble.value / dbDouble2.value) / (1.0 + dbDouble.value + dbDouble3.value * dbDouble.value / dbDouble2.value);
            if (d > 0.0) {
                while (Math.pow(1.0 + dbDouble.value, d2) < d) {
                    d4 = ((d2 *= 2.0) + d3) / 2.0;
                    d5 = Math.pow(1.0 + dbDouble.value, d4);
                }
                while (Math.pow(1.0 + dbDouble.value, d4) - d > 1.0E-5 * d || Math.pow(1.0 + dbDouble.value, d4) - d < -1.0E-5 * d) {
                    d5 = Math.pow(1.0 + dbDouble.value, d4);
                    if (d5 > d) {
                        d2 = d4;
                        d4 = (d2 + d3) / 2.0;
                        continue;
                    }
                    if (d5 < d) {
                        d3 = d4;
                        d4 = (d2 + d3) / 2.0;
                        continue;
                    }
                    if (n++ > 1000 || d3 > d2) break;
                }
                if (n >= 1000) {
                    ((DbDouble)this.Count[2]).value = -this.LOCAL_LANGUAGE(dbDouble.value, dbDouble2.value, dbDouble3.value, dbDouble4.value, dbBigInt.value);
                }
                ((DbDouble)this.Count[2]).value = d4;
                this.Count[2].bNull = false;
            } else {
                ((DbDouble)this.Count[2]).value = 1.0E308;
                this.Count[2].bNull = false;
            }
        }
        return (DbDouble)this.Count[2];
    }

    private double IsTime(double d, double d2, double d3) {
        double d4 = -d3 / d2;
        if (d4 < 0.0) {
            return -1.0;
        }
        return Math.log(d4) / Math.log(1.0 + d);
    }

    private double LOCAL_LANGUAGE(double d, double d2, double d3, double d4, long l) {
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 300.0;
        double d8 = 150.0;
        double d9 = Math.pow(1.0 + d, d8);
        int n = 0;
        d2 *= -1.0;
        if (l != 1L) {
            d5 = (d9 - 1.0) * d2 / d + d3 + d9 * d4;
            while (d5 > 0.1 || d5 < -0.1) {
                if (n++ > 300) break;
                if (d5 > 0.0) {
                    d6 = d8;
                    d8 = (d6 + d7) / 2.0;
                } else if (d5 < 0.0) {
                    d7 = d8;
                    d8 = (d6 + d7) / 2.0;
                } else if (d7 > d6) break;
                d9 = Math.pow(1.0 + d, d8);
                d5 = (d9 - 1.0) * d2 / d + d3 + d9 * d4;
            }
            long l2 = (long)((d8 + 0.005) * 100.0);
            d8 = (double)l2 / 100.0;
        } else if (l == 1L) {
            d5 = (d9 - 1.0) * d2 / d * (1.0 + d) + d3 + d9 * d4;
            while (d5 > 0.1 || d5 < -0.1) {
                if (n++ > 300) break;
                if (d5 > 0.0) {
                    d6 = d8;
                    d8 = (d6 + d7) / 2.0;
                } else if (d5 < 0.0) {
                    d7 = d8;
                    d8 = (d6 + d7) / 2.0;
                } else if (d7 > d6) break;
                d9 = Math.pow(1.0 + d, d8);
                d5 = (d9 - 1.0) * d2 / d * (1.0 + d) + d3 + d9 * d4;
            }
            long l3 = (long)((d8 + 0.005) * 100.0);
            d8 = (double)l3 / 100.0;
        }
        return d8;
    }

    public DbDouble Rate(DbBigInt dbBigInt, DbDouble dbDouble, DbDouble dbDouble2) {
        return this.Rate(dbBigInt, dbDouble, dbDouble2, new DbDouble(0.0));
    }

    public DbDouble Rate(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.Rate(dbDouble, dbDouble2, dbDouble3, new DbDouble(0.0));
    }

    public DbDouble Rate(DbBigInt dbBigInt, DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.Rate(dbBigInt, dbDouble, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble Rate(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.Rate(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble Rate(DbBigInt dbBigInt, DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2) {
        return this.Rate(dbBigInt, dbDouble, dbDouble2, dbDouble3, dbBigInt2, new DbDouble(0.1));
    }

    public DbDouble Rate(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        return this.Rate(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbBigInt, new DbDouble(0.1));
    }

    public DbDouble Rate(DbBigInt dbBigInt, DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2, DbDouble dbDouble4) {
        DbDouble dbDouble5 = new DbDouble();
        dbDouble5.bNull = dbBigInt.bNull;
        dbDouble5.value = dbBigInt.value;
        return this.Rate(dbDouble5, dbDouble, dbDouble2, dbDouble3, dbBigInt2, dbDouble4);
    }

    public DbDouble Rate(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt, DbDouble dbDouble5) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull || dbDouble5.bNull) {
            this.Count[2].bNull = true;
        } else {
            DbDouble dbDouble6 = new DbDouble();
            dbDouble6 = dbBigInt.value != 1L ? this.MRound(dbDouble.value, dbDouble3.value, dbDouble2.value, dbDouble4.value, dbDouble5.value) : this.Minute(dbDouble.value, dbDouble3.value, dbDouble2.value, dbDouble4.value, dbDouble5.value);
            ((DbDouble)this.Count[2]).value = dbDouble6.value;
            ((DbDouble)this.Count[2]).bNull = dbDouble6.bNull;
        }
        return (DbDouble)this.Count[2];
    }

    /*
     * Unable to fully structure code
     */
    private DbDouble MRound(double var1_1, double var3_3, double var5_4, double var7_5, double var9_2) {
        block20: {
            block21: {
                var11_6 = var9_2;
                var13_7 = var9_2 * 2.0;
                var15_8 = -2.01;
                var17_9 = -2.0;
                var19_10 = 0.0;
                var21_11 = 0;
                var22_12 = new DbDouble();
                if (var5_4 == 0.0 && (var3_3 != 0.0 || var7_5 != 0.0)) {
                    var22_12.bNull = true;
                    return var22_12;
                }
                if (var5_4 * var1_1 + (var3_3 + var7_5) != 0.0) ** GOTO lbl19
                var22_12.value = 0.0;
                var22_12.bNull = false;
                return var22_12;
lbl-1000:
                // 1 sources

                {
                    if (((var3_3 + var5_4 / var15_8) * Math.pow(1.0 + var15_8, var1_1) + var7_5 - var5_4 / var15_8) * ((var3_3 + var5_4 / var17_9) * Math.pow(1.0 + var17_9, var1_1) + var7_5 - var5_4 / var17_9) < 0.0) {
                        var19_10 = var15_8;
                    }
                    var15_8 += 0.005;
                    var17_9 += 0.005;
lbl19:
                    // 2 sources

                    ** while (var15_8 >= -2.01 && var15_8 <= 1.0)
                }
lbl20:
                // 1 sources

                var15_8 = var19_10;
                var13_7 = var19_10 + 0.01;
                var11_6 = (var15_8 + var13_7) / 2.0;
                if (!(var15_8 > -2.01) || !(var15_8 < -1.0)) break block21;
                while (var7_5 < var5_4 * 0.999999 / var11_6 || var7_5 > var5_4 * 1.000001 / var11_6) {
                    ++var21_11;
                    if (var7_5 > var5_4 / var11_6) {
                        var15_8 = var11_6;
                        if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                            var11_6 += 1.0E-5;
                        }
                    } else {
                        var13_7 = var11_6;
                        if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                            var11_6 -= 1.0E-5;
                        }
                    }
                    if (var21_11 != 1000) {
                        continue;
                    }
                    break block20;
                }
                break block20;
            }
            if (!(var15_8 < 0.0) || !(var15_8 >= -1.0)) ** GOTO lbl64
            while ((var3_3 + var5_4 / var11_6) * Math.pow(1.0 + var11_6, var1_1) + var7_5 < var5_4 * 0.999999 / var11_6 || (var3_3 + var5_4 / var11_6) * Math.pow(1.0 + var11_6, var1_1) + var7_5 > var5_4 * 1.000001 / var11_6) {
                ++var21_11;
                if ((var5_4 / var11_6 + var3_3) * Math.pow(1.0 + var11_6, var1_1) < var5_4 / var11_6 - var7_5) {
                    var15_8 = var11_6;
                    if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                        var11_6 += 1.0E-5;
                    }
                } else {
                    var13_7 = var11_6;
                    if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                        var11_6 -= 1.0E-5;
                    }
                }
                if (var21_11 != 1000) {
                    continue;
                }
                break block20;
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                ++var21_11;
                if ((var5_4 / var11_6 + var3_3) * Math.pow(1.0 + var11_6, var1_1) < var5_4 / var11_6 - var7_5) {
                    var15_8 = var11_6;
                    if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                        var11_6 += 1.0E-5;
                    }
                } else {
                    var13_7 = var11_6;
                    if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                        var11_6 -= 1.0E-5;
                    }
                }
                if (var21_11 == 1000) break;
lbl64:
                // 2 sources

                ** while ((var3_3 + var5_4 / var11_6) * Math.pow((double)(1.0 + var11_6), (double)var1_1) + var7_5 > var5_4 * 0.999999 / var11_6 || (var3_3 + var5_4 / var11_6) * Math.pow((double)(1.0 + var11_6), (double)var1_1) + var7_5 < var5_4 * 1.000001 / var11_6)
            }
        }
        var22_12.value = var11_6;
        var22_12.bNull = false;
        return var22_12;
    }

    /*
     * Unable to fully structure code
     */
    private DbDouble Minute(double var1_1, double var3_3, double var5_4, double var7_5, double var9_2) {
        block20: {
            block21: {
                var11_6 = var9_2;
                var13_7 = var9_2 * 2.0;
                var15_8 = -2.01;
                var17_9 = -2.0;
                var19_10 = 0.0;
                var21_11 = 0;
                var22_12 = new DbDouble();
                if (var5_4 == 0.0 && (var3_3 != 0.0 || var7_5 != 0.0)) {
                    var22_12.bNull = true;
                    return var22_12;
                }
                if (var5_4 * var1_1 + (var3_3 + var7_5) != 0.0) ** GOTO lbl19
                var22_12.value = 0.0;
                var22_12.bNull = false;
                return var22_12;
lbl-1000:
                // 1 sources

                {
                    if (((var3_3 + var5_4 * (1.0 + var15_8) / var15_8) * Math.pow(1.0 + var15_8, var1_1) + var7_5 - var5_4 * (1.0 + var15_8) / var15_8) * ((var3_3 + var5_4 * (1.0 + var17_9) / var17_9) * Math.pow(1.0 + var17_9, var1_1) + var7_5 - var5_4 * (1.0 + var17_9) / var17_9) < 0.0) {
                        var19_10 = var15_8;
                    }
                    var15_8 += 0.005;
                    var17_9 += 0.005;
lbl19:
                    // 2 sources

                    ** while (var15_8 >= -2.01 && var15_8 <= 1.0)
                }
lbl20:
                // 1 sources

                var15_8 = var19_10;
                var13_7 = var19_10 + 0.01;
                var11_6 = (var15_8 + var13_7) / 2.0;
                if (!(var15_8 > -2.01) || !(var15_8 < -1.0)) break block21;
                while (var7_5 < var5_4 * (1.0 + var11_6) * 0.999999 / var11_6 || var7_5 > var5_4 * (1.0 + var11_6) * 1.000001 / var11_6) {
                    ++var21_11;
                    if (var7_5 > var5_4 / var11_6) {
                        var15_8 = var11_6;
                        if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                            var11_6 += 1.0E-5;
                        }
                    } else {
                        var13_7 = var11_6;
                        if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                            var11_6 -= 1.0E-5;
                        }
                    }
                    if (var21_11 != 1000) {
                        continue;
                    }
                    break block20;
                }
                break block20;
            }
            if (!(var15_8 < 0.0) || !(var15_8 >= -1.0)) ** GOTO lbl64
            while ((var3_3 + var5_4 * (1.0 + var11_6) / var11_6) * Math.pow(1.0 + var11_6, var1_1) + var7_5 < var5_4 * (1.0 + var11_6) * 0.999999 / var11_6 || (var3_3 + var5_4 * (1.0 + var11_6) / var11_6) * Math.pow(1.0 + var11_6, var1_1) + var7_5 > var5_4 * (1.0 + var11_6) * 1.000001 / var11_6) {
                ++var21_11;
                if ((var5_4 / var11_6 + var3_3) * Math.pow(1.0 + var11_6, var1_1) < var5_4 / var11_6 - var7_5) {
                    var15_8 = var11_6;
                    if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                        var11_6 += 1.0E-5;
                    }
                } else {
                    var13_7 = var11_6;
                    if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                        var11_6 -= 1.0E-5;
                    }
                }
                if (var21_11 != 1000) {
                    continue;
                }
                break block20;
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                ++var21_11;
                if ((var5_4 * (1.0 + var11_6) / var11_6 + var3_3) * Math.pow(1.0 + var11_6, var1_1) < var5_4 * (1.0 + var11_6) / var11_6 - var7_5) {
                    var15_8 = var11_6;
                    if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                        var11_6 += 1.0E-5;
                    }
                } else {
                    var13_7 = var11_6;
                    if ((var11_6 = (var15_8 + var13_7) / 2.0) == 0.0) {
                        var11_6 -= 1.0E-5;
                    }
                }
                if (var21_11 == 1000) break;
lbl64:
                // 2 sources

                ** while ((var3_3 + var5_4 * (1.0 + var11_6) / var11_6) * Math.pow((double)(1.0 + var11_6), (double)var1_1) + var7_5 > var5_4 * (1.0 + var11_6) * 0.999999 / var11_6 || (var3_3 + var5_4 * (1.0 + var11_6) / var11_6) * Math.pow((double)(1.0 + var11_6), (double)var1_1) + var7_5 < var5_4 * (1.0 + var11_6) * 1.000001 / var11_6)
            }
        }
        var22_12.value = var11_6;
        var22_12.bNull = false;
        return var22_12;
    }

    public DbDouble IRR(fIntArray fIntArray2) {
        return this.IRR(fIntArray2, new DbDouble(0.1));
    }

    public DbDouble IRR(fNumArray fNumArray2) {
        return this.IRR(fNumArray2, new DbDouble(0.1));
    }

    public DbDouble IRR(fNumArray fNumArray2, DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        DbDouble[] dbDoubleArray = new DbDouble[fNumArray2.value.length];
        int n = 0;
        while (n < fNumArray2.value.length) {
            dbDoubleArray[n] = (DbDouble)fNumArray2.value[n];
            ++n;
        }
        return this.Month(dbDoubleArray, dbDouble);
    }

    public DbDouble IRR(fIntArray fIntArray2, DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        DbDouble[] dbDoubleArray = new DbDouble[fIntArray2.value.length];
        int n = 0;
        while (n < fIntArray2.value.length) {
            dbDoubleArray[n] = new DbDouble();
            dbDoubleArray[n].bNull = ((DbBigInt)fIntArray2.value[n]).bNull;
            dbDoubleArray[n].value = ((DbBigInt)fIntArray2.value[n]).value;
            ++n;
        }
        return this.Month(dbDoubleArray, dbDouble);
    }

    /*
     * Unable to fully structure code
     */
    private DbDouble Month(DbDouble[] var1_1, DbDouble var2_2) {
        var3_3 = 0;
        while (var3_3 < var1_1.length) {
            if (var1_1[var3_3].bNull) {
                this.Count[2].bNull = true;
                return (DbDouble)this.Count[2];
            }
            ++var3_3;
        }
        var4_4 = 1;
        while (var4_4 < var1_1.length) {
            if (var1_1[0].value * var1_1[var4_4].value < 0.0) break;
            ++var4_4;
        }
        if (var4_4 == var1_1.length) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        var5_5 = var2_2.value;
        var7_6 = 2.0 * var2_2.value;
        var9_7 = 0.0;
        var11_8 = 0.0;
        var13_9 = 0;
        while (var13_9 < var1_1.length) {
            var11_8 += var1_1[var13_9].value * Math.pow(1.0 + var7_6, var1_1.length - var13_9 - 1);
            ++var13_9;
        }
        if (var11_8 != 0.0) ** GOTO lbl38
        ((DbDouble)this.Count[2]).value = 0.0;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
        while (var1_1[0].value > 0.0) {
            var9_7 = var5_5;
            var5_5 = ((var7_6 *= 2.0) + var9_7) / 2.0;
            var11_8 = 0.0;
            var14_10 = 0;
            while (var14_10 < var1_1.length) {
                var11_8 += var1_1[var14_10].value * Math.pow(1.0 + var7_6, var1_1.length - var14_10 - 1);
                ++var14_10;
            }
lbl38:
            // 2 sources

            if (var11_8 < 0.0) continue;
        }
        while (var11_8 > 0.0) {
            if (!(var1_1[0].value < 0.0)) break;
            var9_7 = var5_5;
            var5_5 = ((var7_6 *= 2.0) + var9_7) / 2.0;
            var11_8 = 0.0;
            var14_10 = 0;
            while (var14_10 < var1_1.length) {
                var11_8 += var1_1[var14_10].value * Math.pow(1.0 + var7_6, var1_1.length - var14_10 - 1);
                ++var14_10;
            }
        }
        var11_8 = 0.0;
        var14_10 = 0;
        while (var14_10 < var1_1.length) {
            var11_8 += var1_1[var14_10].value * Math.pow(1.0 + var9_7, var1_1.length - var14_10 - 1);
            ++var14_10;
        }
        while (var11_8 < 0.0 && var1_1[0].value < 0.0 || var11_8 > 0.0 && var1_1[0].value > 0.0) {
            if (var9_7 == 0.0) {
                var9_7 = -var2_2.value;
                var7_6 = 0.0;
            } else {
                var9_7 *= 2.0;
                var7_6 = var5_5;
            }
            var5_5 = (var7_6 + var9_7) / 2.0;
            var11_8 = 0.0;
            var15_11 = 0;
            while (var15_11 < var1_1.length) {
                var11_8 += var1_1[var15_11].value * Math.pow(1.0 + var9_7, var1_1.length - var15_11 - 1);
                ++var15_11;
            }
        }
        var11_8 = 0.0;
        var15_11 = 0;
        while (var15_11 < var1_1.length) {
            var11_8 += var1_1[var15_11].value * Math.pow(1.0 + var5_5, var1_1.length - var15_11 - 1);
            ++var15_11;
        }
        var16_12 = 0;
        var17_13 = Math.abs(var11_8 * 1.0E-5);
        while (var11_8 > var17_13 || var11_8 < -var17_13) {
            if (var11_8 < 0.0) {
                if (var1_1[0].value > 0.0) {
                    var9_7 = var5_5;
                    var5_5 = (var7_6 + var9_7) / 2.0;
                } else if (var1_1[0].value < 0.0) {
                    var7_6 = var5_5;
                    var5_5 = (var7_6 + var9_7) / 2.0;
                }
            } else if (var11_8 > 0.0) {
                if (var1_1[0].value < 0.0) {
                    var9_7 = var5_5;
                    var5_5 = (var7_6 + var9_7) / 2.0;
                } else if (var1_1[0].value > 0.0) {
                    var7_6 = var5_5;
                    var5_5 = (var7_6 + var9_7) / 2.0;
                }
            }
            if (++var16_12 > 1000) break;
            var11_8 = 0.0;
            var19_14 = 0;
            while (var19_14 < var1_1.length) {
                var11_8 += var1_1[var19_14].value * Math.pow(1.0 + var5_5, var1_1.length - var19_14 - 1);
                ++var19_14;
            }
        }
        ((DbDouble)this.Count[2]).value = var5_5;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble MIRR(fIntArray fIntArray2, DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull) {
            return new DbDouble();
        }
        double[] dArray = new double[fIntArray2.value.length];
        int n = 0;
        while (n < fIntArray2.value.length) {
            dArray[n] = ((DbBigInt)fIntArray2.value[n]).value;
            ++n;
        }
        int n2 = 0;
        while (n2 < fIntArray2.value.length) {
            if (((DbBigInt)fIntArray2.value[n2]).bNull) {
                return new DbDouble();
            }
            ++n2;
        }
        return this.NPer(dArray, dbDouble, dbDouble2);
    }

    public DbDouble MIRR(fNumArray fNumArray2, DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double[] dArray = new double[fNumArray2.value.length];
        int n = 0;
        while (n < fNumArray2.value.length) {
            dArray[n] = ((DbDouble)fNumArray2.value[n]).value;
            ++n;
        }
        int n2 = 0;
        while (n2 < fNumArray2.value.length) {
            if (((DbDouble)fNumArray2.value[n2]).bNull) {
                this.Count[2].bNull = true;
                return (DbDouble)this.Count[2];
            }
            ++n2;
        }
        return this.NPer(dArray, dbDouble, dbDouble2);
    }

    private DbDouble NPer(double[] dArray, DbDouble dbDouble, DbDouble dbDouble2) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] < 0.0) {
                d3 += dArray[n] * Math.pow(1.0 + dbDouble.value, dArray.length - n - 1);
            } else {
                d2 += dArray[n] * Math.pow(1.0 + dbDouble2.value, dArray.length - n - 1);
            }
            ++n;
        }
        d3 /= Math.pow(1.0 + dbDouble.value, dArray.length);
        d2 /= Math.pow(1.0 + dbDouble2.value, dArray.length);
        ((DbDouble)this.Count[2]).value = d = Math.pow(-(d2 *= Math.pow(1.0 + dbDouble2.value, dArray.length)) / (d3 *= Math.pow(1.0 + dbDouble.value, 1.0)), 1.0 / (double)(dArray.length - 1)) - 1.0;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble SLN(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        ((DbDouble)this.Count[2]).value = (dbDouble.value - dbDouble2.value) / dbDouble3.value;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble SLN(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        ((DbDouble)this.Count[2]).value = ((double)dbBigInt.value - (double)dbBigInt2.value) / (double)dbBigInt3.value;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble SLN(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbDouble2.bNull || dbBigInt.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        ((DbDouble)this.Count[2]).value = (dbDouble.value - dbDouble2.value) / (double)dbBigInt.value;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble SYD(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double d = (dbDouble.value - dbDouble2.value) * (dbDouble3.value - dbDouble4.value + 1.0) * 2.0;
        ((DbDouble)this.Count[2]).value = d /= dbDouble3.value * (dbDouble3.value + 1.0);
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble SYD(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbBigInt.bNull || dbBigInt2.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double d = (dbDouble.value - dbDouble2.value) * (double)(dbBigInt.value - dbBigInt2.value + 1L) * 2.0;
        ((DbDouble)this.Count[2]).value = d /= (double)(dbBigInt.value * (dbBigInt.value + 1L));
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble SYD(DbNumber dbNumber, DbNumber dbNumber2, DbNumber dbNumber3, DbNumber dbNumber4) {
        if (dbNumber.bNull || dbNumber2.bNull || dbNumber3.bNull || dbNumber4.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double d = (dbNumber.doubleValue() - dbNumber2.doubleValue()) * (dbNumber3.doubleValue() - dbNumber4.doubleValue() + 1.0) * 2.0;
        ((DbDouble)this.Count[2]).value = d /= dbNumber3.doubleValue() * (dbNumber3.doubleValue() + 1.0);
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        DbDouble dbDouble3 = new DbDouble(2.0);
        return this.DDB(dbDouble, dbDouble2, dbBigInt, dbBigInt2, dbDouble3);
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        DbDouble dbDouble5 = new DbDouble(2.0);
        return this.DDB(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbDouble5);
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble3) {
        DbDouble dbDouble4 = new DbDouble();
        DbDouble dbDouble5 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        dbDouble5.bNull = dbBigInt2.bNull;
        dbDouble5.value = dbBigInt2.value;
        return this.DDB(dbDouble, dbDouble2, dbDouble4, dbDouble5, dbDouble3);
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        DbDouble dbDouble3 = new DbDouble();
        DbDouble dbDouble4 = new DbDouble();
        DbDouble dbDouble5 = new DbDouble();
        dbDouble3.bNull = dbBigInt.bNull;
        dbDouble3.value = dbBigInt.value;
        dbDouble4.bNull = dbBigInt2.bNull;
        dbDouble4.value = dbBigInt2.value;
        dbDouble5.bNull = dbBigInt3.bNull;
        dbDouble5.value = dbBigInt3.value;
        return this.DDB(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbDouble5);
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5) {
        double d;
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbDouble5.bNull) {
            this.Count[2].bNull = true;
            return (DbDouble)this.Count[2];
        }
        double d2 = d = dbDouble.value * dbDouble5.value / dbDouble3.value;
        int n = 1;
        while ((double)n < dbDouble4.value) {
            d = (dbDouble.value - d2) * dbDouble5.value / dbDouble3.value;
            d2 += d;
            ++n;
        }
        if (dbDouble3.value == dbDouble4.value && dbDouble.value - d2 - dbDouble2.value < 0.0) {
            d += dbDouble.value - d2 - dbDouble2.value;
        }
        d = (d + 0.005) * 100.0;
        d = (long)d;
        ((DbDouble)this.Count[2]).value = d /= 100.0;
        this.Count[2].bNull = false;
        return (DbDouble)this.Count[2];
    }

    private DbValue Next(DbBigInt dbBigInt, fArray fArray2, int n) {
        DbValue[] dbValueArray = fArray2.value;
        this.Count[n].bNull = true;
        if (dbBigInt.bNull) {
            return this.Count[n];
        }
        if ((int)dbBigInt.value > dbValueArray.length || (int)dbBigInt.value < 0) {
            return this.Count[n];
        }
        DbValue dbValue = dbValueArray[(int)dbBigInt.value];
        this.Count[n].set(dbValue);
        return this.Count[n];
    }

    public DbBigInt choose(DbBigInt dbBigInt, fIntArray fIntArray2) {
        return (DbBigInt)this.Next(dbBigInt, fIntArray2, 1);
    }

    public DbDouble choose(DbBigInt dbBigInt, fNumArray fNumArray2) {
        return (DbDouble)this.Next(dbBigInt, fNumArray2, 2);
    }

    public fCurrency choose(DbBigInt dbBigInt, fCurArray fCurArray2) {
        return (fCurrency)this.Next(dbBigInt, fCurArray2, 3);
    }

    public DbBit choose(DbBigInt dbBigInt, fBoolArray fBoolArray2) {
        return (DbBit)this.Next(dbBigInt, fBoolArray2, 4);
    }

    public DbChar choose(DbBigInt dbBigInt, fStrArray fStrArray2) {
        return (DbChar)this.Next(dbBigInt, fStrArray2, 5);
    }

    public DbDate choose(DbBigInt dbBigInt, fDateArray fDateArray2) {
        return (DbDate)this.Next(dbBigInt, fDateArray2, 6);
    }

    public DbTime choose(DbBigInt dbBigInt, fTimeArray fTimeArray2) {
        return (DbTime)this.Next(dbBigInt, fTimeArray2, 7);
    }

    public DbTimestamp choose(DbBigInt dbBigInt, fDateTimeArray fDateTimeArray2) {
        return (DbTimestamp)this.Next(dbBigInt, fDateTimeArray2, 8);
    }

    public DbBinary choose(DbBigInt dbBigInt, fBinaryArray fBinaryArray2) {
        return (DbBinary)this.Next(dbBigInt, fBinaryArray2, 9);
    }

    public fText choose(DbBigInt dbBigInt, fTextArray fTextArray2) {
        return (fText)this.Next(dbBigInt, fTextArray2, 10);
    }

    public fImage choose(DbBigInt dbBigInt, fImageArray fImageArray2) {
        return (fImage)this.Next(dbBigInt, fImageArray2, 11);
    }

    public DbValue Switch(fBoolArray fBoolArray2, fArray fArray2, int n) {
        DbValue[] dbValueArray = fBoolArray2.value;
        DbValue[] dbValueArray2 = fArray2.value;
        this.Count[n].bNull = true;
        if (dbValueArray.length != dbValueArray2.length) {
            return this.Count[n];
        }
        int n2 = 0;
        while (n2 < dbValueArray.length) {
            if (((DbBit)dbValueArray[n2]).bNull) {
                return this.Count[n];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < dbValueArray.length) {
            if (((DbBit)dbValueArray[n3]).value) {
                this.Count[n].set(dbValueArray2[n3]);
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            ++n3;
        }
        return this.Count[n];
    }

    public DbBigInt Switch(fBoolArray fBoolArray2, fIntArray fIntArray2) {
        return (DbBigInt)this.Switch(fBoolArray2, fIntArray2, 1);
    }

    public DbDouble Switch(fBoolArray fBoolArray2, fNumArray fNumArray2) {
        return (DbDouble)this.Switch(fBoolArray2, fNumArray2, 2);
    }

    public fCurrency Switch(fBoolArray fBoolArray2, fCurArray fCurArray2) {
        return (fCurrency)this.Switch(fBoolArray2, fCurArray2, 3);
    }

    public DbBit Switch(fBoolArray fBoolArray2, fBoolArray fBoolArray3) {
        return (DbBit)this.Switch(fBoolArray2, fBoolArray3, 4);
    }

    public DbChar Switch(fBoolArray fBoolArray2, fStrArray fStrArray2) {
        return (DbChar)this.Switch(fBoolArray2, fStrArray2, 5);
    }

    public DbDate Switch(fBoolArray fBoolArray2, fDateArray fDateArray2) {
        return (DbDate)this.Switch(fBoolArray2, fDateArray2, 6);
    }

    public DbTime Switch(fBoolArray fBoolArray2, fTimeArray fTimeArray2) {
        return (DbTime)this.Switch(fBoolArray2, fTimeArray2, 7);
    }

    public DbTimestamp Switch(fBoolArray fBoolArray2, fDateTimeArray fDateTimeArray2) {
        return (DbTimestamp)this.Switch(fBoolArray2, fDateTimeArray2, 8);
    }

    public DbBinary Switch(fBoolArray fBoolArray2, fBinaryArray fBinaryArray2) {
        return (DbBinary)this.Switch(fBoolArray2, fBinaryArray2, 9);
    }

    public fText Switch(fBoolArray fBoolArray2, fTextArray fTextArray2) {
        return (fText)this.Switch(fBoolArray2, fTextArray2, 10);
    }

    public fImage Switch(fBoolArray fBoolArray2, fImageArray fImageArray2) {
        return (fImage)this.Switch(fBoolArray2, fImageArray2, 11);
    }

    public DbBit xor(DbBit dbBit, DbBit dbBit2) {
        if (dbBit.bNull || dbBit2.bNull) {
            this.Count[4].bNull = true;
        } else {
            ((DbBit)this.Count[4]).value = dbBit.value && dbBit2.value ? false : dbBit.value || dbBit2.value;
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    public DbBit eqv(DbBit dbBit, DbBit dbBit2) {
        if (dbBit.bNull || dbBit2.bNull) {
            this.Count[4].bNull = true;
        } else {
            ((DbBit)this.Count[4]).value = dbBit.value && dbBit2.value ? true : !dbBit.value && !dbBit2.value;
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    public DbBit isCountry(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[4].bNull = true;
        } else {
            Locale locale = Locale.getDefault();
            ((DbBit)this.Count[4]).value = locale.getCountry().equals(dbChar.value.trim());
            this.Count[4].bNull = false;
        }
        return (DbBit)this.Count[4];
    }

    public DbSecurityContext getSecurityContext() {
        return this.I.securityContext;
    }

    public DbBit print(DbChar dbChar, DbValue dbValue) {
        return new DbBit(false);
    }

    public DbChar properCase(DbChar dbChar) {
        if (dbChar.bNull) {
            this.Count[5].bNull = true;
        } else {
            boolean bl = true;
            String string = "";
            String string2 = dbChar.value;
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (Character.isLetter(c)) {
                    if (bl) {
                        string = string + Character.toUpperCase(c);
                        bl = false;
                    } else {
                        string = string + Character.toLowerCase(c);
                    }
                } else {
                    string = string + c;
                    bl = true;
                }
                ++n;
            }
            this.Count[5].bNull = false;
            ((DbChar)this.Count[5]).value = string;
        }
        return (DbChar)this.Count[5];
    }

    DbValue I(DbNumber dbNumber, DbNumber dbNumber2, SpecFormulaValueChange specFormulaValueChange, Record record, DbNumber dbNumber3) {
        boolean bl = specFormulaValueChange.isIncrease();
        int n = specFormulaValueChange.getTolerance();
        JRecord jRecord = (JRecord)record;
        int n2 = jRecord.getPosition() - 1;
        if (n2 < 1) {
            return dbNumber2;
        }
        boolean bl2 = false;
        if (dbNumber.compareTo(dbNumber3) == 0) {
            return dbNumber2;
        }
        if (dbNumber.bNull || dbNumber3.bNull) {
            bl2 = true;
        } else {
            switch (dbNumber.getSqlType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    long l = bl ? dbNumber.longValue() - dbNumber3.longValue() : dbNumber3.longValue() - dbNumber.longValue();
                    bl2 = l > (long)n;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    double d = bl ? dbNumber.doubleValue() - dbNumber3.doubleValue() : dbNumber3.doubleValue() - dbNumber.doubleValue();
                    bl2 = d > (double)n;
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = ((DbDecimal)dbNumber).get();
                    BigDecimal bigDecimal2 = ((DbDecimal)dbNumber3).get();
                    BigDecimal bigDecimal3 = bl ? bigDecimal.add(bigDecimal2.negate()) : bigDecimal2.add(bigDecimal.negate());
                    BigDecimal bigDecimal4 = new BigDecimal((double)n);
                    boolean bl3 = bl2 = bigDecimal3.compareTo(bigDecimal4) == 1;
                }
            }
        }
        if (bl2) {
            this.PPmt(dbNumber2, dbNumber.getSqlType());
        }
        dbNumber3.set(dbNumber);
        return dbNumber2;
    }

    private void PPmt(DbNumber dbNumber, int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                ((DbBigInt)dbNumber).set(dbNumber.longValue() + 1L);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                ((DbDouble)dbNumber).set(dbNumber.doubleValue() + 1.0);
                break;
            }
            case 2: 
            case 3: {
                ((DbDecimal)dbNumber).set(new BigDecimal(dbNumber.doubleValue() + 1.0));
            }
        }
    }

    String I(DbNumber dbNumber, SpecFormulaNum specFormulaNum) {
        String string = null;
        Number number = specFormulaNum.getInterval();
        if (dbNumber.isNull()) {
            string = specFormulaNum.isKeepNullGroup() ? specFormulaNum.getOtherGroupName() : "Others";
            return string;
        }
        switch (dbNumber.getSqlType()) {
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ((DbDecimal)dbNumber).get();
                BigDecimal bigDecimal2 = (BigDecimal)number;
                string = bigDecimal.multiply(bigDecimal2) + " to <" + bigDecimal.add(new BigDecimal(1.0)).multiply(bigDecimal2);
                break;
            }
            case 6: 
            case 7: {
                float f = dbNumber.floatValue();
                float f2 = number.floatValue();
                string = f * f2 + " to <" + (f + 1.0f) * f2;
                break;
            }
            case 8: {
                double d = dbNumber.doubleValue();
                double d2 = number.doubleValue();
                string = d * d2 + " to <" + (d + 1.0) * d2;
                break;
            }
            case 5: {
                short s = dbNumber.shortValue();
                short s2 = number.shortValue();
                string = s * s2 + " to <" + (s + 1) * s2;
                break;
            }
            case -6: {
                byte by = dbNumber.byteValue();
                byte by2 = number.byteValue();
                string = by * by2 + " to <" + (by + 1) * by2;
                break;
            }
            case 4: {
                int n = dbNumber.intValue();
                int n2 = number.intValue();
                string = n * n2 + " to <" + (n + 1) * n2;
                break;
            }
            case -5: {
                long l = dbNumber.longValue();
                long l2 = number.longValue();
                string = l * l2 + " to <" + (l + 1L) * l2;
            }
        }
        return string;
    }

    DbValue Z(DbNumber dbNumber, SpecFormulaNum specFormulaNum) {
        DbValue dbValue = null;
        if (dbNumber.isNull()) {
            return dbValue;
        }
        switch (dbNumber.getSqlType()) {
            case 2: 
            case 3: {
                dbValue = this.PV((DbDecimal)dbNumber, specFormulaNum);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                dbValue = this.Pmt(dbNumber, specFormulaNum);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                dbValue = this.PopulationVariance(dbNumber, specFormulaNum);
            }
        }
        return dbValue;
    }

    private DbDecimal PV(DbDecimal dbDecimal, SpecFormulaNum specFormulaNum) {
        DbDecimal dbDecimal2 = new DbDecimal();
        Number number = specFormulaNum.getInterval();
        Number number2 = specFormulaNum.getStartPoint();
        BigDecimal bigDecimal = dbDecimal.get();
        BigDecimal bigDecimal2 = (BigDecimal)number;
        BigDecimal bigDecimal3 = (BigDecimal)number2;
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = new BigDecimal(0.0);
        bigDecimal4 = bigDecimal.compareTo(bigDecimal5) == 1 || bigDecimal.compareTo(bigDecimal5) == 0 ? bigDecimal.divide(bigDecimal2, 0, 1).add(bigDecimal3) : bigDecimal.divide(bigDecimal2, 0, 1).add(new BigDecimal(-1.0)).add(bigDecimal3);
        dbDecimal2.set(bigDecimal4);
        return dbDecimal2;
    }

    private DbValue Pmt(DbNumber dbNumber, SpecFormulaNum specFormulaNum) {
        DbNumber dbNumber2 = null;
        Number number = specFormulaNum.getInterval();
        Number number2 = specFormulaNum.getStartPoint();
        double d = dbNumber.doubleValue();
        double d2 = number.doubleValue();
        double d3 = number2.doubleValue();
        double d4 = 0.0;
        d4 = d >= 0.0 ? d / d2 + d3 : d / d2 - 1.0 + d3;
        d4 = Math.floor(d4);
        switch (dbNumber.getSqlType()) {
            case 6: 
            case 7: {
                dbNumber2 = new DbReal();
                ((DbReal)dbNumber2).set((float)d4);
                break;
            }
            case 8: {
                dbNumber2 = new DbDouble();
                ((DbDouble)dbNumber2).set(d4);
            }
        }
        return dbNumber2;
    }

    private DbValue PopulationVariance(DbNumber dbNumber, SpecFormulaNum specFormulaNum) {
        DbNumber dbNumber2 = null;
        Number number = specFormulaNum.getInterval();
        Number number2 = specFormulaNum.getStartPoint();
        long l = dbNumber.longValue();
        long l2 = number.longValue();
        long l3 = number2.longValue();
        long l4 = 0L;
        l4 = l >= 0L ? l / l2 + l3 : l / l2 - 1L + l3;
        switch (dbNumber.getSqlType()) {
            case 5: {
                dbNumber2 = new DbSmallInt();
                ((DbSmallInt)dbNumber2).set((short)l4);
                break;
            }
            case -6: {
                dbNumber2 = new DbTinyInt();
                ((DbTinyInt)dbNumber2).set((byte)l4);
                break;
            }
            case 4: {
                dbNumber2 = new DbInteger();
                ((DbInteger)dbNumber2).set((int)l4);
                break;
            }
            case -5: {
                dbNumber2 = new DbBigInt();
                ((DbBigInt)dbNumber2).set(l4);
            }
        }
        return dbNumber2;
    }

    String I(DbChar dbChar, SpecFormulaString specFormulaString) {
        String string = null;
        if (dbChar.isNull()) {
            string = specFormulaString.isKeepNullGroup() ? specFormulaString.getOtherGroupName() : "Others";
            return string;
        }
        string = dbChar.get();
        int n = specFormulaString.getConvertGroupName();
        switch (n) {
            case 2: {
                string = string.toUpperCase();
                break;
            }
            case 3: {
                string = string.toLowerCase();
            }
        }
        return string;
    }

    String Z(DbChar dbChar, SpecFormulaString specFormulaString) {
        String string = null;
        if (dbChar.bNull) {
            return string;
        }
        int n = specFormulaString.getIntervalType();
        string = dbChar.get().trim();
        int n2 = string.length();
        int n3 = specFormulaString.getLength();
        char c = specFormulaString.getStuff();
        int n4 = 0;
        int n5 = 0;
        switch (n) {
            case 1: {
                n5 = n4 + n3;
                if (n5 > n2) {
                    int n6 = n5 - n2;
                    while (n6 > 0) {
                        string = string + c;
                        --n6;
                    }
                    break;
                }
                string = string.substring(n4, n5);
                break;
            }
            case 2: {
                n4 = n2 - n3;
                if (n4 < 0) {
                    int n7 = n4;
                    while (n7 < 0) {
                        string = c + string;
                        ++n7;
                    }
                    break;
                }
                string = string.substring(n4);
            }
        }
        return string;
    }

    public DbValue specKeyDateTime(DbDateTime dbDateTime, SpecFormulaDateTime specFormulaDateTime) {
        int n = dbDateTime instanceof DbDate ? 6 : (dbDateTime instanceof DbTime ? 7 : 8);
        switch (specFormulaDateTime.getUnit()) {
            case 1: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                this.gc.set(2, 0);
                this.gc.set(5, 1);
                int n2 = specFormulaDateTime.getInterval();
                if (n2 != 1) {
                    int n3 = this.Prev(this.gc);
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    int n4 = this.Prev(this.bgc);
                    int n5 = (n3 - n4) % n2;
                    if (n5 < 0) {
                        n5 += n2;
                    }
                    this.gc.add(1, -1 * n5);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 2: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                this.gc.set(5, 1);
                int n6 = specFormulaDateTime.getInterval();
                if (n6 != 1) {
                    int n7 = this.Prev(this.gc);
                    int n8 = this.gc.get(2);
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    int n9 = this.Prev(this.bgc);
                    int n10 = this.bgc.get(2);
                    int n11 = ((n7 - n9) * 12 + (n8 - n10)) % n6;
                    if (n11 < 0) {
                        n11 += n6;
                    }
                    this.gc.add(2, -1 * n11);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 5: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                int n12 = specFormulaDateTime.getInterval();
                if (n12 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    long l2 = this.bgc.getTimeInMillis();
                    int n13 = (int)((l - l2) / 86400000L) % n12;
                    if (n13 < 0) {
                        n13 += n12;
                    }
                    this.gc.add(5, -1 * n13);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 10: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                int n14 = specFormulaDateTime.getInterval();
                if (n14 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    long l3 = this.bgc.getTimeInMillis();
                    int n15 = (int)((l - l3) / 3600000L) % n14;
                    if (n15 < 0) {
                        n15 += n14;
                    }
                    this.gc.add(11, -1 * n15);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 12: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                int n16 = specFormulaDateTime.getInterval();
                if (n16 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    long l4 = this.bgc.getTimeInMillis();
                    int n17 = (int)((l - l4) / 60000L) % n16;
                    if (n17 < 0) {
                        n17 += n16;
                    }
                    this.gc.add(12, -1 * n17);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 13: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(14, 0);
                int n18 = specFormulaDateTime.getInterval();
                if (n18 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(14, 0);
                    long l5 = this.bgc.getTimeInMillis();
                    int n19 = (int)((l - l5) / 1000L) % n18;
                    if (n19 < 0) {
                        n19 += n18;
                    }
                    this.gc.add(13, -1 * n19);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 20: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                if (this.gc.get(2) < 6) {
                    this.gc.set(2, 0);
                } else {
                    this.gc.set(2, 6);
                }
                this.gc.set(5, 1);
                int n20 = specFormulaDateTime.getInterval();
                if (n20 != 1) {
                    int n21 = this.Prev(this.gc);
                    int n22 = this.gc.get(2);
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    if (this.bgc.get(2) < 6) {
                        this.bgc.set(2, 0);
                    } else {
                        this.bgc.set(2, 6);
                    }
                    this.bgc.set(5, 1);
                    int n23 = this.Prev(this.bgc);
                    int n24 = this.bgc.get(2);
                    int n25 = ((n21 - n23) * 12 + (n22 - n24)) % n20;
                    if (n25 < 0) {
                        n25 += n20;
                    }
                    this.gc.add(2, -1 * n25);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 21: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                if (this.gc.get(5) < 16) {
                    this.gc.set(5, 1);
                } else {
                    this.gc.set(5, 16);
                }
                int n26 = specFormulaDateTime.getInterval();
                if (n26 != 1) {
                    int n27 = this.Prev(this.gc);
                    int n28 = this.gc.get(2);
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    if (this.bgc.get(5) < 16) {
                        this.bgc.set(5, 1);
                    } else {
                        this.bgc.set(5, 16);
                    }
                    int n29 = this.Prev(this.bgc);
                    int n30 = this.bgc.get(2);
                    int n31 = (n27 - n29) * 12 + (n28 - n30);
                    int n32 = this.gc.get(5) == this.bgc.get(5) ? 0 : (this.gc.get(5) > this.bgc.get(5) ? 1 : -1);
                    int n33 = (n31 * 2 + n32) % n26;
                    if (n33 < 0) {
                        n33 += n26;
                    }
                    this.gc.add(2, -1 * (n33 - n33 % 2));
                    if (n33 % 2 != 0) {
                        if (this.gc.get(5) > 1) {
                            this.bgc.set(5, 1);
                        } else {
                            this.gc.add(2, -1);
                            this.bgc.set(5, 16);
                        }
                    }
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 22: {
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                this.gc.set(5, 1);
                if (this.gc.get(2) < 3) {
                    this.gc.set(2, 0);
                } else if (this.gc.get(2) < 6) {
                    this.gc.set(2, 3);
                } else if (this.gc.get(2) < 9) {
                    this.gc.set(2, 6);
                } else {
                    this.gc.set(2, 9);
                }
                int n34 = specFormulaDateTime.getInterval();
                if (n34 != 1) {
                    int n35 = this.Prev(this.gc);
                    int n36 = this.gc.get(2);
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    this.bgc.set(5, 1);
                    if (this.bgc.get(2) < 3) {
                        this.bgc.set(2, 0);
                    } else if (this.bgc.get(2) < 6) {
                        this.bgc.set(2, 3);
                    } else if (this.bgc.get(2) < 9) {
                        this.bgc.set(2, 6);
                    } else {
                        this.bgc.set(2, 9);
                    }
                    int n37 = this.Prev(this.bgc);
                    int n38 = this.bgc.get(2);
                    int n39 = ((n35 - n37) * 12 + (n36 - n38)) / 3 % n34;
                    if (n39 < 0) {
                        n39 += n34;
                    }
                    this.gc.add(2, -3 * n39);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
            case 23: 
            case 24: {
                int n40 = specFormulaDateTime.getUnit() == 24 ? specFormulaDateTime.getInterval() : specFormulaDateTime.getInterval() * 2;
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                this.gc.set(7, this.gc.getFirstDayOfWeek());
                if (n40 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.I(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    this.bgc.set(7, this.gc.getFirstDayOfWeek());
                    long l6 = this.bgc.getTimeInMillis();
                    int n41 = (int)((l - l6) / 604800000L % (long)n40);
                    if (n41 < 0) {
                        n41 += n40;
                    }
                    this.gc.add(3, -1 * n41);
                }
                ((DbDateTime)this.Count[n]).value = this.gc.I();
                this.Count[n].bNull = false;
                return this.Count[n];
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("unknown SpecFormulaDateTime time unit" + specFormulaDateTime.getUnit()));
        }
        return null;
    }

    private int Prev(MyCalendar myCalendar) {
        int n = myCalendar.get(1);
        if (myCalendar.get(0) == 0) {
            n = 1 - n;
        }
        return n;
    }

    public String specNameDateTime(DbDateTime dbDateTime, SpecFormulaDateTime specFormulaDateTime) {
        String string = null;
        if (dbDateTime.isNull()) {
            string = specFormulaDateTime.isKeepNullGroup() ? specFormulaDateTime.getOtherGroupName() : "Others";
            return string;
        }
        switch (specFormulaDateTime.getUnit()) {
            case 1: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.I(dbDateTime.value);
                    this.gc.computeFields();
                    return this.Second(this.gc);
                }
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Second(this.gc));
                stringBuffer.append('-');
                this.gc.add(1, n - 1);
                stringBuffer.append(this.Second(this.gc));
                return stringBuffer.toString();
            }
            case 2: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.I(dbDateTime.value);
                    this.gc.computeFields();
                    return this.Round(this.gc) + "/" + this.Second(this.gc);
                }
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Round(this.gc) + "/" + this.Second(this.gc));
                stringBuffer.append('-');
                this.gc.add(2, n - 1);
                stringBuffer.append(this.Round(this.gc) + "/" + this.Second(this.gc));
                return stringBuffer.toString();
            }
            case 5: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.I(dbDateTime.value);
                    this.gc.computeFields();
                    return this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc);
                }
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc));
                stringBuffer.append('-');
                this.gc.add(5, n - 1);
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc));
                return stringBuffer.toString();
            }
            case 10: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.I(dbDateTime.value);
                    this.gc.computeFields();
                    return this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":00";
                }
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":00");
                stringBuffer.append('-');
                this.gc.add(11, n - 1);
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":00");
                return stringBuffer.toString();
            }
            case 12: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.I(dbDateTime.value);
                    this.gc.computeFields();
                    return this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":" + this.REPORT_NAME(this.gc);
                }
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":" + this.REPORT_NAME(this.gc));
                stringBuffer.append('-');
                this.gc.add(12, n - 1);
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":" + this.REPORT_NAME(this.gc));
                return stringBuffer.toString();
            }
            case 13: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.I(dbDateTime.value);
                    this.gc.computeFields();
                    return this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":" + this.REPORT_NAME(this.gc) + ":" + this.Quarter(this.gc);
                }
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":" + this.REPORT_NAME(this.gc) + ":" + this.Quarter(this.gc));
                stringBuffer.append('-');
                this.gc.add(13, n - 1);
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc) + " " + this.ROUND_MODEL_KEY(this.gc) + ":" + this.REPORT_NAME(this.gc) + ":" + this.Quarter(this.gc));
                return stringBuffer.toString();
            }
            case 20: {
                int n = specFormulaDateTime.getInterval();
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc));
                stringBuffer.append('-');
                this.gc.add(2, n * 6);
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc));
                return stringBuffer.toString();
            }
            case 22: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.I(dbDateTime.value);
                    this.gc.computeFields();
                    return this.QOIV(this.gc) + "," + this.Second(this.gc);
                }
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.QOIV(this.gc) + "," + this.Second(this.gc));
                stringBuffer.append('-');
                this.gc.add(2, n * 3);
                stringBuffer.append(this.QOIV(this.gc) + "," + this.Second(this.gc));
                return stringBuffer.toString();
            }
            case 21: {
                int n = specFormulaDateTime.getInterval();
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc));
                stringBuffer.append('-');
                this.gc.add(2, n - n % 2);
                if (n % 2 != 0) {
                    if (this.gc.get(5) == 1) {
                        this.gc.set(5, 16);
                    } else {
                        this.gc.add(2, 1);
                        this.gc.set(5, 1);
                    }
                }
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc));
                return stringBuffer.toString();
            }
            case 23: 
            case 24: {
                int n = specFormulaDateTime.getUnit() == 24 ? specFormulaDateTime.getInterval() : specFormulaDateTime.getInterval() * 2;
                this.gc.setTimeZone(specFormulaDateTime.getTimeZone());
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.I(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc));
                stringBuffer.append('-');
                this.gc.add(3, n);
                this.gc.add(5, -1);
                stringBuffer.append(this.Round(this.gc) + "/" + this.Rate(this.gc) + "/" + this.Second(this.gc));
                return stringBuffer.toString();
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("unknown SpecFormulaDateTime time unit" + specFormulaDateTime.getUnit()));
        }
        return null;
    }

    private String QOIV(MyCalendar myCalendar) {
        return String.valueOf(this.gc.get(2) / 3 + 1);
    }

    private String Quarter(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(13));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String REPORT_NAME(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(12));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String ROUND_MODEL_KEY(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(11));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String Rate(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(5));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String Round(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(2) + 1);
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String Second(MyCalendar myCalendar) {
        return String.valueOf(myCalendar.get(1)) + (myCalendar.get(0) == 0 ? " BC" : "");
    }

    public DbDate FirstDayOfWeek(DbDateTime dbDateTime) {
        return this.ForEachWeek(dbDateTime);
    }

    public DbDate FirstDayOfMonth(DbDateTime dbDateTime) {
        return this.ForEachMonth(dbDateTime);
    }

    public DbDate FirstDayOfYear(DbDateTime dbDateTime) {
        return this.ForEachYear(dbDateTime);
    }

    public DbDate FirstDayOfQuarter(DbDateTime dbDateTime) {
        return this.ForEachQuarter(dbDateTime);
    }

    public DbDate FirstSundayOfMonth(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.set(5, 1);
            this.gc.set(5, 1);
            int n = this.gc.get(7);
            if (n != 1) {
                n = 7 - n + 1;
                this.gc.add(5, n);
            }
            ((DbDate)this.Count[6]).value = this.gc.getTimeInMillis();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbDate FirstSundayOfYear(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.Count[6].bNull = true;
        } else {
            this.gc.I(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.set(5, 1);
            this.gc.set(6, 1);
            int n = this.gc.get(7);
            if (n != 1) {
                n = 7 - n + 1;
                this.gc.add(5, n);
            }
            ((DbDate)this.Count[6]).value = this.gc.getTimeInMillis();
            this.Count[6].bNull = false;
        }
        return (DbDate)this.Count[6];
    }

    public DbBit isAll(fArray fArray2) {
        boolean bl = fArray2 instanceof IAllValue;
        this.Count[4].bNull = false;
        ((DbBit)this.Count[4]).value = bl;
        return (DbBit)this.Count[4];
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$formula$Functions == null ? (class$jet$formula$Functions = Functions.class$("jet.formula.Functions")) : class$jet$formula$Functions).desiredAssertionStatus();
        ones = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
        teens = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        tens = new String[]{"?", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
        units = new String[]{"hundreds", "thousand", "million", "billion", "trillion"};
        Average = new int[]{0, 1, 2, 3, 4, 5, 6};
        ROUND_MODEL_KEY = new String[]{"UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN"};
        CurrentDateTime = JRLogger.getLogger((class$jet$formula$Functions == null ? (class$jet$formula$Functions = Functions.class$("jet.formula.Functions")) : class$jet$formula$Functions).getName());
        CurrentTime = new Hashtable();
        CurrentTime.put("1", "January");
        CurrentTime.put("2", "February");
        CurrentTime.put("3", "March");
        CurrentTime.put("4", "April");
        CurrentTime.put("5", "May");
        CurrentTime.put("6", "June");
        CurrentTime.put("7", "July");
        CurrentTime.put("8", "August");
        CurrentTime.put("9", "September");
        CurrentTime.put("10", "October");
        CurrentTime.put("11", "November");
        CurrentTime.put("12", "December");
        D = new Hashtable();
        D.put("1", "Jan");
        D.put("2", "Feb");
        D.put("3", "Mar");
        D.put("4", "Apr");
        D.put("5", "May");
        D.put("6", "Jun");
        D.put("7", "Jul");
        D.put("8", "Aug");
        D.put("9", "Sep");
        D.put("10", "Oct");
        D.put("11", "Nov");
        D.put("12", "Dec");
        weekdayToName = new Hashtable();
        weekdayToName.put("1", "Sunday");
        weekdayToName.put("2", "Monday");
        weekdayToName.put("3", "Tuesday");
        weekdayToName.put("4", "Wednesday");
        weekdayToName.put("5", "Thursday");
        weekdayToName.put("6", "Friday");
        weekdayToName.put("7", "Saturday");
        weekdayToAbbr = new Hashtable();
        weekdayToAbbr.put("1", "Sun");
        weekdayToAbbr.put("2", "Mon");
        weekdayToAbbr.put("3", "Tues");
        weekdayToAbbr.put("4", "Wed");
        weekdayToAbbr.put("5", "Thu");
        weekdayToAbbr.put("6", "Fri");
        weekdayToAbbr.put("7", "Sat");
        firstdayOfWeek = new Hashtable();
        firstdayOfWeek.put("JRUSESYSTEM", "0");
        firstdayOfWeek.put("JRSUNDAY", "1");
        firstdayOfWeek.put("JRMONDAY", "2");
        firstdayOfWeek.put("JRTUESDAY", "3");
        firstdayOfWeek.put("JRWEDNESDAY", "4");
        firstdayOfWeek.put("JRTHURSDAY", "5");
        firstdayOfWeek.put("JRFRIDAY", "6");
        firstdayOfWeek.put("JRSATURDAY", "7");
        dateFormats = new String[25];
        Functions.dateFormats[0] = "MMM. dd, yy";
        Functions.dateFormats[1] = "MMM dd, yy";
        Functions.dateFormats[2] = "MMM. dd,yy";
        Functions.dateFormats[3] = "MMM dd,yy";
        Functions.dateFormats[4] = "yy-MM-dd";
        Functions.dateFormats[5] = "yy/MM/dd";
        Functions.dateFormats[6] = "yy MM dd";
        Functions.dateFormats[7] = "MM/dd/yy";
        Functions.dateFormats[8] = "MM-dd-yy";
        Functions.dateFormats[9] = "MM dd yy";
        Functions.dateFormats[10] = "dd-MM-yy";
        Functions.dateFormats[11] = "dd/MM/yy";
        Functions.dateFormats[12] = "dd MM yy";
        Functions.dateFormats[13] = "yy-MM";
        Functions.dateFormats[14] = "yy/MM";
        Functions.dateFormats[15] = "yy MM";
        Functions.dateFormats[16] = "MM-dd";
        Functions.dateFormats[17] = "MM/dd";
        Functions.dateFormats[18] = "MM dd";
        Functions.dateFormats[19] = "dd-MM";
        Functions.dateFormats[20] = "dd/MM";
        Functions.dateFormats[21] = "dd MM";
        Functions.dateFormats[22] = "MM-yy";
        Functions.dateFormats[23] = "MM/yy";
        Functions.dateFormats[24] = "MM yy";
        timeFormats = new String[5];
        Functions.timeFormats[0] = "kk:mm:ss a";
        Functions.timeFormats[1] = "kk:mm:ss";
        Functions.timeFormats[2] = "kk:mm a";
        Functions.timeFormats[3] = "kk:mm";
        Functions.timeFormats[4] = "kk a";
        datetimeFormats = new String[50];
        Functions.datetimeFormats[0] = "MMM. d, yy kk:mm:ss a";
        Functions.datetimeFormats[1] = "MMM. d, yy kk:mm:ss";
        Functions.datetimeFormats[2] = "MMM. d, yy kk:mm a";
        Functions.datetimeFormats[3] = "MMM. d, yy kk:mm";
        Functions.datetimeFormats[4] = "MMM. d, yy kk a";
        Functions.datetimeFormats[5] = "MMM. d,yy kk:mm:ss a";
        Functions.datetimeFormats[6] = "MMM. d,yy kk:mm:ss";
        Functions.datetimeFormats[7] = "MMM. d,yy kk:mm a";
        Functions.datetimeFormats[8] = "MMM. d,yy kk:mm";
        Functions.datetimeFormats[9] = "MMM. d,yy kk a";
        Functions.datetimeFormats[10] = "MMM d, yy kk:mm:ss a";
        Functions.datetimeFormats[11] = "MMM d, yy kk:mm:ss";
        Functions.datetimeFormats[12] = "MMM d, yy kk:mm a";
        Functions.datetimeFormats[13] = "MMM d, yy kk:mm";
        Functions.datetimeFormats[14] = "MMM d, yy kk a";
        Functions.datetimeFormats[15] = "MMM d,yy kk:mm:ss a";
        Functions.datetimeFormats[16] = "MMM d,yy kk:mm:ss";
        Functions.datetimeFormats[17] = "MMM d,yy kk:mm a";
        Functions.datetimeFormats[18] = "MMM d,yy kk:mm";
        Functions.datetimeFormats[19] = "MMM d,yy kk a";
        Functions.datetimeFormats[20] = "yy-MM-dd kk:mm:ss a";
        Functions.datetimeFormats[21] = "yy-MM-dd kk:mm:ss";
        Functions.datetimeFormats[22] = "yy-MM-dd kk:mm a";
        Functions.datetimeFormats[23] = "yy-MM-dd kk:mm";
        Functions.datetimeFormats[24] = "yy-MM-dd kk a";
        Functions.datetimeFormats[25] = "yy/MM/dd kk:mm:ss a";
        Functions.datetimeFormats[26] = "yy/MM/dd kk:mm:ss";
        Functions.datetimeFormats[27] = "yy/MM/dd kk:mm a";
        Functions.datetimeFormats[28] = "yy/MM/dd kk:mm";
        Functions.datetimeFormats[29] = "yy/MM/dd kk a";
        Functions.datetimeFormats[30] = "yy MM dd kk:mm:ss a";
        Functions.datetimeFormats[31] = "yy MM dd kk:mm:ss";
        Functions.datetimeFormats[32] = "yy MM dd kk:mm a";
        Functions.datetimeFormats[33] = "yy MM dd kk:mm";
        Functions.datetimeFormats[34] = "yy MM dd kk a";
        Functions.datetimeFormats[35] = "yy-MM kk:mm:ss a";
        Functions.datetimeFormats[36] = "yy-MM kk:mm:ss";
        Functions.datetimeFormats[37] = "yy-MM kk:mm a";
        Functions.datetimeFormats[38] = "yy-MM kk:mm";
        Functions.datetimeFormats[39] = "yy-MM kk a";
        Functions.datetimeFormats[40] = "yy/MM kk:mm:ss a";
        Functions.datetimeFormats[41] = "yy/MM kk:mm:ss";
        Functions.datetimeFormats[42] = "yy/MM kk:mm a";
        Functions.datetimeFormats[43] = "yy/MM kk:mm";
        Functions.datetimeFormats[44] = "yy/MM kk a";
        Functions.datetimeFormats[45] = "yy MM kk:mm:ss a";
        Functions.datetimeFormats[46] = "yy MM kk:mm:ss";
        Functions.datetimeFormats[47] = "yy MM kk:mm a";
        Functions.datetimeFormats[48] = "yy MM kk:mm";
        Functions.datetimeFormats[49] = "yy MM kk a";
    }
}

