/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.graphics.ChartBackground;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.datastream.JetChartPropertyValues;
import jet.report.JetRptChartBorderStyle;
import jet.report.chart.JetChartElement;
import jet.report.chart.JetChartFillPattern;
import jet.report.chart.JetChartPenStyle;

public class JetChartBackground
extends JetChartElement {
    public JetRptChartBorderStyle borderStyle;
    public JetChartPenStyle borderPen;
    public JetChartFillPattern fillPattern;
    public JetNumber top;
    public JetNumber left;
    public JetNumber right;
    public JetNumber bottom;

    public JetChartBackground(JetObject jetObject, String string) {
        super(jetObject, string + "Background");
        string = this.prefix;
        this.borderStyle = new JetRptChartBorderStyle(jetObject, string + "BorderStyle");
        this.borderPen = new JetChartPenStyle(jetObject, string + "Border");
        this.fillPattern = new JetChartFillPattern(jetObject, string + "Fill", true);
        this.top = new JetNumber(jetObject, string + "Top");
        this.left = new JetNumber(jetObject, string + "Left");
        this.right = new JetNumber(jetObject, string + "Right");
        this.bottom = new JetNumber(jetObject, string + "Bottom");
    }

    public String getGroupName() {
        return "Background";
    }

    public void addToGroup(String string) {
        this.owner.addPropertyToGroup(this.borderStyle.getName(), string);
        this.borderPen.addToGroup(string);
        this.fillPattern.addToGroup(string);
        this.owner.addPropertyToGroup(this.top.getName(), string);
        this.owner.addPropertyToGroup(this.left.getName(), string);
        this.owner.addPropertyToGroup(this.right.getName(), string);
        this.owner.addPropertyToGroup(this.bottom.getName(), string);
    }

    public ChartBackground getChartBackground() {
        ChartBackground chartBackground = new ChartBackground();
        chartBackground.setBorderStyle(this.borderStyle.intValue());
        chartBackground.setPen(this.borderPen.getChartPenStyle());
        chartBackground.setPattern(this.fillPattern.getChartFillPattern());
        chartBackground.setTop((float)this.top.intValue() / 100.0f);
        chartBackground.setLeft((float)this.left.intValue() / 100.0f);
        chartBackground.setRight((float)this.right.intValue() / 100.0f);
        chartBackground.setBottom((float)this.bottom.intValue() / 100.0f);
        return chartBackground;
    }

    public void setChartBackground(ChartBackground chartBackground) {
        this.borderStyle.set((String)JetChartPropertyValues.BACKGROUND_BORDERSTYLE_INTEGERS.get(new Integer(chartBackground.getBorderStyle())));
        this.borderPen.setChartPenStyle(chartBackground.getPen());
        this.fillPattern.setChartFillPattern(chartBackground.getPattern());
        this.top.set(chartBackground.getTop() * 100.0f);
        this.left.set(chartBackground.getLeft() * 100.0f);
        this.right.set(chartBackground.getRight() * 100.0f);
        this.bottom.set(chartBackground.getBottom() * 100.0f);
    }
}

