/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.tabularLogic;

import java.util.ArrayList;
import jet.reportLogic.objectLogic.tabularLogic.GridRow;
import jet.reportLogic.objectLogic.tabularLogic.Tabular;

public class Rows
extends ArrayList {
    public int vCellSpacing = 0;

    public Rows() {
    }

    public Rows(int n) {
        super(n);
        int n2 = 0;
        while (n2 < n) {
            this.add(new GridRow());
            ++n2;
        }
    }

    public GridRow getGridRow(int n) {
        return (GridRow)this.get(n);
    }

    public int getGridRowHeightAt(int n) {
        return this.getGridRow(n).getHeight();
    }

    public int getGridRowHeightBetween(int n, int n2) {
        int n3 = 0;
        if (n2 >= n && n >= 0 && n2 < this.size()) {
            int n4 = n;
            while (n4 <= n2) {
                n3 += this.getGridRowHeightAt(n4);
                ++n4;
            }
            n3 += this.vCellSpacing * (n2 - n);
        }
        return n3;
    }

    public int getTotalHeight() {
        return this.getGridRowHeightBetween(0, this.size() - 1) + this.vCellSpacing * 2;
    }

    public void addGridRow(GridRow gridRow) {
        this.add(gridRow);
    }

    public void setGridRowHeightAt(int n, int n2) {
        this.getGridRow(n).setHeight(n2);
    }

    public void deleteKeepTotalHeight(int n) {
        if (n >= -1 && n < this.size()) {
            GridRow gridRow = (GridRow)this.remove(n);
            int n2 = this.size();
            if (n2 > 0) {
                int n3 = gridRow.getHeight();
                this.resizeTotalHeight(n3 + this.vCellSpacing);
            }
        }
    }

    public void addKeepTotalHeight(int n, int n2) {
        if (n >= -1 && n <= this.size()) {
            if (n == -1) {
                this.add(new GridRow(n2));
            } else {
                this.add(n, new GridRow(n2));
            }
            this.resizeTotalHeight(-(n2 + this.vCellSpacing));
        }
    }

    public void resizeTotalHeight(int n) {
        this.resizeHeightBetween(0, this.size() - 1, n);
    }

    public void resizeHeightBetween(int n, int n2, int n3) {
        if (n2 >= n && n >= 0 && n2 < this.size()) {
            int n4 = n2 - n + 1;
            int n5 = 0;
            if (n3 > 0) {
                block0: while (n3 >= Tabular.SCALE) {
                    int n6 = n;
                    while (n6 <= n2) {
                        n5 = this.getGridRowHeightAt(n6) + Tabular.SCALE;
                        this.setGridRowHeightAt(n6, n5);
                        if ((n3 -= Tabular.SCALE) < Tabular.SCALE) continue block0;
                        ++n6;
                    }
                }
            } else if (n3 < 0) {
                block2: while (n3 <= -Tabular.SCALE) {
                    int n7 = n;
                    while (n7 <= n2) {
                        n5 = this.getGridRowHeightAt(n7) - Tabular.SCALE;
                        if (n5 < Tabular.DefaultMinGridCellLength) {
                            n5 = Tabular.DefaultMinGridCellLength;
                        }
                        this.setGridRowHeightAt(n7, n5);
                        if ((n3 += Tabular.SCALE) > -Tabular.SCALE) continue block2;
                        ++n7;
                    }
                }
            }
            this.setGridRowHeightAt(this.size() - 1, this.getGridRowHeightAt(this.size() - 1) + n3);
        }
    }
}

