/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.manager;

import com.jinfonet.util.JRLog;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import jet.bean.EngineProperties;
import jet.bean.JREngine;
import jet.controls.JetBoolean;
import jet.controls.JetObject;
import jet.report.JetLink;
import jet.report.JetRptArea;
import jet.report.JetRptField;
import jet.report.JetRptPicture;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptengine.JReportEngine;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.pub.LinkInfo;
import jet.rptservice.pub.MasterDetailInfo;
import jet.util.EngineErrorListener;
import jet.util.EngineRuntimeInfo;
import jet.util.RuntimeInfo;

public class EngineManager {
    private static JetRptArea QOIV(JetRptArea jetRptArea) {
        return ((JetBoolean)jetRptArea.getPropertyByName("UseDefault")).booleanValue() ? (JetRptArea)jetRptArea.getBasedArea() : jetRptArea;
    }

    private static JREngine addDetailReportEngine(JetRptReportSet jetRptReportSet, JReportEngine jReportEngine, String string, JetLink jetLink, Vector vector, RuntimeInfo runtimeInfo, Hashtable hashtable) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "EngineManager.createLinkedReportEngine()..., rptSet: " + jetRptReportSet + " mainViewEngine: " + jReportEngine + " runtimeInfo: " + runtimeInfo);
        }
        JRptSetEngine jRptSetEngine = jReportEngine.getReportViewCenter().getRptCenter().getRptSetCenter().getRptSetEngine();
        EngineProperties engineProperties = new EngineProperties(jRptSetEngine.getUID(), jRptSetEngine.getKey(), jRptSetEngine.getCallerId(), jRptSetEngine.getJdbcDriversCfg(), jRptSetEngine.isCacheZip());
        JREngine jREngine = new JREngine(engineProperties);
        jREngine.setReportSet(jetRptReportSet);
        jREngine.setUniverse(jReportEngine.getReportViewCenter().getRptCenter().getRptSetCenter().getRptSetEngine().getUniverse());
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JetRptReport jetRptReport = reportViewCenter.getReportView();
        JetObject jetObject = jetRptReport.nameToObject(string);
        boolean bl = false;
        if (jetObject instanceof JetRptField) {
            bl = ((JetRptField)jetObject).transferStyle.get();
        } else if (jetObject instanceof JetRptPicture) {
            bl = ((JetRptPicture)jetObject).transferStyle.get();
        } else if (jetObject instanceof JetRptArea) {
            bl = EngineManager.QOIV((JetRptArea)((JetRptArea)jetObject)).transferStyle.get();
        }
        LinkInfo linkInfo = new LinkInfo(jetLink, vector, string, bl);
        if (linkInfo.getRptName() == null || linkInfo.getRptName().trim().equals("")) {
            linkInfo.setRptName(jetRptReportSet.getCurReportId());
        }
        if (linkInfo.getViewName() == null || linkInfo.getViewName().trim().equals("")) {
            linkInfo.setViewName(jetRptReportSet.getReport(linkInfo.getRptName()).getCurViewName());
        }
        EngineManager.addEngineListener(jREngine, jRptSetEngine, new Hashtable());
        jREngine.setReportName(jReportEngine.getRptPath() + linkInfo.getRptSetName());
        if (runtimeInfo != null) {
            EngineRuntimeInfo engineRuntimeInfo = EngineRuntimeInfo.createEngineRuntimeInfo(runtimeInfo);
            engineRuntimeInfo.setExportStyleGroup("");
            jREngine.setRuntimeInfo(linkInfo.getRptName(), engineRuntimeInfo);
            if (bl && !"".equals(runtimeInfo.getExportStyleGroup())) {
                jREngine.setStyleGroup(runtimeInfo.getExportStyleGroup());
            }
        }
        if (!jREngine.createLinkedReportEngine(linkInfo, jReportEngine)) {
            return null;
        }
        reportViewCenter.addLinkReportEngine(string, jREngine);
        jREngine.getReportSet().setUniverse(jReportEngine.getReportViewCenter().getRptCenter().getRptSetCenter().getRptSetEngine().getUniverse());
        EngineManager.addLinkReportEngine(jREngine);
        JRLog.trace(6, "End of EngineManager.createLinkedReportEngine()...");
        return jREngine;
    }

    public static JREngine createDetailReportEngine(JetRptReportSet jetRptReportSet, JReportEngine jReportEngine, String string, MasterDetailInfo masterDetailInfo, Hashtable hashtable) {
        Object object;
        JRLog.trace(6, "EngineManager.createDetailReportEngine()..., rptSet: " + jetRptReportSet + " mainViewEngine: " + jReportEngine + " masterDetailInfo: " + masterDetailInfo);
        JRptSetEngine jRptSetEngine = jReportEngine.getReportViewCenter().getRptCenter().getRptSetCenter().getRptSetEngine();
        EngineProperties engineProperties = new EngineProperties(jRptSetEngine.getUID(), jRptSetEngine.getKey(), jRptSetEngine.getCallerId(), jRptSetEngine.getJdbcDriversCfg(), jRptSetEngine.isCacheZip());
        JREngine jREngine = new JREngine(engineProperties);
        jREngine.setReportSet(jetRptReportSet);
        jREngine.setUniverse(jReportEngine.getReportViewCenter().getRptCenter().getRptSetCenter().getRptSetEngine().getUniverse());
        EngineManager.addEngineListener(jREngine, jRptSetEngine, hashtable);
        if (masterDetailInfo.getDetailRptName() == null || masterDetailInfo.getDetailRptName().trim().equals("")) {
            masterDetailInfo.setDetailRptName(jetRptReportSet.getCurReportId());
        }
        if (masterDetailInfo.getDetailViewName() == null || masterDetailInfo.getDetailViewName().trim().equals("")) {
            object = jetRptReportSet.getReport(masterDetailInfo.getDetailRptName());
            masterDetailInfo.setDetailViewName(((JetRptReport)object).getCurViewName());
        }
        if ((object = (RuntimeInfo)hashtable.get("runtime_info")) != null) {
            jREngine.setRuntimeInfo(masterDetailInfo.getDetailRptName(), (RuntimeInfo)object);
        }
        if (!jREngine.createDetailReportEngine(masterDetailInfo, jReportEngine)) {
            jREngine.exit();
            return null;
        }
        JRptSetEngine jRptSetEngine2 = jREngine.getRptSetEngine();
        JReportEngine jReportEngine2 = jRptSetEngine2.getReportViewEngine(masterDetailInfo.getDetailRptName(), masterDetailInfo.getDetailViewName());
        ReportViewCenter reportViewCenter = jReportEngine2.getReportViewCenter();
        reportViewCenter.setMasterDetailInfo(masterDetailInfo);
        jReportEngine2.setDetailInfo(masterDetailInfo);
        jReportEngine.getReportViewCenter().addDetailReportEngine(string, jREngine);
        JRLog.trace(6, "End of EngineManager.createDetailReportEngine()...");
        return jREngine;
    }

    public static JREngine createLinkedReportEngine(JetRptReportSet jetRptReportSet, JREngine jREngine, String string, String string2, String string3, JetLink jetLink, Vector vector, RuntimeInfo runtimeInfo) {
        JReportEngine jReportEngine = jREngine.getRptSetEngine().getReportViewEngine(string, string2);
        return EngineManager.createLinkedReportEngine(jetRptReportSet, jReportEngine, string3, jetLink, vector, runtimeInfo, new Hashtable());
    }

    private static void addEngineListener(JREngine jREngine, JRptSetEngine jRptSetEngine, Hashtable hashtable) {
        EngineErrorListener[] engineErrorListenerArray;
        JRLog.trace(6, "EngineManager.prepareEngineInfo()..., dest = " + jREngine + " src = " + jRptSetEngine);
        jREngine.setCatalogBean(null);
        jREngine.setUniverse(jRptSetEngine.getUniverse());
        jREngine.setUserName(jRptSetEngine.getUserName());
        jREngine.setPriority(-1);
        jREngine.setSingleThread(jRptSetEngine.isSingleThread());
        jREngine.setLocale(Locale.getDefault());
        jREngine.setTimeZone(TimeZone.getDefault());
        jREngine.setTemplatePath("");
        jREngine.setReportHome("");
        jREngine.setParamValues(jRptSetEngine.getParamValues());
        jREngine.setParamFile(jRptSetEngine.getParamFile());
        jREngine.setParamValues(jRptSetEngine.getParamProperty());
        String string = (String)hashtable.get("encoding");
        if (string == null) {
            jREngine.setEncoding(jRptSetEngine.getEncoding());
        } else {
            jREngine.setEncoding(string);
        }
        String string2 = (String)hashtable.get("convert_from_encoding");
        String string3 = (String)hashtable.get("convert_to_encoding");
        if (string2 == null || string3 == null) {
            jREngine.setConvertEncoding(jRptSetEngine.getConvertFromEncoding(), jRptSetEngine.getConvertToEncoding());
        } else {
            jREngine.setConvertEncoding(Integer.parseInt(string2), Integer.parseInt(string3));
        }
        Map map = (Map)hashtable.get("user_password");
        if (map != null && !map.isEmpty()) {
            engineErrorListenerArray = map.keySet().iterator();
            while (engineErrorListenerArray.hasNext()) {
                String string4 = (String)engineErrorListenerArray.next();
                String[] stringArray = (String[])map.get(string4);
                jREngine.setConnection(string4, stringArray[0], stringArray[1]);
            }
        }
        jREngine.setDhtmlInteract(jRptSetEngine.isDhtmlInteract());
        jREngine.setThreadPriority(jRptSetEngine.getPriority());
        jREngine.setSortMemorySize(jRptSetEngine.getSortMemorySize());
        engineErrorListenerArray = (EngineErrorListener[])hashtable.get("engine_error_listener");
        int n = 0;
        while (engineErrorListenerArray != null && n < engineErrorListenerArray.length) {
            jREngine.addEngineListener(engineErrorListenerArray[n]);
            ++n;
        }
        JRLog.trace(6, "End of EngineManager.prepareEngineInfo().");
    }

    private static void addLinkReportEngine(JREngine jREngine) {
        JRptSetEngine jRptSetEngine = jREngine.getRptSetEngine();
        String[] stringArray = jRptSetEngine.getUsedDataSetNames();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    jRptSetEngine.initRawDataQuery(jRptSetEngine.getReportSetCenter().getDataSetCenter(stringArray[n]));
                }
                catch (JRScheduleException jRScheduleException) {
                    JRLog.error(6, jRScheduleException.getMessage(), (Throwable)jRScheduleException);
                    JRLog.trace(4, "run data set failed, dataSetName = " + stringArray[n]);
                    return;
                }
                ++n;
            }
        }
    }

    public static JREngine createLinkedReportEngine(JetRptReportSet jetRptReportSet, JReportEngine jReportEngine, String string, JetLink jetLink, Vector vector, RuntimeInfo runtimeInfo) {
        Hashtable hashtable = new Hashtable();
        return EngineManager.createLinkedReportEngine(jetRptReportSet, jReportEngine, string, jetLink, vector, runtimeInfo, hashtable);
    }

    public static JREngine createLinkedReportEngine(JetRptReportSet jetRptReportSet, JReportEngine jReportEngine, String string, JetLink jetLink, Vector vector, RuntimeInfo runtimeInfo, Hashtable hashtable) {
        Object object;
        JRptSetEngine jRptSetEngine = jReportEngine.getReportViewCenter().getRptCenter().getRptSetCenter().getRptSetEngine();
        Object object2 = object = jRptSetEngine.isDhtmlInteract() ? null : jRptSetEngine.getPriorityLocker();
        if (object == null) {
            return EngineManager.addDetailReportEngine(jetRptReportSet, jReportEngine, string, jetLink, vector, runtimeInfo, hashtable);
        }
        return EngineManager.append(jetRptReportSet, jReportEngine, string, jetLink, vector, runtimeInfo, object, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JREngine append(JetRptReportSet jetRptReportSet, JReportEngine jReportEngine, String string, JetLink jetLink, Vector vector, RuntimeInfo runtimeInfo, Object object, Hashtable hashtable) {
        Object object2 = object;
        synchronized (object2) {
            JREngine jREngine = EngineManager.addDetailReportEngine(jetRptReportSet, jReportEngine, string, jetLink, vector, runtimeInfo, hashtable);
            return jREngine;
        }
    }
}

