/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.util;

import com.jinfonet.util.JRLog;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.connect.DbArray;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.controls.ColumnableMapping;
import jet.controls.JetBLColumnName;
import jet.controls.JetBLColumnable;
import jet.controls.JetColumnName;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetVector;
import jet.dataengine.api.DSException;
import jet.dataengine.api.JDataEngine;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IOperatorFactory;
import jet.dataengine.api.expression.IOperatorInforFactory;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IBinaryLogicExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.tuple.ITripleConditionExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.expression.tuple.op.IBinaryConditionOperator;
import jet.dataengine.api.expression.tuple.op.IBinaryLogicOperator;
import jet.dataengine.api.expression.tuple.op.IIn;
import jet.dataengine.api.expression.tuple.op.IMultiLogicOperator;
import jet.dataengine.api.expression.tuple.op.ISingleLogicOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.api.query.JIterativeQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.groupengine.GroupModel;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.UserException;
import jet.formula.Aggregation;
import jet.formula.FormulaContainer;
import jet.formula.FormulaInfo;
import jet.formula.FormulaQueue;
import jet.formula.FormulatoJava;
import jet.formula.JetRptFormula;
import jet.formula.JetRptSummary;
import jet.formula.ParamDesc;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReadFailureException;
import jet.jetc.ReportLoader;
import jet.jetc.WriteFailureException;
import jet.report.JRObjectTemplate;
import jet.report.JetRptColAttr;
import jet.report.JetRptCrosstab;
import jet.report.JetRptDataContainer;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptField;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptMultiValueContainer;
import jet.report.JetRptObject;
import jet.report.JetRptPageEnd;
import jet.report.JetRptPagePanel;
import jet.report.JetRptPageStart;
import jet.report.JetRptPicture;
import jet.report.JetRptReportBody;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSection;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSubLinkContainer;
import jet.report.JetRptSubReport;
import jet.report.JetRptSubReturnValueContainer;
import jet.report.JetRptView;
import jet.report.JetRptViews;
import jet.report.paragraph.build.JetRptParagraph;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableDetail;
import jet.report.tabular.JetRptTabular;
import jet.report.tabular.JetRptTabularCell;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.DataContainerLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ReportSetLogic;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptExtendsDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptengine.JSubLinkContainer;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.design.util.GetValueTools;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.pub.JDetailContainer;
import jet.rptservice.util.SubLinkProcessor;
import jet.rptservice.util.Tools;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFormula;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUHDSTable;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.exception.UniverseFileException;
import jet.upgrade.JUpgradeNotSupportedException;
import jet.upgrade.UpgradeUtil;
import jet.util.DbValueComparer;
import jet.util.EngineRuntimeInfo;
import jet.util.HashVector;
import jet.util.RuntimeInfo;
import jet.util.TreeIterater;

public class ReportTools {
    public static final int DATA_CONTAINER_COMMON = 0;
    public static final int DATA_CONTAINER_SECTION_OBJECT = 1;
    public static final int DATA_CONTAINER_CROSSTABLE = 2;
    public static final int DATA_CONTAINER_TABLE = 3;
    public static final int DATA_CONTAINER_REPORT_BODY = 4;
    public static final int DATA_CONTAINER_PARAGRAPH = 5;
    public static final int DATA_CONTAINER_TABULAR = 6;
    public static final int DATA_CONTAINER_TABULAR_CELL = 7;
    public static final int DATA_CONTAINER_MULTIVALUE_CONTAINER = 8;
    public static final int FORMULA_TYPE_CONSTANT_LEVER = 100;
    public static final int FORMULA_TYPE_PAGE_LEVER = 101;
    public static final int FORMULA_TYPE_GLOBAL_LEVER = 102;
    public static final int FORMULA_TYPE_GROUP_LEVER = 103;
    public static final int FORMULA_TYPE_RECORD_LEVER_PASS1 = 104;
    public static final int FORMULA_TYPE_RECORD_LEVER_PASS2 = 105;
    public static final int MAPPING_TYPE_DBFIELD = 0;
    public static final int MAPPING_TYPE_PARAMETER = 1;
    public static final int MAPPING_TYPE_FORMULA = 2;
    private static Hashtable GetCurrentUniverse = new Hashtable();
    private static Vector IsSum = new Vector();
    static Class class$jet$report$JetRptSectionObject;
    static Class class$jet$report$table$JetRptNewTable;
    static Class class$jet$report$JetRptCTCrossTab;
    static Class class$jet$report$chart$JetRptChartPlatform;
    static Class class$jet$report$JetRptSection;

    public static DataContainerLogic getDataContainerLogic(int n) {
        DataContainerLogic dataContainerLogic = null;
        String string = String.valueOf(n);
        if (GetCurrentUniverse.contains(string)) {
            return (DataContainerLogic)GetCurrentUniverse.get(string);
        }
        switch (n) {
            case 0: {
                dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
                break;
            }
            case 1: {
                dataContainerLogic = ObjectLogicFactory.getSectionObjectLogic();
                break;
            }
            case 2: {
                dataContainerLogic = ObjectLogicFactory.getCrosstabLogic();
                break;
            }
            case 4: {
                dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
                break;
            }
            case 3: {
                dataContainerLogic = ObjectLogicFactory.getTableLogic();
                break;
            }
            case 5: {
                dataContainerLogic = ObjectLogicFactory.getParagraphLogic();
                break;
            }
            case 6: {
                dataContainerLogic = ObjectLogicFactory.getTabularLogic();
                break;
            }
            case 7: {
                dataContainerLogic = ObjectLogicFactory.getMultiValueContainerLogic();
                break;
            }
            case 8: {
                dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
                break;
            }
            default: {
                dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
            }
        }
        GetCurrentUniverse.put(string, dataContainerLogic);
        return dataContainerLogic;
    }

    private static int GetCurrentUniverse(JetRptDataContainer jetRptDataContainer) {
        int n;
        if (jetRptDataContainer instanceof JetRptSectionObject) {
            n = 1;
        } else if (jetRptDataContainer instanceof JetRptCrosstab) {
            n = 2;
        } else if (jetRptDataContainer instanceof JetRptReportBody) {
            n = 4;
        } else if (jetRptDataContainer instanceof JetRptNewTable) {
            n = 3;
        } else if (jetRptDataContainer instanceof JetRptParagraph) {
            n = 5;
        } else if (jetRptDataContainer instanceof JetRptTabular) {
            n = 6;
        } else if (jetRptDataContainer instanceof JetRptTabularCell) {
            n = 7;
        } else if (jetRptDataContainer instanceof JetRptMultiValueContainer) {
            n = 8;
        } else {
            return -1;
        }
        return n;
    }

    public static DataContainerLogic getDataContainerLogic(JetRptDataContainer jetRptDataContainer) {
        int n = ReportTools.GetCurrentUniverse(jetRptDataContainer);
        return ReportTools.getDataContainerLogic(n);
    }

    public static DataSet getDataSet(JetRptObject jetRptObject) {
        if (jetRptObject == null) {
            return null;
        }
        JetRptDataContainer jetRptDataContainer = null;
        jetRptDataContainer = jetRptObject instanceof JetRptDataContainer ? (JetRptDataContainer)jetRptObject : ReportTools.getDataContainerLogic(0).getDataContainer(jetRptObject, true);
        if (jetRptDataContainer == null) {
            return null;
        }
        DataContainerLogic dataContainerLogic = ReportTools.getDataContainerLogic(jetRptDataContainer);
        return dataContainerLogic.getUsedDataSet(jetRptDataContainer);
    }

    public static DataSet getDataSet(JetRptDataContainer jetRptDataContainer) {
        DataContainerLogic dataContainerLogic = ReportTools.getDataContainerLogic(jetRptDataContainer);
        return dataContainerLogic.getUsedDataSet(jetRptDataContainer);
    }

    public static JetRptDataContainer getDataContainer(JetRptObject jetRptObject, boolean bl) {
        if (bl && jetRptObject instanceof JetRptDataContainer) {
            return (JetRptDataContainer)jetRptObject;
        }
        return ReportTools.getDataContainerLogic(0).getDataContainer(jetRptObject, true);
    }

    public static String getDataSourceName(JetRptDataContainer jetRptDataContainer) {
        DataContainerLogic dataContainerLogic = ReportTools.getDataContainerLogic(jetRptDataContainer);
        return dataContainerLogic.getUsedDatasourceName(jetRptDataContainer);
    }

    public static JetUUniverse loadUniverse(String string) throws ReadFailureException, UniverseFileException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ReportTools.loadUniverse()... catName=" + string);
        }
        JetUUniverse jetUUniverse = JetUUniverse.LoadUniverse(string);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ReportTools.loadUniverse()... catName = " + string + " universe = " + jetUUniverse);
        }
        return jetUUniverse;
    }

    public static JetRptReportSet loadReportSet(String string, String string2, boolean bl, JetUUniverse jetUUniverse) throws ReadFailureException {
        JetRptReportSet jetRptReportSet;
        long l;
        block8: {
            l = System.currentTimeMillis();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportTools.loadReportSet()... rptSetName=" + string + " styleGroupName = " + string2 + " bCache: " + bl + " universe: " + jetUUniverse);
            }
            jetRptReportSet = null;
            try {
                Object object;
                JetObject jetObject = null;
                String string3 = null;
                if (bl) {
                    object = new ReportLoader(string);
                    ((LoaderNoCache)object).setEditable(true);
                    jetObject = ReportTools.LOGIC_PAGE((LoaderNoCache)object, jetUUniverse);
                    string3 = ((LoaderNoCache)object).getFilePath();
                } else {
                    object = new LoaderNoCache(string);
                    jetObject = ReportTools.LOGIC_PAGE((LoaderNoCache)object, jetUUniverse);
                    string3 = ((LoaderNoCache)object).getFilePath();
                }
                if (jetObject instanceof JetRptReportSet) {
                    Tools.logTrace(6, "convert reportset to current reportset.");
                    jetRptReportSet = jetUUniverse != null || ((JetRptReportSet)jetObject).isBoundled() ? ReportTools.IsSum(jetUUniverse, (JetRptReportSet)jetObject, ((JetRptReportSet)jetObject).isBoundled()) : (JetRptReportSet)jetObject;
                    jetRptReportSet.setPath(string3);
                    break block8;
                }
                if (jetObject instanceof JetRptReportPanel) {
                    Tools.logTrace(6, "convert report panel to report set.");
                    object = (JetRptReportPanel)jetObject;
                    jetRptReportSet = ReportTools.IsSum(jetUUniverse, (JetRptObject)jetObject, ((JetRptReportPanel)object).isBundled());
                    break block8;
                }
                throw new ReadFailureException();
            }
            catch (ReadFailureException readFailureException) {
                JRLog.error(1, readFailureException);
                throw readFailureException;
            }
        }
        jetRptReportSet.setFullFileName(string);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ReportTools.loadReportSet()#######! cost time =" + (System.currentTimeMillis() - l));
            JRLog.trace(6, "End of ReportTools.loadReportSet()! rptSet=" + jetRptReportSet);
        }
        return jetRptReportSet;
    }

    private static JetRptReportSet IsSum(JetUUniverse jetUUniverse, JetRptObject jetRptObject, boolean bl) throws ReadFailureException {
        JetRptReportSet jetRptReportSet = null;
        try {
            if (bl) {
                jetRptReportSet = (JetRptReportSet)UpgradeUtil.upgradeRpt(jetRptObject);
            } else {
                if (jetUUniverse == null) {
                    JUpgradeNotSupportedException jUpgradeNotSupportedException = new JUpgradeNotSupportedException(215003);
                    throw new ReadFailureException(jUpgradeNotSupportedException);
                }
                jetRptReportSet = (JetRptReportSet)UpgradeUtil.upgradeRpt(jetRptObject, jetUUniverse);
            }
        }
        catch (JUpgradeNotSupportedException jUpgradeNotSupportedException) {
            throw new ReadFailureException();
        }
        return jetRptReportSet;
    }

    private static synchronized JetObject LOGIC_PAGE(LoaderNoCache loaderNoCache, JetUUniverse jetUUniverse) throws ReadFailureException {
        JetUUniverse jetUUniverse2 = JetUUniverse.GetCurrentUniverse();
        JetUUniverse.setUniverse(jetUUniverse);
        JetObject jetObject = loaderNoCache.load();
        JetUUniverse.setUniverse(jetUUniverse2);
        return jetObject;
    }

    public static String[] getCurrentReportName(JetRptReportSet jetRptReportSet) {
        String[] stringArray = new String[2];
        String string = jetRptReportSet.getCurReportId();
        JetRptReport jetRptReport = jetRptReportSet.getReport(string);
        String string2 = jetRptReport.getCurViewName();
        stringArray[0] = string;
        stringArray[1] = string2;
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openAllReportView(JetRptReportSet jetRptReportSet) {
        JetRptReportSet jetRptReportSet2 = jetRptReportSet;
        synchronized (jetRptReportSet2) {
            String[] stringArray = jetRptReportSet.getAllReportsName();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[n]);
                jetRptReport.setStatus(0);
                JetRptViews jetRptViews = jetRptReport.getViews();
                String[] stringArray2 = jetRptViews.getAllViewNames();
                if (stringArray2 != null) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        JetRptView jetRptView = jetRptViews.getRptView(stringArray2[n2]);
                        jetRptView.setStatus(0);
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public static Vector[] getOpenReportViews(JetRptReportSet jetRptReportSet, String[] stringArray) {
        if (jetRptReportSet == null) {
            Tools.logTrace(6, "ReportTools.getOperReportViews()..., Error: rptSet can't be null.");
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            vectorArray[n] = new Vector();
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[n]);
            String[] stringArray2 = jetRptReport.getOpenedViewNames();
            if (stringArray2 != null && stringArray2.length != 0) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    vectorArray[n].addElement(stringArray2[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return vectorArray;
    }

    public static void openReports(JetRptReportSet jetRptReportSet, String[] stringArray) {
        if (jetRptReportSet == null || stringArray == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportTools.openReports(), rptSet = " + jetRptReportSet + " rptNames = " + stringArray);
            }
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[n]);
            jetRptReport.setStatus(0);
            String[] stringArray2 = jetRptReport.getAllViewName();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                JetRptView jetRptView = jetRptReport.getViewObject(stringArray2[n]);
                jetRptView.setStatus(0);
                ++n2;
            }
            ++n;
        }
    }

    public static void openReportViews(JetRptReportSet jetRptReportSet, String[] stringArray, Vector[] vectorArray) {
        if (jetRptReportSet == null || stringArray == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportTools.openReports(), rptSet = " + jetRptReportSet + " rptNames = " + stringArray + " vRptViews = " + vectorArray);
            }
            return;
        }
        if (stringArray.length != vectorArray.length) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportTools.openReports(), rptNames.length = " + stringArray.length + " vRptViews.length = " + vectorArray.length);
            }
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[n]);
            jetRptReport.setStatus(0);
            String[] stringArray2 = vectorArray[n].toArray(new String[0]);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                JetRptView jetRptView = jetRptReport.getViewObject(stringArray2[n]);
                jetRptView.setStatus(0);
                ++n2;
            }
            ++n;
        }
    }

    public static void setCurrentReportView(JetRptReportSet jetRptReportSet, String string, String string2) {
        jetRptReportSet.setCurReportId(string);
        JetRptReport jetRptReport = jetRptReportSet.getReport(string);
        if (jetRptReport.getStatus() != 0) {
            jetRptReport.setStatus(0);
        }
        jetRptReport.setCurViewName(string2);
        JetRptView jetRptView = jetRptReport.getViewObject(string2);
        if (jetRptView.getStatus() != 0) {
            jetRptView.setStatus(0);
        }
    }

    public static IBooleanExpression getExpression(JDetailContainer jDetailContainer, JetUUniverse jetUUniverse) throws JRScheduleException, ConditionException {
        int[] nArray;
        Vector vector;
        IBooleanExpression iBooleanExpression;
        IBooleanExpression iBooleanExpression2 = null;
        DataSet dataSet = jDetailContainer.getDataSet();
        String string = dataSet.getDataSourceName();
        String string2 = dataSet.getQueryName();
        DbValueComparer dbValueComparer = jDetailContainer.getJoin();
        if (dbValueComparer != null) {
            iBooleanExpression2 = ReportTools.getExpression(dbValueComparer, jetUUniverse, string, string2);
        }
        IBooleanExpression iBooleanExpression3 = (iBooleanExpression = ReportTools.LoadUniverse(vector = jDetailContainer.getCondition(), nArray = jDetailContainer.getLogics(), jetUUniverse, string, string2)) == null ? iBooleanExpression2 : ExpressionToolKit.buildAndExpression(iBooleanExpression2, iBooleanExpression);
        return iBooleanExpression3;
    }

    private static IBooleanExpression LoadUniverse(Vector vector, int[] nArray, JetUUniverse jetUUniverse, String string, String string2) throws JRScheduleException, ConditionException {
        IBooleanExpression iBooleanExpression;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        IBooleanExpression iBooleanExpression2 = null;
        Vector<IBooleanExpression> vector2 = new Vector<IBooleanExpression>();
        int n = 0;
        while (n < vector.size()) {
            DbValueComparer dbValueComparer = (DbValueComparer)vector.elementAt(n);
            iBooleanExpression = ReportTools.getExpression(dbValueComparer, jetUUniverse, string, string2);
            IBooleanExpression iBooleanExpression3 = iBooleanExpression2 = iBooleanExpression2 == null ? iBooleanExpression : ReportTools.QOIV(iBooleanExpression2, iBooleanExpression);
            if (nArray[n] == 1 || nArray[n] == 2) {
                vector2.addElement(iBooleanExpression2);
                iBooleanExpression2 = null;
            }
            ++n;
        }
        iBooleanExpression2 = null;
        int n2 = 0;
        while (n2 < vector2.size()) {
            iBooleanExpression = (IBooleanExpression)vector2.elementAt(n2);
            iBooleanExpression2 = iBooleanExpression2 == null ? iBooleanExpression : ReportTools.Z(iBooleanExpression2, iBooleanExpression);
            ++n2;
        }
        return iBooleanExpression2;
    }

    public static IBooleanExpression getExpression(JSubLinkContainer jSubLinkContainer, JetUUniverse jetUUniverse) throws JRScheduleException, ConditionException {
        Tools.logTrace(6, "ReportTools.getExpression(JSubLinkContainer,JetUUniverse)...");
        List list = jSubLinkContainer.getSubLinks();
        if (list == null || list.size() == 0) {
            Tools.logTrace(6, "return: null.");
            Tools.logTrace(6, "End of ReportTools.getExpression(JSubLinkContainer,JetUUniverse).");
            return null;
        }
        DataSet dataSet = jSubLinkContainer.getDataSet();
        String string = dataSet.getDataSourceName();
        String string2 = dataSet.getQueryName();
        Object object = null;
        int n = 0;
        while (n < list.size()) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(n);
            object = ReportTools.QOIV((IBooleanExpression)object, ReportTools.getExpression(dbValueComparer, jetUUniverse, string, string2));
            ++n;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "return: " + object.toString());
            JRLog.trace(6, "End of ReportTools.getExpression(JSubLinkContainer,JetUUniverse).");
        }
        return object;
    }

    public static IExpression getExpression(IExpression iExpression, JSubLinkContainer jSubLinkContainer, JetUUniverse jetUUniverse) throws JRScheduleException, ConditionException {
        return ReportTools.getAndExpression(iExpression, ReportTools.getExpression(jSubLinkContainer, jetUUniverse));
    }

    public static IExpression getExpression(IBooleanExpression iBooleanExpression, List list, JetUUniverse jetUUniverse, String string, String string2) throws JRScheduleException, ConditionException {
        if (list == null || list.size() == 0) {
            return iBooleanExpression;
        }
        IBooleanExpression iBooleanExpression2 = iBooleanExpression;
        int n = 0;
        while (n < list.size()) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(n);
            IBooleanExpression iBooleanExpression3 = ReportTools.getExpression(dbValueComparer, jetUUniverse, string, string2);
            iBooleanExpression2 = iBooleanExpression2 == null ? iBooleanExpression3 : ReportTools.QOIV(iBooleanExpression2, iBooleanExpression3);
            ++n;
        }
        return iBooleanExpression2;
    }

    public static IExpression getOrExpression(IBooleanExpression iBooleanExpression, List list, JetUUniverse jetUUniverse, String string, String string2) throws JRScheduleException, ConditionException {
        if (list == null || list.size() == 0) {
            return iBooleanExpression;
        }
        IBooleanExpression iBooleanExpression2 = iBooleanExpression;
        int n = 0;
        while (n < list.size()) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(n);
            IBooleanExpression iBooleanExpression3 = ReportTools.getExpression(dbValueComparer, jetUUniverse, string, string2);
            iBooleanExpression2 = iBooleanExpression2 == null ? iBooleanExpression3 : ReportTools.Z(iBooleanExpression2, iBooleanExpression3);
            ++n;
        }
        return iBooleanExpression2;
    }

    public static String getWhereString(JSubLinkContainer jSubLinkContainer) {
        List list = jSubLinkContainer.getSubLinks();
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        int n2 = 0;
        while (n2 < list.size()) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(n2);
            stringBuffer.append(dbValueComparer.getColumnName() + " ");
            stringBuffer.append(dbValueComparer.getOperString() + " ");
            stringBuffer.append(dbValueComparer.getValueString() + " ");
            if (n2 != n - 1) {
                stringBuffer.append("and ");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static IBooleanExpression QOIV(IBooleanExpression iBooleanExpression, IBooleanExpression iBooleanExpression2) throws ConditionException {
        if (iBooleanExpression == null) {
            return iBooleanExpression2;
        }
        if (iBooleanExpression2 == null) {
            return iBooleanExpression;
        }
        return ExpressionToolKit.buildAndExpression(iBooleanExpression, iBooleanExpression2);
    }

    private static IBooleanExpression Z(IBooleanExpression iBooleanExpression, IBooleanExpression iBooleanExpression2) throws ConditionException {
        if (iBooleanExpression == null) {
            return iBooleanExpression2;
        }
        if (iBooleanExpression2 == null) {
            return iBooleanExpression;
        }
        return (IBooleanExpression)ExpressionToolKit.buildOrExpression(iBooleanExpression, iBooleanExpression2);
    }

    public static IExpression getAndExpression(IExpression iExpression, IBooleanExpression iBooleanExpression) throws ConditionException {
        if (iExpression == null) {
            return iBooleanExpression;
        }
        if (iBooleanExpression == null) {
            return iExpression;
        }
        ISetExpression iSetExpression = null;
        IBooleanExpression iBooleanExpression2 = null;
        IMultiLogicExpression iMultiLogicExpression = null;
        if (ExpressionToolKit.isBooleanExp(iExpression.expressionType())) {
            return ExpressionToolKit.buildAndExpression((IBooleanExpression)iExpression, iBooleanExpression);
        }
        if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            iSetExpression = ReportTools.access$100(iExpression);
        }
        if ((iBooleanExpression2 = ReportTools.access$200(iExpression)) == null) {
            iSetExpression.setExpression(iBooleanExpression);
        } else {
            iMultiLogicExpression = ExpressionToolKit.buildAndExpression(iBooleanExpression2, iBooleanExpression);
            iSetExpression.setExpression(iMultiLogicExpression);
        }
        return iExpression;
    }

    private static ISetExpression access$100(IExpression iExpression) {
        if (!ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            return null;
        }
        IExpression iExpression2 = ((ISetExpression)iExpression).getExpression();
        IExpression iExpression3 = iExpression;
        while (iExpression2 != null && !ExpressionToolKit.isTupleExp(iExpression2.expressionType())) {
            iExpression3 = iExpression2;
            iExpression2 = ((ISetExpression)iExpression2).getExpression();
        }
        return (ISetExpression)iExpression3;
    }

    /*
     * Unable to fully structure code
     */
    private static IBooleanExpression access$200(IExpression var0) {
        if (var0 != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (ExpressionToolKit.isSetExp(var0.expressionType())) {
                var0 = ((ISetExpression)var0).getExpression();
                continue;
            }
            throw new RuntimeException();
lbl7:
            // 2 sources

            ** while (var0 != null && !ExpressionToolKit.isTupleExp((int)var0.expressionType()))
        }
lbl8:
        // 1 sources

        return (IBooleanExpression)var0;
    }

    public static IBooleanExpression getExpression(DbValueComparer dbValueComparer, JetUUniverse jetUUniverse, String string, String string2) throws ConditionException, JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ReportTools.getExpression(DbValueComparer,JetUUniverse,String,String)...");
            JRLog.trace(6, "colName: " + dbValueComparer.getColumnName() + " op: " + dbValueComparer.getOperString() + " value: " + Tools.toString(ReportTools.add(dbValueComparer.getValue()).toArray()) + " dataSourceName: " + string + " queryName: " + string2);
        }
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory(jetUUniverse, string);
        IOperatorFactory iOperatorFactory = ExpressionFactoryCreator.getIOperatorFactory();
        IOperatorInforFactory iOperatorInforFactory = ExpressionFactoryCreator.getIOperatorInforFactory();
        String string3 = dbValueComparer.getColumnName();
        int n = ReportTools.access$300(dbValueComparer.operator);
        IVariableExpression iVariableExpression = null;
        int n2 = ReportTools.getMappingNameType(jetUUniverse, string, string2, string3);
        switch (n2) {
            case 0: {
                iVariableExpression = iExpressionFactory.createReference(string3);
                break;
            }
            case 1: {
                iVariableExpression = iExpressionFactory.createParameter(string3, false);
                break;
            }
            case 2: {
                iVariableExpression = iExpressionFactory.createFormula(string3);
                break;
            }
            default: {
                Tools.logTrace(6, "invalid type of mapping type, return null.");
                Tools.logTrace(6, "End of ReportTools.getExpression(DbValueComparer,JetUUniverse,String,String).");
                return null;
            }
        }
        IBinaryConditionOperator iBinaryConditionOperator = null;
        IBinaryConditionExpression iBinaryConditionExpression = null;
        DbValue dbValue = dbValueComparer.getValue();
        if (dbValue == null) {
            Tools.logTrace(6, "value is null, return null.");
            Tools.logTrace(6, "End of ReportTools.getExpression(DbValueComparer,JetUUniverse,String,String).");
            return null;
        }
        if (dbValue.isNull()) {
            ISingleConditionExpression iSingleConditionExpression = iExpressionFactory.createSingleConditionExp(iOperatorFactory.createSingleConsitionOp(0x11300001), iVariableExpression);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "value.isNull()=ture, return: " + iSingleConditionExpression.toExpString());
                JRLog.trace(6, "End of ReportTools.getExpression(DbValueComparer,JetUUniverse,String,String).");
            }
            return iSingleConditionExpression;
        }
        List list = ReportTools.add(dbValue);
        if (list == null || list.size() == 0) {
            Tools.logTrace(6, "value list is null or blank, return null.");
            Tools.logTrace(6, "End of ReportTools.getExpression(DbValueComparer,JetUUniverse,String,String).");
            return null;
        }
        if (n == 556793857) {
            iBinaryConditionOperator = iOperatorFactory.createInOp();
            IVariableList iVariableList = iExpressionFactory.createVariableList("");
            int n3 = 0;
            while (n3 < list.size()) {
                IConstant iConstant = iExpressionFactory.createConstant((String)list.get(n3));
                iVariableList.addConstant(iConstant);
                ++n3;
            }
            iBinaryConditionExpression = iExpressionFactory.createBinaryInExp((IIn)iBinaryConditionOperator, iVariableExpression, iVariableList);
        } else {
            iBinaryConditionOperator = iOperatorFactory.createBinaryConditionOp(n);
            iBinaryConditionExpression = iExpressionFactory.createBinaryConditionExp(iBinaryConditionOperator, iVariableExpression, (IVariableExpression)iExpressionFactory.createConstant((String)list.get(0)));
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "return: " + iBinaryConditionExpression.toExpString());
            JRLog.trace(6, "End of ReportTools.getExpression(DbValueComparer,JetUUniverse,String,String).");
        }
        return iBinaryConditionExpression;
    }

    private static int access$300(int n) throws JRScheduleException {
        switch (n) {
            case 0: {
                return 556793872;
            }
            case 1: {
                return 556793888;
            }
            case 2: {
                return 556794112;
            }
            case 4: {
                return 556794368;
            }
            case 3: {
                return 556793920;
            }
            case 5: {
                return 556793984;
            }
            case 6: {
                return 556793857;
            }
        }
        throw new JRScheduleException(220004, new String[]{String.valueOf(n)}, null);
    }

    public static void saveToXml(JetRptObject jetRptObject, String string) throws WriteFailureException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "saveToXml.saveToXml()..., o: " + jetRptObject + " file: " + string);
        }
        try {
            ReportLoader.save((JetObject)jetRptObject, "", string);
        }
        catch (WriteFailureException writeFailureException) {
            JRLog.error(2, writeFailureException);
            throw writeFailureException;
        }
        Tools.logTrace(6, "save sucessfully!");
    }

    public static Vector getLinkedTargetComp(JRObjectTemplate jRObjectTemplate) {
        if (jRObjectTemplate instanceof JetRptField) {
            return ((JetRptField)jRObjectTemplate).linkTargetCompInst.get();
        }
        return null;
    }

    public static JetRptReportSet shrinkReportSet(JetRptReportSet jetRptReportSet, Vector vector, boolean bl) {
        ReportSetLogic reportSetLogic = ObjectLogicFactory.getReportSetLogic();
        JetRptReportSet jetRptReportSet2 = jetRptReportSet;
        if (bl) {
            jetRptReportSet2 = (JetRptReportSet)jetRptReportSet.deepDupWithName();
        }
        return reportSetLogic.shrinkReportSet(jetRptReportSet2, vector);
    }

    private static List add(DbValue dbValue) {
        if (dbValue.bNull) {
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        if (dbValue instanceof DbArray) {
            return ReportTools.addConstant((DbArray)dbValue);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (dbValue instanceof DbDateTime) {
            String string2 = null;
            string2 = dbValue instanceof DbDate ? "yyyy-MM-dd" : (dbValue instanceof DbTime ? "HH:mm:ss" : "yyyy-MM-dd HH:mm:ss");
            string = ((DbDateTime)dbValue).toFormatString(string2);
        } else {
            string = dbValue.toString();
        }
        arrayList.add(string);
        return arrayList;
    }

    private static List addConstant(DbArray dbArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = dbArray.getColDesc().sqlType;
        switch (n) {
            case -7: {
                boolean[] blArray = (boolean[])dbArray.getValue();
                int n2 = 0;
                while (n2 < blArray.length) {
                    arrayList.add(String.valueOf(blArray[n2]));
                    ++n2;
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])dbArray.getValue();
                int n3 = 0;
                while (n3 < byArray.length) {
                    arrayList.add(String.valueOf(byArray[n3]));
                    ++n3;
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])dbArray.getValue();
                int n4 = 0;
                while (n4 < sArray.length) {
                    arrayList.add(String.valueOf(sArray[n4]));
                    ++n4;
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])dbArray.getValue();
                int n5 = 0;
                while (n5 < nArray.length) {
                    arrayList.add(String.valueOf(nArray[n5]));
                    ++n5;
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])dbArray.getValue();
                int n6 = 0;
                while (n6 < lArray.length) {
                    arrayList.add(String.valueOf(lArray[n6]));
                    ++n6;
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long[] lArray = (long[])dbArray.getValue();
                int[] nArray = null;
                SimpleDateFormat simpleDateFormat = null;
                if (n == 91) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                } else if (n == 92) {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                } else {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    nArray = dbArray.getNanos();
                }
                if (n == 93) {
                    if (nArray != null) {
                        int n7 = 0;
                        while (n7 < lArray.length) {
                            arrayList.add(simpleDateFormat.format(new Date(lArray[n7] + (long)(nArray[n7] / 1000000))));
                            ++n7;
                        }
                    } else {
                        int n8 = 0;
                        while (n8 < lArray.length) {
                            arrayList.add(simpleDateFormat.format(new Date(lArray[n8])));
                            ++n8;
                        }
                    }
                } else {
                    int n9 = 0;
                    while (n9 < lArray.length) {
                        arrayList.add(simpleDateFormat.format(new Date(lArray[n9])));
                        ++n9;
                    }
                }
                break;
            }
            case 6: 
            case 7: {
                float[] fArray2 = (float[])dbArray.getValue();
                int n10 = 0;
                while (n10 < fArray2.length) {
                    arrayList.add(String.valueOf(fArray2[n10]));
                    ++n10;
                }
                break;
            }
            case 8: {
                double[] dArray = (double[])dbArray.getValue();
                int n11 = 0;
                while (n11 < dArray.length) {
                    arrayList.add(String.valueOf(dArray[n11]));
                    ++n11;
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])dbArray.getValue();
                int n12 = 0;
                while (n12 < bigDecimalArray.length) {
                    arrayList.add(String.valueOf(bigDecimalArray));
                    ++n12;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])dbArray.getValue();
                int n13 = 0;
                while (n13 < stringArray.length) {
                    arrayList.add(stringArray[n13]);
                    ++n13;
                }
                break;
            }
            default: {
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "invalid sql type: " + n);
            }
        }
        return arrayList;
    }

    public static boolean hasSubLink(JetRptSubReport jetRptSubReport) {
        return ReportTools.hasSubLink(jetRptSubReport, null);
    }

    public static boolean hasSubLink(JetRptSubReport jetRptSubReport, JetRptDataContainer jetRptDataContainer) {
        Object object;
        boolean bl = false;
        List list = jetRptSubReport.getSubLinkContainers();
        String string = null;
        if (jetRptDataContainer != null) {
            string = jetRptDataContainer.getInstName();
        }
        if (list != null) {
            object = null;
            int n = 0;
            while (n < list.size()) {
                List list2;
                object = (JetRptSubLinkContainer)list.get(n);
                if (string != null ? ((JetRptSubLinkContainer)object).targetCompInst != null && ((JetRptSubLinkContainer)object).targetCompInst.get().contains(string) : (list2 = ((JetRptSubLinkContainer)object).getSubLinks()) != null && list2.size() > 0) {
                    return true;
                }
                ++n;
            }
        }
        if (string == null && (object = jetRptSubReport.getParameterLinks()) != null && object.size() > 0) {
            return true;
        }
        object = jetRptSubReport.getSubReturnValueContainers();
        if (object != null) {
            int n = 0;
            while (n < object.size()) {
                List list3;
                JetRptSubReturnValueContainer jetRptSubReturnValueContainer = (JetRptSubReturnValueContainer)object.get(n);
                if (string != null ? jetRptSubReturnValueContainer.returnValueComponent != null && jetRptSubReturnValueContainer.returnValueComponent.get().equals(string) : (list3 = jetRptSubReturnValueContainer.getReturnVlaues()) != null && list3.size() > 0) {
                    return true;
                }
                ++n;
            }
        }
        return bl;
    }

    public static List getDBFieldNameList(JetUUniverse jetUUniverse, String string, JetUFormulaInterface jetUFormulaInterface) {
        Vector vector = new Vector();
        ReportTools.addDataSet(jetUUniverse, string, jetUFormulaInterface, vector);
        return vector;
    }

    private static void addDataSet(JetUUniverse jetUUniverse, String string, JetUFormulaInterface jetUFormulaInterface, Vector vector) {
        FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
        Vector vector2 = formulaInfo.refDBfield;
        Vector vector3 = formulaInfo.refFormula;
        int n = 0;
        while (n < vector2.size()) {
            String string2 = ((String)vector2.elementAt(n)).toUpperCase();
            if (!vector.contains(string2)) {
                vector.addElement(string2);
            }
            ++n;
        }
        int n2 = vector3.size();
        int n3 = 0;
        while (n3 < n2) {
            String string3 = (String)vector3.elementAt(n3);
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getMaterialByName(string, string3);
            if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormulaInterface) {
                ReportTools.addDataSet(jetUUniverse, string, (JetUFormulaInterface)((Object)jetUResourceEntity), vector);
            }
            ++n3;
        }
    }

    public static List getParamNameList(JetUUniverse jetUUniverse, String string, JetUFormulaInterface jetUFormulaInterface) {
        Vector vector = new Vector();
        ReportTools.addElement(jetUUniverse, string, jetUFormulaInterface, vector);
        return vector;
    }

    private static void addElement(JetUUniverse jetUUniverse, String string, JetUFormulaInterface jetUFormulaInterface, Vector vector) {
        FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
        Vector vector2 = formulaInfo.refParameter;
        Vector vector3 = formulaInfo.refFormula;
        int n = 0;
        while (n < vector2.size()) {
            String string2 = ((String)vector2.elementAt(n)).toUpperCase();
            if (!vector.contains(string2)) {
                vector.addElement(string2);
            }
            ++n;
        }
        int n2 = vector3.size();
        int n3 = 0;
        while (n3 < n2) {
            String string3 = (String)vector3.elementAt(n3);
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getMaterialByName(string, string3);
            if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormulaInterface) {
                ReportTools.addElement(jetUUniverse, string, (JetUFormulaInterface)((Object)jetUResourceEntity), vector);
            }
            ++n3;
        }
    }

    public static HashVector getRefUFmls(JetUUniverse jetUUniverse, String string, JetUFormula jetUFormula) {
        HashVector hashVector = new HashVector();
        ReportTools.addReport(jetUUniverse, string, jetUFormula, hashVector);
        return hashVector;
    }

    private static void addReport(JetUUniverse jetUUniverse, String string, JetUFormula jetUFormula, HashVector hashVector) {
        String string2 = jetUFormula.getResourceName().toUpperCase();
        if (!hashVector.contains(string2)) {
            hashVector.put(string2, jetUFormula);
            FormulaInfo formulaInfo = jetUFormula.getFormulaInfo();
            Vector vector = formulaInfo.refFormula;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string3 = (String)vector.elementAt(n2);
                JetUResourceEntity jetUResourceEntity = jetUUniverse.getMaterialByName(string, string3);
                if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula) {
                    ReportTools.addReport(jetUUniverse, string, (JetUFormula)jetUResourceEntity, hashVector);
                }
                ++n2;
            }
        }
    }

    public static int getFormulaType(JetUUniverse jetUUniverse, String string, JetUFormula jetUFormula) {
        int n = -1;
        if (!jetUFormula.isParsedOK()) {
            return n;
        }
        FormulaInfo formulaInfo = jetUFormula.formulainfo;
        n = formulaInfo.formulatype.getAttr() == 9 ? 100 : (formulaInfo.isUsePageVar() || formulaInfo.isNextPrev() || formulaInfo.isNoRecordCalled() ? 101 : (formulaInfo.formulatype.IsSum() ? 103 : (formulaInfo.isGlobal && !formulaInfo.isSysVar() && formulaInfo.refDBfield.size() < 1 && formulaInfo.refFormula.size() < 1 ? 102 : (formulaInfo.isGroupby ? 105 : 104))));
        return n;
    }

    public static IExpression getIExpression(JetRptDataContainer jetRptDataContainer, JSubLinkContainer jSubLinkContainer, SubLinkProcessor subLinkProcessor, JetUUniverse jetUUniverse) throws JRScheduleException {
        List list;
        String string = jetRptDataContainer.getInstName();
        IBooleanExpression iBooleanExpression = null;
        if (jSubLinkContainer != null && (list = jSubLinkContainer.getDataContainerNames()) != null && list.contains(string)) {
            try {
                iBooleanExpression = subLinkProcessor.getExpression(jSubLinkContainer, jetUUniverse);
            }
            catch (ConditionException conditionException) {
                throw new JRScheduleException(225002, new String[]{" DataContainer [" + jetRptDataContainer.getInstName() + "]"}, conditionException);
            }
        }
        return iBooleanExpression;
    }

    public static int getMappingNameType(JetUUniverse jetUUniverse, String string, String string2, String string3) throws JRScheduleException {
        JetUDBTreeNode jetUDBTreeNode;
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        if (jetUQueriable != null && (jetUDBTreeNode = jetUQueriable.getFieldByResourceName(string3)) != null) {
            return 0;
        }
        jetUDBTreeNode = jetUUniverse.getDatabase(string);
        if (jetUDBTreeNode == null) {
            throw new JRScheduleException(220021, new String[]{string3, string, string2}, null);
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetUDBTreeNode).getResourceByName(string3);
        if (jetUResourceEntity == null) {
            throw new JRScheduleException(220021, new String[]{string3, string, string2}, null);
        }
        if (jetUResourceEntity instanceof JetUParameter) {
            return 1;
        }
        if (jetUResourceEntity instanceof JetUFormula) {
            return 2;
        }
        throw new JRScheduleException(220021, new String[]{string3, string, string2}, null);
    }

    public static void addMappingNames(Vector vector, String string) {
        if (string != null && string.trim().length() > 0 && !vector.contains(string)) {
            vector.add(string);
        }
    }

    public static Hashtable getBranchToFmls(Vector vector, Hashtable hashtable, int n) {
        Hashtable<String, Vector<Object>> hashtable2 = new Hashtable<String, Vector<Object>>();
        if (vector == null) {
            return hashtable2;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            JetRptFormula jetRptFormula = (JetRptFormula)vector.elementAt(n2);
            String string = jetRptFormula.getName();
            String string2 = hashtable != null && hashtable.containsKey(string) ? (String)hashtable.get(string) : "";
            Vector<Object> vector2 = (Vector<Object>)hashtable2.get(string2);
            if (vector2 == null) {
                vector2 = new Vector<Object>();
                hashtable2.put(string2, vector2);
            }
            if (n == 0) {
                vector2.addElement(jetRptFormula.name.get());
            } else {
                vector2.addElement(jetRptFormula.getColDesc());
            }
            ++n2;
        }
        return hashtable2;
    }

    public static void getBranchToFilter(String string, Hashtable hashtable, Hashtable hashtable2, JSubLinkContainer jSubLinkContainer, Hashtable hashtable3, Hashtable hashtable4, JetUUniverse jetUUniverse) {
        List list;
        if (jSubLinkContainer != null && (list = jSubLinkContainer.getDataContainerNames()) != null && list.contains(string)) {
            ReportTools.getBranchToDbValueComparer(hashtable, hashtable2, jSubLinkContainer.getSubLinks(), hashtable3, hashtable4);
        }
    }

    public static void getBranchToDbValueComparer(Hashtable hashtable, Hashtable hashtable2, List list, Hashtable hashtable3, Hashtable hashtable4) {
        if (list != null && list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                Object object;
                DbValueComparer dbValueComparer = (DbValueComparer)list.get(n);
                String string = dbValueComparer.columnName;
                if (hashtable4.containsKey(string.toUpperCase())) {
                    object = (ParamDesc)hashtable4.get(string.toUpperCase());
                    ((ParamDesc)object).set(dbValueComparer.getValue());
                } else {
                    String string2 = ReportTools.getAvailableBranch(string, hashtable, hashtable2);
                    Vector<Object> vector = (Vector<Object>)hashtable3.get(string2);
                    if (vector == null) {
                        vector = new Vector<Object>();
                        hashtable3.put(string2, vector);
                    }
                    object = new DbValueComparer();
                    ((DbValueComparer)object).columnName = dbValueComparer.columnName;
                    ((DbValueComparer)object).value = (DbValue)dbValueComparer.value.clone();
                    ((DbValueComparer)object).operator = dbValueComparer.operator;
                    vector.addElement(object);
                }
                ++n;
            }
        }
    }

    public static String getAvailableBranch(String string, Hashtable hashtable, Hashtable hashtable2) {
        String string2 = "";
        if (hashtable != null) {
            String string3 = (String)hashtable.get(string);
            if (string3 != null) {
                string2 = string3;
            } else if (hashtable2 != null && (string3 = (String)hashtable2.get(string)) != null) {
                string2 = string3;
            }
        }
        return string2;
    }

    public static Hashtable mergeBranchToFilter(Hashtable hashtable, Hashtable hashtable2) {
        int n;
        Vector vector;
        Vector vector2;
        String string;
        Enumeration enumeration;
        Hashtable hashtable3 = new Hashtable();
        if (hashtable != null && hashtable.size() > 0) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector2 = (Vector)hashtable.get(string);
                vector = new Vector();
                n = 0;
                while (n < vector2.size()) {
                    vector.addElement(vector2.elementAt(n));
                    ++n;
                }
                hashtable3.put(string, vector);
            }
        }
        if (hashtable2 != null && hashtable2.size() > 0) {
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector2 = (Vector)hashtable2.get(string);
                vector = (Vector)hashtable3.get(string);
                if (vector == null) {
                    vector = new Vector();
                    hashtable3.put(string, vector);
                }
                n = 0;
                while (n < vector2.size()) {
                    vector.addElement(vector2.elementAt(n));
                    ++n;
                }
            }
        }
        return hashtable3;
    }

    public static Map divideIExpressionByBranch(ITupleExpression iTupleExpression, Map map) throws UserException, ConditionException {
        Hashtable hashtable = new Hashtable(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ITupleExpression iTupleExpression2 = ReportTools.checkITupleExpression(iTupleExpression, (List)entry.getValue());
            if (iTupleExpression2 == null) continue;
            hashtable.put(entry.getKey(), iTupleExpression2);
        }
        return hashtable;
    }

    private static IBinaryConditionExpression append(IBinaryConditionExpression iBinaryConditionExpression, List list) throws UserException, ConditionException {
        IExpression iExpression = iBinaryConditionExpression.getExpression2();
        int n = iExpression.expressionType();
        if (ExpressionToolKit.isConstant(n) || ExpressionToolKit.isVariableList(n)) {
            IExpression iExpression2 = iBinaryConditionExpression.getExpression1();
            n = iExpression2.expressionType();
            if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isFormula(n)) {
                if (list.contains(ReportTools.class$jet$report$JetRptCTCrossTab((IVariableExpression)iExpression2))) {
                    return iBinaryConditionExpression;
                }
                return null;
            }
            if (ExpressionToolKit.isParameter(n)) {
                return iBinaryConditionExpression;
            }
            throw new UserException(210508);
        }
        throw new UserException(210509);
    }

    private static ISingleConditionExpression bNull(ISingleConditionExpression iSingleConditionExpression, List list) throws UserException, ConditionException {
        if (OperatorToolKit.isNotNull(iSingleConditionExpression.getOperator().operatorType()) || OperatorToolKit.isNull(iSingleConditionExpression.getOperator().operatorType())) {
            IExpression iExpression = iSingleConditionExpression.getExpression();
            int n = iExpression.expressionType();
            if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isFormula(n)) {
                if (list.contains(ReportTools.class$jet$report$JetRptCTCrossTab((IVariableExpression)iExpression))) {
                    return iSingleConditionExpression;
                }
                return null;
            }
            if (ExpressionToolKit.isParameter(n)) {
                return iSingleConditionExpression;
            }
            throw new UserException(210508);
        }
        throw new UserException(210505);
    }

    private static ITupleExpression buildAndExpression(ISingleLogicExpression iSingleLogicExpression, List list) throws UserException, ConditionException {
        IExpression iExpression;
        if (OperatorToolKit.isNot(iSingleLogicExpression.getOperator().operatorType()) && ExpressionToolKit.isBooleanExp((iExpression = iSingleLogicExpression.getExpression()).expressionType())) {
            ITupleExpression iTupleExpression = ReportTools.checkITupleExpression((ITupleExpression)iExpression, list);
            if (iTupleExpression == null) {
                return null;
            }
            if (iTupleExpression == iExpression) {
                return iSingleLogicExpression;
            }
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            return (ITupleExpression)iExpressionFactory.createSingleLogicExp((ISingleLogicOperator)iSingleLogicExpression.getOperator(), (IBooleanExpression)iTupleExpression);
        }
        throw new UserException(210505);
    }

    private static ITripleConditionExpression buildOrExpression(ITripleConditionExpression iTripleConditionExpression, List list) throws UserException, ConditionException {
        if (OperatorToolKit.isBetween(iTripleConditionExpression.getOperator().operatorType()) || OperatorToolKit.isNotBetween(iTripleConditionExpression.getOperator().operatorType())) {
            IExpression iExpression;
            IExpression iExpression2 = iTripleConditionExpression.getExpression2();
            int n = iExpression2.expressionType();
            if ((ExpressionToolKit.isConstant(n) || ExpressionToolKit.isVariableList(n)) && (ExpressionToolKit.isConstant(n = (iExpression = iTripleConditionExpression.getExpression3()).expressionType()) || ExpressionToolKit.isVariableList(n))) {
                IExpression iExpression3 = iTripleConditionExpression.getExpression1();
                n = iExpression3.expressionType();
                if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isFormula(n)) {
                    if (list.contains(ReportTools.class$jet$report$JetRptCTCrossTab((IVariableExpression)iExpression3))) {
                        return iTripleConditionExpression;
                    }
                    return null;
                }
                if (ExpressionToolKit.isParameter(n)) {
                    return iTripleConditionExpression;
                }
                throw new UserException(210508);
            }
            throw new UserException(210509);
        }
        throw new UserException(210505);
    }

    private static ITupleExpression checkITupleExpression(IMultiLogicExpression iMultiLogicExpression, List list) throws UserException, ConditionException {
        IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
        IExpression[] iExpressionArray2 = new IExpression[iExpressionArray.length];
        int n = 0;
        while (n < iExpressionArray.length) {
            if (!ExpressionToolKit.isTupleExp(iExpressionArray[n].expressionType())) {
                throw new UserException(210505);
            }
            iExpressionArray2[n] = ReportTools.checkITupleExpression((ITupleExpression)iExpressionArray[n], list);
            ++n;
        }
        boolean bl = false;
        Vector<IExpression> vector = new Vector<IExpression>();
        int n2 = 0;
        while (n2 < iExpressionArray.length) {
            if (iExpressionArray2[n2] != null) {
                if (iExpressionArray[n2] != iExpressionArray2[n2]) {
                    bl = true;
                }
                vector.add(iExpressionArray2[n2]);
            }
            ++n2;
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (ITupleExpression)vector.get(0);
        }
        if (vector.size() < iExpressionArray2.length || vector.size() == iExpressionArray2.length && bl) {
            iExpressionArray2 = new IExpression[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                iExpressionArray2[n3] = (IExpression)vector.get(n3);
                ++n3;
            }
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            return iExpressionFactory.createMultiLogicExp((IMultiLogicOperator)iMultiLogicExpression.getOperator(), iExpressionArray2);
        }
        return iMultiLogicExpression;
    }

    private static ITupleExpression class$(IBinaryLogicExpression iBinaryLogicExpression, List list) throws UserException, ConditionException {
        IExpression iExpression = iBinaryLogicExpression.getExpression1();
        IExpression iExpression2 = iBinaryLogicExpression.getExpression2();
        if (!ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            throw new UserException(210506);
        }
        ITupleExpression iTupleExpression = ReportTools.checkITupleExpression((ITupleExpression)iExpression, list);
        if (!ExpressionToolKit.isTupleExp(iExpression2.expressionType())) {
            throw new UserException(210507);
        }
        ITupleExpression iTupleExpression2 = ReportTools.checkITupleExpression((ITupleExpression)iExpression2, list);
        if (iTupleExpression == null && iTupleExpression2 == null) {
            return null;
        }
        if (iTupleExpression != null && iTupleExpression2 != null) {
            if (iTupleExpression != iExpression || iTupleExpression2 != iExpression2) {
                IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
                return iExpressionFactory.createBinaryLogicExp((IBinaryLogicOperator)iBinaryLogicExpression.getOperator(), (IBooleanExpression)iTupleExpression, (IBooleanExpression)iTupleExpression2);
            }
            return iBinaryLogicExpression;
        }
        return iTupleExpression == null ? iTupleExpression2 : iTupleExpression;
    }

    public static ITupleExpression checkITupleExpression(ITupleExpression iTupleExpression, List list) throws ConditionException, UserException {
        int n = iTupleExpression.expressionType();
        if (ExpressionToolKit.isBinaryTupleExp(n)) {
            if (ExpressionToolKit.isBinaryConditionExp(n)) {
                return ReportTools.append((IBinaryConditionExpression)iTupleExpression, list);
            }
            if (ExpressionToolKit.isBinaryLogicExp(n)) {
                return ReportTools.class$((IBinaryLogicExpression)iTupleExpression, list);
            }
        } else if (ExpressionToolKit.isTripleTupleExp(n)) {
            if (ExpressionToolKit.isTripleConditonExp(n)) {
                return ReportTools.buildOrExpression((ITripleConditionExpression)iTupleExpression, list);
            }
        } else if (ExpressionToolKit.isSingleTupleExp(n)) {
            if (ExpressionToolKit.isSingleConditionExp(n)) {
                return ReportTools.bNull((ISingleConditionExpression)iTupleExpression, list);
            }
            if (ExpressionToolKit.isSingleLogicExp(n)) {
                return ReportTools.buildAndExpression((ISingleLogicExpression)iTupleExpression, list);
            }
        } else if (ExpressionToolKit.isMultiExp(n) && ExpressionToolKit.isMultiLogicExp(n)) {
            return ReportTools.checkITupleExpression((IMultiLogicExpression)iTupleExpression, list);
        }
        throw new UserException(210505);
    }

    private static String class$jet$report$JetRptCTCrossTab(IVariableExpression iVariableExpression) throws ConditionException, UserException {
        int n = iVariableExpression.expressionType();
        if (ExpressionToolKit.isConstant(n)) {
            return ((IConstant)iVariableExpression).getValue();
        }
        if (ExpressionToolKit.isFormula(n)) {
            return ((IFormula)iVariableExpression).getName();
        }
        if (ExpressionToolKit.isParameter(n)) {
            return ((IParameter)iVariableExpression).getName();
        }
        if (ExpressionToolKit.isReference(n)) {
            return ((IReference)iVariableExpression).getAttributeName();
        }
        if (ExpressionToolKit.isVariableList(n)) {
            int n2 = ((IVariableList)iVariableExpression).size();
            if (n2 == 0) {
                throw new UserException(210510);
            }
            StringBuffer stringBuffer = new StringBuffer(n2 * 4);
            int n3 = 0;
            while (n3 < n2 - 1) {
                String string = ReportTools.class$jet$report$JetRptCTCrossTab(((IVariableList)iVariableExpression).getVariableExp(n3));
                stringBuffer.append(string).append(String.valueOf('\u0007'));
                ++n3;
            }
            stringBuffer.append(ReportTools.class$jet$report$JetRptCTCrossTab(((IVariableList)iVariableExpression).getVariableExp(n2 - 1)));
            return stringBuffer.toString();
        }
        throw new UserException(210511);
    }

    public static JetRptSummary buildRptFormula(String string, MeasureInfo measureInfo, FormulaContainer formulaContainer) throws FormulaSyntaxErrorException {
        String string2 = string.toUpperCase();
        JetRptSummary jetRptSummary = new JetRptSummary();
        jetRptSummary.setName(string2);
        jetRptSummary.setDataSource(formulaContainer);
        String string3 = null;
        String string4 = measureInfo.getAggFunction();
        String string5 = "0";
        String string6 = measureInfo.getRefMappingName();
        if (string3 != null && string3.length() > 0) {
            jetRptSummary.setExpression(string4, string6, string5, string3);
        } else {
            jetRptSummary.setExpression(string4, string6, string5);
        }
        jetRptSummary.parseFormula(new FormulatoJava("", null));
        return jetRptSummary;
    }

    public static JetRptFormula buildRptFormula(String string, JetUFormulaInterface jetUFormulaInterface, FormulaContainer formulaContainer) throws FormulaSyntaxErrorException {
        JetRptFormula jetRptFormula = null;
        boolean bl = ReportTools.isUseDynamicSummary(jetUFormulaInterface);
        if (jetUFormulaInterface instanceof JetUSummary) {
            JetUSummary jetUSummary = (JetUSummary)jetUFormulaInterface;
            jetRptFormula = new JetRptSummary();
            jetRptFormula.setDataSource(formulaContainer);
            jetRptFormula.setName(string);
            String string2 = jetUSummary.getSpecFuncKey();
            String string3 = jetUSummary.getGroupByFld();
            if (bl) {
                try {
                    int n = Integer.parseInt(string3);
                    if (n > 0) {
                        n = 0;
                    }
                    string3 = new Integer(n).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FormulaSyntaxErrorException(string, " Group by value error. It is not integer value for dynamic summary!");
                }
            }
            if (string2 != null && string2.length() > 0) {
                ((JetRptSummary)jetRptFormula).setExpression(jetUSummary.getFunction(), jetUSummary.getFieldName(), string3, string2);
            } else {
                ((JetRptSummary)jetRptFormula).setExpression(jetUSummary.getFunction(), jetUSummary.getFieldName(), string3);
            }
        } else {
            jetRptFormula = new JetRptFormula(string, jetUFormulaInterface.getExpression(), formulaContainer);
        }
        jetRptFormula.parseFormula(new FormulatoJava("", null));
        return jetRptFormula;
    }

    public static boolean isUseDynamicSummary(JetUFormulaInterface jetUFormulaInterface) {
        boolean bl = false;
        if (jetUFormulaInterface != null) {
            FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
            Vector vector = formulaInfo.refAggregation;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                Aggregation aggregation = (Aggregation)vector.elementAt(n2);
                if (aggregation.getAggDesc().isDynamicSummary()) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public static JetProperty getBLPropertyUseColumnName(JetObject jetObject, String string) {
        JetProperty jetProperty;
        JetProperty jetProperty2 = null;
        String string2 = ColumnableMapping.getBLColumnNameByColumnName(jetObject, string);
        if (string2 != null && (jetProperty = jetObject.nameToProperty(string2)) != null && jetProperty instanceof JetBLColumnable && ReportTools.useProperty(jetProperty)) {
            jetProperty2 = jetProperty;
        }
        return jetProperty2;
    }

    public static boolean useProperty(JetProperty jetProperty) {
        boolean bl = false;
        if (jetProperty != null) {
            Vector vector;
            String string = null;
            if (jetProperty instanceof JetBLColumnName || jetProperty instanceof JetColumnName) {
                string = jetProperty.toString();
            } else if (jetProperty instanceof JetVector && (vector = ((JetVector)jetProperty).get()) != null && vector.size() > 0) {
                string = (String)vector.firstElement();
            }
            if (string != null && !string.equals("")) {
                bl = true;
            }
        }
        return bl;
    }

    public static Object getResourceEntity(JetUUniverse jetUUniverse, String string, String string2, String string3, String string4, boolean bl) {
        Object object = null;
        if (jetUUniverse != null) {
            JBusinessLogic jBusinessLogic;
            object = !bl ? jetUUniverse.getResourceByName(string, string2, string3) : ((jBusinessLogic = ReportTools.getBL(jetUUniverse, string, string2, "")) != null ? jBusinessLogic.get(string3) : ReportTools.getResourceEntity(jetUUniverse, string, string2, string3, string4, false));
        }
        return object;
    }

    public static JBusinessLogic getBL(JetUUniverse jetUUniverse, String string, String string2, String string3) {
        JBusinessLogic jBusinessLogic = null;
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        if (jetUQueriable instanceof JetUQuery) {
            jBusinessLogic = ((JetUQuery)jetUQueriable).getBL();
        } else if (jetUQueriable instanceof JetUFileQuery) {
            jBusinessLogic = ((JetUFileQuery)jetUQueriable).getBL();
        } else if (jetUQueriable instanceof JetUProcedure) {
            jBusinessLogic = ((JetUProcedure)jetUQueriable).getBL();
        } else if (jetUQueriable instanceof JetUUserDataSource) {
            jBusinessLogic = ((JetUUserDataSource)jetUQueriable).getBL();
        }
        return jBusinessLogic;
    }

    public static BLNode getBLNode(JetUUniverse jetUUniverse, String string, String string2, String string3, String string4) {
        BLNode bLNode = null;
        JBusinessLogic jBusinessLogic = ReportTools.getBL(jetUUniverse, string, string2, string3);
        if (jBusinessLogic != null) {
            bLNode = jBusinessLogic.get(string4);
        }
        return bLNode;
    }

    public static GroupModel getGroupModelByGMIndex(GroupModel groupModel, int n) {
        GroupModel groupModel2 = null;
        if (n >= 0) {
            GroupModel groupModel3 = groupModel;
            while (groupModel3 != null) {
                if (groupModel3.getGroupIndex() == n) {
                    groupModel2 = groupModel3;
                    break;
                }
                groupModel3 = groupModel3.nextToMe();
            }
        }
        return groupModel2;
    }

    public static String getDisplayName(DataSet dataSet, String string, boolean bl, ReportViewCenter reportViewCenter) throws JRScheduleException {
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        BLNode bLNode = null;
        String string3 = "";
        if (bl) {
            bLNode = ObjectLogicFactory.getDataSetLogic().getRefDataElement(dataSet, string);
            if (bLNode != null && bLNode instanceof DataElementInfo) {
                string3 = ((DataElementInfo)bLNode).getDisplayName();
                string2 = ((DataElementInfo)bLNode).getRefMappingName();
            }
        } else {
            string3 = dataSet.hasDisplayName() ? ReportTools.class$jet$report$JetRptSectionObject(dataSet, string2, reportViewCenter) : string2;
            if (string3 == null || string3.equals("")) {
                string3 = string2;
            }
        }
        return string3;
    }

    private static String class$jet$report$JetRptSectionObject(DataSet dataSet, String string, ReportViewCenter reportViewCenter) throws JRScheduleException {
        Vector vector = dataSet.getResourceAttrs();
        int n = 0;
        while (n < vector.size()) {
            JetRptColAttr jetRptColAttr = (JetRptColAttr)vector.elementAt(n);
            if (string.compareToIgnoreCase(jetRptColAttr.resourceName.get()) == 0) {
                String string2 = "";
                if (jetRptColAttr.displayName.isChangeByOther()) {
                    JRptSetEngine jRptSetEngine = reportViewCenter.getReportViewEngine().getRptSetEngine();
                    List list = null;
                    try {
                        list = GetValueTools.getFormulaValueList(jRptSetEngine, dataSet, jetRptColAttr.displayName.getChangeByObjectName().toUpperCase(), 0, 1);
                    }
                    catch (DSException dSException) {
                        throw new JRScheduleException(dSException);
                    }
                    catch (JRScheduleException jRScheduleException) {
                        throw jRScheduleException;
                    }
                    if (list != null && list.size() > 0) {
                        string2 = list.get(list.size() - 1).toString();
                    }
                } else {
                    string2 = jetRptColAttr.displayName.get();
                }
                return string2;
            }
            ++n;
        }
        return null;
    }

    public static boolean isDrillPathComponent(JetRptDataContainer jetRptDataContainer) {
        if (jetRptDataContainer == null) {
            return false;
        }
        if (!(jetRptDataContainer instanceof JetRptSectionObject) && !(jetRptDataContainer instanceof JetRptNewTable)) {
            return false;
        }
        DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
        return !dataContainerLogic.isParallel(jetRptDataContainer);
    }

    public static IExpression cloneIExpression(IExpression iExpression) throws ConditionException {
        return ExpressionToolKit.cloneExpression(iExpression);
    }

    public static boolean supportBrowseAction(JetObject jetObject) {
        return IsSum.contains(jetObject.getClass().getName());
    }

    public static Vector getGroupLevelValue(FormulaQueue formulaQueue, int n) {
        Vector vector = new Vector();
        if (formulaQueue != null) {
            int n2 = n;
            while (n2 < formulaQueue.getGroupSize()) {
                Vector vector2 = formulaQueue.getSumFmlQueue(1, n2);
                Vector vector3 = formulaQueue.getGlobalHSumQueue(n2);
                Vector vector4 = formulaQueue.getGlobalFSumQueue(n2);
                ReportTools.class$jet$report$chart$JetRptChartPlatform(vector, vector2);
                ReportTools.class$jet$report$chart$JetRptChartPlatform(vector, vector3);
                ReportTools.class$jet$report$chart$JetRptChartPlatform(vector, vector4);
                ++n2;
            }
        }
        return vector;
    }

    private static void class$jet$report$chart$JetRptChartPlatform(Vector vector, Vector vector2) {
        int n = vector2 == null ? 0 : vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetRptFormula jetRptFormula = (JetRptFormula)vector2.elementAt(n2);
            if (!vector.contains(jetRptFormula.getName())) {
                vector.addElement(jetRptFormula.getName());
            }
            ++n2;
        }
    }

    public static final String getActualExportStyleGroup(String string, JetRptReport jetRptReport) {
        Vector<String> vector = new Vector<String>();
        String string2 = string;
        String[] stringArray = new String[]{"defined\u0007dhtml\u0007export\u0007style", "defined\u0007rst\u0007export\u0007style", "defined\u0007html\u0007export\u0007style", "defined\u0007excel\u0007export\u0007style", "defined\u0007pdf\u0007export\u0007style", "defined\u0007text\u0007export\u0007style", "defined\u0007rtf\u0007export\u0007style", "defined\u0007xml\u0007export\u0007style", "defined\u0007ps\u0007export\u0007style", "defined\u0007fax\u0007export\u0007style"};
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        int n2 = vector.indexOf(string2);
        if (n2 != -1) {
            switch (n2) {
                case 0: {
                    string2 = jetRptReport.stlGrpOfDHTML.get();
                    break;
                }
                case 1: {
                    string2 = jetRptReport.stlGrpOfRST.get();
                    break;
                }
                case 2: {
                    string2 = jetRptReport.stlGrpOfHTML.get();
                    break;
                }
                case 3: {
                    string2 = jetRptReport.stlGrpOfExcel.get();
                    break;
                }
                case 4: {
                    string2 = jetRptReport.stlGrpOfPDF.get();
                    break;
                }
                case 5: {
                    string2 = jetRptReport.stlGrpOfText.get();
                    break;
                }
                case 6: {
                    string2 = jetRptReport.stlGrpOfRTF.get();
                    break;
                }
                case 7: {
                    string2 = jetRptReport.stlGrpOfXML.get();
                    break;
                }
                case 8: {
                    string2 = jetRptReport.stlGrpOfPS.get();
                    break;
                }
                case 9: {
                    string2 = jetRptReport.stlGrpOfFax.get();
                    break;
                }
            }
        }
        return "".equals(string2) ? null : string2;
    }

    public static final boolean equals(RuntimeInfo runtimeInfo, RuntimeInfo runtimeInfo2, JetRptReport jetRptReport) {
        if (jetRptReport == null) {
            throw new NullPointerException();
        }
        RuntimeInfo runtimeInfo3 = runtimeInfo;
        if (!jetRptReport.precisionSense.get() && runtimeInfo.isHighPrecision() != runtimeInfo2.isHighPrecision()) {
            runtimeInfo3 = EngineRuntimeInfo.createEngineRuntimeInfo(runtimeInfo);
            runtimeInfo3.setHighPrecision(runtimeInfo2.isHighPrecision());
        }
        if (Tools.equals(runtimeInfo3, runtimeInfo2)) {
            return true;
        }
        if (runtimeInfo3.isHighPrecision() != runtimeInfo2.isHighPrecision()) {
            return false;
        }
        String string = ReportTools.getActualExportStyleGroup(runtimeInfo3.getExportStyleGroup(), jetRptReport);
        String string2 = ReportTools.getActualExportStyleGroup(runtimeInfo2.getExportStyleGroup(), jetRptReport);
        return Tools.equals(string, string2);
    }

    public static final JetRptReportSet createReportSet(JetRptReportSet jetRptReportSet, JetRptReport jetRptReport, String string, String[] stringArray) {
        JetObject jetObject;
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        JetRptReportSet jetRptReportSet2 = ObjectLogicFactory.getReportSetLogic().createReportSet(jetRptReportSet.getUniverse());
        JetRptReport jetRptReport2 = (JetRptReport)jetRptReport.deepDupWithName();
        jetRptReport2.getRptBody().dataSet.set(null);
        Vector vector = jetRptReport2.getRptBody().getChildren();
        if (vector != null) {
            int n = vector.size();
            while (n-- > 0) {
                basicComponentLogic.remove((JetObject)vector.elementAt(n));
            }
        }
        JetRptDataContainer jetRptDataContainer = (JetRptDataContainer)jetRptReport.nameToObject(string);
        DataSet dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(jetRptDataContainer);
        JetRptDataSet jetRptDataSet = (JetRptDataSet)((JetRptDataSet)dataSet).deepDupWithName();
        try {
            jetRptDataSet.setIExpression(null);
            jetRptDataSet.setPreIExpression(null);
        }
        catch (ConditionException conditionException) {
            Tools.logTrace(5, conditionException);
        }
        jetRptDataSet.setDatasetType(1);
        JetRptDataContainer jetRptDataContainer2 = (JetRptDataContainer)jetRptDataContainer.deepDupWithName();
        TreeIterater treeIterater = new TreeIterater(jetRptDataContainer2, false);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject instanceof JetRptSubReport) {
                basicComponentLogic.remove(jetObject);
                continue;
            }
            ReportTools.clone(jetObject);
        }
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                jetObject = ReportTools.clearDrillIExpression(jetRptDataContainer2, stringArray[n]);
                if (jetObject != null) {
                    basicComponentLogic.remove(jetObject);
                }
                ++n;
            }
        }
        DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
        dataContainerLogic.clearBrowserIExpression(jetRptDataContainer2, 4098);
        dataContainerLogic.clearDrillIExpression(jetRptDataContainer2);
        dataContainerLogic.clearIExpression(jetRptDataContainer2);
        jetRptDataContainer2.dataSet.setObject(jetRptDataSet);
        jetRptDataContainer2.dataInherit.set(false);
        jetRptDataContainer2.x.setUnitValue(0);
        jetRptDataContainer2.y.setUnitValue(0);
        jetRptDataContainer2.dataInherit.set(false);
        jetRptDataContainer2.dataSet.setObject(jetRptDataSet);
        jetRptReportSet2.addReport(jetRptReport2);
        JetRptPagePanel jetRptPagePanel = ObjectLogicFactory.getPageLogic().getPage(jetRptDataContainer);
        if (jetRptPagePanel != null) {
            JetRptPagePanel jetRptPagePanel2 = new JetRptPagePanel();
            jetRptPagePanel2.setEditable();
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptReport2, jetRptPagePanel2);
            JetRptPageStart jetRptPageStart = new JetRptPageStart();
            jetRptPageStart.setPagePanel(jetRptPagePanel2);
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptReport2.getRptBody(), jetRptPageStart);
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptReport2.getRptBody(), jetRptDataContainer2);
            JetRptPageEnd jetRptPageEnd = new JetRptPageEnd();
            jetRptPageEnd.setPagePanel(jetRptPagePanel2);
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptReport2.getRptBody(), jetRptPageEnd);
            String string2 = jetRptReport2.getCurrentViewObject().getPageMode();
            jetRptReport2.getCurrentViewObject().setPageMode(JetRptView.LOGIC_PAGE);
            if (!string2.equals(JetRptView.LOGIC_PAGE)) {
                ReportTools.class$jet$report$table$JetRptNewTable(jetRptDataContainer2);
            }
            ReportTools.clearBrowserIExpression(jetRptPagePanel2, jetRptPagePanel.getProperties());
        }
        jetRptReportSet2.addDataSet(jetRptDataSet);
        jetRptReportSet2.setFullFileName(jetRptReportSet.getFullFileName());
        return jetRptReportSet2;
    }

    private static final void class$jet$report$table$JetRptNewTable(JetRptDataContainer jetRptDataContainer) {
        JetObject jetObject;
        TreeIterater treeIterater = new TreeIterater(jetRptDataContainer, true);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject instanceof JetRptGroupPanel) {
                ((JetRptGroupPanel)jetObject).currentBlockIndex.set(0);
                ((JetRptGroupPanel)jetObject).itemsPerBlock.set(-1);
                continue;
            }
            if (jetObject instanceof JetRptDetailPanel) {
                ((JetRptDetailPanel)jetObject).currentBlockIndex.set(0);
                ((JetRptDetailPanel)jetObject).itemsPerBlock.set(-1);
                continue;
            }
            if (!(jetObject instanceof JetRptTableDetail)) continue;
            ((JetRptTableDetail)jetObject).currentBlockIndex.set(0);
            ((JetRptTableDetail)jetObject).itemsPerBlock.set(-1);
        }
    }

    private static final void clearBrowserIExpression(JetRptPagePanel jetRptPagePanel, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            JetProperty jetProperty;
            String string = (String)enumeration.nextElement();
            JetProperty jetProperty2 = (JetProperty)hashtable.get(string);
            if (jetProperty2.isChangeByOther() || (jetProperty = jetRptPagePanel.nameToProperty(string)) == null) continue;
            jetProperty.setUnitValue(jetProperty2.toUnitString());
        }
    }

    public static final void doGoToDetail(JetRptReport jetRptReport, String string) {
        JetObject jetObject;
        GoToComponentInfo goToComponentInfo = new GoToComponentInfo(jetRptReport, string, null);
        while ((jetObject = (JetObject)GoToComponentInfo.access$100(goToComponentInfo).next()) != null) {
            if (!(jetObject instanceof JetRptSection)) continue;
            if (GoToComponentInfo.access$200(goToComponentInfo).contains(jetObject)) {
                ReportTools.clearIExpression((JetRptSection)jetObject, false, false);
                continue;
            }
            ReportTools.clearIExpression((JetRptSection)jetObject, true, true);
        }
    }

    public static final void doGoTo(JetRptReport jetRptReport, String string) {
        JetObject jetObject;
        GoToComponentInfo goToComponentInfo = new GoToComponentInfo(jetRptReport, string, null);
        while ((jetObject = (JetObject)GoToComponentInfo.access$100(goToComponentInfo).next()) != null) {
            if (!(jetObject instanceof JetRptSection)) continue;
            if (GoToComponentInfo.access$200(goToComponentInfo).contains(jetObject)) {
                if (!GoToComponentInfo.access$300(goToComponentInfo).getChildren().contains(jetObject)) continue;
                ReportTools.clearIExpression((JetRptSection)jetObject, false, false);
                continue;
            }
            ReportTools.clearIExpression((JetRptSection)jetObject, true, true);
        }
    }

    public static final void doGoUp(JetRptReport jetRptReport, String string) {
        JetObject jetObject;
        GoToComponentInfo goToComponentInfo = new GoToComponentInfo(jetRptReport, string, null);
        while ((jetObject = (JetObject)GoToComponentInfo.access$100(goToComponentInfo).next()) != null) {
            if (!(jetObject instanceof JetRptSection)) continue;
            if (GoToComponentInfo.access$200(goToComponentInfo).contains(jetObject)) {
                if (!GoToComponentInfo.access$300(goToComponentInfo).getChildren().contains(jetObject)) continue;
                ReportTools.clearIExpression((JetRptSection)jetObject, false, false);
                continue;
            }
            ReportTools.clearIExpression((JetRptSection)jetObject, true, true);
        }
    }

    public static final void doGoDown(JetRptReport jetRptReport, String string) {
        JetObject jetObject;
        GoToComponentInfo goToComponentInfo = new GoToComponentInfo(jetRptReport, string, null);
        while ((jetObject = (JetObject)GoToComponentInfo.access$100(goToComponentInfo).next()) != null) {
            if (!(jetObject instanceof JetRptSection)) continue;
            if (GoToComponentInfo.access$200(goToComponentInfo).contains(jetObject)) {
                if (!GoToComponentInfo.access$300(goToComponentInfo).getChildren().contains(jetObject)) continue;
                ReportTools.clearIExpression((JetRptSection)jetObject, false, false);
                continue;
            }
            ReportTools.clearIExpression((JetRptSection)jetObject, true, true);
        }
    }

    private static final JetObject clearDrillIExpression(JetObject jetObject, String string) {
        JetObject jetObject2;
        TreeIterater treeIterater = new TreeIterater(jetObject, false);
        JetObject jetObject3 = null;
        while ((jetObject2 = (JetObject)treeIterater.next()) != null) {
            if (!jetObject2.getInstName().equals(string)) continue;
            jetObject3 = jetObject2;
            break;
        }
        return jetObject3;
    }

    private static final void clearIExpression(JetRptSection jetRptSection, boolean bl, boolean bl2) {
        jetRptSection.suppressed.set(bl);
        jetRptSection.invisible.set(bl2);
    }

    private static final void clone(JetObject jetObject) {
        if (jetObject == null) {
            return;
        }
        if (jetObject instanceof JetRptField) {
            ((JetRptField)jetObject).link.set("");
            ((JetRptField)jetObject).detailRpt.set("");
            ((JetRptField)jetObject).masterJoin.set("");
            ((JetRptField)jetObject).joinOp.set("");
            ((JetRptField)jetObject).detailJoin.set("");
            ((JetRptField)jetObject).masterCols.set("");
            ((JetRptField)jetObject).ops.set("");
            ((JetRptField)jetObject).detailCols.set("");
            ((JetRptField)jetObject).logics.set("");
            ((JetRptField)jetObject).detailTargetCompInst.set("");
            ((JetRptField)jetObject).sameEnc.set("");
            ((JetRptField)jetObject).paraValInMaster.set("");
            ((JetRptField)jetObject).paraInDetail.set("");
        } else if (jetObject instanceof JetRptPicture) {
            ((JetRptPicture)jetObject).link.set("");
            ((JetRptPicture)jetObject).detailRpt.set("");
            ((JetRptPicture)jetObject).masterJoin.set("");
            ((JetRptPicture)jetObject).joinOp.set("");
            ((JetRptPicture)jetObject).detailJoin.set("");
            ((JetRptPicture)jetObject).masterCols.set("");
            ((JetRptPicture)jetObject).ops.set("");
            ((JetRptPicture)jetObject).detailCols.set("");
            ((JetRptPicture)jetObject).logics.set("");
            ((JetRptPicture)jetObject).detailTargetCompInst.set("");
            ((JetRptPicture)jetObject).sameEnc.set("");
            ((JetRptPicture)jetObject).paraValInMaster.set("");
            ((JetRptPicture)jetObject).paraInDetail.set("");
        }
    }

    public static int getGroupPanelType(JetRptGroupPanel jetRptGroupPanel) {
        return jetRptGroupPanel.groupType.get();
    }

    public static boolean isSummaryRefernced(JetRptFormula jetRptFormula, JetUUniverse jetUUniverse, String string, String string2) {
        FormulaInfo formulaInfo = jetRptFormula.formulainfo;
        if (formulaInfo.refAggregation.size() > 0) {
            return true;
        }
        int n = 0;
        while (n < formulaInfo.refFormula.size()) {
            String string3 = (String)formulaInfo.refFormula.elementAt(n);
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, string2, string3);
            if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUFormula) {
                if (jetUResourceEntity instanceof JetUSummary) {
                    return true;
                }
                JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
                JetRptFormula jetRptFormula2 = jetUFormula.getRptFormula();
                if (ReportTools.isSummaryRefernced(jetRptFormula2, jetUUniverse, string, string2)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public static boolean canCacheQueryForDefault(JetUUniverse jetUUniverse, String string, String string2) {
        boolean bl = true;
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        if (jetUQueriable instanceof JetUQuery) {
            if (((JetUQuery)jetUQueriable).enableSQLStmtCreator.get()) {
                bl = false;
            }
        } else if (jetUQueriable instanceof JetUHDSTable && jetUQueriable instanceof JetUHierDataSource) {
            bl = false;
        }
        return bl;
    }

    public static boolean isRealDataInherit(JetRptDataContainer jetRptDataContainer) {
        boolean bl = false;
        if (jetRptDataContainer.dataInherit.get()) {
            bl = true;
        } else {
            int n;
            JetRptDataSet jetRptDataSet = (JetRptDataSet)ReportTools.getDataSet(jetRptDataContainer);
            if (jetRptDataSet != null && jetRptDataSet.isExtends() && (n = ((JetRptExtendsDataSet)jetRptDataSet).getExtendsType()) == 1) {
                bl = true;
            }
        }
        return bl;
    }

    public static JRawDataQuery getRootRawQuery(int n, JDataEngine jDataEngine) throws DSException {
        int n2 = n;
        JRawDataQuery jRawDataQuery = (JRawDataQuery)jDataEngine.getQuery(n);
        while (jRawDataQuery instanceof JIterativeQuery) {
            n2 = ((JIterativeQuery)jRawDataQuery).getBaseId();
            jRawDataQuery = (JRawDataQuery)jDataEngine.getQuery(n2);
        }
        return jRawDataQuery;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static JetObject access$400(JetObject jetObject, String string) {
        return ReportTools.clearDrillIExpression(jetObject, string);
    }

    static {
        IsSum.addElement((class$jet$report$JetRptSectionObject == null ? (class$jet$report$JetRptSectionObject = ReportTools.class$("jet.report.JetRptSectionObject")) : class$jet$report$JetRptSectionObject).getName());
        IsSum.addElement((class$jet$report$table$JetRptNewTable == null ? (class$jet$report$table$JetRptNewTable = ReportTools.class$("jet.report.table.JetRptNewTable")) : class$jet$report$table$JetRptNewTable).getName());
        IsSum.addElement((class$jet$report$JetRptCTCrossTab == null ? (class$jet$report$JetRptCTCrossTab = ReportTools.class$("jet.report.JetRptCTCrossTab")) : class$jet$report$JetRptCTCrossTab).getName());
        IsSum.addElement((class$jet$report$chart$JetRptChartPlatform == null ? (class$jet$report$chart$JetRptChartPlatform = ReportTools.class$("jet.report.chart.JetRptChartPlatform")) : class$jet$report$chart$JetRptChartPlatform).getName());
    }

    class 1 {
    }

    private static final class GoToComponentInfo {
        private JetRptObject QOIV = null;
        private Vector access$400 = new Vector();
        private TreeIterater class$ = null;

        private GoToComponentInfo(JetRptReport jetRptReport, String string) {
            JetObject jetObject = this.QOIV = (JetRptObject)ReportTools.access$400(jetRptReport, string);
            if (!(jetObject instanceof JetRptSectionObject) && !(jetObject instanceof JetRptNewTable)) {
                while (jetObject != null && !((jetObject = (JetObject)((Object)jetObject.getParent())) instanceof JetRptSectionObject) || jetObject instanceof JetRptNewTable) {
                }
            }
            this.QOIV(this.access$400, this.QOIV);
            this.class$ = new TreeIterater(jetObject, false);
        }

        private void QOIV(Vector vector, JetObject jetObject) {
            ObjectLogicFactory.getBasicComponentLogic().getAllPosterityComponentByClass(jetObject, class$jet$report$JetRptSection == null ? (class$jet$report$JetRptSection = ReportTools.class$("jet.report.JetRptSection")) : class$jet$report$JetRptSection, (List)vector);
        }

        GoToComponentInfo(JetRptReport jetRptReport, String string, 1 var3_3) {
            this(jetRptReport, string);
        }

        static TreeIterater access$100(GoToComponentInfo goToComponentInfo) {
            return goToComponentInfo.class$;
        }

        static Vector access$200(GoToComponentInfo goToComponentInfo) {
            return goToComponentInfo.access$400;
        }

        static JetRptObject access$300(GoToComponentInfo goToComponentInfo) {
            return goToComponentInfo.QOIV;
        }
    }
}

