/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.JComponent;
import jet.connect.Record;
import jet.datastream.DSContainer;
import jet.datastream.DSGroup;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.util.CCUtil;
import jet.thinviewer.JReportChartPlatform;
import jet.thinviewer.JReportContainerable;
import jet.thinviewer.JReportParagraph;
import jet.thinviewer.JReportParagraphText;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.udo.JRObjectRender;
import jet.util.PropertySetable;

public class JReportAreaComponent
extends JComponent
implements JRObjectRender,
JReportContainerable {
    Shape I;
    protected int startY = 0;
    protected int resolution;
    int Z = 0;

    public boolean contains(Point point) {
        return this.I.contains(point);
    }

    public boolean contains(int n, int n2) {
        return this.I.contains(n, n2);
    }

    public void setProperty(PropertySetable propertySetable) {
        Color color = this.getColorPropertyByName((JRObjectResult)propertySetable, "Background");
        if (color != null) {
            this.setBackground(color);
        }
        this.resolution = ((JRObjectResult)propertySetable).getResolution();
        this.startY = Unit.convertUnitToPixel(((DSContainer)propertySetable).getStartYPos(), this.resolution);
    }

    public void createChildren(DSContainer dSContainer) {
        this.removeAll();
        List list = dSContainer.getChildren();
        list = ViewerTools.I(list);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(n2);
            JRObjectRender jRObjectRender = null;
            try {
                jRObjectRender = this.createComponent(jRObjectResult);
            }
            catch (Exception exception) {
                ViewerTools.I(2401503, exception);
            }
            if (jRObjectRender != null) {
                this.add((Component)((Object)jRObjectRender));
            }
            ++n2;
        }
    }

    protected JRObjectRender createComponent(JRObjectResult jRObjectResult) {
        boolean bl = true;
        while (jRObjectResult instanceof DSReference) {
            bl = false;
            jRObjectResult = ((DSReference)jRObjectResult).getRefData();
        }
        if (this.getBooleanPropertyByName(jRObjectResult, "Invisible")) {
            return null;
        }
        JRObjectRender jRObjectRender = JReportViewer.I(jRObjectResult);
        if (jRObjectRender != null) {
            JRVisiableResult jRVisiableResult = (JRVisiableResult)jRObjectResult;
            jRObjectRender.setProperty(jRVisiableResult);
            Rectangle rectangle = jRVisiableResult.getBounds();
            int n = 0;
            if (jRVisiableResult.getStartYPos() != 0) {
                JRObjectResult jRObjectResult2;
                int n2 = 0;
                if (jRVisiableResult instanceof DSSection && ((jRObjectResult2 = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult2.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                    n2 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult2).getStartYPos());
                }
                rectangle.y = (n = n2) > 0 ? Unit.convertUnitToPixel(n, this.resolution) : 0;
            } else {
                rectangle.y -= this.startY;
            }
            if (bl && n > 0) {
                rectangle.height = Math.min(this.getBounds().height, rectangle.height);
            } else if (bl) {
                rectangle.height = Math.min(this.getBounds().height - rectangle.y, rectangle.height);
            }
            if (jRObjectRender instanceof JReportParagraph) {
                ((JReportParagraph)jRObjectRender).setActualSize(rectangle);
            } else if (jRObjectRender instanceof JReportParagraphText) {
                ((Component)((Object)jRObjectRender)).setBounds(rectangle);
            } else if (!(jRObjectRender instanceof JReportChartPlatform)) {
                ((Component)((Object)jRObjectRender)).setBounds(rectangle);
            }
            if (jRVisiableResult instanceof DSContainer) {
                ((JReportContainerable)((Object)jRObjectRender)).createChildren((DSContainer)jRVisiableResult);
            }
            if (jRObjectRender instanceof JReportChartPlatform) {
                ((Component)((Object)jRObjectRender)).setBounds(rectangle);
            }
        } else if (!(jRObjectResult instanceof DSGroup) && JRLog.isError(2)) {
            JRLog.error(2, 2401518, jRObjectResult);
        }
        return jRObjectRender;
    }

    public void setProperty(PropertySetable propertySetable, Record record) {
    }

    protected Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    protected boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    protected int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    protected Image getImagePropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getImagePropertyByName(jRObjectResult, string);
    }

    protected String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }
}

