/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.io.File;
import java.util.Vector;
import jet.JResource;
import jet.JetObjInspector.ObjectInfo;
import jet.ReportEnv;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.jetc.ReadFailureException;
import jet.jetc.ReportLoader;
import jet.log.JRLogger;
import jet.universe.JetUBuildInClassNode;
import jet.universe.JetUTree;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDefinedClassNode;

public abstract class JetUClassTreeNode
extends JetUTree {
    public JetString name = new JetString(this, "Name");
    public JetString desc = new JetString(this, "Description");
    protected transient ObjectInfo objInfo = null;
    private static final String GetCurrentUniverse;
    public static final String extCls = ".jcls";
    private transient String addClass = null;
    private static JRLogger addElement;
    static Class class$jet$universe$JetUClassTreeNode;
    static final boolean $assertionsDisabled;

    public JetUClassTreeNode() {
    }

    public JetUClassTreeNode(String string, String string2) {
        this.setName(string);
        this.setDesc(string2);
    }

    public JetObject add(JetObject jetObject, int n) {
        if (!($assertionsDisabled || jetObject instanceof JetUClassTreeNode && ((JetUClassTreeNode)jetObject).getName() != null)) {
            throw new AssertionError((Object)("Invalid child of JetUClassTreeNode! " + jetObject.getClass().getName() + " Can not be child of " + this.getClass().getName()));
        }
        super.add(jetObject, n);
        return jetObject;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String string) {
        this.name.set(string);
    }

    public String getFullJetcFile() {
        String string = this.getPath() + this.getName() + extCls;
        File file = new File(string);
        string = file != null && file.exists() ? file.getPath() : null;
        return string;
    }

    public abstract String getPath();

    public String toString() {
        Vector vector = this.getChildren();
        int n = vector.size();
        String string = this.getName();
        if (n > 0) {
            string = string + "[";
            int n2 = 0;
            while (n2 < n) {
                string = string + ((JetUClassTreeNode)vector.elementAt(n2)).toString() + " ";
                ++n2;
            }
            string = string + "]";
        }
        return string;
    }

    public String getDesc() {
        return this.desc.get();
    }

    public void setDesc(String string) {
        this.desc.set(string);
    }

    public JetUClassTreeNode addClass(JetUClassTreeNode jetUClassTreeNode) {
        this.add(jetUClassTreeNode);
        return jetUClassTreeNode;
    }

    public Vector getClasses() {
        Vector vector;
        Vector vector2 = vector = (Vector)this.getChildren().clone();
        int n = vector.size();
        JetUClassTreeNode jetUClassTreeNode = null;
        int n2 = 0;
        while (n2 < n) {
            jetUClassTreeNode = (JetUClassTreeNode)vector.elementAt(n2);
            JetUClassTreeNode.$assertionsDisabled(jetUClassTreeNode, vector2);
            ++n2;
        }
        return vector2;
    }

    public JetUClassTreeNode getClassByName(String string) {
        JetUClassTreeNode jetUClassTreeNode = null;
        JetUClassTreeNode jetUClassTreeNode2 = null;
        Vector vector = this.getClasses();
        int n = 0;
        while (n < vector.size()) {
            jetUClassTreeNode2 = (JetUClassTreeNode)vector.elementAt(n);
            if (jetUClassTreeNode2.getName().equalsIgnoreCase(string)) {
                jetUClassTreeNode = jetUClassTreeNode2;
                break;
            }
            ++n;
        }
        return jetUClassTreeNode;
    }

    protected boolean createObjectInfo(StringBuffer stringBuffer) {
        String string = this.getFullJetcFile();
        boolean bl = false;
        if (string != null) {
            ReportLoader reportLoader = new ReportLoader(string);
            try {
                this.objInfo = new ObjectInfo(reportLoader.loadObject(), null);
                bl = true;
            }
            catch (ReadFailureException readFailureException) {
                stringBuffer.append(readFailureException.toString());
            }
        } else {
            stringBuffer.append(JResource.getMessage("CAT_11", new Object[]{this.getName(), this.getPath()}));
        }
        return bl;
    }

    public ObjectInfo getObjectInfo(StringBuffer stringBuffer) {
        if (this.objInfo == null) {
            this.createObjectInfo(stringBuffer);
        }
        return this.objInfo;
    }

    public JetObject getInstance(StringBuffer stringBuffer) {
        this.getObjectInfo(stringBuffer);
        if (this.objInfo != null) {
            return this.objInfo.getObject();
        }
        return null;
    }

    public JetUUniverse getUniverse() {
        JetUTreeNode jetUTreeNode = (JetUTreeNode)((Object)this.getParent());
        while (jetUTreeNode != null) {
            if (jetUTreeNode instanceof JetUUniverse) {
                return (JetUUniverse)jetUTreeNode;
            }
            jetUTreeNode = (JetUTreeNode)((Object)jetUTreeNode.getParent());
        }
        return null;
    }

    public static boolean isValidClassName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public JetUUserDefinedClassNode addDerivedClass(String string, String string2, StringBuffer stringBuffer) {
        JetUUserDefinedClassNode jetUUserDefinedClassNode = null;
        jetUUserDefinedClassNode = new JetUUserDefinedClassNode(string, string2);
        JetObject jetObject = this.getInstance(stringBuffer);
        if (jetObject != null) {
            JetObject jetObject2 = jetObject.deepDup();
            jetUUserDefinedClassNode.setInstance(jetObject2);
            boolean bl = jetUUserDefinedClassNode.I(stringBuffer);
            if (!bl) {
                jetUUserDefinedClassNode = null;
            } else {
                this.addClass(jetUUserDefinedClassNode);
            }
        } else {
            jetUUserDefinedClassNode = null;
        }
        return jetUUserDefinedClassNode;
    }

    public synchronized JetUClassTreeNode removeClass(JetUUserDefinedClassNode jetUUserDefinedClassNode) {
        boolean bl = false;
        String string = jetUUserDefinedClassNode.getFullJetcFile();
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                bl = file.delete();
            }
        } else {
            bl = true;
        }
        return bl ? (JetUClassTreeNode)this.remove(jetUUserDefinedClassNode) : null;
    }

    public String getUnvPath() {
        if (this.addClass == null) {
            JetUUniverse jetUUniverse = JetUUniverse.GetCurrentUniverse();
            if (!$assertionsDisabled && jetUUniverse == null) {
                throw new AssertionError((Object)"Not found the current universe!");
            }
            this.addClass = jetUUniverse.getFilePath();
        }
        return this.addClass;
    }

    protected String getTempPath() {
        return GetCurrentUniverse.endsWith(File.separator) ? GetCurrentUniverse : GetCurrentUniverse + File.separator;
    }

    protected JetUUserDefinedClassNode buildAllUserClassTree() {
        JetUUserDefinedClassNode jetUUserDefinedClassNode = new JetUUserDefinedClassNode();
        jetUUserDefinedClassNode.setParent(new JetUUniverse());
        Vector vector = this.getChildren();
        JetUClassTreeNode jetUClassTreeNode = null;
        int n = 0;
        while (n < vector.size()) {
            jetUClassTreeNode = (JetUClassTreeNode)vector.elementAt(n);
            if (jetUClassTreeNode instanceof JetUBuildInClassNode && ((JetUBuildInClassNode)jetUClassTreeNode).getDerived()) {
                jetUUserDefinedClassNode.add(JetUClassTreeNode.I(jetUClassTreeNode));
            }
            ++n;
        }
        return jetUUserDefinedClassNode;
    }

    static JetUClassTreeNode I(JetUClassTreeNode jetUClassTreeNode) {
        String string = jetUClassTreeNode.getName();
        JetUClassTreeNode jetUClassTreeNode2 = null;
        jetUClassTreeNode2 = jetUClassTreeNode instanceof JetUBuildInClassNode ? new JetUBuildInClassNode(string, jetUClassTreeNode.getDesc()) : new JetUUserDefinedClassNode(string, jetUClassTreeNode.getDesc());
        Vector vector = jetUClassTreeNode.getChildren();
        JetUClassTreeNode jetUClassTreeNode3 = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            jetUClassTreeNode3 = (JetUClassTreeNode)vector.elementAt(n2);
            jetUClassTreeNode2.add(JetUClassTreeNode.I(jetUClassTreeNode3));
            ++n2;
        }
        return jetUClassTreeNode2;
    }

    static void $assertionsDisabled(JetUClassTreeNode jetUClassTreeNode, Vector vector) {
        Vector vector2 = jetUClassTreeNode.getChildren();
        int n = vector2.size();
        JetUClassTreeNode jetUClassTreeNode2 = null;
        int n2 = 0;
        while (n2 < n) {
            jetUClassTreeNode2 = (JetUClassTreeNode)vector2.elementAt(n2);
            vector.addElement(jetUClassTreeNode2);
            JetUClassTreeNode.$assertionsDisabled(jetUClassTreeNode2, vector);
            ++n2;
        }
    }

    public static JetUBuildInClassNode getBuildSuperNode(JetUClassTreeNode jetUClassTreeNode) {
        if (jetUClassTreeNode instanceof JetUBuildInClassNode) {
            return (JetUBuildInClassNode)jetUClassTreeNode;
        }
        JetObject jetObject = (JetObject)((Object)jetUClassTreeNode.getParent());
        if (jetObject instanceof JetUClassTreeNode) {
            return JetUClassTreeNode.getBuildSuperNode((JetUClassTreeNode)jetObject);
        }
        return null;
    }

    public String getBuildSuperType() {
        JetUBuildInClassNode jetUBuildInClassNode = JetUClassTreeNode.getBuildSuperNode(this);
        if (jetUBuildInClassNode != null) {
            return jetUBuildInClassNode.getBuildType();
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUClassTreeNode == null ? (class$jet$universe$JetUClassTreeNode = JetUClassTreeNode.class$("jet.universe.JetUClassTreeNode")) : class$jet$universe$JetUClassTreeNode).desiredAssertionStatus();
        GetCurrentUniverse = ReportEnv.templatePath;
        addElement = JRLogger.getLogger((class$jet$universe$JetUClassTreeNode == null ? (class$jet$universe$JetUClassTreeNode = JetUClassTreeNode.class$("jet.universe.JetUClassTreeNode")) : class$jet$universe$JetUClassTreeNode).getName());
    }
}

