/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.sql.SQLException;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.log.JRLogger;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFolderTree;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUProcedure;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUTransformRelationSchema;
import jet.universe.JetUUniverse;
import jet.universe.exception.AddTableViewException;
import jet.universe.psql.FileQuery;
import toolkit.db.DateTimeFormat;
import toolkit.db.ProcInfo;
import toolkit.db.TableInfo;

public abstract class JetUConnection
extends JetUResourceContainer
implements DateTimeFormat {
    public static final int PATTERN_1PART_NAME = 0;
    public static final int PATTERN_2PART_NAME = 1;
    public static final int PATTERN_3PART_NAME = 2;
    public static final int ENCODINGAUTO = 0;
    public static final int ENCODINGYES = 1;
    public static final int ENCODINGNO = 2;
    static Character I;
    protected static JRLogger logger;
    public JetEnumeration qualifiedNamePattern = new JetEnumeration(this, "QualifiedNamePattern", 82);
    public JetBoolean preJoin = new JetBoolean(this, "Pre-join", false);
    public JetString dateFormat = new JetString(this, "DateFormat");
    public JetString timeFormat = new JetString(this, "TimeFormat");
    public JetString timestampFormat = new JetString(this, "TimestampFormat");
    public JetBoolean security = new JetBoolean(this, "SecurityCheck", false);
    public JetEnumeration encodingPattern = new JetEnumeration(this, "EncodingPattern", 34);
    static Class class$jet$universe$JetUConnection;
    static final boolean $assertionsDisabled;

    public JetUConnection() {
        this.$assertionsDisabled();
    }

    public JetUConnection(String string, String string2) {
        super(string, string2);
        this.$assertionsDisabled();
    }

    private void $assertionsDisabled() {
        this.security.set(false);
    }

    void I() {
        Vector vector = this.getChildren();
        JetObject jetObject = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUFileQuery) {
                ((JetUFileQuery)jetObject).I();
            }
            ++n2;
        }
    }

    public JetUDatabase getDatabase() {
        return (JetUDatabase)this.getParent();
    }

    public JetObject add(JetObject jetObject, int n) {
        if (!($assertionsDisabled || jetObject instanceof JetUTableView || jetObject instanceof JetUProcedure || jetObject instanceof JetUFileQuery || jetObject instanceof JetUSupportInfo || jetObject instanceof JetUFolderTree || jetObject instanceof JetUTransformRelationSchema || jetObject instanceof MetadataContainerImpl)) {
            throw new AssertionError((Object)("Invalid child of JetUConnection!" + jetObject.getClass().getName() + " Can not be child of " + this.getClass().getName()));
        }
        super.add(jetObject, n);
        return jetObject;
    }

    public JetUTableView addTableView(String string, int n, String string2, String string3, String string4) {
        JetUTableView jetUTableView = new JetUTableView(string, "", n, string2, string3, string4);
        boolean bl = this.addTableView(jetUTableView);
        if (bl) {
            return jetUTableView;
        }
        return null;
    }

    public JetUTableView addTableView(String string, TableInfo tableInfo) {
        return this.addTableView(string, tableInfo, null);
    }

    public JetUTableView addTableView(String string, TableInfo tableInfo, Character c) {
        JetUTableView jetUTableView = new JetUTableView(string, "", tableInfo);
        boolean bl = this.addTableView(jetUTableView, c);
        if (bl) {
            return jetUTableView;
        }
        return null;
    }

    public boolean addTableView(JetUTableView jetUTableView) {
        return this.addTableView(jetUTableView, null);
    }

    public boolean addTableView(JetUTableView jetUTableView, Character c) {
        if (!this.isNameExist(jetUTableView.getResourceName())) {
            this.add(jetUTableView);
            jetUTableView.InitAfterCreate(c);
            JetUUniverse jetUUniverse = (JetUUniverse)this.getDatabase().getParent();
            if (jetUUniverse.editor != null) {
                jetUUniverse.editor.addTableView(jetUTableView, this.getDatabase().getResourceName());
            }
            return true;
        }
        return false;
    }

    public boolean removeTableView(String string) {
        JetUTableView jetUTableView = this.GetTableByResourceName(string);
        if (jetUTableView != null) {
            return this.removeTableView(jetUTableView);
        }
        return false;
    }

    public boolean removeTableView(JetUTableView jetUTableView) {
        JetUUniverse jetUUniverse = (JetUUniverse)this.getDatabase().getParent();
        if (jetUUniverse.editor != null) {
            jetUUniverse.editor.removeTableView(jetUTableView.tableName.get(), this.getDatabase().getResourceName());
        }
        this.remove(jetUTableView);
        return true;
    }

    public Vector getTables() {
        return this.getTableViews(1);
    }

    public JetUTableView GetTableByResourceName(String string) {
        return this.getTableViewsByResourceName(string, 1);
    }

    public Vector getViews() {
        return this.getTableViews(2);
    }

    public JetUTableView GetViewByResourceName(String string) {
        return this.getTableViewsByResourceName(string, 2);
    }

    public JetUTableView GetTableOrViewByResourceName(String string) {
        return this.getTableViewsByResourceName(string, 15);
    }

    public JetUTableView GetTableOrViewByRealName(String string) {
        return this.getTableViewBy3PartName(null, null, string, 15);
    }

    public Vector getTableViews() {
        return this.getTableViews(15);
    }

    public Vector getTableViews(int n) {
        Vector<JetObject> vector = new Vector<JetObject>();
        Vector vector2 = this.getChildren();
        int n2 = vector2.size();
        JetObject jetObject = null;
        int n3 = 0;
        while (n3 < n2) {
            jetObject = (JetObject)vector2.elementAt(n3);
            if (jetObject instanceof JetUTableView && (n & ((JetUTableView)jetObject).getTableType()) != 0) {
                vector.addElement(jetObject);
            }
            ++n3;
        }
        return vector;
    }

    public JetUTableView getTableViewsByResourceName(String string, int n) {
        Vector vector = this.getChildren();
        int n2 = vector.size();
        JetObject jetObject = null;
        JetUTableView jetUTableView = null;
        int n3 = 0;
        while (n3 < n2) {
            jetObject = (JetObject)vector.elementAt(n3);
            if (jetObject instanceof JetUTableView && (n & (jetUTableView = (JetUTableView)jetObject).getTableType()) != 0 && jetUTableView.getResourceName().equalsIgnoreCase(string)) {
                return jetUTableView;
            }
            ++n3;
        }
        return null;
    }

    public JetUTableView getTableViewBy3PartName(String string, String string2, String string3, int n) {
        Vector vector = this.getTableViewsBy3PartName(string, string2, string3, n);
        if (vector.size() > 0) {
            return (JetUTableView)vector.elementAt(0);
        }
        return null;
    }

    public Vector getTableViewsBy3PartName(String string, String string2, String string3, int n) {
        Vector<JetUTableView> vector = new Vector<JetUTableView>();
        Vector vector2 = this.getChildren();
        int n2 = vector2.size();
        JetObject jetObject = null;
        JetUTableView jetUTableView = null;
        int n3 = 0;
        while (n3 < n2) {
            jetObject = (JetObject)vector2.elementAt(n3);
            if (jetObject instanceof JetUTableView && (n & (jetUTableView = (JetUTableView)jetObject).getTableType()) != 0 && (string == null || string.equalsIgnoreCase(jetUTableView.getQualifier())) && (string2 == null || string2.equalsIgnoreCase(jetUTableView.getOwner())) && string3.equalsIgnoreCase(jetUTableView.getTableName())) {
                vector.addElement(jetUTableView);
            }
            ++n3;
        }
        return vector;
    }

    public JetUProcedure addProcedure(String string, ProcInfo procInfo) {
        JetUProcedure jetUProcedure = new JetUProcedure(string, "", procInfo);
        if (!this.isQueryNameExist(jetUProcedure.getResourceName())) {
            this.add(jetUProcedure);
            jetUProcedure.InitProcedure();
            return jetUProcedure;
        }
        return null;
    }

    public boolean addProcedure(JetUProcedure jetUProcedure) {
        if (!this.isQueryNameExist(jetUProcedure.getResourceName())) {
            this.add(jetUProcedure);
            jetUProcedure.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeProcedure(String string) {
        JetUProcedure jetUProcedure = this.getProcedureByResourceName(string);
        if (jetUProcedure != null) {
            return this.removeProcedure(jetUProcedure);
        }
        return false;
    }

    public boolean removeProcedure(JetUProcedure jetUProcedure) {
        this.remove(jetUProcedure);
        return true;
    }

    public Vector getProcedures() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUProcedure) {
                vector.addElement(jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public JetUProcedure getProcedureByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        JetUProcedure jetUProcedure = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUProcedure && (jetUProcedure = (JetUProcedure)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return jetUProcedure;
            }
            ++n2;
        }
        return null;
    }

    public JetUFileQuery addFileQuery(String string, FileQuery fileQuery) {
        JetUFileQuery jetUFileQuery = new JetUFileQuery(string, "", fileQuery);
        boolean bl = this.addFileQuery(jetUFileQuery);
        if (bl) {
            return jetUFileQuery;
        }
        return null;
    }

    public boolean addFileQuery(JetUFileQuery jetUFileQuery) {
        if (!this.isQueryNameExist(jetUFileQuery.getResourceName())) {
            this.add(jetUFileQuery);
            jetUFileQuery.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean addFileQueryAfterInit(JetUFileQuery jetUFileQuery) {
        if (!this.isQueryNameExist(jetUFileQuery.getResourceName())) {
            this.add(jetUFileQuery);
            jetUFileQuery.initAfterAdd();
            return true;
        }
        return false;
    }

    public boolean removeFileQUery(String string) {
        JetUFileQuery jetUFileQuery = this.GetFileQueryByResourceName(string);
        if (jetUFileQuery != null) {
            return this.removeFileQuery(jetUFileQuery);
        }
        return false;
    }

    public boolean removeFileQuery(JetUFileQuery jetUFileQuery) {
        this.remove(jetUFileQuery);
        return true;
    }

    public Vector getFileQueries() {
        Vector<JetObject> vector = new Vector<JetObject>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUFileQuery) {
                vector.addElement(jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public JetUFolderTree getFolderTree() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUFolderTree) {
                return (JetUFolderTree)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public JetUFileQuery GetFileQueryByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        JetUFileQuery jetUFileQuery = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUFileQuery && (jetUFileQuery = (JetUFileQuery)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return jetUFileQuery;
            }
            ++n2;
        }
        return null;
    }

    public boolean IsTableNameExist(String string) {
        return this.GetTableOrViewByResourceName(string) != null;
    }

    public boolean isFileQueryNameExist(String string) {
        return this.GetFileQueryByResourceName(string) != null;
    }

    public boolean isProcedureNameExist(String string) {
        return this.getProcedureByResourceName(string) != null;
    }

    public boolean isNameExist(String string) {
        return this.IsTableNameExist(string) || this.isFileQueryNameExist(string) || this.isProcedureNameExist(string);
    }

    public JetUDBTreeNode getByResourceName(String string) {
        JetUResourceContainer jetUResourceContainer = this.GetTableOrViewByResourceName(string);
        if (jetUResourceContainer != null) {
            return jetUResourceContainer;
        }
        jetUResourceContainer = this.GetFileQueryByResourceName(string);
        if (jetUResourceContainer != null) {
            return jetUResourceContainer;
        }
        jetUResourceContainer = this.getProcedureByResourceName(string);
        if (jetUResourceContainer != null) {
            return jetUResourceContainer;
        }
        return this.getDatabase().getResourceByName(string);
    }

    public boolean isQueryNameExist(String string) {
        return this.isNameExist(string) || this.getDatabase().IsQueryNameExist(string);
    }

    public abstract JetUConnection createNew();

    public abstract void connect() throws Exception;

    public abstract void disconnect() throws Exception;

    public abstract boolean isConnecting();

    public abstract Vector getFieldsOfTable(String var1, String var2, String var3) throws SQLException, ClassNotFoundException;

    public abstract boolean cnntToSameDB(JetUConnection var1);

    public int getQualifiedNamePattern() {
        return this.qualifiedNamePattern.intValue();
    }

    public void setQualifiedNamePattern(int n) {
        this.qualifiedNamePattern.set(new Integer(n));
    }

    public boolean isPreJoin() {
        return this.preJoin.get();
    }

    public void setPrejoin(boolean bl) {
        this.preJoin.set(bl);
    }

    public abstract JetUSupportInfo getSupportInfo();

    public String getDateFormat() {
        return this.dateFormat.get();
    }

    public void setDateFormat(String string) {
        this.dateFormat.set(string);
    }

    public String getTimeFormat() {
        return this.timeFormat.get();
    }

    public void setTimeFormat(String string) {
        this.timeFormat.set(string);
    }

    public String getTimestampFormat() {
        return this.timestampFormat.get();
    }

    public void setTimestampFormat(String string) {
        this.timestampFormat.set(string);
    }

    public abstract TableInfo createTableInfo(String var1, String var2, String var3, int var4) throws SQLException, ClassNotFoundException;

    public abstract void fetchSupportInfo() throws SQLException, ClassNotFoundException;

    public abstract void updateSupportInfo() throws SQLException, ClassNotFoundException;

    public abstract Vector addTableViews(String var1, String var2, String var3, int var4) throws ClassNotFoundException, SQLException, AddTableViewException;

    public abstract Vector getTypeInfo();

    protected boolean isMatchingType(int n, int n2) {
        if ((n2 & 1) != 0 && n == 1) {
            return true;
        }
        return (n2 & 2) != 0 && n == 2;
    }

    public boolean isSecurityCheck() {
        return this.security.get();
    }

    public static final int mapColType(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n += 82;
                break;
            }
        }
        return n;
    }

    protected JetUJDBCTypeInfo getTypeInfo(int n) {
        JetUJDBCTypeInfo jetUJDBCTypeInfo = null;
        Vector vector = this.getTypeInfo();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            jetUJDBCTypeInfo = (JetUJDBCTypeInfo)vector.elementAt(n3);
            if (jetUJDBCTypeInfo.DataType.get() == n) {
                return jetUJDBCTypeInfo;
            }
            ++n3;
        }
        return jetUJDBCTypeInfo;
    }

    protected abstract boolean isSQLTypeCaseSensitive(int var1);

    public int getEncodingPattern() {
        return this.encodingPattern.intValue();
    }

    public void setEncodingPattern(int n) {
        this.encodingPattern.set(new Integer(n));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUConnection == null ? (class$jet$universe$JetUConnection = JetUConnection.class$("jet.universe.JetUConnection")) : class$jet$universe$JetUConnection).desiredAssertionStatus();
        I = new Character('_');
        logger = JRLogger.getLogger((class$jet$universe$JetUConnection == null ? (class$jet$universe$JetUConnection = JetUConnection.class$("jet.universe.JetUConnection")) : class$jet$universe$JetUConnection).getName());
    }
}

