/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetPassword;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUJdbcSupportInfo;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.exception.AddTableViewException;
import jet.util.HashVector;
import toolkit.db.ConnectionInfo;
import toolkit.db.DbTools;
import toolkit.db.TableInfo;
import toolkit.db.gui.ConnectionsBroker;
import toolkit.db.gui.MappingSQLType;

public class JetUJDBCConnection
extends JetUConnection {
    public static final int EXTRA_NAME_JDBC = 0;
    public static final int EXTRA_NAME_USERDEFINED = 1;
    public static final int TRANSACTION_DEFAULT = 0;
    public static final int TRANSACTION_NONE = 1;
    public static final int TRANSACTION_READ_UNCOMMITTED = 2;
    public static final int TRANSACTION_READ_COMMITTED = 3;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 5;
    public static final int READ_ONLY_DEFAULT = 1;
    public static final int READ_ONLY_TRUE = 2;
    public static final int READ_ONLY_FALSE = 0;
    public JetString url = new JetString(this, "URL");
    public JetString drv = new JetString(this, "Driver");
    public JetString user = new JetString(this, "User");
    public JetPassword password = new JetPassword(this, "Password");
    public JetEnumeration extraNamePattern = new JetEnumeration(this, "ExtraNamePattern", 35);
    public JetBoolean uptoDateSI = new JetBoolean(this, "uptoDateSI");
    public JetEnumeration transactionIsolation = new JetEnumeration(this, "TransactionIsolation", 98);
    public JetEnumeration readOnly = new JetEnumeration(this, "ReadOnly", 84);
    public JetString sqlNameAnalyser = new JetString(this, "SQLNameAnalyser");
    public JetString sqlStmtCreator = new JetString(this, "SQLStmtCreator");
    public JetVector schemaNames = new JetVector(this, "SchemaName");
    protected transient Connection connection = null;
    public transient int conFlag = 0;
    private static JRLogger CaseSensitive = JRLogger.getLogger((class$jet$universe$JetUJDBCConnection == null ? (class$jet$universe$JetUJDBCConnection = JetUJDBCConnection.class$("jet.universe.JetUJDBCConnection")) : class$jet$universe$JetUJDBCConnection).getName());
    private static final HashMap DEF_DATE_FORMAT = new HashMap(20);
    private static final HashVector DEF_TIMESTAMP_FORMAT;
    static Class class$jet$universe$JetUJDBCConnection;

    public JetUJDBCConnection() {
        this.initialize();
    }

    public JetUJDBCConnection(String string, String string2, String string3, String string4, String string5, int n, String string6) throws SQLException, ClassNotFoundException {
        super(string, string2);
        this.initialize();
        this.url.set(string3);
        this.user.set(string4);
        this.password.set(string5);
        this.drv.set(string6);
        this.qualifiedNamePattern.set(new Integer(n));
        this.createSupportInfo();
    }

    public JetUJDBCConnection(String string, String string2, ConnectionInfo connectionInfo) throws SQLException, ClassNotFoundException {
        super(string, string2);
        this.initialize();
        this.setConnectionInfo(connectionInfo);
        connectionInfo = null;
    }

    protected void initialize() {
        this.qualifiedNamePattern.set(new Integer(0));
        this.extraNamePattern.set(new Integer(0));
        this.encodingPattern.set(new Integer(0));
        this.dateFormat.set(DbTools.DEF_DATE_FORMAT);
        this.timeFormat.set(DbTools.DEF_TIME_FORMAT);
        this.timestampFormat.set(DbTools.DEF_TIMESTAMP_FORMAT);
        this.uptoDateSI.set(false);
        this.uptoDateSI.setEditFlag(3);
        this.transactionIsolation.set(new Integer(0));
        this.readOnly.set(new Integer(1));
        this.security.set(false);
        this.sqlNameAnalyser.setEditFlag(3);
        this.preJoin.set(true);
    }

    protected void createSupportInfo() throws SQLException, ClassNotFoundException {
        JetUJdbcSupportInfo jetUJdbcSupportInfo = new JetUJdbcSupportInfo();
        this.add(jetUJdbcSupportInfo);
        this.fetchSupportInfo();
    }

    public boolean cnntToSameDB(JetUConnection jetUConnection) {
        if (jetUConnection instanceof JetUJDBCConnection) {
            String string = this.getURL();
            String string2 = ((JetUJDBCConnection)jetUConnection).getURL();
            return string.equalsIgnoreCase(string2);
        }
        return false;
    }

    public String getURL() {
        if (this.url.get() == null) {
            return this.url.get();
        }
        return this.url.get().trim();
    }

    public void setURL(String string) {
        this.url.set(string);
    }

    public String getJdbcDriver() {
        if (this.drv.get() == null) {
            return this.drv.get();
        }
        return this.drv.get().trim();
    }

    public void setJdbcDriver(String string) {
        this.drv.set(string);
    }

    public String getUID() {
        return this.user.get();
    }

    public void setUID(String string) {
        this.user.set(string);
    }

    public String getPSWD() {
        return this.password.get();
    }

    public void setPSWD(String string) {
        this.password.set(string);
    }

    public int getExtraNamePattern() {
        return this.extraNamePattern.intValue();
    }

    public void setExtraNamePattern(int n) {
        this.extraNamePattern.set(new Integer(n));
    }

    public boolean isUptoDateSupportInfo() {
        return this.uptoDateSI.get();
    }

    public void setTransactionIsolation(int n) {
        this.transactionIsolation.set(new Integer(n));
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation.intValue();
    }

    public void setReadOnly(int n) {
        this.readOnly.set(new Integer(n));
    }

    public int getReadOnly() {
        return this.readOnly.intValue();
    }

    public ConnectionInfo getConnectionInfo() {
        return new ConnectionInfo(this.getURL(), this.getUID(), this.getPSWD(), this.getJdbcDriver(), this.getQualifiedNamePattern(), this.getExtraNamePattern(), this.getSupportInfo().getExtraNameChar(), this.getSupportInfo().getQuoteChar(), this.getEncodingPattern(), this.getDateFormat(), this.getTimeFormat(), this.getTimestampFormat(), this.isUptoDateSupportInfo(), this.getTransactionIsolation(), this.getReadOnly());
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.setURL(connectionInfo.getUrl());
        this.setUID(connectionInfo.getUid());
        this.setPSWD(connectionInfo.getPassword());
        this.setJdbcDriver(connectionInfo.getDriver());
        this.setQualifiedNamePattern(connectionInfo.getQualifiedNamePattern());
        this.setDateFormat(connectionInfo.getDateFormat());
        this.setTimeFormat(connectionInfo.getTimeFormat());
        this.setTimestampFormat(connectionInfo.getTimestampFormat());
        int n = connectionInfo.getExtraNamePattern();
        if (this.getExtraNamePattern() == 1) {
            this.getSupportInfo().setExtraNameChar(connectionInfo.getExtraNameChar());
            this.getSupportInfo().setQuoteChar(connectionInfo.getQuoteNameChar());
        } else {
            try {
                this.fetchSupportInfo();
            }
            catch (SQLException sQLException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.setExtraNamePattern(n);
        this.setEncodingPattern(connectionInfo.getEncodingPattern());
        this.setTransactionIsolation(connectionInfo.getTransactionIsolation());
        this.setReadOnly(connectionInfo.getReadOnly());
        this.setUptoDateSupportInfo(connectionInfo.isUptoDateSupportInfo());
    }

    public void setUptoDateSupportInfo(boolean bl) {
        this.uptoDateSI.set(bl);
    }

    public void updateSupportInfo() throws SQLException, ClassNotFoundException {
        if (this.uptoDateSI.get()) {
            this.fetchSupportInfo();
            this.setUptoDateSupportInfo(false);
        }
    }

    public void fetchSupportInfo() throws SQLException, ClassNotFoundException {
        boolean bl = this.isConnecting();
        if (!bl) {
            this.connect();
        }
        JetUJdbcSupportInfo jetUJdbcSupportInfo = this.getJdbcSupportInfo();
        jetUJdbcSupportInfo.fetchJDBCSupportInfo(this.getConnection());
        if (!bl) {
            this.disconnect();
        }
    }

    public Vector getTypeInfo() {
        JetUJdbcSupportInfo jetUJdbcSupportInfo = this.getJdbcSupportInfo();
        if (jetUJdbcSupportInfo != null) {
            Vector vector;
            block10: {
                vector = jetUJdbcSupportInfo.getTypeInfo();
                if (vector.size() == 0 && this.conFlag != 1) {
                    try {
                        boolean bl = this.isConnecting();
                        int n = 0;
                        while (!bl && n < 3) {
                            block9: {
                                try {
                                    this.connect();
                                }
                                catch (SQLException sQLException) {
                                    if (n < 2) break block9;
                                    throw sQLException;
                                }
                            }
                            bl = this.isConnecting();
                            ++n;
                        }
                        jetUJdbcSupportInfo.I(this.getConnection());
                        if (bl) {
                            this.disconnect();
                        }
                        vector = jetUJdbcSupportInfo.getTypeInfo();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (SQLException sQLException) {
                        if (this.isConnecting() || this.conFlag == 2) break block10;
                        this.conFlag = 1;
                    }
                }
            }
            return vector;
        }
        return null;
    }

    protected boolean isSQLTypeCaseSensitive(int n) {
        JetUJDBCTypeInfo jetUJDBCTypeInfo = this.getTypeInfo(n);
        return jetUJDBCTypeInfo == null ? false : jetUJDBCTypeInfo.CaseSensitive.get();
    }

    public JetUConnection createNew() {
        JetUJDBCConnection jetUJDBCConnection = new JetUJDBCConnection();
        jetUJDBCConnection.setResourceName(this.getResourceName());
        jetUJDBCConnection.setUptoDateSupportInfo(true);
        JetObject.copyProperties(jetUJDBCConnection, this);
        try {
            jetUJDBCConnection.createSupportInfo();
        }
        catch (SQLException sQLException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JetUSupportInfo jetUSupportInfo = jetUJDBCConnection.getSupportInfo();
        JetUSupportInfo jetUSupportInfo2 = this.getSupportInfo();
        jetUSupportInfo.setExtraNameChar(jetUSupportInfo2.getExtraNameChar());
        jetUSupportInfo.setQuoteChar(jetUSupportInfo2.getQuoteChar());
        return jetUJDBCConnection;
    }

    public void copyPropsFrom(JetUJDBCConnection jetUJDBCConnection) {
        this.setDesc(jetUJDBCConnection.getDesc());
        this.setURL(jetUJDBCConnection.getURL());
        this.setUID(jetUJDBCConnection.getUID());
        this.setPSWD(jetUJDBCConnection.getPSWD());
        this.setQualifiedNamePattern(jetUJDBCConnection.getQualifiedNamePattern());
        this.setJdbcDriver(jetUJDBCConnection.getJdbcDriver());
        this.setDateFormat(jetUJDBCConnection.getDateFormat());
        this.setTimeFormat(jetUJDBCConnection.getTimeFormat());
        this.setTimestampFormat(jetUJDBCConnection.getTimestampFormat());
        this.getSupportInfo().setExtraNameChar(jetUJDBCConnection.getSupportInfo().getExtraNameChar());
        this.getSupportInfo().setQuoteChar(jetUJDBCConnection.getSupportInfo().getQuoteChar());
        this.setExtraNamePattern(jetUJDBCConnection.getExtraNamePattern());
        this.setEncodingPattern(jetUJDBCConnection.getEncodingPattern());
        this.setTransactionIsolation(jetUJDBCConnection.getTransactionIsolation());
        this.setReadOnly(jetUJDBCConnection.getReadOnly());
        this.setPrejoin(jetUJDBCConnection.isPreJoin());
    }

    public Vector addTableViews(String string, String string2, String string3, int n) throws ClassNotFoundException, SQLException, AddTableViewException {
        Vector<String> vector = new Vector<String>();
        boolean bl = this.isConnecting();
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            this.connect();
        }
        Connection connection = this.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(string, string2, string3, null);
        String string4 = "";
        String string5 = "";
        String string6 = "";
        while (resultSet.next()) {
            string = resultSet.getString(1);
            string4 = resultSet.getString(2);
            string5 = resultSet.getString(3);
            int n2 = this.CaseSensitive(resultSet.getString(4));
            if (!this.isMatchingType(n2, n)) continue;
            String string7 = string5;
            int n3 = 0;
            while (this.isNameExist(string7)) {
                string7 = string5 + String.valueOf(n3);
                ++n3;
            }
            TableInfo tableInfo = this.createTableInfo(string, string4, string5, n2);
            JetUTableView jetUTableView = this.addTableView(string7, tableInfo);
            if (jetUTableView == null) {
                stringBuffer.append("Catalog Name: " + string + "\n" + "Schema Name: " + string4 + "\n" + "Table Name: " + string5);
            }
            vector.addElement(string7);
        }
        resultSet.close();
        if (!bl) {
            this.disconnect();
        }
        if (stringBuffer.length() > 0) {
            throw new AddTableViewException(0, stringBuffer.toString());
        }
        return vector;
    }

    private int CaseSensitive(String string) {
        if (string.indexOf("TABLE") != -1) {
            return 1;
        }
        if (string.indexOf("VIEW") != -1) {
            return 2;
        }
        return -1;
    }

    public void connect() throws SQLException, ClassNotFoundException {
        this.connection = ConnectionsBroker.getConnection(this.getURL(), this.user.get(), this.password.get(), this.getJdbcDriver(), this.getTransactionIsolation(), this.getReadOnly());
    }

    public Driver getDriver() {
        Driver driver;
        block7: {
            boolean bl;
            block6: {
                driver = null;
                bl = false;
                if (!this.isConnecting()) {
                    try {
                        this.connect();
                        bl = true;
                    }
                    catch (Exception exception) {
                        if (!CaseSensitive.isErrorEnabled()) break block6;
                        CaseSensitive.error("", exception);
                    }
                }
            }
            try {
                driver = DriverManager.getDriver(this.getURL());
                if (bl) {
                    this.disconnect();
                }
            }
            catch (SQLException sQLException) {
                if (!CaseSensitive.isErrorEnabled()) break block7;
                CaseSensitive.error("", sQLException);
            }
        }
        return driver;
    }

    public void disconnect() throws SQLException {
        if (this.connection != null) {
            ConnectionsBroker.freeConnection(this.connection);
            this.connection = null;
        }
    }

    public boolean isConnecting() {
        return this.connection != null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Vector getFieldsOfView(String string, String string2, String string3) throws SQLException, ClassNotFoundException {
        return this.getFieldsOfTable(string, string2, string3);
    }

    public Vector getFieldsOfTable(String string, String string2, String string3) throws SQLException, ClassNotFoundException {
        this.connect();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        String string4 = null;
        String string5 = databaseMetaData.getDriverName();
        if (string5.equals("InterClient")) {
            CaseSensitive.debug("The current JDBC driver is InterClient.  Use \"%\" to get information.");
            string4 = "%";
        }
        ResultSet resultSet = databaseMetaData.getColumns(string, string2, string3, string4);
        Vector<DbColDesc> vector = new Vector<DbColDesc>();
        boolean bl = resultSet.next();
        if (!bl) {
            string4 = "%";
            resultSet.close();
            resultSet = databaseMetaData.getColumns(string, string2, string3, string4);
            bl = resultSet.next();
        }
        boolean bl2 = false;
        while (bl) {
            DbColDesc dbColDesc = new DbColDesc(resultSet.getString(4).trim(), MappingSQLType.mapColType(resultSet.getInt(5)), resultSet.getInt(7), resultSet.getInt(9), resultSet.getInt(11));
            vector.addElement(dbColDesc);
            bl = resultSet.next();
        }
        resultSet.close();
        this.disconnect();
        return vector;
    }

    public static boolean IsConnectionOK(String string, String string2, String string3, String string4, StringBuffer stringBuffer) {
        try {
            Object object = "URL:\t" + string + "\n" + "User:\t" + string2 + "\n" + "Driver:\t" + string4 + "\n";
            CaseSensitive.debug(object);
            object = ConnectionsBroker.getConnection(string, string2, string3, string4);
            if (object != null) {
                ConnectionsBroker.freeConnection((Connection)object);
            }
            return true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage() == null || sQLException.getMessage().length() < 1) {
                stringBuffer.append("An error occurs when creating the connection. Check the connection settings.");
            } else {
                stringBuffer.append(sQLException.getMessage());
            }
            CaseSensitive.error("", sQLException);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string5 = classNotFoundException.getMessage();
            stringBuffer.append(JResource.getMessage("CAT_91", (Object)(string5 != null ? string5 : "")));
            CaseSensitive.error("", classNotFoundException);
            return false;
        }
    }

    public String getInstancePrefix() {
        return "JDBCConnection";
    }

    public JetUJdbcSupportInfo getJdbcSupportInfo() {
        return (JetUJdbcSupportInfo)this.getSupportInfo();
    }

    public TableInfo createTableInfo(String string, String string2, String string3, int n) throws SQLException {
        String string4;
        DatabaseMetaData databaseMetaData;
        if (this.connection == null) {
            try {
                this.connect();
            }
            catch (ClassNotFoundException classNotFoundException) {
                CaseSensitive.debug(classNotFoundException.getMessage());
            }
        }
        TableInfo tableInfo = new TableInfo(string, string2, string3, n);
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null && string.trim().length() > 0 && (databaseMetaData = this.connection.getMetaData()) != null && (string4 = databaseMetaData.getDriverName()) != null && ((string4 = string4.toUpperCase()).indexOf("SQLSRV") >= 0 || string4.indexOf("SQLServer") >= 0 || string4.indexOf("I-NET UNA") >= 0)) {
            this.connection.setCatalog(string);
        }
        databaseMetaData = this.connection.getMetaData();
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        string4 = null;
        String string5 = databaseMetaData.getDriverName();
        if (string5.equals("InterClient")) {
            CaseSensitive.debug("JDBC Connection\nThe current JDBC driver is InterClient.  Use \"%\" to get information.");
            string4 = "%";
        }
        ResultSet resultSet = databaseMetaData.getColumns(string, string2, string3, string4);
        Vector<Object> vector = new Vector<Object>();
        boolean bl = resultSet.next();
        if (!bl) {
            resultSet.close();
            string4 = "%";
            resultSet = databaseMetaData.getColumns(string, string2, string3, string4);
            bl = resultSet.next();
        }
        boolean bl2 = false;
        while (bl) {
            Object object;
            String string6 = resultSet.getString(4).trim();
            int n2 = resultSet.getInt(5);
            if (databaseMetaData.getDatabaseProductName().toUpperCase().indexOf("ORACLE") != -1 && n2 == 1111) {
                n2 = resultSet.getString(6).toUpperCase().equals("FLOAT") ? 8 : this.DEF_DATE_FORMAT(this.connection, string6, string2 + "." + string3, 5);
            }
            boolean bl3 = false;
            if (n2 == 2003) {
                bl3 = true;
                object = string3;
                if (string2 != null && string2.trim().length() > 0) {
                    object = "\"" + string2 + "\"" + "." + (String)object;
                }
                if (string != null && string.trim().length() > 0) {
                    object = "\"" + string + "\"" + "." + (String)object;
                }
                n2 = this.DEF_TIMESTAMP_FORMAT(this.connection, string6, (String)object);
            }
            object = new DbColDesc(string6, MappingSQLType.mapColType(n2), resultSet.getInt(7), resultSet.getInt(9), resultSet.getInt(11));
            if (bl3) {
                ((DbColDesc)object).setArray(true);
            }
            vector.addElement(object);
            bl = resultSet.next();
        }
        resultSet.close();
        tableInfo.setColumns(vector);
        return tableInfo;
    }

    private int DEF_DATE_FORMAT(Connection connection, String string, String string2, int n) throws SQLException {
        Statement statement = connection.createStatement();
        statement.setFetchSize(1);
        String string3 = "SELECT " + string + " FROM " + string2 + " WHERE 0 > 1 ";
        ResultSetMetaData resultSetMetaData = statement.executeQuery(string3).getMetaData();
        int n2 = 0;
        switch (n) {
            case 5: {
                n2 = resultSetMetaData.getColumnType(1);
                break;
            }
            case 7: {
                n2 = resultSetMetaData.getPrecision(1);
                break;
            }
            case 9: {
                n2 = resultSetMetaData.getScale(1);
                break;
            }
            case 11: {
                n2 = resultSetMetaData.isNullable(1);
                break;
            }
            default: {
                throw new Error("unknow sql info : " + n + " of the column " + string + " from the table " + string2);
            }
        }
        return n2;
    }

    private int DEF_TIMESTAMP_FORMAT(Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        statement.setFetchSize(1);
        String string3 = "SELECT " + string + " FROM " + string2;
        ResultSet resultSet = statement.executeQuery(string3);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnType(1);
        if (n == 2003) {
            if (resultSet.next()) {
                Array array = resultSet.getArray(1);
                if (array != null) {
                    n = array.getBaseType();
                } else {
                    n = 12;
                    CaseSensitive.debug("TableInfo\nFailed to get sql type for the column " + string + " in the table " + string2 + "! Type has been set to VARCHAR.");
                }
            }
        } else {
            throw new Error("not equ array type!  the column :" + string + " from the table " + string2);
        }
        return n;
    }

    public JetUSupportInfo getSupportInfo() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUJdbcSupportInfo) {
                return (JetUJdbcSupportInfo)jetObject;
            }
            ++n2;
        }
        JetUJdbcSupportInfo jetUJdbcSupportInfo = new JetUJdbcSupportInfo();
        this.add(jetUJdbcSupportInfo);
        return jetUJdbcSupportInfo;
    }

    public Vector getSchemaNames() {
        return this.schemaNames.get();
    }

    public void setSchemaNames(Vector vector) {
        this.schemaNames.set(vector);
    }

    public HashMap getIndecialMap() {
        return DEF_DATE_FORMAT;
    }

    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return DEF_TIMESTAMP_FORMAT;
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEF_DATE_FORMAT.put("TimeFormat", new Integer(0));
        DEF_DATE_FORMAT.put("Driver", new Integer(1));
        DEF_DATE_FORMAT.put("Description", new Integer(2));
        DEF_DATE_FORMAT.put("User", new Integer(3));
        DEF_DATE_FORMAT.put("SchemaName", new Integer(4));
        DEF_DATE_FORMAT.put("SQLNameAnalyser", new Integer(5));
        DEF_DATE_FORMAT.put("DateFormat", new Integer(6));
        DEF_DATE_FORMAT.put("TimestampFormat", new Integer(7));
        DEF_DATE_FORMAT.put("SQLStmtCreator", new Integer(8));
        DEF_DATE_FORMAT.put("URL", new Integer(9));
        DEF_DATE_FORMAT.put("EncodingPattern", new Integer(10));
        DEF_DATE_FORMAT.put("ReadOnly", new Integer(11));
        DEF_DATE_FORMAT.put("ExtraNamePattern", new Integer(12));
        DEF_DATE_FORMAT.put("uptoDateSI", new Integer(13));
        DEF_DATE_FORMAT.put("Name", new Integer(14));
        DEF_DATE_FORMAT.put("TransactionIsolation", new Integer(15));
        DEF_DATE_FORMAT.put("QualifiedNamePattern", new Integer(16));
        DEF_DATE_FORMAT.put("Password", new Integer(17));
        DEF_DATE_FORMAT.put("Pre-join", new Integer(18));
        DEF_DATE_FORMAT.put("SecurityCheck", new Integer(19));
        DEF_TIMESTAMP_FORMAT = new HashVector(1);
        String string = "anonymous";
        Vector<String> vector = new Vector<String>(20);
        vector.add("TimeFormat");
        vector.add("Driver");
        vector.add("Description");
        vector.add("User");
        vector.add("SchemaName");
        vector.add("SQLNameAnalyser");
        vector.add("DateFormat");
        vector.add("TimestampFormat");
        vector.add("SQLStmtCreator");
        vector.add("URL");
        vector.add("ReadOnly");
        vector.add("ExtraNamePattern");
        vector.add("uptoDateSI");
        vector.add("Name");
        vector.add("TransactionIsolation");
        vector.add("QualifiedNamePattern");
        vector.add("Password");
        vector.add("Pre-join");
        vector.add("SecurityCheck");
        DEF_TIMESTAMP_FORMAT.put(string, vector);
    }
}

