/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.dsdriver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import jet.ReportEnv;
import jet.log.JRLogger;
import jet.universe.dsdriver.UDSDriver;
import jet.universe.dsdriver.UDSDriverFormatException;
import jet.universe.dsdriver.UDSDriverManagerListener;

public class UDSDriverManager {
    protected static final String strDriverFile = "jrdata.drv";
    protected static boolean bLoad;
    protected static Vector vecDrivers;
    protected static Vector listeners;
    private static JRLogger DriverChanged;
    static Class class$jet$universe$dsdriver$UDSDriverManager;
    static final boolean $assertionsDisabled;

    protected static void Load() {
        File file = new File(ReportEnv.binPath, strDriverFile);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    vecDrivers.addElement(new UDSDriver(string));
                }
                catch (UDSDriverFormatException uDSDriverFormatException) {}
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void Save() {
        UDSDriverManager.initialize();
        File file = new File(ReportEnv.binPath, strDriverFile);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = vecDrivers.size();
            int n2 = 0;
            while (n2 < n) {
                UDSDriver uDSDriver = (UDSDriver)vecDrivers.elementAt(n2);
                if (!uDSDriver.I) {
                    String string = uDSDriver.getDriver();
                    bufferedWriter.write(string);
                    if (n2 + 1 < n) {
                        bufferedWriter.newLine();
                    }
                }
                ++n2;
            }
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DriverChanged.debug(fileNotFoundException);
        }
        catch (IOException iOException) {
            DriverChanged.debug(iOException);
        }
    }

    protected static void initialize() {
        if (!bLoad) {
            try {
                vecDrivers.addElement(new UDSDriver("CatalogQuery"));
            }
            catch (UDSDriverFormatException uDSDriverFormatException) {
                DriverChanged.debug(uDSDriverFormatException);
            }
            UDSDriverManager.Load();
            bLoad = true;
            UDSDriverManager.DriverChanged();
        }
    }

    public static void rollback() {
        vecDrivers.removeAllElements();
        try {
            vecDrivers.addElement(new UDSDriver("CatalogQuery"));
        }
        catch (UDSDriverFormatException uDSDriverFormatException) {
            DriverChanged.debug(uDSDriverFormatException);
        }
        UDSDriverManager.Load();
        UDSDriverManager.DriverChanged();
    }

    public static void addDriver(UDSDriver uDSDriver) {
        UDSDriverManager.initialize();
        vecDrivers.addElement(uDSDriver);
        UDSDriverManager.DriverChanged();
    }

    public static void removeDriver(UDSDriver uDSDriver) {
        UDSDriverManager.initialize();
        vecDrivers.removeElement(uDSDriver);
        UDSDriverManager.DriverChanged();
    }

    public static UDSDriver removeDriver(String string) {
        UDSDriverManager.initialize();
        UDSDriver uDSDriver = UDSDriverManager.getDriverByName(string);
        vecDrivers.removeElement(uDSDriver);
        UDSDriverManager.DriverChanged();
        return uDSDriver;
    }

    public static Vector getDrivers() {
        UDSDriverManager.initialize();
        return vecDrivers;
    }

    public static Vector getDriverStrings() {
        Vector vector = UDSDriverManager.getDrivers();
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            vector2.addElement(((UDSDriver)vector.elementAt(n2)).getDriver());
            ++n2;
        }
        return vector2;
    }

    public static Vector getDriversByScheme(String string) {
        UDSDriverManager.initialize();
        Vector<UDSDriver> vector = new Vector<UDSDriver>();
        int n = vecDrivers.size();
        int n2 = 0;
        while (n2 < n) {
            UDSDriver uDSDriver = (UDSDriver)vecDrivers.elementAt(n2);
            if (string.equalsIgnoreCase(uDSDriver.getScheme())) {
                vector.addElement(uDSDriver);
            }
            ++n2;
        }
        return vector;
    }

    public static Vector getDriverStringsByScheme(String string) {
        Vector vector = UDSDriverManager.getDriversByScheme(string);
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            vector2.addElement(((UDSDriver)vector.elementAt(n2)).getDriver());
            ++n2;
        }
        return vector2;
    }

    public static Vector getDriverNamesByScheme(String string) {
        Vector vector = UDSDriverManager.getDriversByScheme(string);
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            vector2.addElement(((UDSDriver)vector.elementAt(n2)).getDriverName());
            ++n2;
        }
        return vector2;
    }

    public static UDSDriver getDriverByName(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError((Object)"Illegal arguement");
        }
        UDSDriverManager.initialize();
        int n = vecDrivers.size();
        int n2 = 0;
        while (n2 < n) {
            UDSDriver uDSDriver = (UDSDriver)vecDrivers.elementAt(n2);
            if (string.equalsIgnoreCase(uDSDriver.getDriverName())) {
                return uDSDriver;
            }
            ++n2;
        }
        return null;
    }

    public static void addDSDriverManagerListener(UDSDriverManagerListener uDSDriverManagerListener) {
        if (!listeners.contains(uDSDriverManagerListener)) {
            listeners.addElement(uDSDriverManagerListener);
        }
    }

    public static void removeDSDriverManagerListener(UDSDriverManagerListener uDSDriverManagerListener) {
        if (listeners.contains(uDSDriverManagerListener)) {
            listeners.removeElement(uDSDriverManagerListener);
        }
    }

    public static void DriverChanged() {
        int n = listeners.size();
        int n2 = 0;
        while (n2 < n) {
            ((UDSDriverManagerListener)listeners.elementAt(n2)).DriverChanged();
            ++n2;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$dsdriver$UDSDriverManager == null ? (class$jet$universe$dsdriver$UDSDriverManager = UDSDriverManager.class$("jet.universe.dsdriver.UDSDriverManager")) : class$jet$universe$dsdriver$UDSDriverManager).desiredAssertionStatus();
        bLoad = false;
        vecDrivers = new Vector();
        listeners = new Vector();
        DriverChanged = JRLogger.getLogger((class$jet$universe$dsdriver$UDSDriverManager == null ? (class$jet$universe$dsdriver$UDSDriverManager = UDSDriverManager.class$("jet.universe.dsdriver.UDSDriverManager")) : class$jet$universe$dsdriver$UDSDriverManager).getName());
    }
}

