/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetSet;
import jet.controls.JetString;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.universe.JetUQuery;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.convert.IExpression2Jet;
import jet.universe.psql.JetPsqlAndCondition;
import jet.universe.psql.JetPsqlJoin;
import jet.universe.psql.JetPsqlSelColumn;
import jet.universe.psql.JetPsqlTable;
import jet.universe.psql.JetPsqlUnion;
import jet.universe.psql.JetStmtSelCol;
import jet.universe.psql.RptPsqlFormulaColumn;
import jet.universe.psql.RptPsqlQuery;
import jet.util.TreeIterater;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlQuery;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.PsqlUnion;

public class JetPsqlQuery
extends JetSet {
    public JetNumber ver = new JetNumber(this, "ver");
    public JetString mappingName = new JetString(this, "mappingName");
    public JetString extWhere = new JetString(this, "extWhere");
    public JetString replWhere = new JetString(this, "replWhere");
    public JetBoolean bStateOfUnqualifiedName = new JetBoolean(this, "isQualifiedName");
    public JetBoolean bStateOfJoinOnForeignKeys = new JetBoolean(this, "isJoinOnFKey");
    public JetBoolean bStateOfJoinOnPrimaryKey = new JetBoolean(this, "isJoinOnPKey");
    public JetBoolean bStateOfJoinOnLikeName = new JetBoolean(this, "isJoinOnName");
    public JetBoolean bStateOfShowTableNames = new JetBoolean(this, "isShowTableName");
    public JetBoolean bShowMappingName = new JetBoolean(this, "isShowMappingName");
    public JetBoolean bStateOfProhibitCartesianProducts = new JetBoolean(this, "isProhibitCartesianProducts");
    public JetBoolean bDistinct = new JetBoolean(this, "isDistinct");
    public JetBoolean bIgnorePredicateIfParamIsNull = new JetBoolean(this, "ignorePredicateIfParamIsNull");
    public JetString username = new JetString(this, "UserName");
    public JetString password = new JetString(this, "PassWord");
    public JetBoolean share = new JetBoolean(this, "Share", true);
    private JetString add = new JetString(this, "UserDefinedQueryStmt");
    private static final HashMap convert = new HashMap(17);

    public JetPsqlQuery() {
    }

    public JetPsqlQuery(PsqlQuery psqlQuery) {
        this.initFromPsqlQuery(psqlQuery);
    }

    public void initFromPsqlQuery(PsqlQuery psqlQuery) {
        Object object;
        this.ver.set(1);
        this.mappingName.set(psqlQuery.getMappingName());
        this.extWhere.set(psqlQuery.getExtendedWhere());
        this.replWhere.set(psqlQuery.getReplacedWhere());
        this.bDistinct.set(psqlQuery.isDistinct());
        this.bIgnorePredicateIfParamIsNull.set(psqlQuery.isIgnorePredicateIfParamIsNull());
        this.bStateOfUnqualifiedName.set(psqlQuery.getStateOfUnqualifiedName());
        this.bStateOfJoinOnForeignKeys.set(psqlQuery.getStateOfJoinOnForeignKeys());
        this.bStateOfJoinOnPrimaryKey.set(psqlQuery.getStateOfJoinOnPrimaryKey());
        this.bStateOfJoinOnLikeName.set(psqlQuery.getStateOfJoinOnLikeName());
        this.bStateOfShowTableNames.set(psqlQuery.getStateOfShowTableNames());
        this.bShowMappingName.set(psqlQuery.isShowMappingName());
        this.bStateOfProhibitCartesianProducts.set(psqlQuery.getStateOfProhibitCartesianProducts());
        this.username.set(((RptPsqlQuery)psqlQuery).getUsername());
        this.password.set(((RptPsqlQuery)psqlQuery).getPassword());
        this.share.set(((RptPsqlQuery)psqlQuery).getShare());
        Vector vector = psqlQuery.getPsqlTablesVector();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            PsqlTable psqlTable = (PsqlTable)vector.elementAt(n2);
            JetPsqlTable jetPsqlTable = new JetPsqlTable(psqlTable);
            this.add(jetPsqlTable, -1);
            ++n2;
        }
        vector = psqlQuery.getSelColsVector();
        n = vector.size();
        JetStmtSelCol jetStmtSelCol = null;
        int n3 = 0;
        while (n3 < n) {
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(n3);
            if (psqlSelColumn.isCompCol() && !(psqlSelColumn instanceof RptPsqlFormulaColumn)) {
                jetStmtSelCol = new JetStmtSelCol(psqlSelColumn);
                this.add(jetStmtSelCol, -1);
            } else {
                JetPsqlSelColumn jetPsqlSelColumn = new JetPsqlSelColumn(psqlQuery, psqlSelColumn);
                this.add(jetPsqlSelColumn, -1);
            }
            ++n3;
        }
        vector = psqlQuery.getPsqlJoinsVector();
        n = vector.size();
        int n4 = 0;
        while (n4 < n) {
            PsqlJoin psqlJoin = (PsqlJoin)vector.elementAt(n4);
            JetPsqlJoin jetPsqlJoin = new JetPsqlJoin(psqlJoin);
            this.add(jetPsqlJoin, -1);
            ++n4;
        }
        vector = psqlQuery.getAndExpressionVector();
        n = vector.size();
        int n5 = 0;
        while (n5 < n) {
            String string = (String)vector.elementAt(n5++);
            if (n5 >= n) break;
            String string2 = (String)vector.elementAt(n5++);
            if (n5 >= n) break;
            String string3 = (String)vector.elementAt(n5++);
            if (n5 >= n) break;
            String string4 = (String)vector.elementAt(n5);
            JetPsqlAndCondition jetPsqlAndCondition = new JetPsqlAndCondition(string, string2, string3, string4);
            this.add(jetPsqlAndCondition, -1);
            ++n5;
        }
        IExpression iExpression = psqlQuery.getSearchConditionGroups();
        if (iExpression != null) {
            object = new IExpression2Jet();
            UFilterExpression uFilterExpression = null;
            try {
                uFilterExpression = ((IExpression2Jet)object).convert(iExpression);
            }
            catch (ConditionException conditionException) {
                // empty catch block
            }
            this.add(uFilterExpression, -1);
        }
        vector = psqlQuery.getUnionVector();
        n = vector.size();
        int n6 = 0;
        while (n6 < n) {
            object = new JetPsqlUnion((PsqlUnion)vector.elementAt(n6));
            this.add((JetObject)object);
            ++n6;
        }
        this.add.set(psqlQuery.getUserDefinedQueryStmt());
    }

    public void clearMem() {
        JetObject jetObject;
        TreeIterater treeIterater = new TreeIterater(this, true);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            jetObject.delete();
        }
        this.ver = null;
        this.mappingName = null;
        this.extWhere = null;
        this.replWhere = null;
        this.bDistinct = null;
        this.bIgnorePredicateIfParamIsNull = null;
        this.bStateOfUnqualifiedName = null;
        this.bStateOfJoinOnForeignKeys = null;
        this.bStateOfJoinOnPrimaryKey = null;
        this.bStateOfJoinOnLikeName = null;
        this.bStateOfShowTableNames = null;
        this.bShowMappingName = null;
        this.bStateOfProhibitCartesianProducts = null;
        this.username = null;
        this.password = null;
        this.share = null;
    }

    public void delete() {
        Object object;
        Vector vector = this.getChildren();
        int n = vector.size() - 1;
        while (n >= 0) {
            object = (JetObject)vector.elementAt(n);
            this.remove((JetObject)object);
            --n;
        }
        super.delete();
        object = this.getParent();
        if (object != null && object instanceof JetUQuery) {
            ((JetUQuery)object).remove(this);
        }
    }

    public String getUserDefinedQueryStmt() {
        return this.add.get();
    }

    public HashMap getIndecialMap() {
        return convert;
    }

    static {
        convert.put("isShowTableName", new Integer(0));
        convert.put("ver", new Integer(1));
        convert.put("isDistinct", new Integer(2));
        convert.put("isJoinOnName", new Integer(3));
        convert.put("mappingName", new Integer(4));
        convert.put("UserDefinedQueryStmt", new Integer(5));
        convert.put("isShowMappingName", new Integer(6));
        convert.put("extWhere", new Integer(7));
        convert.put("UserName", new Integer(8));
        convert.put("isQualifiedName", new Integer(9));
        convert.put("Share", new Integer(10));
        convert.put("replWhere", new Integer(11));
        convert.put("isJoinOnPKey", new Integer(12));
        convert.put("ignorePredicateIfParamIsNull", new Integer(13));
        convert.put("isProhibitCartesianProducts", new Integer(14));
        convert.put("PassWord", new Integer(15));
        convert.put("isJoinOnFKey", new Integer(16));
    }
}

