/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jet.util.DCT;
import jet.util.Huffman;
import jet.util.JpegInfo;

public class JpegEncoder
extends Panel {
    BufferedOutputStream ACtableNumber;
    JpegInfo Ah;
    Huffman Al;
    DCT BlockHeight;
    int BlockWidth;
    int CompID;
    int Components;
    public static int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public JpegEncoder(Image image, int n, OutputStream outputStream) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.Components = n;
        this.Ah = new JpegInfo(image);
        this.BlockWidth = this.Ah.imageHeight;
        this.CompID = this.Ah.imageWidth;
        this.ACtableNumber = new BufferedOutputStream(outputStream);
        this.BlockHeight = new DCT(this.Components);
        this.Al = new Huffman(this.CompID, this.BlockWidth);
    }

    public void setQuality(int n) {
        this.BlockHeight = new DCT(n);
    }

    public int getQuality() {
        return this.Components;
    }

    public void Compress() {
        this.WriteHeaders(this.ACtableNumber);
        this.WriteCompressedData(this.ACtableNumber);
        this.WriteEOI(this.ACtableNumber);
        try {
            this.ACtableNumber.flush();
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }

    public void WriteCompressedData(BufferedOutputStream bufferedOutputStream) {
        boolean bl = false;
        float[][] fArray2 = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[this.Ah.NumberOfComponents];
        int[] nArray3 = new int[64];
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = this.CompID % 8 != 0 ? (int)(Math.floor((double)this.CompID / 8.0) + 1.0) * 8 : this.CompID;
        int n4 = this.BlockWidth % 8 != 0 ? (int)(Math.floor((double)this.BlockWidth / 8.0) + 1.0) * 8 : this.BlockWidth;
        int n5 = 0;
        while (n5 < this.Ah.NumberOfComponents) {
            n3 = Math.min(n3, this.Ah.BlockWidth[n5]);
            n4 = Math.min(n4, this.Ah.BlockHeight[n5]);
            ++n5;
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                n6 = n8 * 8;
                int n9 = n7 * 8;
                n5 = 0;
                while (n5 < this.Ah.NumberOfComponents) {
                    n = this.Ah.BlockWidth[n5];
                    n2 = this.Ah.BlockHeight[n5];
                    float[][] fArray3 = (float[][])this.Ah.Components[n5];
                    int n10 = 0;
                    while (n10 < this.Ah.VsampFactor[n5]) {
                        int n11 = 0;
                        while (n11 < this.Ah.HsampFactor[n5]) {
                            int n12 = n11 * 8;
                            int n13 = n10 * 8;
                            int n14 = 0;
                            while (n14 < 8) {
                                int n15 = 0;
                                while (n15 < 8) {
                                    fArray2[n14][n15] = fArray3[n9 + n13 + n14][n6 + n12 + n15];
                                    ++n15;
                                }
                                ++n14;
                            }
                            dArray = this.BlockHeight.forwardDCT(fArray2);
                            nArray = this.BlockHeight.quantizeBlock(dArray, this.Ah.QtableNumber[n5]);
                            this.Al.HuffmanBlockEncoder(bufferedOutputStream, nArray, nArray2[n5], this.Ah.DCtableNumber[n5], this.Ah.ACtableNumber[n5]);
                            nArray2[n5] = nArray[0];
                            ++n11;
                        }
                        ++n10;
                    }
                    ++n5;
                }
                ++n8;
            }
            ++n7;
        }
        this.Al.I(bufferedOutputStream);
    }

    public void WriteEOI(BufferedOutputStream bufferedOutputStream) {
        byte[] byArray = new byte[]{-1, -39};
        this.ACtableNumber(byArray, bufferedOutputStream);
    }

    public void WriteHeaders(BufferedOutputStream bufferedOutputStream) {
        int n;
        byte[] byArray = new byte[]{-1, -40};
        this.ACtableNumber(byArray, bufferedOutputStream);
        byte[] byArray2 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.Ah(byArray2, bufferedOutputStream);
        String string = new String();
        string = this.Ah.getComment();
        int n2 = string.length();
        byte[] byArray3 = new byte[n2 + 4];
        byArray3[0] = -1;
        byArray3[1] = -2;
        byArray3[2] = (byte)(n2 >> 8 & 0xFF);
        byArray3[3] = (byte)(n2 & 0xFF);
        System.arraycopy(this.Ah.I.getBytes(), 0, byArray3, 4, this.Ah.I.length());
        this.Ah(byArray3, bufferedOutputStream);
        byte[] byArray4 = new byte[134];
        byArray4[0] = -1;
        byArray4[1] = -37;
        byArray4[2] = 0;
        byArray4[3] = -124;
        int n3 = 4;
        int n4 = 0;
        while (n4 < 2) {
            byArray4[n3++] = (byte)(0 + n4);
            int[] nArray = (int[])this.BlockHeight.quantum[n4];
            n = 0;
            while (n < 64) {
                byArray4[n3++] = (byte)nArray[jpegNaturalOrder[n]];
                ++n;
            }
            ++n4;
        }
        this.Ah(byArray4, bufferedOutputStream);
        byte[] byArray5 = new byte[19];
        byArray5[0] = -1;
        byArray5[1] = -64;
        byArray5[2] = 0;
        byArray5[3] = 17;
        byArray5[4] = (byte)this.Ah.Precision;
        byArray5[5] = (byte)(this.Ah.imageHeight >> 8 & 0xFF);
        byArray5[6] = (byte)(this.Ah.imageHeight & 0xFF);
        byArray5[7] = (byte)(this.Ah.imageWidth >> 8 & 0xFF);
        byArray5[8] = (byte)(this.Ah.imageWidth & 0xFF);
        byArray5[9] = (byte)this.Ah.NumberOfComponents;
        int n5 = 10;
        n4 = 0;
        while (n4 < byArray5[9]) {
            byArray5[n5++] = (byte)this.Ah.CompID[n4];
            byArray5[n5++] = (byte)((this.Ah.HsampFactor[n4] << 4) + this.Ah.VsampFactor[n4]);
            byArray5[n5++] = (byte)this.Ah.QtableNumber[n4];
            ++n4;
        }
        this.Ah(byArray5, bufferedOutputStream);
        n2 = 2;
        n5 = 4;
        int n6 = 4;
        byte[] byArray6 = new byte[17];
        byte[] byArray7 = new byte[4];
        byArray7[0] = -1;
        byArray7[1] = -60;
        n4 = 0;
        while (n4 < 4) {
            int n7 = 0;
            byArray6[n5++ - n6] = (byte)((int[])this.Al.bits.elementAt(n4))[0];
            n = 1;
            while (n < 17) {
                int n8 = ((int[])this.Al.bits.elementAt(n4))[n];
                byArray6[n5++ - n6] = (byte)n8;
                n7 += n8;
                ++n;
            }
            int n9 = n5;
            byte[] byArray8 = new byte[n7];
            n = 0;
            while (n < n7) {
                byArray8[n5++ - n9] = (byte)((int[])this.Al.val.elementAt(n4))[n];
                ++n;
            }
            byte[] byArray9 = new byte[n5];
            System.arraycopy(byArray7, 0, byArray9, 0, n6);
            System.arraycopy(byArray6, 0, byArray9, n6, 17);
            System.arraycopy(byArray8, 0, byArray9, n6 + 17, n7);
            byArray7 = byArray9;
            n6 = n5;
            ++n4;
        }
        byArray7[2] = (byte)(n5 - 2 >> 8 & 0xFF);
        byArray7[3] = (byte)(n5 - 2 & 0xFF);
        this.Ah(byArray7, bufferedOutputStream);
        byte[] byArray10 = new byte[14];
        byArray10[0] = -1;
        byArray10[1] = -38;
        byArray10[2] = 0;
        byArray10[3] = 12;
        byArray10[4] = (byte)this.Ah.NumberOfComponents;
        n5 = 5;
        n4 = 0;
        while (n4 < byArray10[4]) {
            byArray10[n5++] = (byte)this.Ah.CompID[n4];
            byArray10[n5++] = (byte)((this.Ah.DCtableNumber[n4] << 4) + this.Ah.ACtableNumber[n4]);
            ++n4;
        }
        byArray10[n5++] = (byte)this.Ah.Ss;
        byArray10[n5++] = (byte)this.Ah.Se;
        byArray10[n5++] = (byte)((this.Ah.Ah << 4) + this.Ah.Al);
        this.Ah(byArray10, bufferedOutputStream);
    }

    void ACtableNumber(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.write(byArray, 0, 2);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }

    void Ah(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            int n = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) + 2;
            bufferedOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
    }
}

