/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.sql.Time;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.util.AllNumberFormat;
import jet.util.BitFormat;
import jet.util.CharBinaryFormat;
import jet.util.DateTimeFormat;
import jet.util.DbValueFormat;

public class ReportFormat {
    private static Hashtable CHAR_DESC = new Hashtable();
    private static Hashtable DOUBLE_DESC = new Hashtable();
    private static Hashtable INTEGER_DESC = new Hashtable();

    public static String localizeFormatPattern(String string, int n, Locale locale) {
        Object var3_3 = null;
        String string2 = null;
        try {
            switch (n) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                    string2 = new AllNumberFormat(string, decimalFormatSymbols).getLocalizedPattern();
                    break;
                }
                case -7: {
                    string2 = new BitFormat(string).getLocalizedPattern();
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
                    string2 = new DateTimeFormat(string, dateFormatSymbols).getLocalizedPattern();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    string2 = new CharBinaryFormat(string).getLocalizedPattern();
                    break;
                }
                default: {
                    string2 = string;
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = string;
        }
        if (string2.equals("#")) {
            string2 = "#####";
        }
        return string2;
    }

    public static String normalizeFormatPattern(String string, int n, Locale locale) {
        Object var3_3 = null;
        String string2 = null;
        try {
            switch (n) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                    AllNumberFormat allNumberFormat = new AllNumberFormat();
                    allNumberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                    allNumberFormat.applyLocalizedPattern(string);
                    string2 = allNumberFormat.getPattern();
                    break;
                }
                case -7: {
                    BitFormat bitFormat = new BitFormat();
                    bitFormat.applyLocalizedPattern(string);
                    string2 = bitFormat.getPattern();
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
                    DateTimeFormat dateTimeFormat = new DateTimeFormat();
                    dateTimeFormat.setDateFormatSymbols(dateFormatSymbols);
                    dateTimeFormat.applyLocalizedPattern(string);
                    string2 = dateTimeFormat.getPattern();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    CharBinaryFormat charBinaryFormat = new CharBinaryFormat();
                    charBinaryFormat.applyLocalizedPattern(string);
                    string2 = charBinaryFormat.getPattern();
                    break;
                }
                default: {
                    string2 = string;
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = string;
        }
        if (string2.equals("#")) {
            string2 = "#####";
        }
        return string2;
    }

    public static DbValueFormat getOneFormat(int n, String string, Locale locale, TimeZone timeZone) {
        DbValueFormat dbValueFormat = null;
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                String string2 = locale == null ? "null" : "" + locale.toString();
                String string3 = string2 + "_" + string;
                dbValueFormat = (DbValueFormat)DOUBLE_DESC.get(string3);
                if (dbValueFormat != null) break;
                dbValueFormat = locale == null ? new AllNumberFormat(string) : new AllNumberFormat(string, new DecimalFormatSymbols(locale));
                DOUBLE_DESC.put(string3, dbValueFormat);
                break;
            }
            case -7: {
                dbValueFormat = (DbValueFormat)INTEGER_DESC.get(string);
                if (dbValueFormat != null) break;
                dbValueFormat = new BitFormat(string);
                INTEGER_DESC.put(string, dbValueFormat);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                String string4 = timeZone == null ? "null" : "" + timeZone.hashCode();
                String string5 = locale == null ? "null" : "" + locale.toString();
                String string6 = string5 + "_" + string4 + "_" + string;
                dbValueFormat = (DbValueFormat)CHAR_DESC.get(string6);
                if (dbValueFormat != null) break;
                dbValueFormat = locale == null ? (timeZone == null ? new DateTimeFormat(string) : new DateTimeFormat(string, timeZone)) : (timeZone == null ? new DateTimeFormat(string, new DateFormatSymbols(locale)) : new DateTimeFormat(string, new DateFormatSymbols(locale), timeZone));
                CHAR_DESC.put(string6, dbValueFormat);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                dbValueFormat = (DbValueFormat)INTEGER_DESC.get(string);
                if (dbValueFormat != null) break;
                dbValueFormat = new CharBinaryFormat(string);
                INTEGER_DESC.put(string, dbValueFormat);
                break;
            }
            case -26803: {
                break;
            }
            default: {
                throw new Error("Unknown Data Type: " + n);
            }
        }
        return dbValueFormat;
    }

    public static DbValueFormat getOneFormat(int n, String string, Locale locale) {
        return ReportFormat.getOneFormat(n, string, locale, null);
    }

    public static DbValueFormat getOneFormat(int n, String string) {
        return ReportFormat.getOneFormat(n, string, null);
    }

    public static Vector getMoreFormat(DbColDesc dbColDesc) {
        return ReportFormat.getMoreFormat(dbColDesc, false);
    }

    public static Vector getMoreFormat(DbColDesc dbColDesc, boolean bl) {
        return ReportFormat.getMoreFormat(dbColDesc.getSqlType(), dbColDesc.getPrecision(), bl);
    }

    public static Vector getMoreFormat(int n, int n2) {
        return ReportFormat.getMoreFormat(n, n2, false);
    }

    public static Vector getMoreFormat(int n, int n2, boolean bl) {
        Vector<String> vector = new Vector<String>();
        switch (n) {
            case 91: {
                vector.addElement("MM/dd/yy");
                vector.addElement("MM/dd/yyyy");
                vector.addElement("dd/MM/yy");
                vector.addElement("dd/MM/yyyy");
                vector.addElement("yyyy-MM-dd");
                vector.addElement("yy-MM-dd");
                vector.addElement("MMMMM d, yyyy");
                vector.addElement("yy");
                vector.addElement("yyyy");
                vector.addElement("M");
                vector.addElement("MMM");
                vector.addElement("MMMMM");
                vector.addElement("dd");
                break;
            }
            case 92: {
                vector.addElement("hh:mm:ss");
                vector.addElement("hh:mm a");
                vector.addElement("hh:mm:ss a");
                vector.addElement("HH:mm");
                vector.addElement("HH");
                break;
            }
            case 93: {
                vector.addElement("MM/dd/yy");
                vector.addElement("MM/dd/yyyy");
                vector.addElement("dd/MM/yy");
                vector.addElement("dd/MM/yyyy");
                vector.addElement("yyyy-MM-dd");
                vector.addElement("yy-MM-dd");
                vector.addElement("MMMMM d, yyyy");
                vector.addElement("hh:mm:ss");
                vector.addElement("hh:mm a");
                vector.addElement("hh:mm:ss a");
                vector.addElement("MM/dd/yyyy hh:mm:ss a");
                vector.addElement("yyyy-MM-dd hh:mm:ss");
                vector.addElement("yy");
                vector.addElement("yyyy");
                vector.addElement("M");
                vector.addElement("MMM");
                vector.addElement("MMMMM");
                vector.addElement("dd");
                vector.addElement("HH");
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                vector.addElement("#,###");
                vector.addElement("#####");
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                vector.addElement("#,###.00");
                vector.addElement("#,###.00;(#,###.00)");
                vector.addElement("#,###.##");
                vector.addElement("$#,###.00");
                vector.addElement("$#,###.##");
                vector.addElement("$#,###.00;($#,###.00)");
                vector.addElement("$#,###.##;($#,###.##)");
                vector.addElement("#,###.00%");
                vector.addElement("#,###.##%");
                vector.addElement("#####");
                vector.addElement("#,###");
                vector.addElement("$#,###;($#,###)");
                vector.addElement("#,###%");
                vector.addElement("$#,###");
                break;
            }
            case -7: {
                vector.addElement("True/False");
                vector.addElement("T/F");
                vector.addElement("1/0");
                break;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(n2);
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append('X');
                    ++n3;
                }
                vector.addElement(stringBuffer.toString());
                break;
            }
            case -1: 
            case 12: 
            case 2005: {
                vector.addElement("XXXXXXXXX...");
                break;
            }
            case 2003: {
                vector.addElement("XXXXXXXXX...");
                break;
            }
            default: {
                vector.addElement("XXXXXXXXX...");
            }
        }
        if (bl) {
            Locale locale = Locale.getDefault();
            Vector vector2 = (Vector)vector.clone();
            vector.removeAllElements();
            int n4 = vector2.size();
            String string = null;
            int n5 = 0;
            while (n5 < n4) {
                string = (String)vector2.elementAt(n5);
                string = ReportFormat.localizeFormatPattern(string, n, locale);
                vector.addElement(string);
                ++n5;
            }
        }
        return vector;
    }

    public static DbValue getExampleValue(int n) {
        DbValue dbValue = null;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                dbValue = new DbInteger(DbValue.INTEGER_DESC);
                ((DbInteger)dbValue).set(1000);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                dbValue = new DbDouble(DbValue.DOUBLE_DESC);
                ((DbDouble)dbValue).set(100.0);
                break;
            }
            case -7: {
                dbValue = new DbBit(new DbColDesc("", -7, 30, 0, 2));
                ((DbBit)dbValue).set(true);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                dbValue = new DbTime(DbValue.TIME_DESC);
                ((DbTime)dbValue).setTime(new Time(12, 12, 12));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                dbValue = new DbChar(DbValue.CHAR_DESC);
                ((DbChar)dbValue).set("jinfonet");
                break;
            }
            default: {
                throw new Error("Unknown Data Type: " + n);
            }
        }
        return dbValue;
    }
}

