/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.log.JRLogger;
import jet.naming.EnumerationConstant;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.SQLKeywords;

public class DbTools {
    public static final String DBN_MS_SQL_SERVER = "Microsoft SQL Server";
    public static final String DBN_MS_ACCESS = "ACCESS";
    public static final String DBN_MS_TEXT = "TEXT";
    public static final String DBN_XDB = "XDB";
    public static final int DB_OTHER = 0;
    public static final int DB_MS_SQL_SERVER = 1;
    public static final int DB_MS_ACCESS = 2;
    public static final int DB_XDB = 3;
    public static final int DB_MS_TEXT = 4;
    public static final int OPT_1P = 0;
    public static final int OPT_2P = 1;
    public static final int OPT_3P = 2;
    public static final String STR_OPT_1P = EnumerationConstant.QUALIFIEDNAMEPATTERN_STR_NAMES[0];
    public static final String STR_OPT_2P = EnumerationConstant.QUALIFIEDNAMEPATTERN_STR_NAMES[1];
    public static final String STR_OPT_3P = EnumerationConstant.QUALIFIEDNAMEPATTERN_STR_NAMES[2];
    public static final int READ_ONLY_DEFAULT = 1;
    public static final int READ_ONLY_TRUE = 2;
    public static final int READ_ONLY_FALSE = 0;
    public static final String STR_READ_ONLY_DEFAULT = EnumerationConstant.READONLY_STR_NAMES[1];
    public static final String STR_READ_ONLY_TRUE = EnumerationConstant.READONLY_STR_NAMES[2];
    public static final String STR_READ_ONLY_FALSE = EnumerationConstant.READONLY_STR_NAMES[0];
    public static final int TRANSACTION_DEFAULT = 0;
    public static final int TRANSACTION_NONE = 1;
    public static final int TRANSACTION_READ_UNCOMMITTED = 2;
    public static final int TRANSACTION_READ_COMMITTED = 3;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 5;
    public static final String STR_TRANSACTION_DEFAULT = EnumerationConstant.TRANSACTIONISOLATION1_STR_NAMES[0];
    public static final String STR_TRANSACTION_NONE = EnumerationConstant.TRANSACTIONISOLATION1_STR_NAMES[1];
    public static final String STR_TRANSACTION_READ_UNCOMMITTED = EnumerationConstant.TRANSACTIONISOLATION1_STR_NAMES[2];
    public static final String STR_TRANSACTION_READ_COMMITTED = EnumerationConstant.TRANSACTIONISOLATION1_STR_NAMES[3];
    public static final String STR_TRANSACTION_REPEATABLE_READ = EnumerationConstant.TRANSACTIONISOLATION1_STR_NAMES[4];
    public static final String STR_TRANSACTION_SERIALIZABLE = EnumerationConstant.TRANSACTIONISOLATION1_STR_NAMES[5];
    public static final int EXTRA_NAME_JDBC = 0;
    public static final int EXTRA_NAME_USERDEFINED = 1;
    public static final String STR_EXTRA_NAME_JDBC = EnumerationConstant.EXTRANAMEPATTERN_STR_NAMES[0];
    public static final String STR_EXTRA_NAME_USERDEFINED = EnumerationConstant.EXTRANAMEPATTERN_STR_NAMES[1];
    public static final String STR_JDBC_EXTRA_NAME_CHARS = "";
    public static final String STR_JDBC_QUOTE_CHAR = "\"";
    public static final String STR_EXTRA_KEYWORDS = "";
    public static final int ENCODING_AUTO = 0;
    public static final int ENCODING_YES = 1;
    public static final int ENCODING_NO = 2;
    public static final String STR_ENCODING_AUTO = EnumerationConstant.ENCODINGPATTERN_STR_NAMES[0];
    public static final String STR_ENCODING_YES = EnumerationConstant.ENCODINGPATTERN_STR_NAMES[1];
    public static final String STR_ENCODING_NO = EnumerationConstant.ENCODINGPATTERN_STR_NAMES[2];
    public static final String JDBC_ODBC_BRIDGE = "jdbc:odbc:";
    public static final String strSUNJDBCODBCBridge = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String strMicrosoftJDBCODBCBridge = "com.ms.jdbc.odbc.JdbcOdbcDriver";
    public static final String JDBC_JINFONET_OBJECT_PROTOCAL = "jdbc:jinfonet:object";
    public static String sExtraNameChar = "";
    public static String sQuoteChar = "\"";
    public static String strExtraKeywords = "";
    public static String DEF_DATE_FORMAT = "yyyy-MM-dd";
    public static String DEF_TIME_FORMAT = "HH:mm:ss";
    public static String DEF_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static int[] ENCODINGPATTERN_STR_NAMES = new int[26];
    public static final String[] SPECIAL_FIELDS = new String[]{"UserName", "RoleName"};
    public static final int NORMAL_FIELD = -1;
    public static final int USER_NAME = 0;
    public static final int ROLE_NAME = 1;
    private static JRLogger EXTRANAMEPATTERN_STR_NAMES = JRLogger.getLogger((class$toolkit$db$DbTools == null ? (class$toolkit$db$DbTools = DbTools.class$("toolkit.db.DbTools")) : class$toolkit$db$DbTools).getName());
    public static int unx = 10;
    static Class class$toolkit$db$DbTools;

    public static void setQuoteChar(String string) {
        sQuoteChar = string;
    }

    public static String getQuoteChar() {
        return sQuoteChar;
    }

    public static boolean hasTheStringInVector(String string, Vector vector) {
        if (vector != null && string != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(vector.elementAt(n2))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isStringSame(String string, String string2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        return string.equals(string2);
    }

    public static boolean isStringSameNull(String string, String string2) {
        if (string == null || string2 == null) {
            if (string == null && string2 == null) {
                return true;
            }
            return string == null ? string2.length() == 0 : string.length() == 0;
        }
        return string.equals(string2);
    }

    public static String makeQuotedString(String string) {
        if (string != null) {
            String string2 = "'";
            if (sQuoteChar.trim().length() != 0) {
                string2 = sQuoteChar;
            }
            string = string2 + string + string2;
        }
        return string;
    }

    public static boolean canCastAsSQLIdentifier(String string) {
        String string2 = sQuoteChar.trim().length() > 0 ? sQuoteChar : STR_JDBC_QUOTE_CHAR;
        if (string.startsWith(string2) && string.endsWith(string2)) {
            return true;
        }
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String quotedWhenNeed(String string) {
        if (!DbTools.canCastAsSQLIdentifier(string)) {
            return sQuoteChar + string + sQuoteChar;
        }
        return string;
    }

    public static boolean canCastAsSQLIdentifier(String string, String string2) {
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || string2.indexOf(c) != -1)) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || string2.indexOf(c) != -1)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String quotedWhenNeed(String string, String string2, String string3) {
        if (string.startsWith(string3) && string.endsWith(string3)) {
            return string;
        }
        if (!DbTools.canCastAsSQLIdentifier(string, string2)) {
            return string3 + string + string3;
        }
        return string;
    }

    public static boolean canCastAsSQLIdentifier(String string, String string2, String string3) {
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || string2.indexOf(c) != -1)) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || string2.indexOf(c) != -1)) {
                return false;
            }
            ++n;
        }
        return !SQLKeywords.isKeywords(string3, string);
    }

    public static String quotedWhenNeed(String string, String string2, String string3, String string4) {
        if (string.startsWith(string3) && string.endsWith(string3)) {
            return string;
        }
        if (string3.equals("`")) {
            string2 = "";
        }
        if (!DbTools.canCastAsSQLIdentifier(string, string2, string4)) {
            return string3 + string + string3;
        }
        return string;
    }

    public static byte[] intToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    public static int bytesToInt(byte[] byArray) {
        if (byArray == null || byArray.length < 4) {
            return 0;
        }
        return byArray[0] | byArray[1] << 8 | byArray[2] << 16 | byArray[3] << 24;
    }

    private static int DEF_DATE_FORMAT(String string) {
        if (string != null && string.length() == 1) {
            char c = string.charAt(0);
            if (c >= 'a' && c <= 'z') {
                return c - 97;
            }
            if (c >= 'A' && c <= 'Z') {
                return c - 65;
            }
        }
        return -1;
    }

    public static String getCorrelationNameOfTable(int n, String string) {
        int n2;
        String string2 = "";
        String string3 = "";
        int n3 = 0;
        if (string.length() > 0) {
            string2 = string.substring(0, 1);
            n3 = DbTools.DEF_DATE_FORMAT(string2);
        }
        if (n > 1) {
            int n4 = n3;
            int n5 = ENCODINGPATTERN_STR_NAMES[n4];
            ENCODINGPATTERN_STR_NAMES[n4] = n5 + 1;
            n2 = n5 % 100;
        } else {
            n2 = 1;
        }
        string3 = string2.concat(String.valueOf(n2));
        return string3;
    }

    public static String getFirstName(String string) {
        String string2 = null;
        int n = 0;
        String string3 = string.trim();
        while (n < string3.length()) {
            char c = string3.charAt(n);
            if (c == '(') break;
            ++n;
        }
        string2 = string3.substring(0, n);
        return string2;
    }

    public static String getColumnsTableName(PsqlSelColumn psqlSelColumn) {
        String string = "";
        PsqlTable psqlTable = psqlSelColumn.getPsqlTable();
        if (psqlTable != null && (string = psqlTable.getCorrelationName()) == null) {
            string = psqlSelColumn.getTableName();
        }
        return string;
    }

    public static PsqlSelColumn getPsqlSelColumnByTableAndName(String string, String string2, Vector vector) {
        PsqlSelColumn psqlSelColumn = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            psqlSelColumn = (PsqlSelColumn)vector.elementAt(n2);
            if (!psqlSelColumn.isCompCol() && DbTools.getColumnsTableName(psqlSelColumn).equals(string) && psqlSelColumn.getName().equals(string2)) {
                return psqlSelColumn;
            }
            ++n2;
        }
        return psqlSelColumn;
    }

    public static void copyVector(Vector vector, Vector vector2) {
        if (!vector.isEmpty()) {
            vector.removeAllElements();
        }
        if (!vector2.isEmpty()) {
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = vector2.elementAt(n2);
                vector.addElement(e);
                ++n2;
            }
        }
    }

    public static Vector getNamesByColumns(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(n2);
            if (psqlSelColumn.isCompCol()) {
                vector2.addElement(psqlSelColumn.getName());
            } else {
                String string = "";
                string = DbTools.getColumnsTableName(psqlSelColumn);
                string = string.concat(".");
                string = string.concat(psqlSelColumn.getName());
                vector2.addElement(string);
            }
            ++n2;
        }
        return vector2;
    }

    public static void setCertainTableByCorrelationName(String string) {
        if (string.length() > 0) {
            String string2 = string.substring(0, 1);
            DbTools.DEF_DATE_FORMAT(string2);
            String string3 = string.substring(1);
            Integer.valueOf(string3).intValue();
        }
    }

    public static String printSQLExceptionMessage(SQLException sQLException) {
        if (sQLException == null) {
            return "";
        }
        if (EXTRANAMEPATTERN_STR_NAMES.isErrorEnabled()) {
            EXTRANAMEPATTERN_STR_NAMES.error("", sQLException);
        }
        String string = sQLException.getMessage();
        return string;
    }

    public static boolean hasCompCols(Vector vector) {
        if (vector != null) {
            int n = vector.size() - 1;
            while (n >= 0) {
                if (((PsqlSelColumn)vector.elementAt(n)).isCompCol()) {
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    public static int isWhichDB(String string) {
        int n = 0;
        if (string != null) {
            if ((string = string.toUpperCase()).startsWith(DBN_MS_ACCESS)) {
                n = 2;
            } else if (string.startsWith(DBN_MS_SQL_SERVER)) {
                n = 1;
            } else if (string.startsWith(DBN_MS_TEXT)) {
                n = 4;
            } else if (string.startsWith(DBN_XDB)) {
                n = 3;
            }
        }
        return n;
    }

    public static boolean hasJdbcOdbcBridge(String string) {
        boolean bl = false;
        if (string != null) {
            bl = string.equalsIgnoreCase(JDBC_ODBC_BRIDGE);
        }
        return bl;
    }

    public static Vector concatVectors(Vector vector, Vector vector2) {
        int n;
        Vector vector3 = new Vector();
        int n2 = 0;
        if (vector != null) {
            n2 = vector.size();
            n = 0;
            while (n < n2) {
                vector3.addElement(vector.elementAt(n));
                ++n;
            }
        }
        if (vector2 != null) {
            n2 = vector2.size();
            n = 0;
            while (n < n2) {
                vector3.addElement(vector2.elementAt(n));
                ++n;
            }
        }
        return vector3;
    }

    public static String convertToAndExpressionString(Vector vector) {
        String string = "";
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            if (n2 >= n) {
                return string;
            }
            String string3 = (String)vector.elementAt(++n2);
            if (n2 >= n) {
                return string;
            }
            String string4 = (String)vector.elementAt(++n2);
            if (n2 >= n) {
                return string;
            }
            String string5 = (String)vector.elementAt(++n2);
            string2.trim();
            string3.trim();
            string4.trim();
            string5.trim();
            if (string2 != "") {
                string2 = " " + string2 + " ";
            }
            string4 = " " + string4 + " ";
            string = string + string2 + string3 + string4 + string5;
            ++n2;
        }
        return string;
    }

    public static String getReversedOperator(String string) {
        String string2 = string;
        if (string != null) {
            if (string.equals(">")) {
                string2 = "<";
            } else if (string.equals("<")) {
                string2 = ">";
            } else if (string.equals(">=")) {
                string2 = "<=";
            } else if (string.equals("<=")) {
                string2 = ">=";
            }
        }
        return string2;
    }

    public static String getNotOperator(String string) {
        String string2 = string;
        if (string != null) {
            if (string.equals("=")) {
                string2 = "<>";
            } else if (string.equals(">")) {
                string2 = "<=";
            } else if (string.equals("<")) {
                string2 = ">=";
            } else if (string.equals(">=")) {
                string2 = "<";
            } else if (string.equals("<=")) {
                string2 = ">";
            } else if (string.equals("<>")) {
                string2 = "=";
            } else if (string.equals("between")) {
                string2 = "not between";
            } else if (string.equals("like")) {
                string2 = "not like";
            } else if (string.equals("in")) {
                string2 = "not in";
            } else if (string.equals("exists")) {
                string2 = "not ";
            } else if (string.equals("is null")) {
                string2 = "is not null";
            } else if (string.equals("not between")) {
                string2 = "between";
            } else if (string.equals("not like")) {
                string2 = "like";
            } else if (string.equals("not in")) {
                string2 = "in";
            } else if (string.equals("not exists")) {
                string2 = "exists";
            } else if (string.equals("is not null")) {
                string2 = "is null";
            } else if (string.equals("(+)=")) {
                string2 = "(+)<>";
            } else if (string.equals("(+)>")) {
                string2 = "(+)<=";
            } else if (string.equals("(+)<")) {
                string2 = "(+)>=";
            } else if (string.equals("(+)>=")) {
                string2 = "(+)<";
            } else if (string.equals("(+)<=")) {
                string2 = "(+)>";
            } else if (string.equals("(+)<>")) {
                string2 = "(+)=";
            } else if (string.equals("=(+)")) {
                string2 = "<>(+)";
            } else if (string.equals(">(+)")) {
                string2 = "<=(+)";
            } else if (string.equals("<(+)")) {
                string2 = ">=(+)";
            } else if (string.equals(">=(+)")) {
                string2 = "<(+)";
            } else if (string.equals("<=(+)")) {
                string2 = ">(+)";
            } else if (string.equals("<>(+)")) {
                string2 = "=(+)";
            } else if (string.equals("*=")) {
                string2 = "*<>";
            } else if (string.equals("*>")) {
                string2 = "*<=";
            } else if (string.equals("*<")) {
                string2 = "*>=";
            } else if (string.equals("*>=")) {
                string2 = "*<";
            } else if (string.equals("*<=")) {
                string2 = "*>";
            } else if (string.equals("*<>")) {
                string2 = "*=";
            } else if (string.equals("=*")) {
                string2 = "<>*";
            } else if (string.equals(">*")) {
                string2 = "<=*";
            } else if (string.equals("<*")) {
                string2 = ">=*";
            } else if (string.equals(">=*")) {
                string2 = "<*";
            } else if (string.equals("<=*")) {
                string2 = ">*";
            } else if (string.equals("<>*")) {
                string2 = "=*";
            }
        }
        return string2;
    }

    public static String makeSqlString(String string) {
        if (string != null) {
            return "'" + DbTools.replaceQuotes(string) + "'";
        }
        return "''";
    }

    public static String makeDqString(String string) {
        if (string != null) {
            return STR_JDBC_QUOTE_CHAR + DbTools.replaceQuotes(string) + STR_JDBC_QUOTE_CHAR;
        }
        return "\"\"";
    }

    public static String replaceQuotes(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            if (stringBuffer.charAt(n) == '\'') {
                if (n > 0) {
                    if (stringBuffer.charAt(n - 1) != '\'') {
                        stringBuffer.insert(n, '\'');
                    } else {
                        --n;
                    }
                } else {
                    stringBuffer.insert(n, '\'');
                }
            }
            --n;
        }
        if (stringBuffer.length() > string.length()) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        if (string == null) {
            return false;
        }
        return string.startsWith("Windows");
    }

    public static String getStackTraceString(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static Vector getMappingNamesInRawSql(String string) {
        Vector<String> vector = new Vector<String>(10);
        if (string == null || string.trim().length() == 0) {
            return vector;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            switch (n) {
                case 0: {
                    if (c == '@' || c == ':') {
                        n = 1;
                        stringBuffer.setLength(0);
                        break;
                    }
                    if (c != '\'') break;
                    n = 3;
                    break;
                }
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        n = 0;
                        vector.addElement(stringBuffer.toString());
                        --n2;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 2: {
                    if (c == '\"') {
                        n = 0;
                        vector.addElement(stringBuffer.toString());
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 3: {
                    if (c != '\'') break;
                    n = 0;
                }
            }
            ++n2;
        }
        if (n != 0 && n != 3) {
            vector.addElement(stringBuffer.toString());
        }
        return vector;
    }

    public static String getFirstParameterNameInString(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer == null) {
            return null;
        }
        int n = 0;
        int n2 = stringBuffer.length();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer2.setLength(0);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c = stringBuffer.charAt(n4);
            switch (n) {
                case 0: {
                    if (c == '@' || c == ':') {
                        n = 1;
                        stringBuffer3.setLength(0);
                        break;
                    }
                    if (c == '\"') {
                        n3 = stringBuffer2.length();
                        n = 3;
                        break;
                    }
                    stringBuffer2.append(c);
                    break;
                }
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        DbTools.delete(stringBuffer, n4);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    break;
                }
                case 2: {
                    if (c == '\"') {
                        DbTools.delete(stringBuffer, n4 + 1);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    break;
                }
                case 3: {
                    if (c == '\"') {
                        if (n3 == stringBuffer2.length()) {
                            stringBuffer2.append('\"');
                        }
                        n = 0;
                        break;
                    }
                    stringBuffer2.append(c);
                }
            }
            ++n4;
        }
        if (n == 1) {
            DbTools.delete(stringBuffer, n2);
            return stringBuffer3.toString();
        }
        if (n == 3) {
            stringBuffer2.insert(n3, '\"');
        }
        return null;
    }

    public static String getFirstParameterNameInString2(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer == null) {
            return null;
        }
        int n = 0;
        int n2 = stringBuffer.length();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer2.setLength(0);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c = stringBuffer.charAt(n4);
            switch (n) {
                case 0: {
                    if (c == '@' || c == ':') {
                        n = 1;
                        stringBuffer3.setLength(0);
                        break;
                    }
                    if (c == '\"') {
                        stringBuffer2.append('\"');
                        n = 3;
                        break;
                    }
                    stringBuffer2.append(c);
                    break;
                }
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        DbTools.delete(stringBuffer, n4);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    break;
                }
                case 2: {
                    if (c == '\"') {
                        DbTools.delete(stringBuffer, n4 + 1);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    break;
                }
                case 3: {
                    if (c == '\"') {
                        stringBuffer2.append('\"');
                        n = 0;
                        break;
                    }
                    stringBuffer2.append(c);
                }
            }
            ++n4;
        }
        if (n == 1) {
            DbTools.delete(stringBuffer, n2);
            return stringBuffer3.toString();
        }
        if (n == 3) {
            stringBuffer2.insert(n3, '\"');
        }
        return null;
    }

    public static String[] toArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreElements()) {
            vector.addElement((String)stringTokenizer.nextElement());
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public static void delete(StringBuffer stringBuffer, int n) {
        String string = stringBuffer.toString();
        string = string.substring(n);
        stringBuffer.setLength(0);
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(string.charAt(n3));
            ++n3;
        }
    }

    public static int mergeReadOnly(int n, int n2) {
        int n3 = n;
        if (n2 != 1) {
            n3 = n2;
        }
        return n3;
    }

    public static int mergeTransactionIsolation(int n, int n2) {
        int n3 = n;
        if (n2 != 0) {
            n3 = n2;
        }
        return n3;
    }

    public static boolean isJinfonetObjProtocal(String string) {
        return string != null && string.toLowerCase().startsWith(JDBC_JINFONET_OBJECT_PROTOCAL);
    }

    public static String toFmlOperator(String string) {
        if (string != null && string.trim().length() > 0) {
            String string2 = string.trim();
            if (string2.equals("=")) {
                string2 = "==";
            } else if (string2.equals("<>")) {
                string2 = "!=";
            } else if (string2.equals(">")) {
                string2 = ">";
            } else if (string2.equals("<")) {
                string2 = "<";
            } else if (string2.equals(">=")) {
                string2 = ">=";
            } else if (string2.equals("<=")) {
                string2 = "<=";
            }
            return string2;
        }
        return "";
    }

    public static void copyHT(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            if (v == null || hashtable2.contains(k)) continue;
            hashtable2.put(k, v);
        }
    }

    public static void updateHT(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            if (v == null) continue;
            hashtable2.put(k, v);
        }
    }

    public static String getTransactionStringFromInt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = STR_TRANSACTION_DEFAULT;
                break;
            }
            case 1: {
                string = STR_TRANSACTION_NONE;
                break;
            }
            case 2: {
                string = STR_TRANSACTION_READ_UNCOMMITTED;
                break;
            }
            case 3: {
                string = STR_TRANSACTION_READ_COMMITTED;
                break;
            }
            case 4: {
                string = STR_TRANSACTION_REPEATABLE_READ;
                break;
            }
            case 5: {
                string = STR_TRANSACTION_SERIALIZABLE;
                break;
            }
            default: {
                string = "Unsupported Transaction Level";
            }
        }
        return string;
    }

    public static String getReadOnlyStringFromInt(int n) {
        String string;
        switch (n) {
            case 1: {
                string = STR_READ_ONLY_DEFAULT;
                break;
            }
            case 2: {
                string = STR_READ_ONLY_TRUE;
                break;
            }
            case 0: {
                string = STR_READ_ONLY_FALSE;
                break;
            }
            default: {
                string = "Unsupported Read Only Level";
            }
        }
        return string;
    }

    public static String getQualifyOptionStringFromInt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = STR_ENCODING_AUTO;
                break;
            }
            case 1: {
                string = STR_ENCODING_YES;
                break;
            }
            case 2: {
                string = STR_ENCODING_NO;
                break;
            }
            default: {
                string = "Unsupported Qualify Option";
            }
        }
        return string;
    }

    public static String getExtraNamePatternFromInt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = STR_EXTRA_NAME_USERDEFINED;
                break;
            }
            case 1: {
                string = STR_EXTRA_NAME_USERDEFINED;
                break;
            }
            default: {
                string = "Unsupported extra name pattern";
            }
        }
        return string;
    }

    public static String getEncodingPatternFromInt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = STR_ENCODING_AUTO;
                break;
            }
            case 1: {
                string = STR_ENCODING_YES;
                break;
            }
            case 2: {
                string = STR_ENCODING_NO;
                break;
            }
            default: {
                string = "Unsupported extra name pattern";
            }
        }
        return string;
    }

    public static int isSpecialField(String string) {
        int n = SPECIAL_FIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase(SPECIAL_FIELDS[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

