/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.normalization;

import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.custom.normalization.Util;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AttCopySeriesId
implements CustomNormalizationRule {
    private static final String TITLE = "TITLE";
    private static final String SRC_SERIES_ID_XPATH = "/tns:Fields/tns:TvId/tns:SeriesId";
    private static final String DEST_SERIES_ID_XPATH = "/tns:Fields/tns:CustomFields/tns:CustomField[@name=L2V_SERIES_ID]/@value";

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        RuleResults result = new RuleResults(title);
        List srcSeriesId = title.getAsset().getAllFieldsForXpath(TITLE, SRC_SERIES_ID_XPATH);
        List dstSeriesId = title.getAsset().getAllFieldsForXpath(TITLE, DEST_SERIES_ID_XPATH);
        if (srcSeriesId.size() == 0) {
            return result;
        }
        String seriesIdValue = ((Field)srcSeriesId.get(0)).getValue();
        if (dstSeriesId.size() == 1) {
            ((Field)dstSeriesId.get(0)).setValue(seriesIdValue);
        } else {
            Field destNetworkField = new Field(DEST_SERIES_ID_XPATH, seriesIdValue);
            Util.setFieldIndices(destNetworkField);
            List titles = title.getAsset().getAllAssetsOfType(TITLE);
            ((Asset)titles.get(0)).addField(destNetworkField);
        }
        result.setModified(true);
        return result;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("AttSeriesToL2VSeries", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

