/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Item;
import java.util.Map;

public class TitleMapInfo {
    private static final String TITLEID_PREFIX = "titleId:";
    private static final String MAPPED_ASSET_FILES = "mappedAssetFiles:";
    private Status status;
    private StringBuffer mappedTitles;

    public TitleMapInfo(Status status) {
        this.status = status;
        this.mappedTitles = new StringBuffer();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void addMappedTitle(Long titleId, boolean validationSuccess, Map<Asset, File> mappedAssets) {
        if (this.mappedTitles.length() > 0) {
            this.mappedTitles.append(", ");
        }
        this.mappedTitles.append("[").append(TITLEID_PREFIX).append(titleId).append("|").append("Validation ").append(validationSuccess ? "Success" : "Failure").append("|").append(MAPPED_ASSET_FILES);
        if (mappedAssets != null) {
            for (File file : mappedAssets.values()) {
                this.mappedTitles.append(file.getURL() + "=" + file.getId());
                this.mappedTitles.append(", ");
            }
            this.mappedTitles.append("|");
            boolean firstTime = true;
            for (Asset asset : mappedAssets.keySet()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.mappedTitles.append(", ");
                }
                this.mappedTitles.append(((Item)asset).getType());
            }
        }
        this.mappedTitles.append("]");
    }

    public String getMappedTitles() {
        return this.mappedTitles.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Status: ").append((Object)this.status).append(" | ");
        sb.append("Mapped Titles: ").append(this.mappedTitles);
        return sb.toString();
    }

    public static enum Status {
        TITLES_NOT_FOUND,
        TITLES_MERGED;

    }
}

