/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Title {
    private Long id;
    private TitleStatus status;
    private String externalLocation;
    private String metadataContent;
    private Asset asset;
    private Collection<IAssetList> titlelists;
    private Collection<ProgressItem> progressItems;
    private Map<String, TitleStatus> assetVersionStatusMap;
    private Long originalId;
    private String originalVersion;
    private Date lastModifiedTime;

    public Title() {
        this.progressItems = new ArrayList<ProgressItem>();
        this.titlelists = new ArrayList<IAssetList>();
        this.status = TitleStatus.DRAFT;
        this.assetVersionStatusMap = new HashMap<String, TitleStatus>();
    }

    public Title(Title title) {
        this.id = title.id;
        this.status = title.status;
        this.externalLocation = title.externalLocation;
        this.metadataContent = title.metadataContent;
        this.asset = title.asset;
        this.titlelists = title.titlelists;
        this.progressItems = title.progressItems;
        this.assetVersionStatusMap = title.assetVersionStatusMap;
        this.originalId = title.originalId;
        this.originalVersion = title.originalVersion;
        this.lastModifiedTime = title.lastModifiedTime;
    }

    public Title(Long id) {
        this();
        this.id = id;
    }

    public Title(TitleStatus status) {
        this();
        this.status = status;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getIsActive() {
        return this.getAsset().isActive();
    }

    public void setIsActive(Boolean isActive) {
        this.getAsset().setState(isActive.booleanValue());
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public String getExternalLocation() {
        return this.externalLocation;
    }

    public void setExternalLocation(String externalLocation) {
        this.externalLocation = externalLocation;
    }

    public String getMetadataContent() {
        return this.metadataContent;
    }

    public void setMetadataContent(String metadataContent) {
        this.metadataContent = metadataContent;
    }

    public TitleStatus getStatus() {
        return this.status;
    }

    public void setStatus(TitleStatus status) {
        this.status = status;
    }

    public Collection<IAssetList> getTitlelists() {
        return this.titlelists;
    }

    public Collection<ProgressItem> getProgressItems() {
        ArrayList<ProgressItem> progressItems = new ArrayList<ProgressItem>();
        for (ProgressItem progress : this.progressItems) {
            if (!progress.getIsActive().booleanValue()) continue;
            progressItems.add(progress);
        }
        return progressItems;
    }

    public Collection<ProgressItem> getAllProgressItems() {
        return this.progressItems;
    }

    public String toString() {
        String desc = "[" + this.id + " | " + this.asset.getId() + "] ";
        if (this.isCopy()) {
            desc = desc + "copied from [" + this.getOriginalId() + " v" + this.getOriginalVersion() + "] ";
        }
        desc = desc + (Object)((Object)this.status);
        return desc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Title)) {
            return false;
        }
        Title other = (Title)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public Map<String, TitleStatus> getAssetStatusMap() {
        return this.assetVersionStatusMap;
    }

    public void setAssetStatusMap(Map<String, TitleStatus> assetStatusMap) {
        this.assetVersionStatusMap = assetStatusMap;
    }

    public TitleStatus getStatus(String version) {
        return this.assetVersionStatusMap.get(version);
    }

    public Long getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public void setOriginalVersion(String originalVersion) {
        this.originalVersion = originalVersion;
    }

    public boolean isCopy() {
        return this.getOriginalId() != null;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Collection<Asset> getAllAssets(boolean includeFiles) {
        return this.asset != null ? this.asset.getAllAssets(includeFiles) : new ArrayList();
    }

    public void removeAsset(Asset assetToRemove) {
        if (assetToRemove.equals(this.asset)) {
            throw new IllegalArgumentException("Cannot remove the root asset from the title.");
        }
        if (this.asset != null) {
            this.asset.removeAsset(assetToRemove);
        }
    }
}

