/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.FileInfo;
import com.tandbergtv.metadatamanager.search.PropertyValueField;
import com.tandbergtv.metadatamanager.search.SearchField;
import com.tandbergtv.metadatamanager.search.SearchFieldList;
import com.tandbergtv.metadatamanager.search.SearchInfo;
import com.tandbergtv.metadatamanager.search.SortField;
import com.tandbergtv.metadatamanager.search.SortInfo;
import com.tandbergtv.metadatamanager.search.builder.JoinOperator;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.search.builder.QueryOperators;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.AssetFieldQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.AssetQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.FileQueryBuilder;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.Join;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class AssetSearchServiceImpl
implements AssetSearchService {
    private HibernateTemplate hibernateTemplate;
    private static final Logger logger = Logger.getLogger(AssetSearchServiceImpl.class);

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    @Override
    public SearchCriteria getCriteria(String rootEntityAlias, SearchInfo searchInfo, SortInfo sortInfo, int revision) {
        SearchCriteria crit = new SearchCriteria();
        Entity assetEntity = new Entity(rootEntityAlias, Asset.class, "a");
        this.buildActiveAssetCriteria(assetEntity);
        if (searchInfo != null) {
            List<SearchField> fields = searchInfo.getFields();
            if (fields.get(0) instanceof PropertyValueField) {
                PropertyValueField propertyField = (PropertyValueField)fields.get(0);
                assetEntity.addParameter((SearchParameterBase)new ValueParameter(propertyField.getName(), SearchType.STRING, (Object)propertyField.getValues().get(0), SearchOperator.EQUAL));
            } else {
                FieldInfo fieldInfo = (FieldInfo)fields.get(0);
                fieldInfo.createEntity(searchInfo.getProperty(), assetEntity);
            }
        }
        if (sortInfo != null) {
            if (sortInfo.getProperty() == null || sortInfo.getProperty().equals("")) {
                SortParameter sortParam = new SortParameter(sortInfo.getSortItemName(), sortInfo.getOrder());
                assetEntity.addParameter((SearchParameterBase)sortParam);
            } else {
                Entity sortField = new Entity("field", sortInfo.getProperty(), "f");
                ArrayList<String> selectPropertyNames = new ArrayList<String>();
                selectPropertyNames.add("value");
                sortField.setSelectPropertyNames(selectPropertyNames);
                sortField.setJoin(Join.LEFT_OUTER);
                sortField.setFetch(true);
                String type = DataTypeMappingReader.getInstance().determineDataType(sortInfo.getSortItemName());
                if (type.equals("integer")) {
                    sortField.addParameter((SearchParameterBase)new SortParameter("intValue", sortInfo.getOrder()));
                    selectPropertyNames.clear();
                    selectPropertyNames.add("intValue");
                } else if (type.equals("float")) {
                    sortField.addParameter((SearchParameterBase)new SortParameter("floatValue", sortInfo.getOrder()));
                    selectPropertyNames.clear();
                    selectPropertyNames.add("floatValue");
                } else if (type.equals("date")) {
                    sortField.addParameter((SearchParameterBase)new SortParameter("dateValue", sortInfo.getOrder()));
                    selectPropertyNames.clear();
                    selectPropertyNames.add("dateValue");
                } else {
                    sortField.addParameter((SearchParameterBase)new SortParameter("value", sortInfo.getOrder()));
                }
                sortField.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)sortInfo.getSortItemName(), SearchOperator.EQUAL));
                assetEntity.addParameter((SearchParameterBase)sortField);
            }
        }
        this.buildRevsionCriteria(revision, assetEntity);
        crit.addParameter((SearchParameterBase)assetEntity);
        return crit;
    }

    private void buildActiveAssetCriteria(Entity assetEntity) {
        assetEntity.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.ASSET_STATE.toString(), SearchType.NUMERIC, (Object)AssetState.ACTIVE.ordinal()));
    }

    private void buildRevsionCriteria(int revision, Entity assetEntity) {
    }

    @Override
    @Transactional
    public int count(String query) {
        AssetFieldQueryBuilder assetFieldQueryBuilder = new AssetFieldQueryBuilder(false);
        String countQueryAlias = "assets";
        final String countQuery = QueryConstants.SELECT + QueryConstants.SPACE + QueryConstants.COUNT + QueryConstants.START_PARENTHESIS + AssetFieldQueryBuilder.SEARCH_ASSET_SELECT_ALIAS + QueryConstants.END_PARENTHESIS + QueryConstants.SPACE + QueryConstants.FROM + QueryConstants.START_PARENTHESIS + query + QueryConstants.END_PARENTHESIS + QueryConstants.SPACE + countQueryAlias;
        BigDecimal count = (BigDecimal)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery q = session.createSQLQuery(countQuery);
                return q.uniqueResult();
            }
        });
        return count.intValueExact();
    }

    @Override
    public String getQuery(String searchQueryAlias, String sortQueryAlias, SearchInfo searchInfo, SortField sortField) {
        return this.getQuery(searchQueryAlias, sortQueryAlias, searchInfo, sortField, false);
    }

    private String getQuery(String searchQueryAlias, String sortQueryAlias, SearchInfo searchInfo, SortField sortField, boolean useFieldRevision) {
        AssetFieldQueryBuilder assetFieldQueryBuilder = new AssetFieldQueryBuilder(useFieldRevision);
        StringBuilder query = new StringBuilder();
        if (searchInfo == null && sortField != null) {
            return assetFieldQueryBuilder.getSortQuery(sortField, AssetFieldQueryBuilder.SEARCH_ASSET_SELECT_ALIAS);
        }
        List<SearchField> searchFields = searchInfo.getFields();
        this.getQueryHelper(searchFields, query, assetFieldQueryBuilder);
        if (sortField == null) {
            return query.toString();
        }
        String sortAlias = "sortTree";
        String searchAlias = "searchTree";
        StringBuilder searchSortQuery = new StringBuilder();
        searchSortQuery.append(QueryConstants.SELECT + QueryConstants.SPACE + AssetFieldQueryBuilder.SEARCH_ASSET_SELECT_ALIAS + QueryConstants.COMMA + SortField.ALIAS + QueryConstants.SPACE + QueryConstants.FROM + QueryConstants.SPACE + QueryConstants.START_PARENTHESIS + query.toString() + QueryConstants.END_PARENTHESIS + QueryConstants.SPACE + searchAlias);
        searchSortQuery.append(QueryConstants.SPACE + QueryConstants.LEFT_OUTER_JOIN + QueryConstants.SPACE + QueryConstants.START_PARENTHESIS);
        searchSortQuery.append(assetFieldQueryBuilder.getSortQuery(sortField, AssetFieldQueryBuilder.SORT_ASSET_SELECT_ALIAS) + QueryConstants.END_PARENTHESIS);
        searchSortQuery.append(QueryConstants.SPACE + sortAlias + QueryConstants.SPACE + QueryConstants.ON + QueryConstants.SPACE + QueryConstants.START_PARENTHESIS + this.getSearchSortJoin(searchAlias, sortAlias) + QueryConstants.END_PARENTHESIS);
        return searchSortQuery.toString();
    }

    private void getQueryHelper(List<SearchField> searchFields, StringBuilder query, AssetFieldQueryBuilder assetFieldQueryBuilder) {
        FileQueryBuilder fileQueryBuilder = new FileQueryBuilder();
        Iterator<SearchField> iterator = searchFields.iterator();
        while (iterator.hasNext()) {
            SearchField field = iterator.next();
            if (field instanceof FileInfo) {
                query.append(fileQueryBuilder.getSearchSubQuery((FileInfo)field));
            } else if (field instanceof SearchFieldList) {
                SearchFieldList sfi = (SearchFieldList)field;
                query.append(QueryConstants.SPACE);
                query.append(QueryConstants.START_PARENTHESIS);
                this.getQueryHelper(sfi.getSubFields(), query, assetFieldQueryBuilder);
                query.append(QueryConstants.END_PARENTHESIS);
                query.append(QueryConstants.SPACE);
            } else {
                query.append(assetFieldQueryBuilder.getSearchSubQuery(field, false, true, true));
            }
            if (!iterator.hasNext()) continue;
            query.append(QueryConstants.SPACE);
            JoinOperator operator = field.isConjunction() ? JoinOperator.INTERSECT : JoinOperator.UNION;
            query.append(operator.name());
            query.append(QueryConstants.SPACE);
        }
    }

    private String getSearchSortJoin(String searchAlias, String sortAlias) {
        StringBuilder join = new StringBuilder();
        join.append(searchAlias + QueryConstants.PERIOD + AssetFieldQueryBuilder.SEARCH_ASSET_SELECT_ALIAS + QueryOperators.EQUAL.toString() + sortAlias + QueryConstants.PERIOD + AssetFieldQueryBuilder.SORT_ASSET_SELECT_ALIAS);
        return join.toString();
    }

    @Override
    public String getQuery(List<SearchField> filters) {
        SearchInfo info = new SearchInfo();
        info.setFields(filters);
        return this.getQuery("", "", info, null);
    }

    @Override
    public String getFieldRevisionQuery(SearchInfo searchInfo) {
        return this.getQuery("", "", searchInfo, null, true);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Asset> search(final String query) {
        List result = (List)this.getHibernateTemplate().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery q = session.createSQLQuery(query);
                return q.list();
            }
        });
        if (result.size() == 0) {
            return new ArrayList<Asset>();
        }
        LinkedHashMap<Long, Asset> assets = new LinkedHashMap<Long, Asset>();
        block0: for (int i = 0; i < result.size(); ++i) {
            if (result.get(i) instanceof BigDecimal) {
                BigDecimal id = (BigDecimal)result.get(i);
                assets.put(Long.valueOf(id.toString()), null);
                continue;
            }
            Object[] cols = (Object[])result.get(i);
            for (int j = 0; j < cols.length; ++j) {
                if (!(cols[j] instanceof BigDecimal)) continue;
                assets.put(Long.valueOf(cols[j].toString()), null);
                continue block0;
            }
        }
        StringBuilder assetIds = new StringBuilder();
        for (Long id : assets.keySet()) {
            if (assetIds.length() > 0) {
                assetIds.append(QueryConstants.COMMA);
            }
            assetIds.append(id.toString());
        }
        final String queryStr = "FROM Asset a WHERE a.id in " + QueryConstants.START_PARENTHESIS + assetIds.toString() + QueryConstants.END_PARENTHESIS;
        List matchingAssets = (List)this.getHibernateTemplate().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(queryStr);
                return q.list();
            }
        });
        for (Asset a : matchingAssets) {
            if (a.getRoot() != null) {
                a.getRoot().loadCompleteTree();
            } else {
                a.loadCompleteTree();
            }
            assets.put(a.getId(), a);
        }
        return new ArrayList<Asset>(assets.values());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Long> searchForAssetId(final String query) {
        List result = (List)this.getHibernateTemplate().executeWithNativeSession(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery q = session.createSQLQuery(query);
                return q.list();
            }
        });
        ArrayList<Long> assetIds = new ArrayList<Long>();
        for (int i = 0; i < result.size(); ++i) {
            if (!(result.get(i) instanceof BigDecimal)) continue;
            BigDecimal id = (BigDecimal)result.get(i);
            assetIds.add(Long.valueOf(id.toString()));
        }
        return assetIds;
    }

    @Override
    public String getDefaultAssetConditions(String alias) {
        AssetQueryBuilder qb = new AssetQueryBuilder();
        return qb.getDefaultConditions(alias);
    }
}

