/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum LogicalOperator {
    EQUAL("EQUAL"),
    LESSTHAN("LESSTHAN"),
    GREATERTHAN("GREATERTHAN"),
    LESSTHANEQUAL("LESSTHANEQUAL"),
    GREATERTHANEQUAL("GREATERTHANEQUAL"),
    ISEMPTY("ISEMPTY"),
    ISNOTEMPTY("ISNOTEMPTY"),
    NOTEQUAL("NOTEQUAL"),
    CONTAINS("CONTAINS"),
    DOESNOTCONTAIN("DOESNOTCONTAIN"),
    IN("IN"),
    NOTIN("NOTIN"),
    AND("AND"),
    OR("OR"),
    NOT("NOT"),
    XOR("XOR"),
    STARTSWITH("STARTSWITH"),
    ENDSWITH("ENDSWITH"),
    DOESNOTSTARTWITH("DOESNOTSTARTWITH"),
    DOESNOTENDWITH("DOESNOTENDWITH"),
    EVALCHILDFIELDS("evalChildFields"),
    LENGTHEQUALS("LENGTHEQUALS"),
    LENGTHLESSTHAN("LENGTHLESSTHAN"),
    LENGTHGREATERTHAN("LENGTHGREATERTHAN"),
    REGEX("REGEX"),
    GREATERTHANTODAY("GREATERTHANTODAY"),
    LESSTHANTODAY("LESSTHANTODAY"),
    CONTAINSUNPARSABLE("CONTAINSUNPARSABLE"),
    NOTGREATERTHANTODAY("NOTGREATERTHANTODAY"),
    NOTLESSTHANTODAY("NOTLESSTHANTODAY"),
    DOESNOTCONTAINUNPARSABLE("DOESNOTCONTAINUNPARSABLE"),
    TIER1EQUALS("TIER1EQUALS"),
    TIER2EQUALS("TIER2EQUALS"),
    TIER3EQUALS("TIER3EQUALS"),
    TIER4EQUALS("TIER4EQUALS"),
    ISNULL("ISNULL"),
    ISNOTNULL("ISNOTNULL");

    private String key;

    private LogicalOperator(String key) {
        this.key = key;
    }

    public static LogicalOperator lookUp(String operator) {
        LogicalOperator[] allOper;
        for (LogicalOperator oper : allOper = LogicalOperator.values()) {
            if (!oper.key.equalsIgnoreCase(operator)) continue;
            return oper;
        }
        throw new IllegalArgumentException("No value found for " + operator);
    }

    public String toString() {
        return this.key;
    }

    public String getName() {
        return this.key;
    }

    public LogicalOperator invert() {
        switch (this) {
            case EQUAL: {
                return NOTEQUAL;
            }
            case LESSTHAN: {
                return GREATERTHANEQUAL;
            }
            case GREATERTHAN: {
                return LESSTHANEQUAL;
            }
            case LESSTHANEQUAL: {
                return GREATERTHAN;
            }
            case GREATERTHANEQUAL: {
                return LESSTHAN;
            }
            case ISEMPTY: {
                return ISNOTEMPTY;
            }
            case ISNOTEMPTY: {
                return ISEMPTY;
            }
            case NOTEQUAL: {
                return EQUAL;
            }
            case CONTAINS: {
                return DOESNOTCONTAIN;
            }
            case DOESNOTCONTAIN: {
                return CONTAINS;
            }
            case IN: {
                return NOTIN;
            }
            case NOTIN: {
                return IN;
            }
            case STARTSWITH: {
                return DOESNOTSTARTWITH;
            }
            case DOESNOTSTARTWITH: {
                return STARTSWITH;
            }
            case ENDSWITH: {
                return DOESNOTENDWITH;
            }
            case DOESNOTENDWITH: {
                return ENDSWITH;
            }
            case GREATERTHANTODAY: {
                return NOTGREATERTHANTODAY;
            }
            case NOTGREATERTHANTODAY: {
                return GREATERTHANTODAY;
            }
            case LESSTHANTODAY: {
                return NOTLESSTHANTODAY;
            }
            case NOTLESSTHANTODAY: {
                return LESSTHANTODAY;
            }
            case CONTAINSUNPARSABLE: {
                return DOESNOTCONTAINUNPARSABLE;
            }
            case DOESNOTCONTAINUNPARSABLE: {
                return CONTAINSUNPARSABLE;
            }
            case TIER1EQUALS: {
                return TIER1EQUALS;
            }
            case TIER2EQUALS: {
                return TIER2EQUALS;
            }
            case TIER3EQUALS: {
                return TIER3EQUALS;
            }
            case TIER4EQUALS: {
                return TIER4EQUALS;
            }
            case AND: {
                return AND;
            }
            case OR: {
                return OR;
            }
            case NOT: {
                return NOT;
            }
            case XOR: {
                return XOR;
            }
            case EVALCHILDFIELDS: {
                return EVALCHILDFIELDS;
            }
            case LENGTHEQUALS: {
                return LENGTHEQUALS;
            }
            case LENGTHLESSTHAN: {
                return LENGTHLESSTHAN;
            }
            case LENGTHGREATERTHAN: {
                return LENGTHGREATERTHAN;
            }
            case REGEX: {
                return REGEX;
            }
        }
        return this;
    }
}

