/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.FieldSearchKey;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.builder.JoinOperator;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.search.builder.QueryOperators;
import com.tandbergtv.metadatamanager.util.DateParseException;
import com.tandbergtv.metadatamanager.util.DateUtil;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.NestedQueryEntity;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MetadataValueFieldInfo
extends FieldInfo {
    LogicalOperator operator;
    String value;

    public MetadataValueFieldInfo(String ttvxpath, LogicalOperator operator, String value) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.value = value;
        this.isConjunction = true;
    }

    public MetadataValueFieldInfo(String ttvxpath, LogicalOperator operator, String value, boolean isConjunction) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.value = value;
        this.isConjunction = isConjunction;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(LogicalOperator operator) {
        this.operator = operator;
    }

    @Override
    public void createEntity(String property, Entity assetEntity) {
        if (!this.ttvxpath.startsWith("/")) {
            if (this.operator.equals((Object)LogicalOperator.CONTAINSUNPARSABLE) || this.operator.equals((Object)LogicalOperator.DOESNOTCONTAINUNPARSABLE)) {
                Entity field = new Entity("field", property, "f");
                field.addParameter((SearchParameterBase)new ValueParameter("parsable", SearchType.NUMERIC, (Object)"0", SearchOperator.EQUAL));
                ValueParameter assetTypeParam = this.addAssetTypeCriteria();
                if (assetTypeParam != null && !assetTypeParam.getValue().equals(AssetSearchKey.ROOT_TYPE.toString())) {
                    field.addParameter((SearchParameterBase)assetTypeParam);
                }
                if (this.operator.equals((Object)LogicalOperator.DOESNOTCONTAINUNPARSABLE)) {
                    this.inverse((SearchParameterBase)field, assetEntity);
                } else {
                    assetEntity.addParameter((SearchParameterBase)field, this.isConjunction());
                }
            } else if (this.operator.equals((Object)LogicalOperator.ISEMPTY) || this.operator.equals((Object)LogicalOperator.ISNOTEMPTY)) {
                Entity param = null;
                if (this.addAssetTypeCriteria().getValue().equals(AssetSearchKey.ROOT_TYPE.toString())) {
                    param = new ValueParameter(AssetSearchKey.ASSET_TYPE.toString(), SearchType.STRING, (Object)AssetSearchKey.ROOT_TYPE.toString(), SearchOperator.EQUAL);
                    assetEntity.addParameter((SearchParameterBase)param, this.isConjunction());
                } else {
                    param = new Entity("asset", AssetSearchKey.ALL_DESCENDANT_ASSETS.toString(), "desasset");
                    param.addParameter((SearchParameterBase)new ValueParameter("type", SearchType.STRING, this.addAssetTypeCriteria().getValue(), SearchOperator.EQUAL));
                }
                if (this.operator.equals((Object)LogicalOperator.ISEMPTY)) {
                    this.inverse((SearchParameterBase)param, assetEntity);
                } else if (this.operator.equals((Object)LogicalOperator.ISNOTEMPTY)) {
                    assetEntity.addParameter((SearchParameterBase)param, this.isConjunction());
                }
            }
        } else if (this.operator.equals((Object)LogicalOperator.ISEMPTY)) {
            Entity internalField = new Entity("field", property, "internalField");
            internalField.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.ISNOTEMPTY));
            ValueParameter assetTypeParam = this.addAssetTypeCriteria();
            if (assetTypeParam != null) {
                internalField.addParameter((SearchParameterBase)assetTypeParam);
            }
            this.inverse((SearchParameterBase)internalField, assetEntity);
        } else {
            Entity field = new Entity("field", property, "f");
            if (this.operator.equals((Object)LogicalOperator.ISNOTEMPTY)) {
                field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.valueOf((String)this.operator.toString())));
            } else {
                String valueColumnName = "";
                SearchType searchType = SearchType.STRING;
                if (this.operator.equals((Object)LogicalOperator.CONTAINSUNPARSABLE) || this.operator.equals((Object)LogicalOperator.DOESNOTCONTAINUNPARSABLE)) {
                    field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.ISNOTEMPTY));
                } else {
                    field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.EQUAL));
                }
                valueColumnName = this.getValueColumnName();
                searchType = this.getSearchTypeBasedOnColumn(valueColumnName);
                if (searchType == SearchType.DATE && this.operator.equals((Object)LogicalOperator.EQUAL)) {
                    RangeParameter range = this.handleEqualsOnDate(valueColumnName);
                    field.addParameter((SearchParameterBase)range);
                } else {
                    if (searchType == SearchType.DATE) {
                        this.value = this.convertDate();
                    }
                    if (this.operator.equals((Object)LogicalOperator.CONTAINSUNPARSABLE) || this.operator.equals((Object)LogicalOperator.DOESNOTCONTAINUNPARSABLE)) {
                        field.addParameter((SearchParameterBase)new ValueParameter("parsable", SearchType.NUMERIC, (Object)"0", SearchOperator.EQUAL));
                    } else if (this.operator.equals((Object)LogicalOperator.DOESNOTSTARTWITH)) {
                        field.addParameter((SearchParameterBase)new ValueParameter(valueColumnName, searchType, (Object)this.value, SearchOperator.STARTSWITH, this.ignoreCase));
                    } else if (this.operator.equals((Object)LogicalOperator.DOESNOTENDWITH)) {
                        field.addParameter((SearchParameterBase)new ValueParameter(valueColumnName, searchType, (Object)this.value, SearchOperator.ENDSWITH, this.ignoreCase));
                    } else {
                        field.addParameter((SearchParameterBase)new ValueParameter(valueColumnName, searchType, (Object)this.value, SearchOperator.valueOf((String)this.operator.toString()), this.ignoreCase));
                    }
                }
            }
            ValueParameter assetTypeParam = this.addAssetTypeCriteria();
            if (assetTypeParam != null) {
                field.addParameter((SearchParameterBase)assetTypeParam);
            }
            if (this.operator.equals((Object)LogicalOperator.DOESNOTSTARTWITH) || this.operator.equals((Object)LogicalOperator.DOESNOTENDWITH) || this.operator.equals((Object)LogicalOperator.DOESNOTCONTAINUNPARSABLE)) {
                field.setOperator(SearchOperator.valueOf((String)this.operator.invert().toString()));
                this.inverse((SearchParameterBase)field, assetEntity);
            } else {
                assetEntity.addParameter((SearchParameterBase)field, this.isConjunction());
            }
        }
    }

    private void inverse(SearchParameterBase innerParam, Entity outerEntity) {
        Entity internalAssetEntity = new Entity("rootAsset", Asset.class, "internalAsset");
        internalAssetEntity.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.ASSET_STATE.toString(), SearchType.NUMERIC, (Object)AssetState.ACTIVE.ordinal()));
        internalAssetEntity.addParameter(innerParam);
        NestedQueryEntity n = new NestedQueryEntity("rootAsset", Asset.class, outerEntity.getAlias());
        n.setOperator(SearchOperator.NOTIN);
        n.addParameter((SearchParameterBase)internalAssetEntity);
        outerEntity.addParameter((SearchParameterBase)n, this.isConjunction());
    }

    private RangeParameter handleEqualsOnDate(String valueColumnName) {
        String buffer = this.convertDate();
        RangeParameter range = new RangeParameter(valueColumnName, SearchType.DATE, buffer);
        range.setTo(buffer);
        return range;
    }

    private String convertDate() {
        if (this.value == null) {
            return null;
        }
        if (this.value.equals("")) {
            return "";
        }
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            if (this.operator.equals((Object)LogicalOperator.LESSTHANTODAY) || this.operator.equals((Object)LogicalOperator.GREATERTHANTODAY) || this.operator.equals((Object)LogicalOperator.NOTGREATERTHANTODAY) || this.operator.equals((Object)LogicalOperator.NOTLESSTHANTODAY)) {
                if (this.operator.equals((Object)LogicalOperator.NOTGREATERTHANTODAY)) {
                    this.operator = LogicalOperator.LESSTHANEQUAL;
                } else if (this.operator.equals((Object)LogicalOperator.NOTLESSTHANTODAY)) {
                    this.operator = LogicalOperator.GREATERTHANEQUAL;
                }
                calendar.setTime(new Date());
                ((Calendar)calendar).add(5, Integer.parseInt(this.value));
            } else {
                calendar.setTime(DateUtil.convertDate(this.value));
            }
        }
        catch (DateParseException e) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(this.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(this.twoDigit(calendar.get(5)));
        return buffer.toString();
    }

    private String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    @Override
    public String getCondition(String alias) {
        String valueColumnName;
        SearchType searchType;
        StringBuilder fieldConditions = new StringBuilder();
        if (!this.ttvxpath.isEmpty()) {
            fieldConditions.append(alias + QueryConstants.PERIOD + (Object)((Object)FieldSearchKey.TTV_XPATH) + QueryOperators.EQUAL.toString() + QueryConstants.QUOTE + this.getTtvxpath() + QueryConstants.QUOTE);
            if (this.operator.equals((Object)LogicalOperator.ISNOTEMPTY) || this.operator.equals((Object)LogicalOperator.ISEMPTY)) {
                return fieldConditions.toString();
            }
            fieldConditions.append(QueryConstants.SPACE);
            fieldConditions.append((Object)JoinOperator.AND);
            fieldConditions.append(QueryConstants.SPACE);
        }
        if ((searchType = this.getSearchTypeBasedOnColumn(valueColumnName = this.getValueColumnName())) == SearchType.DATE && this.operator.equals((Object)LogicalOperator.EQUAL)) {
            RangeParameter range = this.handleEqualsOnDate(valueColumnName);
            fieldConditions.append(alias + QueryConstants.PERIOD + valueColumnName + QueryConstants.SPACE + QueryConstants.BETWEEN + QueryConstants.SPACE + QueryConstants.TO_DATE + QueryConstants.START_PARENTHESIS + QueryConstants.QUOTE + range.getFrom() + QueryConstants.QUOTE + QueryConstants.COMMA + QueryConstants.DATE_FORMAT + QueryConstants.END_PARENTHESIS + QueryConstants.SPACE + (Object)((Object)JoinOperator.AND) + QueryConstants.SPACE + QueryConstants.TO_DATE + QueryConstants.START_PARENTHESIS + QueryConstants.QUOTE + range.getTo() + QueryConstants.QUOTE + QueryConstants.COMMA + QueryConstants.DATE_FORMAT + QueryConstants.END_PARENTHESIS);
        } else {
            if (searchType == SearchType.DATE) {
                this.value = this.convertDate();
            }
            if (this.operator.equals((Object)LogicalOperator.CONTAINSUNPARSABLE) || this.operator.equals((Object)LogicalOperator.DOESNOTCONTAINUNPARSABLE)) {
                fieldConditions.append(alias + QueryConstants.PERIOD + (Object)((Object)FieldSearchKey.PARSABLE) + QueryConstants.SPACE + (Object)((Object)QueryOperators.EQUAL) + QueryConstants.SPACE + "0");
            } else if (this.operator.equals((Object)LogicalOperator.DOESNOTSTARTWITH) || this.operator.equals((Object)LogicalOperator.STARTSWITH) || this.operator.equals((Object)LogicalOperator.DOESNOTENDWITH) || this.operator.equals((Object)LogicalOperator.ENDSWITH)) {
                if (searchType == SearchType.STRING) {
                    this.value = this.operator.equals((Object)LogicalOperator.DOESNOTSTARTWITH) || this.operator.equals((Object)LogicalOperator.STARTSWITH) ? QueryConstants.QUOTE + this.value + QueryConstants.WILDCARD + QueryConstants.QUOTE : QueryConstants.QUOTE + QueryConstants.WILDCARD + this.value + QueryConstants.QUOTE;
                    if (this.isIgnoreCase()) {
                        this.value = QueryConstants.TO_LOWER + QueryConstants.START_PARENTHESIS + this.value + QueryConstants.END_PARENTHESIS;
                        fieldConditions.append(QueryConstants.TO_LOWER + QueryConstants.START_PARENTHESIS);
                    }
                    fieldConditions.append(alias + QueryConstants.PERIOD + valueColumnName);
                    if (this.isIgnoreCase()) {
                        fieldConditions.append(QueryConstants.END_PARENTHESIS);
                    }
                    fieldConditions.append(QueryConstants.SPACE + (Object)((Object)QueryOperators.LIKE) + QueryConstants.SPACE + this.value);
                }
            } else {
                String value;
                String string = value = this.operator.equals((Object)LogicalOperator.CONTAINS) || this.operator.equals((Object)LogicalOperator.DOESNOTCONTAIN) ? QueryConstants.WILDCARD + this.getValue() + QueryConstants.WILDCARD : this.getValue();
                if (searchType == SearchType.STRING) {
                    value = QueryConstants.QUOTE + value + QueryConstants.QUOTE;
                    if (this.isIgnoreCase()) {
                        value = QueryConstants.TO_LOWER + QueryConstants.START_PARENTHESIS + value + QueryConstants.END_PARENTHESIS;
                    }
                } else if (searchType == SearchType.DATE) {
                    value = QueryConstants.TO_DATE + QueryConstants.START_PARENTHESIS + QueryConstants.QUOTE + value + QueryConstants.QUOTE + QueryConstants.COMMA + QueryConstants.DATE_FORMAT + QueryConstants.END_PARENTHESIS;
                }
                if (searchType == SearchType.STRING && this.isIgnoreCase()) {
                    fieldConditions.append(QueryConstants.TO_LOWER + QueryConstants.START_PARENTHESIS);
                }
                fieldConditions.append(alias + QueryConstants.PERIOD + valueColumnName);
                if (searchType == SearchType.STRING && this.isIgnoreCase()) {
                    fieldConditions.append(QueryConstants.END_PARENTHESIS);
                }
                fieldConditions.append(QueryConstants.SPACE + QueryOperators.lookUp(this.operator.getName()) + QueryConstants.SPACE + value);
            }
        }
        return fieldConditions.toString();
    }

    @Override
    public String getSelectProperties() {
        return "";
    }
}

