/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.searchimpl.querybuilder;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.NodeFieldInfo;
import com.tandbergtv.metadatamanager.search.PropertyValueField;
import com.tandbergtv.metadatamanager.search.SearchField;
import com.tandbergtv.metadatamanager.search.SortField;
import com.tandbergtv.metadatamanager.search.builder.IQueryBuilder;
import com.tandbergtv.metadatamanager.search.builder.JoinOperator;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.searchimpl.joinbuilder.AssetFieldJoinBuilder;
import com.tandbergtv.metadatamanager.searchimpl.joinbuilder.OwnerRelationJoinBuilder;
import com.tandbergtv.metadatamanager.searchimpl.joinbuilder.TargetRelationJoinBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.AssetQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.FieldQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.FieldRevisionQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.RelationQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.RootAssetQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.util.SQLQueryOperatorHelper;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.HashMap;

public class AssetFieldQueryBuilder
implements IQueryBuilder {
    private AssetQueryBuilder assetQueryBuilder = new AssetQueryBuilder();
    private RootAssetQueryBuilder rootAssetQueryBuilder = new RootAssetQueryBuilder();
    private FieldQueryBuilder fieldQueryBuilder;
    private RelationQueryBuilder relationQueryBuilder;
    private AssetFieldJoinBuilder assetFieldJoinBuilder;
    private OwnerRelationJoinBuilder ownerRelationJoinBuilder;
    private TargetRelationJoinBuilder targetRelationJoinBuilder;
    public static String SEARCH_ASSET_SELECT_ALIAS = "assetId";
    public static String SORT_ASSET_SELECT_ALIAS = "sortAssetId";

    public AssetFieldQueryBuilder(boolean useFieldRevision) {
        this.fieldQueryBuilder = useFieldRevision ? new FieldRevisionQueryBuilder() : new FieldQueryBuilder();
        this.assetFieldJoinBuilder = new AssetFieldJoinBuilder();
        this.relationQueryBuilder = new RelationQueryBuilder();
        this.ownerRelationJoinBuilder = new OwnerRelationJoinBuilder();
        this.targetRelationJoinBuilder = new TargetRelationJoinBuilder();
    }

    public String getSearchSubQuery(SearchField field, boolean searchOnFieldRevisions, boolean getRoot, boolean getRootAsset) {
        StringBuilder query = new StringBuilder();
        if (field instanceof FieldInfo) {
            this.attachQueryForFieldInfo((FieldInfo)field, query, getRoot);
        } else if (field instanceof PropertyValueField) {
            this.attachQueryForProperty((PropertyValueField)field, query);
        }
        return query.toString();
    }

    private void attachQueryForFieldInfo(FieldInfo field, StringBuilder query, boolean getRoot) {
        if (field instanceof NodeFieldInfo) {
            NodeFieldInfo node = (NodeFieldInfo)NodeFieldInfo.class.cast(field);
            query.append(QueryConstants.START_PARENTHESIS);
            for (int i = 0; i < node.getFields().size(); ++i) {
                FieldInfo f = node.getFields().get(i);
                if (i > 0) {
                    query.append(QueryConstants.SPACE);
                    query.append((Object)(node.isChildrenConjunction() ? JoinOperator.INTERSECT : JoinOperator.UNION));
                    query.append(QueryConstants.SPACE);
                }
                this.attachQueryForSingleField(f, getRoot, query);
            }
            query.append(QueryConstants.END_PARENTHESIS);
        } else {
            this.attachQueryForSingleField(field, getRoot, query);
        }
    }

    private void attachQueryForProperty(PropertyValueField field, StringBuilder query) {
        SQLQueryOperatorHelper operatorHelper;
        boolean invertCondition;
        StringBuilder propertyQuery = new StringBuilder();
        boolean isRoot = this.isRootAsset(field);
        HashMap<String, String> filters = new HashMap<String, String>();
        StringBuilder allValues = new StringBuilder();
        for (String v : field.getValues()) {
            if (allValues.length() > 0) {
                allValues.append(",");
            }
            if (this.getFieldType(field.getName()) == SearchType.STRING) {
                allValues.append(QueryConstants.QUOTE + v + QueryConstants.QUOTE);
                continue;
            }
            allValues.append(v);
        }
        filters.put(field.getName(), allValues.toString());
        propertyQuery.append(QueryConstants.SELECT + QueryConstants.SPACE + QueryConstants.DISTINCT + QueryConstants.SPACE + this.assetQueryBuilder.getSelectProperties(isRoot, SEARCH_ASSET_SELECT_ALIAS) + QueryConstants.SPACE + QueryConstants.FROM + QueryConstants.SPACE + this.assetQueryBuilder.getPartialFromClause() + QueryConstants.SPACE);
        if (!isRoot) {
            propertyQuery.append(QueryConstants.COMMA + this.relationQueryBuilder.getPartialFromClause() + QueryConstants.SPACE);
        }
        propertyQuery.append(QueryConstants.WHERE + QueryConstants.SPACE + this.assetQueryBuilder.getPartialWhereClause(filters, field.getOperator()));
        if (!isRoot) {
            propertyQuery.append(QueryConstants.SPACE + (Object)((Object)JoinOperator.AND) + QueryConstants.SPACE + this.relationQueryBuilder.getPartialWhereClause());
            propertyQuery.append(QueryConstants.SPACE);
            propertyQuery.append((Object)JoinOperator.AND);
            propertyQuery.append(QueryConstants.SPACE);
            propertyQuery.append(this.ownerRelationJoinBuilder.getJoin(this.relationQueryBuilder.getAlias(), this.assetQueryBuilder.getAlias()));
            propertyQuery.append(QueryConstants.SPACE);
            propertyQuery.append((Object)JoinOperator.AND);
            propertyQuery.append(QueryConstants.SPACE);
            propertyQuery.append(this.targetRelationJoinBuilder.getJoin(this.relationQueryBuilder.getAlias(), this.assetQueryBuilder.getAlias()));
        }
        if (invertCondition = (operatorHelper = new SQLQueryOperatorHelper()).invertOperator(field)) {
            if (field.getName().equals(AssetSearchKey.ASSET_TYPE.toString())) {
                query.append(this.rootAssetQueryBuilder.wrapNotInQuery(SEARCH_ASSET_SELECT_ALIAS, allValues.toString(), propertyQuery.toString()));
            }
        } else {
            query.append(propertyQuery.toString());
        }
    }

    private SearchType getFieldType(String propertyColName) {
        if (propertyColName.equalsIgnoreCase(DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ASSET_ID.toString())) || propertyColName.equalsIgnoreCase(DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ASSET_STATE.toString())) || propertyColName.equalsIgnoreCase(DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ASSET_ROOT.toString())) || propertyColName.equalsIgnoreCase(DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ORIGINAL_ASSET_ID.toString()))) {
            return SearchType.NUMERIC;
        }
        return SearchType.STRING;
    }

    private boolean isRootAsset(SearchField field) {
        if (field instanceof FieldInfo) {
            if ((FieldInfo)field instanceof NodeFieldInfo) {
                return false;
            }
            if (field instanceof SortField) {
                return ((SortField)field).getAssetType().equals(AssetSearchKey.ROOT_TYPE.toString());
            }
            if (((FieldInfo)field).getAssetType() != null && !((FieldInfo)field).getAssetType().isEmpty()) {
                return ((FieldInfo)field).getAssetType().equals(AssetSearchKey.ROOT_TYPE.toString());
            }
            return true;
        }
        if (field instanceof PropertyValueField) {
            if (!((PropertyValueField)field).getName().equalsIgnoreCase(AssetSearchKey.ASSET_TYPE.toString())) {
                return true;
            }
            return ((PropertyValueField)field).getValues().contains(AssetSearchKey.ROOT_TYPE.toString());
        }
        return false;
    }

    public String getSortQuery(SortField field, String alias) {
        return this.getMatchingAssetSubQuery(field, alias);
    }

    private String getMatchingAssetSubQuery(FieldInfo field, String assetSelectAlias) {
        StringBuilder matchingAssetQuery = new StringBuilder();
        boolean isRootCondition = this.isRootAsset(field);
        matchingAssetQuery.append(QueryConstants.SELECT);
        matchingAssetQuery.append(QueryConstants.SPACE);
        matchingAssetQuery.append(this.assetQueryBuilder.getSelectProperties(isRootCondition, assetSelectAlias));
        String fieldProperties = field.getSelectProperties();
        if (fieldProperties != null && !fieldProperties.isEmpty()) {
            matchingAssetQuery.append(QueryConstants.COMMA);
        }
        matchingAssetQuery.append(fieldProperties);
        if (!isRootCondition) {
            String relationProperties = this.relationQueryBuilder.getSelectProperties();
            if (relationProperties != null && !relationProperties.isEmpty()) {
                matchingAssetQuery.append(QueryConstants.COMMA);
            }
            matchingAssetQuery.append(relationProperties);
        }
        matchingAssetQuery.append(QueryConstants.SPACE);
        matchingAssetQuery.append(QueryConstants.FROM);
        matchingAssetQuery.append(QueryConstants.SPACE);
        matchingAssetQuery.append(this.assetQueryBuilder.getPartialFromClause());
        matchingAssetQuery.append(QueryConstants.COMMA);
        matchingAssetQuery.append(this.fieldQueryBuilder.getPartialFromClause(field));
        if (!isRootCondition) {
            matchingAssetQuery.append(QueryConstants.COMMA);
            matchingAssetQuery.append(this.relationQueryBuilder.getPartialFromClause());
        }
        matchingAssetQuery.append(QueryConstants.SPACE);
        matchingAssetQuery.append(QueryConstants.WHERE);
        matchingAssetQuery.append(QueryConstants.SPACE);
        HashMap<String, String> filters = new HashMap<String, String>();
        if (field.getAssetType() != null && !field.getAssetType().isEmpty()) {
            filters.put(AssetSearchKey.ASSET_TYPE.toString(), QueryConstants.QUOTE + field.getAssetType() + QueryConstants.QUOTE);
        }
        matchingAssetQuery.append(this.assetQueryBuilder.getPartialWhereClause(filters, LogicalOperator.IN));
        matchingAssetQuery.append(QueryConstants.SPACE);
        String fieldCondition = this.fieldQueryBuilder.getPartialWhereClause(field);
        if (!fieldCondition.isEmpty()) {
            matchingAssetQuery.append((Object)JoinOperator.AND);
            matchingAssetQuery.append(QueryConstants.SPACE);
            matchingAssetQuery.append(fieldCondition);
        }
        if (!isRootCondition) {
            String relationCondition = this.relationQueryBuilder.getPartialWhereClause();
            matchingAssetQuery.append(QueryConstants.SPACE);
            matchingAssetQuery.append((Object)JoinOperator.AND);
            matchingAssetQuery.append(QueryConstants.SPACE);
            matchingAssetQuery.append(relationCondition);
        }
        matchingAssetQuery.append(QueryConstants.SPACE);
        matchingAssetQuery.append((Object)JoinOperator.AND);
        matchingAssetQuery.append(QueryConstants.SPACE);
        matchingAssetQuery.append(this.assetFieldJoinBuilder.getJoin(this.assetQueryBuilder.getAlias(), this.fieldQueryBuilder.getAlias()));
        if (!isRootCondition) {
            matchingAssetQuery.append(QueryConstants.SPACE);
            matchingAssetQuery.append((Object)JoinOperator.AND);
            matchingAssetQuery.append(QueryConstants.SPACE);
            matchingAssetQuery.append(this.ownerRelationJoinBuilder.getJoin(this.relationQueryBuilder.getAlias(), this.assetQueryBuilder.getAlias()));
            matchingAssetQuery.append(QueryConstants.SPACE);
            matchingAssetQuery.append((Object)JoinOperator.AND);
            matchingAssetQuery.append(QueryConstants.SPACE);
            matchingAssetQuery.append(this.targetRelationJoinBuilder.getJoin(this.relationQueryBuilder.getAlias(), this.assetQueryBuilder.getAlias()));
        }
        return matchingAssetQuery.toString();
    }

    @Override
    public String getAlias() {
        return null;
    }

    private void attachQueryForSingleField(FieldInfo field, boolean getRoot, StringBuilder query) {
        String matchingAssetQuery = this.getMatchingAssetSubQuery(field, SEARCH_ASSET_SELECT_ALIAS);
        SQLQueryOperatorHelper operatorHelper = new SQLQueryOperatorHelper();
        boolean invertCondition = false;
        invertCondition = operatorHelper.invertOperator(field);
        if (invertCondition) {
            String assetType = QueryConstants.QUOTE + field.getAssetType() + QueryConstants.QUOTE;
            query.append(this.assetQueryBuilder.wrapNotInQuery(SEARCH_ASSET_SELECT_ALIAS, assetType, matchingAssetQuery));
        } else {
            query.append(matchingAssetQuery);
        }
    }
}

