/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.NextRevision;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.specimpl.SpecHandlerBase;
import java.util.List;

public abstract class SingleTitleSpecHandler
extends SpecHandlerBase {
    @Override
    protected void specSpecificMerging(Asset oldAsset, NextRevision nextRevision, Relation newRelation, Asset newTargetAsset) {
        List<Asset> oldTitleAssets = oldAsset.getTargetAssets(Item.ItemType.TITLE.toString());
        if (oldTitleAssets != null && oldTitleAssets.size() > 0) {
            this.mergeFields(newTargetAsset, oldTitleAssets.get(0), Item.ItemType.TITLE.toString(), nextRevision);
            if (nextRevision != null && oldTitleAssets.get(0).isRevisionNumberUpdated()) {
                oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
            }
        } else if (nextRevision == null) {
            NextRevision tempNextRevision = new NextRevision();
            tempNextRevision.setRevisionNumber(oldAsset.getLatestRevisionNumber());
            oldAsset.addChild(newRelation.getTargetAsset(), tempNextRevision, true);
        } else {
            oldAsset.addChild(newRelation.getTargetAsset(), nextRevision, true);
        }
    }

    @Override
    protected void specSpecificMergingNoSave(Asset newAsset, Relation oldRelation, Asset oldTitle) {
        List<Asset> newTitleAssets = newAsset.getTargetAssets(Item.ItemType.TITLE.toString());
        if (newTitleAssets != null && newTitleAssets.size() > 0) {
            Asset newTitleAsset = newTitleAssets.get(0);
            newTitleAsset.setTTVId(oldTitle.getTTVId());
            newTitleAsset.setOriginalAssetID(oldTitle.getOriginalAssetID());
            newTitleAsset.setOriginalRevisionNumber(oldTitle.getOriginalRevisionNumber());
            this.mergeFields(newTitleAssets.get(0), oldTitle, this.getAssetType(oldTitle));
        } else {
            Item i = new Item();
            i.setType(Item.ItemType.TITLE);
            i.setFields(oldTitle.getFields());
            i.setTTVId(oldTitle.getTTVId());
            i.setOriginalAssetID(oldTitle.getOriginalAssetID());
            i.setOriginalRevisionNumber(oldTitle.getOriginalRevisionNumber());
            newAsset.addChild(i);
        }
    }

    @Override
    protected boolean requireSpecSpecificMerging(String assetType) {
        return Item.ItemType.TITLE.toString().equalsIgnoreCase(assetType);
    }

    @Override
    protected boolean requireSpecSpecificSearchForPruning(String assetType) {
        return Item.ItemType.TITLE.toString().equalsIgnoreCase(assetType);
    }

    @Override
    protected Asset specSpecificSearchForPruning(String assetType, Asset newAsset, Asset oldTargetAsset) {
        Asset newTargetAsset = null;
        List<Asset> titleAssets = newAsset.getTargetAssets(Item.ItemType.TITLE.toString());
        if (titleAssets != null && titleAssets.size() > 0) {
            newTargetAsset = titleAssets.get(0);
        }
        return newTargetAsset;
    }
}

