/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.communication;

import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.Collection;

public class Util {
    private static final String ZERO = "0";

    public static String getStringValueTrimmed(WorkflowMessage message, String paramName) {
        String value;
        String string = value = message.getPayload() != null ? message.getValue(paramName) : null;
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public static Long getLongValue(WorkflowMessage message, String paramName) {
        String value = Util.getStringValueTrimmed(message, paramName);
        return value != null ? Long.valueOf(value) : null;
    }

    public static boolean getBooleanValue(WorkflowMessage message, String paramName) {
        String value = Util.getStringValueTrimmed(message, paramName);
        return value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
    }

    public static Long convertZeroOrLessToNull(Long l) {
        return l == null || l < 1L ? null : l;
    }

    public static String convertNullToZero(Long l) {
        return l == null ? ZERO : String.valueOf(l);
    }

    public static void validateRequired(WorkflowMessage message, String ... paramNames) {
        if (paramNames != null) {
            for (String paramName : paramNames) {
                if (Util.getStringValueTrimmed(message, paramName) != null) continue;
                throw new RuntimeException("Parameter " + paramName + " is not found or does not have value");
            }
        }
    }

    public static String getCommaSeparatedList(Collection<?> collection) {
        StringBuffer sb = new StringBuffer();
        if (collection != null) {
            boolean firstTime = true;
            for (Object object : collection) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(", ");
                }
                sb.append(object.toString());
            }
        }
        return sb.toString();
    }
}

