/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CreateScheduleMessageHandler
implements MessageHandler {
    private static final String CONTEXT_ID_PARAM = "contextId";
    private static final String PITCH_DATE_PARAM = "pitchDate";
    private static final String SOURCE_PARTNER_ID_PARAM = "sourcePartnerId";
    private static final String SCHEDULE_ID_PARAM = "scheduleId";
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        ServiceRegistry registry;
        IScheduleSearchService search;
        long contextId = this.getLongParameter(message, CONTEXT_ID_PARAM, false);
        Date pitchDate = this.getDateParameter(message, PITCH_DATE_PARAM);
        Long sourcePartnerId = this.getLongParameter(message, SOURCE_PARTNER_ID_PARAM, true);
        if (sourcePartnerId != null && sourcePartnerId <= 0L) {
            sourcePartnerId = null;
        }
        if ((search = (IScheduleSearchService)(registry = ServiceRegistry.getDefault()).lookup(IScheduleSearchService.class)).getPitchSchedulesByPitchDate(Long.valueOf(contextId), pitchDate).size() > 0) {
            throw new MessageHandlerException("ERR-001", "Pitch schedule already exists for the specified date");
        }
        DistributionSchedule schedule = new DistributionSchedule(sourcePartnerId, Long.valueOf(contextId), pitchDate);
        ISchedulePersistenceService service = (ISchedulePersistenceService)registry.lookup(ISchedulePersistenceService.class);
        service.save((IAssetList)schedule);
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(SCHEDULE_ID_PARAM, Long.toString(schedule.getId()));
        return response;
    }

    private Long getLongParameter(WorkflowMessage message, String name, boolean optional) throws MessageHandlerException {
        String value;
        Long result = null;
        String string = value = message.getPayload() != null ? message.getValue(name) : null;
        if (value == null || value.trim().length() == 0) {
            if (optional) {
                return result;
            }
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter is blank / missing when a number value was expected.");
        }
        try {
            result = new Long(value);
        }
        catch (Exception e) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter does not have a valid number value, received value: " + value, e);
        }
        return result;
    }

    private Date getDateParameter(WorkflowMessage message, String name) throws MessageHandlerException {
        String value;
        Date result = null;
        String string = value = message.getPayload() != null ? message.getValue(name) : null;
        if (value == null || value.trim().length() == 0) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter is blank / missing when a date value was expected.");
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            result = format.parse(value);
        }
        catch (Exception e) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter does not have a valid date value. Expected format: " + DATE_FORMAT + ", received value: " + value, e);
        }
        return result;
    }
}

