/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class GetScheduleIdMessageHandler
implements MessageHandler {
    private static final String IS_PLANNER = "isPlanner";
    private static final String TITLE_ID = "titleId";
    private static final String SCHEDULE_ID = "scheduleId";
    private static final String CONTEXT_ID = "contextId";
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    private static final Logger logger = Logger.getLogger(GetScheduleIdMessageHandler.class);

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Entity e;
        Util.validateRequired(message, CONTEXT_ID, TITLE_ID, IS_PLANNER);
        boolean isPlanner = Util.getBooleanValue(message, IS_PLANNER);
        long titleId = Util.getLongValue(message, TITLE_ID);
        long contextId = Util.getLongValue(message, CONTEXT_ID);
        if (titleId < 1L) {
            throw new IllegalArgumentException("titleId has to be greater than zero");
        }
        if (contextId < 1L) {
            throw new IllegalArgumentException("contextId has to be greater than zero");
        }
        SearchCriteria criteria = new SearchCriteria();
        if (isPlanner) {
            e = new Entity("planner", Planner.class, "p");
            long partnerId = this.determinePartnerId(contextId);
            e.addParameter((SearchParameterBase)new ValueParameter("sourcePartnerID", SearchType.NUMERIC, (Object)partnerId));
            e.addParameter(this.getFutureDateRangeCriterion());
            e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.ASCENDING));
        } else {
            e = new Entity("pitch", DistributionSchedule.class, "d");
            e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
            e.addParameter(this.getPastDateRangeCriterion());
            e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.DESCENDING));
        }
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        criteria.addParameter((SearchParameterBase)e);
        IScheduleSearchService service = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Collection schedules = service.search(criteria);
        logger.debug((Object)("Found " + schedules.size() + " schedules."));
        String scheduleId = "";
        for (Schedule schedule : schedules) {
            Collection titles = schedule.getTitles();
            for (Title title : titles) {
                if (title.getId() != titleId) continue;
                scheduleId = Long.toString(schedule.getId());
                logger.debug((Object)("Found scheduleId=" + scheduleId));
                break;
            }
            if (scheduleId.equals("")) continue;
            break;
        }
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        response.putValue(SCHEDULE_ID, scheduleId);
        return response;
    }

    private long determinePartnerId(long contextId) throws MessageHandlerException {
        Partner partner;
        Partner result = null;
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)Long.valueOf(contextId));
        if (container != null && container.getContainerType() == ContainerType.PARTNER && (partner = (Partner)container).getType() == PartnerType.SOURCE) {
            result = partner;
            logger.debug((Object)("Found sourcePartnerId=" + result.getId()));
            return result.getId();
        }
        throw new MessageHandlerException("ERR-001", "Failed to find a valid source partner for context id: " + contextId);
    }

    private SearchParameterBase getPastDateRangeCriterion() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE);
        range.setTo(formatter.format(new Date()));
        return range;
    }

    private SearchParameterBase getFutureDateRangeCriterion() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, formatter.format(new Date()));
        return range;
    }
}

