/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandler;
import com.tandbergtv.watchpoint.pmm.communication.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.schedule.ISchedulePersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import java.io.Serializable;

public class GetScheduleStatusMessageHandler
implements MessageHandler {
    private static final String SCHEDULE_ID_PARAM = "scheduleId";
    private static final String SCHEDULE_STATUS_PARAM = "status";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws MessageHandlerException {
        Long scheduleId = null;
        try {
            scheduleId = Util.getLongValue(message, SCHEDULE_ID_PARAM);
        }
        catch (Exception e) {
            String value;
            WorkflowPayload payload = message.getPayload();
            String string = value = payload != null ? payload.getValue(SCHEDULE_ID_PARAM) : null;
            if (value == null) {
                value = "";
            }
            String msg = "The Schedule Id is not a valid number, received value: " + value;
            throw new MessageHandlerException("ERR-002", msg, e);
        }
        if (scheduleId == null) {
            String msg = "The Title Id is missing or blank.";
            throw new MessageHandlerException("ERR-002", msg);
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISchedulePersistenceService service = (ISchedulePersistenceService)registry.lookup(ISchedulePersistenceService.class);
        Schedule schedule = null;
        try {
            schedule = (Schedule)service.get((Serializable)scheduleId);
        }
        catch (Exception e) {
            String msg = "Failed to read the Schedule from the persistence service, error: " + e.getMessage();
            throw new MessageHandlerException("ERR-003", msg, e);
        }
        if (schedule == null) {
            String msg = "Did not find a Schedule with id=" + scheduleId + " from the persistence service.";
            throw new MessageHandlerException("ERR-003", msg);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        ScheduleStatus status = schedule.getStatus();
        String statusValue = status != null ? status.toString() : "";
        response.putValue(SCHEDULE_STATUS_PARAM, statusValue);
        return response;
    }
}

