/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.watchpoint.contentmgmt.communication.CMMessageService;
import com.tandbergtv.watchpoint.pmm.communication.PMMMessageService;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.IPMMService;
import com.tandbergtv.watchpoint.pmm.core.IPMMUIService;
import com.tandbergtv.watchpoint.pmm.core.PMMService;
import com.tandbergtv.watchpoint.pmm.core.PMMUIService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import org.apache.log4j.Logger;

public class PMMActivator {
    private static final Logger logger = Logger.getLogger(PMMActivator.class);

    public void start() {
        AssetsManager.init();
        this.addService((Service)new PMMService());
        this.addService((Service)new PMMUIService());
        this.addService(new PMMMessageService());
        this.addService(new CMMessageService());
        logger.debug((Object)"PMM and CM services started");
    }

    public void stop() {
        this.removeService(CMMessageService.class);
        this.removeService(PMMMessageService.class);
        this.removeService(IPMMUIService.class);
        this.removeService(IPMMService.class);
        logger.debug((Object)"PMM services stopped");
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

