/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.referenceEvaluator;

import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.GeneralReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ParameterReferencePath;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.PartnerReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ScheduleReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.ServiceReferenceEvaluator;
import com.tandbergtv.watchpoint.pmm.job.referenceEvaluator.TitleReferenceEvaluator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReferenceEvaluatorChain {
    private Logger logger = Logger.getLogger(PartnerReferenceEvaluator.class);
    public static ReferenceEvaluatorChain instance;
    private ReferenceEvaluator chainRoot;

    private ReferenceEvaluatorChain() {
        this.buildEvaluatorChain();
    }

    public static synchronized ReferenceEvaluatorChain getInstance() {
        if (instance == null) {
            instance = new ReferenceEvaluatorChain();
        }
        return instance;
    }

    public ReferenceEvaluator getChainRoot() {
        return this.chainRoot;
    }

    public void setChainRoot(ReferenceEvaluator chainRoot) {
        this.chainRoot = chainRoot;
    }

    private void buildEvaluatorChain() {
        PartnerReferenceEvaluator partnerEvaluator = new PartnerReferenceEvaluator();
        TitleReferenceEvaluator titleEvaluator = new TitleReferenceEvaluator();
        partnerEvaluator.setSuccessor(titleEvaluator);
        ScheduleReferenceEvaluator scheduleEvaluator = new ScheduleReferenceEvaluator();
        titleEvaluator.setSuccessor(scheduleEvaluator);
        ServiceReferenceEvaluator serviceEvaluator = new ServiceReferenceEvaluator();
        scheduleEvaluator.setSuccessor(serviceEvaluator);
        GeneralReferenceEvaluator generalEvaluator = new GeneralReferenceEvaluator();
        serviceEvaluator.setSuccessor(generalEvaluator);
        this.setChainRoot(partnerEvaluator);
    }

    public ParameterReferencePath getPath(String property) {
        return this.chainRoot.getPath(property);
    }

    public void evaluate(Object entity, Map<String, Object> info) {
        try {
            this.chainRoot.evaluate(entity, info);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Error while evaluating parameter reference.", (Throwable)e);
        }
        this.logger.debug((Object)"Done evaluating parameter references");
    }
}

