/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.messageidentifier;

import com.tandbergtv.workflow.adaptor.AdaptorRuntimeException;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.util.WPCLValidationException;
import com.tandbergtv.workflow.message.util.WPCLValidator;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WPCLMessageIdentifier
implements IMessageIdentifier {
    private static Logger logger = Logger.getLogger(WPCLMessageIdentifier.class);
    private static final String UIDXpathExpression = "//WFSMessage/@UID";

    @Override
    public IMessageUID identify(IMessage message) {
        IMessageUID uid = null;
        try {
            logger.debug((Object)("Attempting to identify message: " + message.getPayload()));
            String payload = message.getPayload().getContent();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(payload)));
            WPCLValidator.newInstance().validate(doc);
            uid = this.getUIDFromWPCL(doc);
        }
        catch (WPCLValidationException e) {
            throw new AdaptorRuntimeException("Message is not in WPCL format", e);
        }
        catch (Exception e) {
            throw new AdaptorRuntimeException(e);
        }
        return uid;
    }

    private IMessageUID getUIDFromWPCL(Document doc) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xPath.evaluate(UIDXpathExpression, doc, XPathConstants.NODE);
        String uid = node.getTextContent();
        logger.debug((Object)("Message identified having uid:" + uid));
        return new MessageUIDImpl(uid);
    }
}

