/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.management.CacheStatisticsMBean;

public class CacheStatistics
implements CacheStatisticsMBean {
    private static final long serialVersionUID = 8085302752781762030L;
    private Ehcache ehcache;
    private Statistics statistics;
    private ObjectName objectName;
    private long lastUpdated;

    public CacheStatistics(Ehcache ehcache) {
        this.ehcache = ehcache;
        this.objectName = CacheStatistics.createObjectName(ehcache.getCacheManager().getName(), ehcache.getName());
    }

    static ObjectName createObjectName(String cacheManagerName, String cacheName) {
        ObjectName objectName;
        try {
            objectName = new ObjectName("net.sf.ehcache:type=CacheStatistics,CacheManager=" + cacheManagerName + ",name=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException(e);
        }
        return objectName;
    }

    public int getStatisticsAccuracy() {
        this.updateIfNeeded();
        return this.statistics.getStatisticsAccuracy();
    }

    private void updateIfNeeded() {
        if (System.currentTimeMillis() != this.lastUpdated) {
            this.statistics = this.ehcache.getStatistics();
            this.lastUpdated = System.currentTimeMillis();
        }
    }

    public String getStatisticsAccuracyDescription() {
        this.updateIfNeeded();
        return this.statistics.getStatisticsAccuracyDescription();
    }

    public String getAssociatedCacheName() {
        return this.statistics.getAssociatedCacheName();
    }

    public void clearStatistics() {
        this.statistics.clearStatistics();
    }

    public long getCacheHits() {
        this.updateIfNeeded();
        return this.statistics.getCacheHits();
    }

    public long getInMemoryHits() {
        this.updateIfNeeded();
        return this.statistics.getInMemoryHits();
    }

    public long getOnDiskHits() {
        this.updateIfNeeded();
        return this.statistics.getOnDiskHits();
    }

    public long getCacheMisses() {
        this.updateIfNeeded();
        return this.statistics.getCacheMisses();
    }

    public long getObjectCount() {
        this.updateIfNeeded();
        return this.statistics.getObjectCount();
    }

    ObjectName getObjectName() {
        return this.objectName;
    }
}

