/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ResourceManager {
    private static final Object FAKE_BUNDLE = new Object();
    private static final Map<String, Object> bundles = Collections.synchronizedMap(new HashMap());

    public static String getMessage(String string, String string2) {
        return ResourceManager.getMessage(string, string2, Locale.getDefault(), null);
    }

    public static String getMessage(String string, String string2, Object object) {
        return ResourceManager.getMessage(string, string2, Locale.getDefault(), object);
    }

    public static String getMessage(String string, String string2, Locale locale) {
        return ResourceManager.getMessage(string, string2, locale, null);
    }

    public static String getMessage(String string, String string2, Locale locale, Object object) {
        Object object2 = bundles.get(string + '|' + locale);
        if (object2 == null) {
            try {
                object2 = ResourceBundle.getBundle(string + ".Resources", locale);
            }
            catch (MissingResourceException missingResourceException) {
                object2 = FAKE_BUNDLE;
            }
            bundles.put(string + '|' + locale, object2);
        }
        if (object2 == FAKE_BUNDLE) {
            return "resource " + string + '.' + string2 + " not found for locale " + locale;
        }
        try {
            String string3 = ((ResourceBundle)object2).getString(string2);
            return object == null ? string3 : ResourceManager.processParams(string3, object);
        }
        catch (MissingResourceException missingResourceException) {
            return "resource " + string + '.' + string2 + " not found for locale " + locale;
        }
    }

    private static String processParams(String string, Object object) {
        String string2 = string;
        if (object != null && object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = ResourceManager.replaceAll(string2, "{" + i + "}", "" + objectArray[i]);
            }
        } else if (object instanceof Collection) {
            int n = 0;
            for (Object e : (Collection)object) {
                string2 = ResourceManager.replaceAll(string2, "{" + n++ + "}", "" + e);
            }
        } else {
            string2 = ResourceManager.replaceAll(string2, "{0}", "" + object);
        }
        return string2;
    }

    private static String replaceAll(String string, String string2, String string3) {
        String string4 = string;
        int n = 0;
        while ((n = string4.indexOf(string2, n)) != -1) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + string2.length());
            n += string3.length();
        }
        return string4;
    }

    private ResourceManager() {
    }
}

