package com.tandbergtv.cms.portal.ui.widget.client;

import java.util.List;

public interface IDataProvider {
	void registerView(View view);
	//will reset current page number to 1 if page size is different from current
	void setPageSize(int pageSize);
	int getPageSize();
	void gotoPage(int pageNum) throws PageUnavailableException;
	int getCurrentPageNumber();
	List<Row<ColumnData>> getCurrentPage();
	void gotoPrevPage();
	void gotoNextPage();
	void gotoFirstPage();
	void gotoLastPage();
	boolean hasPrevPage();
	boolean hasNextPage();
	int getNumPages();
	boolean hasPage(int pageNum);
	//sorts ascending; reverses sort if it is already in asc
	void sort(String colName);
	Row<ColumnHeader> getHeader();
	String getSortColumn();
	SortOrder getSortOrder();
	int getTotalCount();
	void delete(List<String> rowIds);
}
