/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.actions.job;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.EntityType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.entities.JobParameter;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.Rule;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.job.conf.RuleTypeInfoLoader;
import com.tandbergtv.watchpoint.pmm.job.ui.JobUIConstants;
import com.tandbergtv.watchpoint.pmm.job.util.RuleCallbackClassFinder;
import com.tandbergtv.watchpoint.pmm.util.ContextManager;
import com.tandbergtv.watchpoint.pmm.util.IContextManager;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobParameterForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.RuleParameterForm;
import com.tandbergtv.watchpoint.pmm.web.util.JobFormPopulator;
import com.tandbergtv.watchpoint.pmm.web.validators.JobValidator;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class JobManagementAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(JobManagementAction.class);
    private static String CREATEJOB = "createJob";
    private static String POST_CREATE_UPDATE = "postCreateUpdate";
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    private static String PARAMETER_NAME_DELIMETER = ",";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static int INVALID_INDEX = -1;
    private static String SPACE = " ";
    private static String DEFAULT_TIME = "12:00 am";

    public ActionForward showJobPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobForm jobform = (JobForm)form;
        long contextId = jobform.getContextId();
        this.logger.debug((Object)("ContextId: " + contextId));
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)Long.valueOf(contextId));
        jobform.setEntityName(container.getContainerName());
        ContainerType containerType = container.getContainerType();
        if (containerType == ContainerType.PARTNER) {
            PartnerType partnerType = ((Partner)container).getType();
            if (partnerType == PartnerType.SELF) {
                jobform.setEntityType(partnerType.toString());
            } else {
                jobform.setEntityType(container.getContainerType().toString());
            }
        } else {
            jobform.setEntityType(container.getContainerType().toString());
        }
        jobform.setIsAssociatedWithTitles("true");
        JobFormPopulator.setRequiredInfoInForm(jobform);
        this.setSelectedRuleTypeToDefault(jobform);
        return mapping.findForward(CREATEJOB);
    }

    public ActionForward getTemplateParameters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobForm jobform = (JobForm)form;
        String templateName = jobform.getSelectedTemplate();
        Collection<TaskVariable> variables = JobFormPopulator.getTemplateParameters(templateName);
        this.setJobParamNames(variables, jobform);
        List<JobParameterForm> jobParameters = JobFormPopulator.prepareJobParameterForm(variables, null);
        jobform.setParams(jobParameters);
        jobform.setValue(null);
        JobFormPopulator.setRequiredInfoInForm(jobform);
        return mapping.findForward(CREATEJOB);
    }

    public ActionForward getScheduleRulesAndMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobForm jobform = (JobForm)form;
        jobform.setRuleParamValue(null);
        jobform.setValue(null);
        jobform.setJobStartDate("");
        jobform.setJobEndDate("");
        JobFormPopulator.setRequiredInfoInForm(jobform);
        this.setSelectedRuleTypeToDefault(jobform);
        return mapping.findForward(CREATEJOB);
    }

    public ActionForward getJob(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobForm jobform = (JobForm)form;
        IJobManager jobMgr = JobManager.getInstance();
        Job job = jobMgr.getJob(jobform.getId());
        jobform.setId(job.getId());
        jobform.setContextId(job.getContext().getId());
        ContainerType type = job.getContext().getContainerType();
        if (type == ContainerType.PARTNER) {
            PartnerType pType = ((Partner)job.getContext().getContainer()).getType();
            if (pType == PartnerType.SELF) {
                jobform.setEntityType(PartnerType.SELF.toString());
            } else {
                jobform.setEntityType(job.getContext().getContainerType().toString());
            }
        } else {
            jobform.setEntityType(job.getContext().getContainerType().toString());
        }
        jobform.setEntityName(job.getContext().getContainer().getContainerName());
        jobform.setName(job.getName());
        jobform.setIsAssociatedWithTitles(Boolean.toString(job.getRule().getType().getTitlesAssociated()));
        String jobRuleTypeName = job.getRule().getType().getName();
        if (JobValidator.startDateAllowed(jobRuleTypeName)) {
            String[] start = job.getRule().getStartDate().toString().split(SPACE);
            jobform.setJobStartDate(start[0]);
            if (JobValidator.isDateInPast(start[0], DATE_FORMAT)) {
                Calendar cal = Calendar.getInstance();
                Date today = cal.getTime();
                SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT);
                String todayStr = fmt.format(today);
                jobform.setJobStartDate(todayStr);
            }
        }
        if (JobValidator.endDateAllowed(jobRuleTypeName) && job.getRule().getEndDate() != null) {
            String[] end = job.getRule().getEndDate().toString().split(SPACE);
            jobform.setJobEndDate(end[0]);
        }
        jobform.setSelectedPriority(job.getPriority().toString());
        jobform.setSelectedTemplate(job.getTemplateName());
        this.setJobParameterValueInfo(job, jobform);
        JobFormPopulator.setRequiredInfoInForm(jobform);
        jobform.setSelectedRuleType(job.getRule().getType().getName());
        this.setJobRuleValueInfo(job, jobform);
        return mapping.findForward(CREATEJOB);
    }

    public ActionForward createJob(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobForm jobform = (JobForm)form;
        IJobManager jobMgr = JobManager.getInstance();
        IContextManager ctxMgr = ContextManager.getInstance();
        Job job = new Job();
        job.setName(jobform.getName());
        job.setContext(ctxMgr.getContext(jobform.getContextId()));
        job.setPriority(ProcessPriority.valueOf((String)jobform.getSelectedPriority()));
        job.setTemplateName(jobform.getSelectedTemplate());
        job.setJobParams(this.createJobParameters(job, jobform.getJobParamNames(), jobform.getValue()));
        job.setRule(this.createRule(jobform));
        if (jobMgr.createJob(job)) {
            jobform.setId(job.getId());
            request.setAttribute(JobUIConstants.JOB_CREATION_SUCCESSFUL, (Object)JobUIConstants.JOB_CREATION_SUCCESSFUL);
        } else {
            request.setAttribute(JobUIConstants.JOB_CREATION_FAILED, (Object)JobUIConstants.JOB_CREATION_FAILED);
        }
        if (jobform.getEntityType().equalsIgnoreCase(EntityType.PARTNER.toString())) {
            request.setAttribute("TabbedPMMPartnersModify", (Object)"TabbedPMMPartnersModify");
        } else if (jobform.getEntityType().equalsIgnoreCase(EntityType.SERVICE.toString())) {
            request.setAttribute("TabbedPMMServicesModify", (Object)"TabbedPMMServicesModify");
        }
        return mapping.findForward(POST_CREATE_UPDATE);
    }

    public ActionForward updateJob(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobForm jobform = (JobForm)form;
        IJobManager jobMgr = JobManager.getInstance();
        Job job = jobMgr.getJob(jobform.getId());
        job.setName(jobform.getName());
        job.setPriority(ProcessPriority.valueOf((String)jobform.getSelectedPriority()));
        this.updateJobParameters(job, jobform.getJobParamNames(), jobform.getValue());
        this.updateJobRule(job, jobform);
        if (jobMgr.updateJob(job)) {
            request.setAttribute(JobUIConstants.JOB_UPDATE_SUCCESSFUL, (Object)JobUIConstants.JOB_UPDATE_SUCCESSFUL);
        } else {
            request.setAttribute(JobUIConstants.JOB_UPDATE_FAILED, (Object)JobUIConstants.JOB_UPDATE_FAILED);
        }
        if (jobform.getEntityType().equalsIgnoreCase(EntityType.PARTNER.toString())) {
            request.setAttribute("TabbedPMMPartnersModify", (Object)"TabbedPMMPartnersModify");
        } else if (jobform.getEntityType().equalsIgnoreCase(EntityType.SERVICE.toString())) {
            request.setAttribute("TabbedPMMServicesModify", (Object)"TabbedPMMServicesModify");
        }
        return mapping.findForward(POST_CREATE_UPDATE);
    }

    private void updateJobRule(Job job, JobForm jobform) {
        ICacheService containerCache;
        Partner container;
        PartnerType partnerType;
        List ruleParamList = job.getRule().getParams();
        if (jobform.getSelectedRuleType().equalsIgnoreCase(job.getRule().getType().getName())) {
            List ruleTypeParamList = job.getRule().getType().getParams();
            String[] ruleParamValues = JobFormPopulator.getRuleParamsForSelectedRule(jobform);
            for (int i = 0; i < ruleTypeParamList.size(); ++i) {
                if (!((RuleTypeParameter)ruleTypeParamList.get(i)).getIsRequired() && ruleParamValues[i] == null || ruleParamValues[i].trim().length() == 0) {
                    if (((RuleTypeParameter)ruleTypeParamList.get(i)).getType() == RuleParameterDataType.DATE) {
                        ((RuleParameter)ruleParamList.get(i)).setValue(new Date().toString());
                        continue;
                    }
                    if (((RuleTypeParameter)ruleTypeParamList.get(i)).getType() == RuleParameterDataType.TIME) {
                        ((RuleParameter)ruleParamList.get(i)).setValue(DEFAULT_TIME);
                        continue;
                    }
                    ((RuleParameter)ruleParamList.get(i)).setValue(ruleParamValues[i]);
                    continue;
                }
                ((RuleParameter)ruleParamList.get(i)).setValue(ruleParamValues[i]);
            }
        } else {
            IJobManager jobMgr = JobManager.getInstance();
            RuleType ruleType = jobMgr.getRuleType(jobform.getSelectedRuleType());
            job.getRule().setType(ruleType);
            List ruleTypeParamList = ruleType.getParams();
            String[] ruleParamValues = JobFormPopulator.getRuleParamsForSelectedRule(jobform);
            if (ruleParamList.size() != ruleTypeParamList.size()) {
                int i;
                if (ruleParamList.size() < ruleTypeParamList.size()) {
                    int additionalParamCount = ruleTypeParamList.size() - ruleParamList.size();
                    for (i = 0; i < additionalParamCount; ++i) {
                        RuleParameter parameter = new RuleParameter();
                        parameter.setOrder(ruleParamList.size() + 1);
                        ruleParamList.add(parameter);
                    }
                } else if (ruleParamList.size() > ruleTypeParamList.size()) {
                    int extraParameterCount = ruleParamList.size() - ruleTypeParamList.size();
                    for (i = 0; i < extraParameterCount; ++i) {
                        ruleParamList.remove(ruleParamList.get(ruleParamList.size() - 1));
                    }
                }
            }
            for (int i = 0; i < ruleParamList.size(); ++i) {
                ((RuleParameter)ruleParamList.get(i)).setRule(job.getRule());
                ((RuleParameter)ruleParamList.get(i)).setValue(ruleParamValues[i]);
            }
        }
        RuleTypeInfoLoader infoLoader = RuleTypeInfoLoader.getInstance();
        String timeClass = infoLoader.getTimerClass(jobform.getSelectedRuleType());
        job.getRule().setTimeClass(timeClass);
        RuleCallbackClassFinder callbackFinder = new RuleCallbackClassFinder();
        EntityType type = EntityType.valueOf((String)jobform.getEntityType());
        if (type == EntityType.PARTNER && (partnerType = (container = (Partner)(containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME)).get((Serializable)Long.valueOf(job.getContext().getId()))).getType()) == PartnerType.SELF) {
            type = EntityType.SELF;
        }
        String callbackClass = callbackFinder.getCallbackClass(Boolean.valueOf(jobform.getIsAssociatedWithTitles()).booleanValue(), type, ruleParamList, job.getRule().getType().getParams());
        job.getRule().setCallbackClass(callbackClass);
        job.getRule().setStartDate(this.getStartDate(jobform));
        job.getRule().setEndDate(this.getEndDate(jobform));
    }

    private void updateJobParameters(Job job, String jobParamNames, String[] value) {
        int i;
        JobParameter parameter;
        String[] namesList = jobParamNames.split(PARAMETER_NAME_DELIMETER);
        List jobParams = job.getJobParams();
        for (int i2 = 0; i2 < namesList.length; ++i2) {
            int index = this.getParameterIndex(namesList[i2], jobParams);
            if (index != INVALID_INDEX) {
                ((JobParameter)jobParams.get(index)).setValue(value[i2]);
                continue;
            }
            parameter = new JobParameter();
            parameter.setJob(job);
            parameter.setName(namesList[i2]);
            parameter.setValue(value[i2]);
            jobParams.add(parameter);
        }
        ArrayList<Integer> paramsToRemoveIndex = new ArrayList<Integer>();
        for (i = 0; i < jobParams.size(); ++i) {
            parameter = (JobParameter)jobParams.get(i);
            int index = JobManagementAction.getVariableIndex(parameter.getName(), namesList);
            if (index != INVALID_INDEX) continue;
            paramsToRemoveIndex.add(i);
        }
        for (i = 0; i < paramsToRemoveIndex.size(); ++i) {
            jobParams.remove((Integer)paramsToRemoveIndex.get(i));
        }
    }

    private void setJobRuleValueInfo(Job job, JobForm jobform) {
        jobform.setRuleId(job.getRule().getId());
        List<RuleParameterForm> forms = jobform.getRuleParameters().get(jobform.getSelectedRuleType());
        for (int i = 0; i < forms.size(); ++i) {
            forms.get(i).setRuleParamValue(((RuleParameter)job.getRule().getParams().get(i)).getValue());
        }
    }

    private void setJobParameterValueInfo(Job job, JobForm jobform) {
        Collection<TaskVariable> variables = JobFormPopulator.getTemplateParameters(job.getTemplateName());
        TaskVariable[] variableList = new TaskVariable[variables.size()];
        StringBuilder parameterNames = new StringBuilder();
        String[] parameterValues = new String[variables.size()];
        variableList = variables.toArray(variableList);
        for (int i = 0; i < variableList.length; ++i) {
            if (parameterNames.length() > 0) {
                parameterNames.append(PARAMETER_NAME_DELIMETER);
            }
            parameterNames.append(variableList[i].getMappedName());
            int index = this.getParameterIndex(variableList[i].getMappedName(), job.getJobParams());
            if (index == INVALID_INDEX) continue;
            parameterValues[i] = ((JobParameter)job.getJobParams().get(index)).getValue();
        }
        jobform.setJobParamNames(parameterNames.toString());
        jobform.setValue(parameterValues);
    }

    private int getParameterIndex(String parameterName, List<JobParameter> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getName().equalsIgnoreCase(parameterName)) continue;
            return i;
        }
        return INVALID_INDEX;
    }

    private static int getVariableIndex(String variableName, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equalsIgnoreCase(variableName)) continue;
            return i;
        }
        return INVALID_INDEX;
    }

    private Rule createRule(JobForm jobform) {
        IJobManager jobMgr = JobManager.getInstance();
        Rule jobRule = new Rule();
        jobRule.setId(jobform.getRuleId());
        RuleType ruleType = jobMgr.getRuleType(jobform.getSelectedRuleType());
        jobRule.setType(ruleType);
        String[] selectedRuleParams = JobFormPopulator.getRuleParamsForSelectedRule(jobform);
        List<RuleParameter> ruleParameters = this.createRuleParameters(jobRule, selectedRuleParams);
        jobRule.setParams(ruleParameters);
        jobRule.setStartDate(this.getStartDate(jobform));
        jobRule.setEndDate(this.getEndDate(jobform));
        RuleTypeInfoLoader infoLoader = RuleTypeInfoLoader.getInstance();
        String timeClass = infoLoader.getTimerClass(jobform.getSelectedRuleType());
        jobRule.setTimeClass(timeClass);
        RuleCallbackClassFinder callbackFinder = new RuleCallbackClassFinder();
        String callbackClass = callbackFinder.getCallbackClass(Boolean.valueOf(jobform.getIsAssociatedWithTitles()).booleanValue(), EntityType.valueOf((String)jobform.getEntityType()), ruleParameters, ruleType.getParams());
        jobRule.setCallbackClass(callbackClass);
        return jobRule;
    }

    private Date getEndDate(JobForm jobform) {
        SimpleDateFormat timefomat = new SimpleDateFormat(DATE_FORMAT);
        timefomat.setLenient(false);
        Date endDate = null;
        if (jobform.getJobEndDate() != null && jobform.getJobEndDate().trim().length() > 0) {
            try {
                endDate = timefomat.parse(jobform.getJobEndDate());
            }
            catch (ParseException e) {
                this.logger.error((Object)("Error while parsing end date: " + e.toString()));
            }
        }
        return endDate;
    }

    private Date getStartDate(JobForm jobform) {
        SimpleDateFormat timefomat = new SimpleDateFormat(DATE_FORMAT);
        timefomat.setLenient(false);
        Date startDate = new Date();
        if (jobform.getJobStartDate() != null && jobform.getJobStartDate().trim().length() > 0) {
            try {
                startDate = timefomat.parse(jobform.getJobStartDate());
            }
            catch (ParseException e) {
                this.logger.error((Object)("Error while parsing start date: " + e.toString()));
            }
        }
        return startDate;
    }

    private List<JobParameter> createJobParameters(Job parent, String names, String[] values) {
        ArrayList<JobParameter> jobParameters = new ArrayList<JobParameter>();
        String[] parameterNames = names.split(PARAMETER_NAME_DELIMETER);
        for (int i = 0; i < parameterNames.length; ++i) {
            JobParameter parameter = new JobParameter();
            parameter.setJob(parent);
            parameter.setName(parameterNames[i]);
            parameter.setValue(values[i]);
            jobParameters.add(parameter);
        }
        return jobParameters;
    }

    private List<RuleParameter> createRuleParameters(Rule rule, String[] ruleParamValue) {
        ArrayList<RuleParameter> ruleParameters = new ArrayList<RuleParameter>();
        for (int i = 0; i < rule.getType().getParams().size(); ++i) {
            RuleTypeParameter currRuletypeParameter = (RuleTypeParameter)rule.getType().getParams().get(i);
            RuleParameter parameter = new RuleParameter();
            if (!currRuletypeParameter.getIsRequired() && ruleParamValue[i] == null || ruleParamValue[i].trim().length() == 0) {
                if (currRuletypeParameter.getType() == RuleParameterDataType.DATE) {
                    parameter.setValue(new Date().toString());
                } else if (currRuletypeParameter.getType() == RuleParameterDataType.TIME) {
                    parameter.setValue(DEFAULT_TIME);
                } else {
                    parameter.setValue(ruleParamValue[i]);
                }
            } else {
                parameter.setValue(ruleParamValue[i]);
            }
            parameter.setRule(rule);
            parameter.setOrder(i + 1);
            ruleParameters.add(parameter);
        }
        return ruleParameters;
    }

    private void setJobParamNames(Collection<TaskVariable> variables, JobForm jobform) {
        TaskVariable[] taskVariables = new TaskVariable[variables.size()];
        taskVariables = variables.toArray(taskVariables);
        StringBuilder parameterNames = new StringBuilder();
        for (int i = 0; i < taskVariables.length; ++i) {
            if (parameterNames.length() > 0) {
                parameterNames.append(PARAMETER_NAME_DELIMETER);
            }
            parameterNames.append(taskVariables[i].getMappedName());
        }
        jobform.setJobParamNames(parameterNames.toString());
    }

    private void setSelectedRuleTypeToDefault(JobForm jobform) {
        IJobManager jobMgr = JobManager.getInstance();
        List rules = jobMgr.getRuleTypes(Boolean.valueOf(jobform.getIsAssociatedWithTitles()).booleanValue());
        this.logger.debug((Object)("setting selectedRuleType to " + ((RuleType)rules.get(0)).getName()));
        jobform.setSelectedRuleType(((RuleType)rules.get(0)).getName());
    }
}

