/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.web.actions.service;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Service;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.JobManager;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.PartnerManager;
import com.tandbergtv.watchpoint.pmm.service.IServiceManagement;
import com.tandbergtv.watchpoint.pmm.service.ServiceManager;
import com.tandbergtv.watchpoint.pmm.util.ContextManager;
import com.tandbergtv.watchpoint.pmm.util.IContextManager;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.job.JobListForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.service.ServiceForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.service.ServiceListForm;
import com.tandbergtv.watchpoint.pmm.web.formbeans.service.ServicePartnersListForm;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleForm;
import com.tandbergtv.watchpoint.pmm.web.schedule.ScheduleListForm;
import com.tandbergtv.watchpoint.pmm.web.util.CommonUtils;
import com.tandbergtv.watchpoint.pmm.web.util.GUISearchHelper;
import com.tandbergtv.watchpoint.pmm.web.util.HTMLOption;
import com.tandbergtv.watchpoint.pmm.web.util.PMMTableConfigHelper;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import com.tandbergtv.workflow.web.util.ExportUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;

public class ServiceDispatchAction
extends DispatchAction {
    private static final String SERVICES = "services";
    private static final Logger logger = Logger.getLogger(ServiceDispatchAction.class);
    private static final String FORWARD_POST_CREATE_SERVICE = "postCreateService";
    private static final String FORWARD_SERVICE_DETAILS = "serviceDetails";
    private static final String JOBS = "jobs";
    private static final String SCHEDULES = "schedules";
    private static String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    private static final String DISPLAY_MESSAGE = "service.update.messages";
    private static final String DISPLAY_ERRORS = "service.update.errors";
    private static final String PMM_MESSAGE_RESOURCES_FILE_NAME = "WorkFlowMessageResources";
    private IServiceManagement serviceManager = ServiceManager.getInstance();

    public ActionForward getServicesView(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean exportFlag = false;
        exportFlag = request.getParameter("exportData") != null && request.getParameter("exportData").toString().equals("export");
        ServiceListForm serviceListForm = (ServiceListForm)actionForm;
        SearchCriteria searchCriteria = serviceListForm.getSearchCriteria();
        logger.debug((Object)("The Search Criteria--->" + searchCriteria));
        ArrayList<ServiceForm> services = new ArrayList<ServiceForm>();
        if (exportFlag) {
            searchCriteria.setStartingRecordNumber(0);
            searchCriteria.setRecordsCount(Integer.MAX_VALUE);
        }
        List lsServices = this.serviceManager.getServicesBySearchCriteria(searchCriteria);
        ServiceForm serviceForm = null;
        for (Service service : lsServices) {
            serviceForm = new ServiceForm();
            serviceForm = this.prepareServiceForm(service, serviceForm);
            services.add(serviceForm);
        }
        int iTotalRecords = this.serviceManager.getTotalActiveServiceCount();
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        serviceListForm.setTotalRecords(iTotalRecords);
        serviceListForm.setServiceList(services);
        if (exportFlag) {
            ExportUtility exportUtility = new ExportUtility();
            exportUtility.exportDataToExcel(request, response, (BaseForm)serviceListForm, services, PMMTableConfigHelper.getTableConfigFile(), PMM_MESSAGE_RESOURCES_FILE_NAME);
            return null;
        }
        ServiceListForm paginationAndSortingForm = serviceListForm;
        request.setAttribute("Search_Criteria", (Object)paginationAndSortingForm);
        return actionMapping.findForward(SERVICES);
    }

    private ServiceForm prepareServiceForm(Service service, ServiceForm serviceForm) {
        serviceForm.setId(String.valueOf(service.getId()));
        serviceForm.setName(service.getName());
        serviceForm.setDescription(service.getDescription());
        Set partners = service.getPartners();
        HashSet<Partner> sourcePartners = new HashSet<Partner>();
        HashSet<Partner> distributionPartners = new HashSet<Partner>();
        for (Partner partner : partners) {
            if (partner.getType() == PartnerType.DISTRIBUTION) {
                distributionPartners.add(partner);
                continue;
            }
            if (partner.getType() != PartnerType.SOURCE) continue;
            sourcePartners.add(partner);
        }
        serviceForm.setDistributionPartners(distributionPartners);
        serviceForm.setSourcePartners(sourcePartners);
        serviceForm.setPartners(service.getPartners());
        serviceForm.setContextId(service.getContext().getId());
        serviceForm.setLookupKey(service.getLookupKey());
        return serviceForm;
    }

    public ActionForward createServiceSetup(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return actionMapping.findForward("createService");
    }

    public ActionForward createService(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceForm serviceForm = (ServiceForm)actionForm;
        Service service = new Service();
        service = this.prepareService(serviceForm, service);
        service = this.serviceManager.createService(service);
        logger.debug((Object)("new service id=" + service.getId()));
        serviceForm.setId(String.valueOf(service.getId()));
        serviceForm.setContextId(service.getContainerContextId());
        request.setAttribute("serviceCreated", (Object)"serviceCreated");
        request.setAttribute("OUTPUT", (Object)serviceForm);
        return actionMapping.findForward(FORWARD_POST_CREATE_SERVICE);
    }

    private Service prepareService(ServiceForm serviceForm, Service service) throws Exception {
        service.setName(serviceForm.getName());
        service.setDescription(serviceForm.getDescription());
        service.setLookupKey(serviceForm.getLookupKey());
        IContextManager ctxMgr = ContextManager.getInstance();
        service.setContext(ctxMgr.getContext(serviceForm.getContextId()));
        return service;
    }

    public ActionForward getServiceDetails(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug((Object)"Starting---->");
        Long contextId = null;
        ServiceForm serviceForm = (ServiceForm)actionForm;
        contextId = serviceForm.getContextId();
        logger.debug((Object)("Service contextId------->" + contextId));
        Long serviceId = null;
        if (contextId != null && contextId != 0L) {
            ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
            IContainer container = (IContainer)containerCache.get((Serializable)contextId);
            serviceId = ((Service)container).getId();
        } else if (serviceForm.getId() != null) {
            serviceId = Long.valueOf(serviceForm.getId());
        }
        logger.debug((Object)("Service Id------->" + serviceId));
        Service service = this.serviceManager.getService(serviceId.longValue());
        serviceForm = this.prepareServiceForm(service, serviceForm);
        request.setAttribute("TabbedPMMServicesModify", (Object)"TabbedPMMServicesModify");
        request.setAttribute("OUTPUT", (Object)serviceForm);
        logger.debug((Object)"Ending---->");
        return actionMapping.findForward(FORWARD_SERVICE_DETAILS);
    }

    public ActionForward deleteServices(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceForm serviceForm = (ServiceForm)actionForm;
        String[] strServiceIds = serviceForm.getSelectedServices();
        ActionMessages messages = new ActionMessages();
        for (int i = 0; i < strServiceIds.length; ++i) {
            try {
                boolean isDeleted = this.serviceManager.deleteService(Long.parseLong(strServiceIds[i]));
                if (isDeleted) {
                    messages.add("infoMessages", new ActionMessage(DISPLAY_MESSAGE, (Object)("Service [" + strServiceIds[i] + "] deleted successfully.")));
                    continue;
                }
                messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)("Service [" + strServiceIds[i] + "] cannot be deleted.")));
                continue;
            }
            catch (Exception exception) {
                messages.add("errorMessages", new ActionMessage(DISPLAY_ERRORS, (Object)exception.getMessage()));
            }
        }
        this.saveErrors(request, messages);
        this.saveMessages(request, messages);
        return actionMapping.findForward(SERVICES);
    }

    public ActionForward updateService(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ServiceForm serviceForm = (ServiceForm)actionForm;
            Service service = this.serviceManager.getService(Long.parseLong(serviceForm.getId()));
            this.prepareService(serviceForm, service);
            service = this.serviceManager.updateService(service);
            serviceForm.setId(String.valueOf(service.getId()));
            request.setAttribute("serviceUpdated", (Object)"serviceUpdated");
            request.setAttribute("OUTPUT", (Object)serviceForm);
        }
        catch (Exception validationException) {
            // empty catch block
        }
        return actionMapping.findForward(FORWARD_POST_CREATE_SERVICE);
    }

    public ActionForward getPartnersForService(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServicePartnersListForm servicePartnersLF = (ServicePartnersListForm)actionForm;
        String contextId = servicePartnersLF.getContextId();
        this.populatePartnersMaps(servicePartnersLF);
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)new Long(contextId));
        ContainerType containerType = container.getContainerType();
        if (containerType == ContainerType.SERVICE) {
            String serviceName = ((Service)container).getName();
            servicePartnersLF.setName(serviceName);
        }
        servicePartnersLF.setEntityType(container.getContainerType().toString());
        request.setAttribute("TabbedPMMServicesModify", (Object)"TabbedPMMServicesModify");
        return actionMapping.findForward("partners");
    }

    private void populatePartnersMaps(ServicePartnersListForm servicePartnersLF) {
        ArrayList<HTMLOption> associatedDistPartners = new ArrayList<HTMLOption>();
        ArrayList<HTMLOption> associatedSourcePartners = new ArrayList<HTMLOption>();
        IPartnerManagement partnerManager = PartnerManager.getInstance();
        Set allPartnersAssociatedWithService = partnerManager.getAllPartnersAssociatedWithService(Long.parseLong(servicePartnersLF.getContextId()));
        if (allPartnersAssociatedWithService != null) {
            for (Partner partner : allPartnersAssociatedWithService) {
                String partnerId = String.valueOf(partner.getId());
                String name = partner.getName();
                if (partner.getType().equals((Object)PartnerType.SOURCE)) {
                    associatedSourcePartners.add(new HTMLOption(name, partnerId));
                    continue;
                }
                if (partner.getType() != PartnerType.DISTRIBUTION) continue;
                associatedDistPartners.add(new HTMLOption(name, partnerId));
            }
        }
        logger.debug((Object)("associatedDistPartners.size()=" + associatedDistPartners.size()));
        logger.debug((Object)("associatedSourcePartners.size()=" + associatedSourcePartners.size()));
        Collections.sort(associatedDistPartners);
        Collections.sort(associatedSourcePartners);
        servicePartnersLF.setAssociatedDistPartners(associatedDistPartners);
        servicePartnersLF.setAssociatedSourcePartners(associatedSourcePartners);
        ArrayList<HTMLOption> unassociatedDistPartners = new ArrayList<HTMLOption>();
        ArrayList<HTMLOption> unassociatedSourcePartners = new ArrayList<HTMLOption>();
        List allPartners = partnerManager.getAllActivePartners();
        for (Partner partner : allPartners) {
            String partnerId = String.valueOf(partner.getId());
            String name = partner.getName();
            HTMLOption htmlOption = new HTMLOption(name, partnerId);
            if (partner.getType().equals((Object)PartnerType.SOURCE) && !associatedSourcePartners.contains(htmlOption)) {
                unassociatedSourcePartners.add(htmlOption);
                continue;
            }
            if (partner.getType() != PartnerType.DISTRIBUTION || associatedDistPartners.contains(htmlOption)) continue;
            unassociatedDistPartners.add(htmlOption);
        }
        logger.debug((Object)("unassociatedDistPartners.size()=" + unassociatedDistPartners.size()));
        logger.debug((Object)("unassociatedSourcePartners.size()=" + unassociatedSourcePartners.size()));
        Collections.sort(unassociatedDistPartners);
        Collections.sort(unassociatedSourcePartners);
        servicePartnersLF.setUnassociatedDistPartners(unassociatedDistPartners);
        servicePartnersLF.setUnassociatedSourcePartners(unassociatedSourcePartners);
    }

    public ActionForward savePartnersForService(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServicePartnersListForm servicePartnersLF = (ServicePartnersListForm)actionForm;
        String contextId = servicePartnersLF.getContextId();
        logger.debug((Object)("servicePartnersLF.getContextId()=" + contextId));
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)new Long(contextId));
        long serviceId = -1L;
        String serviceName = ((Service)container).getName();
        servicePartnersLF.setName(serviceName);
        serviceId = ((Service)container).getId();
        servicePartnersLF.setId(String.valueOf(serviceId));
        Service service = this.serviceManager.getService(serviceId);
        this.prepareService(servicePartnersLF, service);
        service = this.serviceManager.updateService(service);
        servicePartnersLF.setId(String.valueOf(service.getId()));
        request.setAttribute("OUTPUT", (Object)servicePartnersLF);
        return actionMapping.findForward("serviceSaved");
    }

    private void prepareService(ServicePartnersListForm servicePartnersLF, Service service) {
        Partner partner;
        int i;
        String[] associatedDistPartners = servicePartnersLF.getSelectedAssociatedDistPartners();
        String[] associatedSourcePartners = servicePartnersLF.getSelectedAssociatedSourcePartners();
        logger.debug((Object)("There are " + associatedDistPartners.length + " assoc. dist partners"));
        logger.debug((Object)("There are " + associatedSourcePartners.length + " assoc. source partners"));
        IPartnerManagement partnerManager = PartnerManager.getInstance();
        HashSet<Partner> partnerSet = new HashSet<Partner>();
        for (i = 0; i < associatedDistPartners.length; ++i) {
            logger.debug((Object)("associatedDistPartners[i]=" + associatedDistPartners[i]));
            partner = partnerManager.getPartner(Long.parseLong(associatedDistPartners[i]));
            partnerSet.add(partner);
        }
        for (i = 0; i < associatedSourcePartners.length; ++i) {
            logger.debug((Object)("associatedSourcePartners[i]=" + associatedSourcePartners[i]));
            partner = partnerManager.getPartner(Long.parseLong(associatedSourcePartners[i]));
            partnerSet.add(partner);
        }
        service.setPartners(partnerSet);
    }

    public ActionForward getJobsForService(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JobListForm jobListForm = (JobListForm)actionForm;
        String contextId = jobListForm.getContextId();
        logger.debug((Object)("Service Context id --->" + contextId));
        ArrayList<JobForm> jobForms = new ArrayList<JobForm>();
        IJobManager jobManager = JobManager.getInstance();
        List lsJobs = jobManager.getAllJobs(Long.parseLong(contextId));
        JobForm jobForm = null;
        for (Job job : lsJobs) {
            jobForm = new JobForm();
            jobForm = this.prepareJobForm(job, jobForm);
            jobForms.add(jobForm);
        }
        int iTotalRecords = lsJobs != null ? lsJobs.size() : 0;
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        jobListForm.setTotalRecords(iTotalRecords);
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)new Long(contextId));
        ContainerType containerType = container.getContainerType();
        if (containerType == ContainerType.SERVICE) {
            String serviceName = ((Service)container).getName();
            jobListForm.setName(serviceName);
            jobListForm.setEntityType(container.getContainerType().toString());
        } else {
            jobListForm.setEntityType(container.getContainerType().toString());
        }
        jobListForm.setJobList(jobForms);
        request.setAttribute("Search_Criteria", (Object)jobListForm);
        request.setAttribute("TabbedPMMServicesModify", (Object)"TabbedPMMServicesModify");
        return actionMapping.findForward(JOBS);
    }

    private JobForm prepareJobForm(Job job, JobForm jobForm) {
        jobForm.setId(job.getId());
        jobForm.setName(job.getName());
        jobForm.setSelectedTemplate(job.getTemplateName());
        jobForm.setSelectedPriority(job.getPriority().name());
        jobForm.setScheduleRule(job.getScheduleRuleString());
        if (job.isTitleAssociated()) {
            jobForm.setIsAssociatedWithTitles("YES");
        } else {
            jobForm.setIsAssociatedWithTitles("NO");
        }
        return jobForm;
    }

    public ActionForward getCurrentSchedulesForService(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int iTotalRecords;
        ScheduleListForm scheduleListForm = (ScheduleListForm)actionForm;
        String contextId = scheduleListForm.getContextId();
        logger.debug((Object)("Service Context id --->" + contextId));
        ArrayList<ScheduleForm> scheduleForms = new ArrayList<ScheduleForm>();
        Collection<Schedule> lsSchedules = null;
        ICacheService containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        IContainer container = (IContainer)containerCache.get((Serializable)new Long(contextId));
        lsSchedules = GUISearchHelper.getCurrentPitchSchedules(new Long(contextId));
        Service service = (Service)container;
        String serviceName = service.getName();
        scheduleListForm.setName(serviceName);
        ScheduleForm scheduleForm = null;
        if (lsSchedules != null) {
            for (Schedule schedule : lsSchedules) {
                scheduleForm = new ScheduleForm();
                scheduleForm = this.prepareScheduleForm(schedule, scheduleForm);
                scheduleForms.add(scheduleForm);
            }
            iTotalRecords = lsSchedules.size();
        } else {
            iTotalRecords = 0;
        }
        logger.debug((Object)("Total number of records -->" + iTotalRecords));
        scheduleListForm.setTotalRecords(iTotalRecords);
        scheduleListForm.setScheduleList(scheduleForms);
        request.setAttribute("Search_Criteria", (Object)scheduleListForm);
        request.setAttribute("TabbedPMMServicesModify", (Object)"TabbedPMMServicesModify");
        return actionMapping.findForward(SCHEDULES);
    }

    private ScheduleForm prepareScheduleForm(Schedule schedule, ScheduleForm scheduleForm) {
        scheduleForm.setScheduleId(Long.toString(schedule.getId()));
        scheduleForm.setStatus(schedule.getStatus().name());
        scheduleForm.setDate(CommonUtils.formatDate(schedule.getDate()));
        return scheduleForm;
    }
}

